/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethserviceoam;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.ethserviceoam.TEEthNodeResourceBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TEGetEthNodeResourceBean
extends TENEExplorerBean {
    private static final int errorCode0 = 38662;
    private static final int errorCode1 = 39326;
    private static final int errorCode2 = 38737;
    private static final int IFUP_NUM = 36864;
    private static final String NON_VLANID = "65535";
    private TEConfigurationDataMgr mgr = null;
    private Map resourceMap = new HashMap();

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        errorCodeList.add(new Integer(39326));
        errorCodeList.add(new Integer(38737));
        return errorCodeList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        HashMap<Integer, TEEthNodeResourceBean> vbMap = new HashMap<Integer, TEEthNodeResourceBean>();
        Output[] outputes = null;
        Output output = null;
        boolean isAdBridgeCMD = true;
        if (null != operationList && operationList.size() > 0) {
            this.mgr = TEConfigurationDataMgr.getInstance();
            int m = operationList.size();
            for (int i = 0; i < m; ++i) {
                TEEthNodeResourceBean res;
                int linkId;
                int portId;
                int j;
                int n;
                Operation operation = (Operation)operationList.get(i);
                if ("NSCMD_ETHN_GET_VLANSWITCHLINK".equalsIgnoreCase(operation.getName())) {
                    outputes = operation.getOutput();
                    if (null == outputes || outputes.length <= 0) continue;
                    n = outputes.length;
                    for (j = 0; j < n; ++j) {
                        output = outputes[j];
                        if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                        int slotId = Integer.parseInt(output.getPartValue("slotID"));
                        int linkId2 = Integer.parseInt(output.getPartValue("linkID"));
                        portId = Integer.parseInt(output.getPartValue("srcPort"));
                        String vlanId = output.getPartValue("srcVlan");
                        this.addResource(slotId, portId, linkId2, vlanId);
                        isAdBridgeCMD = false;
                    }
                    continue;
                }
                if ("NSCMD_ETHN_GET_QINQLINK".equalsIgnoreCase(operation.getName())) {
                    outputes = operation.getOutput();
                    if (null == outputes || outputes.length <= 0) continue;
                    n = outputes.length;
                    for (j = 0; j < n; ++j) {
                        output = outputes[j];
                        if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                        int slotId = Integer.parseInt(output.getPartValue("slotID"));
                        int linkId3 = Integer.parseInt(output.getPartValue("linkID"));
                        portId = Integer.parseInt(output.getPartValue("srcPort"));
                        String cVlanId = output.getPartValue("srcVlan");
                        String sVlanId = output.getPartValue("srcSVlan");
                        if (!NON_VLANID.equals(sVlanId)) {
                            this.addResource(slotId, portId, linkId3, sVlanId);
                        } else {
                            this.addResource(slotId, portId, linkId3, cVlanId);
                        }
                        isAdBridgeCMD = false;
                    }
                    continue;
                }
                if ("NSCMD_ETHN_GET_LINK".equalsIgnoreCase(operation.getName())) {
                    outputes = operation.getOutput();
                    if (null == outputes || outputes.length <= 0) continue;
                    n = outputes.length;
                    for (j = 0; j < n; ++j) {
                        output = outputes[j];
                        if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                        Integer vbPort = Integer.valueOf(output.getPartValue("ingressport"));
                        int slotId = Integer.parseInt(output.getPartValue("slotid"));
                        linkId = Integer.parseInt(output.getPartValue("linkid"));
                        int portId2 = Integer.parseInt(output.getPartValue("egressport"));
                        String vlanId = output.getPartValue("ingressvlanid");
                        this.addResource(slotId, portId2, linkId, vlanId);
                        res = new TEEthNodeResourceBean();
                        res.setSlotId(slotId);
                        res.setPortId(portId2);
                        res.setLinkId(linkId);
                        vbMap.put(vbPort, res);
                        isAdBridgeCMD = false;
                    }
                    continue;
                }
                if ("NSCMD_ETHN_GET_VLAN_TABLE".equalsIgnoreCase(operation.getName())) {
                    outputes = operation.getOutput();
                    if (null == outputes || outputes.length <= 0) continue;
                    n = outputes.length;
                    for (j = 0; j < n; ++j) {
                        output = outputes[j];
                        if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                        String vlanId = output.getPartValue("vlanid");
                        byte[] bValue = output.getPartValue("portNoList").getBytes();
                        int nCount = 4;
                        int nPos = 0;
                        int nParaSize = bValue.length;
                        while (nPos + nCount <= nParaSize) {
                            TEEthNodeResourceBean res2;
                            byte[] bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                            Integer portId3 = new Integer(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0));
                            if (vbMap.containsKey(portId3) && this.resourceMap.containsKey(res2 = (TEEthNodeResourceBean)vbMap.get(portId3))) {
                                Integer linkid = new Integer(res2.getLinkId());
                                Map map = (Map)this.resourceMap.get(res2);
                                if (map.containsKey(linkid)) {
                                    ArrayList list = (ArrayList)map.get(linkid);
                                    list.add(vlanId);
                                }
                            }
                            nPos += nCount;
                        }
                        isAdBridgeCMD = false;
                    }
                    continue;
                }
                if ("NSCMD_ETHN_GET_PORTSVLANVBLINK".equalsIgnoreCase(operation.getName())) {
                    outputes = operation.getOutput();
                    if (null == outputes || outputes.length <= 0) continue;
                    n = outputes.length;
                    for (j = 0; j < n; ++j) {
                        output = outputes[j];
                        if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                        Integer vbPort = Integer.valueOf(output.getPartValue("vbport"));
                        int slotId = Integer.parseInt(output.getPartValue("slotid"));
                        linkId = Integer.parseInt(output.getPartValue("linkid"));
                        int portId4 = Integer.parseInt(output.getPartValue("portid"));
                        String vlanId = output.getPartValue("svlan");
                        this.addResource(slotId, portId4, linkId, vlanId);
                        res = new TEEthNodeResourceBean();
                        res.setSlotId(slotId);
                        res.setPortId(portId4);
                        res.setLinkId(linkId);
                        vbMap.put(vbPort, res);
                        isAdBridgeCMD = false;
                    }
                    continue;
                }
                if ("NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK".equalsIgnoreCase(operation.getName())) {
                    outputes = operation.getOutput();
                    if (null == outputes || outputes.length <= 0) continue;
                    n = outputes.length;
                    for (j = 0; j < n; ++j) {
                        output = outputes[j];
                        if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                        Integer vbPort = Integer.valueOf(output.getPartValue("vbport"));
                        int slotId = Integer.parseInt(output.getPartValue("slotid"));
                        linkId = Integer.parseInt(output.getPartValue("linkid"));
                        int portId5 = Integer.parseInt(output.getPartValue("portid"));
                        String vlanId = output.getPartValue("cvlan");
                        this.addResource(slotId, portId5, linkId, vlanId);
                        res = new TEEthNodeResourceBean();
                        res.setSlotId(slotId);
                        res.setPortId(portId5);
                        res.setLinkId(linkId);
                        vbMap.put(vbPort, res);
                        isAdBridgeCMD = false;
                    }
                    continue;
                }
                if (!"NSCMD_ETHN_GET_LINK_BY_VB_EX".equalsIgnoreCase(operation.getName()) || null == (outputes = operation.getOutput()) || outputes.length <= 0) continue;
                n = outputes.length;
                for (j = 0; j < n; ++j) {
                    output = outputes[j];
                    if (!"0".equalsIgnoreCase(output.getFault(0).getCode()) || !isAdBridgeCMD) continue;
                    Integer vbPort = Integer.valueOf(output.getPartValue("ingressport"));
                    int slotId = Integer.parseInt(output.getPartValue("slotid"));
                    linkId = Integer.parseInt(output.getPartValue("linkid"));
                    int portId6 = Integer.parseInt(output.getPartValue("egressport"));
                    String vlanId = output.getPartValue("svlan");
                    this.addResource(slotId, portId6, linkId, vlanId);
                    res = new TEEthNodeResourceBean();
                    res.setSlotId(slotId);
                    res.setPortId(portId6);
                    res.setLinkId(linkId);
                    vbMap.put(vbPort, res);
                }
            }
        }
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        Set entrySet = this.resourceMap.entrySet();
        for (Map.Entry entry2 : entrySet) {
            TEEthNodeResourceBean resource = (TEEthNodeResourceBean)entry2.getKey();
            RowParams rowParams = new RowParams();
            Param param = new Param("slot", String.valueOf(resource.getSlotId()));
            rowParams.addParam(param);
            param = new Param("boardname", resource.getBoardName());
            rowParams.addParam(param);
            param = new Param("port", String.valueOf(resource.getPortId()));
            rowParams.addParam(param);
            param = new Param("portname", resource.getPortName());
            rowParams.addParam(param);
            param = new Param("vlanid", "");
            Map map = (Map)entry2.getValue();
            Set entrySet1 = map.entrySet();
            for (Map.Entry entry2 : entrySet1) {
                int key = (Integer)entry2.getKey();
                ArrayList list = (ArrayList)entry2.getValue();
                int m = list.size();
                for (int i = 0; i < m; ++i) {
                    String value = ((String)list.get(i)).trim();
                    if (m > 1 && value.equals(NON_VLANID) || "".equals(value)) continue;
                    if (param.getValue().equals("")) {
                        param.setValue(key + "-" + value);
                        continue;
                    }
                    Option option = new Option(key + "-" + value);
                    param.addOption(option);
                }
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private void addResource(int slotId, int portId, int linkId, String vlanId) {
        if (portId > 36864) {
            return;
        }
        int boardType = this.mgr.getBoardType(this.neid, slotId);
        String boardName = this.mgr.getBoardTypeName(this.neid, boardType);
        TEEthNodeResourceBean resource = new TEEthNodeResourceBean();
        resource.setSlotId(slotId);
        resource.setBoardName(boardName);
        resource.setPortId(portId);
        resource.setPortName(this.getPortName(slotId, boardType, portId));
        Map<Integer, ArrayList> map = null;
        ArrayList list = null;
        Integer link = new Integer(linkId);
        if (this.resourceMap.containsKey(resource)) {
            map = (Map)this.resourceMap.get(resource);
            if (map.containsKey(link)) {
                list = (ArrayList)map.get(link);
                list.add(vlanId);
            } else {
                list = new ArrayList();
                list.add(vlanId);
                map.put(link, list);
            }
        } else {
            map = new HashMap();
            list = new ArrayList();
            list.add(vlanId);
            map.put(link, list);
            this.resourceMap.put(resource, map);
        }
    }

    private String getPortName(int slotId, int boardType, int portId) {
        String portName = "";
        int portType = this.mgr.getPortType(this.neid, boardType, portId);
        portName = portType == 61005 ? TEConfigurationDataMgr.getVCTrunkName((int)(portId - 32768)) : TEConfigurationDataMgr.getMACName((int)portId);
        return portName;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

