/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethserviceoam;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TEApplyServiceOAMBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String SERVICE_OAM_RES = "ip" + File.separator + "sdh" + File.separator + "res" + File.separator + "serviceoam" + File.separator + "serviceoamres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            String operateObject = "";
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            Map detailMap = this.getOperationInfo();
            Set entrySet = detailMap.entrySet();
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                TELogInfo log = new TELogInfo();
                log.setCmdID(subfunc.getCode());
                log.setLocation(ipAddress);
                log.setUserID(userID);
                log.setUserName(TESysManagerBean.getInstance().getSysUser());
                log.setOperateObject(operateObject);
                log.setOperateName(operateName);
                Map.Entry e = iter.next();
                String desc = ((StringBuffer)e.getValue()).toString();
                log.setOperateDesc(desc);
                String mpid = (String)e.getKey();
                int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
                if (0 == errorCode || 1 == errorCode || 2 == errorCode) {
                    boolean flag = true;
                    RowParams[] rowParams = outputData.getBussinessParams().getRowParams();
                    int m = rowParams.length;
                    for (int i = 0; i < m; ++i) {
                        int errorCount = rowParams[i].getRowErrorsCount();
                        for (int j = 0; j < errorCount; ++j) {
                            RowErrors rowErrors = rowParams[i].getRowErrors(j);
                            String key = rowErrors.getParam("mpid").getValue();
                            if (!key.equals(mpid)) continue;
                            log.setResult(2);
                            log.setErrCode(Integer.parseInt(rowErrors.getErrorMessage().getErrorcode()));
                            log.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
                            flag = false;
                            break;
                        }
                        if (!flag) break;
                    }
                    if (flag) {
                        log.setResult(0);
                        log.setErrCode(0);
                        log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
                    }
                } else {
                    log.setResult(2);
                    log.setErrCode(errorCode);
                    log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                }
                loginfoList.add(log);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private Map getOperationInfo() {
        this.res = TEGetFilePath.getResource((int)this.neid, (String)SERVICE_OAM_RES);
        HashMap<String, StringBuffer> descMap = new HashMap<String, StringBuffer>();
        StringBuffer desc = null;
        RowParams[] rows = this.inputData.getBussinessParams().getRowParams();
        int len = rows.length;
        for (int i = 0; i < len; ++i) {
            Param param = rows[i].getParam("mpid");
            String mpid = param.getValue();
            if (descMap.containsKey(mpid)) {
                desc = (StringBuffer)descMap.get(mpid);
            } else {
                desc = new StringBuffer();
                descMap.put(mpid, desc);
                String node = rows[i].getParam("node").getValue();
                desc.append(this.res.getString("node")).append(":").append(node);
                StringBuffer sb = new StringBuffer(15);
                sb.append(mpid.substring(0, 2)).append("-");
                sb.append(mpid.substring(2, 4)).append("-").append(mpid.substring(4));
                desc.append(",").append(this.res.getString("mpid")).append(":").append(sb.toString());
            }
            if (rows[i].getParam("lbtesttime").getModifyFlag()) {
                param = rows[i].getParam("lbtesttime");
                desc.append(",").append(this.res.getString("lbtesttime")).append(":").append(param.getValue()).append("ms");
            }
            if (rows[i].getParam("lttesttime").getModifyFlag()) {
                param = rows[i].getParam("lttesttime");
                desc.append(",").append(this.res.getString("lttesttime")).append(":").append(param.getValue()).append("ms");
            }
            if (rows[i].getParam("ccperiod").getModifyFlag()) {
                param = rows[i].getParam("ccperiod");
                desc.append(",").append(this.res.getString("ccperiod")).append(":").append(param.getValue()).append("ms");
            }
            if (rows[i].getParam("aisStatus").getModifyFlag()) {
                param = rows[i].getParam("aisStatus");
                desc.append(",").append(this.res.getString("aisStatus")).append(":").append(this.res.getString("aisStatus_" + param.getValue()));
            }
            if (rows[i].getParam("clientLevel").getModifyFlag()) {
                param = rows[i].getParam("clientLevel");
                desc.append(",").append(this.res.getString("clientLevel")).append(":").append(param.getValue());
            }
            if (rows[i].getParam("aisPeriod").getModifyFlag()) {
                param = rows[i].getParam("aisPeriod");
                desc.append(",").append(this.res.getString("aisPeriod")).append(":").append(param.getValue()).append("ms");
            }
            if (!rows[i].getParam("ccMac").getModifyFlag()) continue;
            param = rows[i].getParam("ccMacStr");
            desc.append(",").append(this.res.getString("ccMac")).append(":").append(param.getValue());
        }
        return descMap;
    }
}

