/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethlanservice;

import com.huawei.nglct.nemgr.ip.sdh.ethlanservice.TELinkPortInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class TEVBInfoList {
    private static final int VBPORT_FLG = 28672;
    private static final String NA_VALUESTR = "65535";
    private HashMap vbMemMap = new HashMap();
    private ArrayList otherLinkPortList = new ArrayList();
    private ArrayList linkIdList = new ArrayList();
    private String Bidirection_VBLink = "4";

    public void clearMemData() {
        this.vbMemMap.clear();
        this.otherLinkPortList.clear();
        this.linkIdList.clear();
    }

    public ArrayList getLinkPortList(String vbid) {
        return (ArrayList)this.vbMemMap.get(vbid);
    }

    public void addItem(String vbid) {
        ArrayList linkPortList = new ArrayList();
        this.vbMemMap.put(vbid, linkPortList);
    }

    public void initVBLink(String vbid, int lpCount) {
        ArrayList linkPortList = null;
        if (!this.hasVB(vbid)) {
            return;
        }
        linkPortList = this.getLinkPorts(vbid);
        TELinkPortInfo linkPortInfo = null;
        int lpNo = 0;
        for (int i = 0; i < lpCount; ++i) {
            linkPortInfo = new TELinkPortInfo();
            lpNo = 28672 + i + 1;
            linkPortInfo.setLpNo(String.valueOf(lpNo));
            linkPortList.add(linkPortInfo);
        }
    }

    public void addPort(String vbid, String lpNo, TELinkPortInfo linkPort) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        linkPortList.add(linkPort);
    }

    public void setPortAttribute(String linkid, String vbid, String lpNo, String portid, String direction) {
        TELinkPortInfo linkPort = this.getLinkPortInfoByLpNo(vbid, lpNo);
        this.addLinkIdList(linkid);
        linkPort.setPortAttribute(linkid, lpNo, portid, "4", "2", NA_VALUESTR, NA_VALUESTR);
    }

    public void setPortAttribute(String vbid, String linkid, String lpNo, String portid, String direction, String opertype, String porttype, String cvlan, String svlan) {
        this.addLinkIdList(linkid);
        TELinkPortInfo linkPort = new TELinkPortInfo();
        linkPort.setPortAttribute(linkid, lpNo, portid, opertype, porttype, cvlan, svlan);
        ArrayList linkPortList = this.getLinkPortList(vbid);
        if (!linkPortList.contains(linkPort)) {
            linkPortList.add(linkPort);
        }
    }

    public void setPortAttribute(String vbid, String linkid, String lpNo, String portid, String direction, String opertype, String porttype, String cvlan, String svlan, String cpriority, String spriority) {
        this.addLinkIdList(linkid);
        TELinkPortInfo linkPort = new TELinkPortInfo();
        linkPort.setPortAttribute(linkid, lpNo, portid, opertype, porttype, cvlan, svlan, cpriority, spriority);
        ArrayList linkPortList = this.getLinkPortList(vbid);
        if (!linkPortList.contains(linkPort)) {
            linkPortList.add(linkPort);
        }
    }

    public void delPortAttribute(String vbid, String lpNo) {
        TELinkPortInfo linkPort = this.getLinkPortInfoByLpNo(vbid, lpNo);
        linkPort.clearAllAttribute();
        String linkid = linkPort.getLinkid();
        if (!linkid.equals("") && !linkid.equals("0") && this.linkIdList.contains(new Integer(linkid))) {
            this.linkIdList.remove(new Integer(linkid));
        }
    }

    public void delPBLink(String vbid, String linkid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        int len = linkPortList.size();
        for (int i = 0; i < len; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPortList.get(i);
            if (!tempLinkPort.getLinkid().equals(linkid)) continue;
            linkPortList.remove(i);
            this.linkIdList.remove(new Integer(linkid));
            break;
        }
    }

    public void delVB(String vbid) {
        this.vbMemMap.remove(vbid);
    }

    public boolean hasVB(String vbid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        return null != linkPortList;
    }

    public boolean hasVBLink(String vbid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPortList.get(i);
            if (null == tempLinkPort.getPortId() || !tempLinkPort.getPortId().equals("") || !tempLinkPort.getPortId().equals("0")) continue;
            return true;
        }
        return false;
    }

    public ArrayList getLinkPorts(String vbid) {
        ArrayList portList = this.getLinkPortList(vbid);
        Collections.sort(portList);
        return portList;
    }

    public ArrayList getPortIdsByVB(String vbid) {
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList portList = this.getLinkPorts(vbid);
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)portList.get(i);
            if (tempLinkPort.getPortId().equals("0")) continue;
            portidList.add(tempLinkPort.getPortId());
        }
        return portidList;
    }

    public void addOtherLinkPort(String linkPortId) {
        if (this.otherLinkPortList.contains(linkPortId)) {
            return;
        }
        this.otherLinkPortList.add(linkPortId);
    }

    public void clearOtherLinkPort() {
        this.otherLinkPortList.clear();
    }

    public ArrayList getOtherLinkPortList() {
        return this.otherLinkPortList;
    }

    public void addLinkIdList(String linkid) {
        if (this.linkIdList.contains(Integer.valueOf(linkid))) {
            return;
        }
        this.linkIdList.add(Integer.valueOf(linkid));
        Collections.sort(this.linkIdList);
    }

    public void delLinkIdFromList(String linkid) {
        this.linkIdList.remove(new Integer(linkid));
    }

    public ArrayList getAllLinkId() {
        return this.linkIdList;
    }

    public ArrayList getAvailableLinkId(int linkCount) {
        int i;
        ArrayList<Integer> availLinkIdList = new ArrayList<Integer>();
        int count = 0;
        int dispersion = 0;
        int newlinkid = 0;
        int listlen = this.linkIdList.size();
        for (i = 0; i < listlen - 1; ++i) {
            newlinkid = (Integer)this.linkIdList.get(i);
            dispersion = (Integer)this.linkIdList.get(i + 1) - newlinkid;
            if (dispersion <= 1) continue;
            count += dispersion - 1;
            for (int j = 0; j < dispersion; ++j) {
                availLinkIdList.add(++newlinkid);
            }
        }
        if (count < linkCount) {
            newlinkid = 0 == this.linkIdList.size() ? 0 : (Integer)this.linkIdList.get(this.linkIdList.size() - 1);
            for (i = 0; i < linkCount - count; ++i) {
                availLinkIdList.add(++newlinkid);
            }
        }
        return availLinkIdList;
    }

    public void deleteLinkportByLinkid(String vbid, ArrayList linkPortList) {
        ArrayList linkPorts = this.getLinkPortList(vbid);
        if (null == linkPorts) {
            return;
        }
        boolean pblinktypeflg = false;
        int listlen = linkPorts.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPorts.get(i);
            if (tempLinkPort.getLinkType().equals(this.Bidirection_VBLink)) {
                if (!linkPortList.contains(tempLinkPort.getLinkid())) continue;
                this.linkIdList.remove(Integer.valueOf(tempLinkPort.getLinkid()));
                tempLinkPort.clearAllAttribute();
                continue;
            }
            if (tempLinkPort.getPortId().equals("0")) continue;
            pblinktypeflg = true;
            break;
        }
        if (pblinktypeflg) {
            this.deletePBPortByLinkid(vbid, linkPortList);
        }
    }

    public void deletePBPortByLinkid(String vbid, ArrayList linkPortList) {
        ArrayList linkPorts = this.getLinkPortList(vbid);
        if (null == linkPorts) {
            return;
        }
        for (int i = linkPorts.size() - 1; i >= 0; --i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPorts.get(i);
            if (!linkPortList.contains(tempLinkPort.getLinkid())) continue;
            this.linkIdList.remove(Integer.valueOf(tempLinkPort.getLinkid()));
            linkPorts.remove(i);
        }
    }

    public String getLinkPortByLinkId(String vbid, String linkId) {
        ArrayList linkPorts = this.getLinkPortList(vbid);
        String aportid = "";
        if (null == linkPorts) {
            return aportid;
        }
        int listlen = linkPorts.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPorts.get(i);
            if (!tempLinkPort.getLinkid().equals(linkId)) continue;
            aportid = tempLinkPort.getPortId();
            break;
        }
        return aportid;
    }

    public ArrayList getAllUsedPort() {
        ArrayList<Integer> usedPortList = new ArrayList<Integer>();
        Iterator memMapIt = this.vbMemMap.values().iterator();
        ArrayList linkPorts = null;
        TELinkPortInfo linkPortInfo = null;
        while (memMapIt.hasNext()) {
            linkPorts = (ArrayList)memMapIt.next();
            int len = linkPorts.size();
            for (int i = 0; i < len; ++i) {
                linkPortInfo = (TELinkPortInfo)linkPorts.get(i);
                if (linkPortInfo.getPortId().equals("0") || usedPortList.contains(new Integer(linkPortInfo.getPortId()))) continue;
                usedPortList.add(new Integer(linkPortInfo.getPortId()));
            }
        }
        if (null != this.otherLinkPortList && 0 == this.otherLinkPortList.size()) {
            usedPortList.addAll(this.otherLinkPortList);
        }
        return usedPortList;
    }

    public TELinkPortInfo getLinkPortInfoByLpNo(String vbid, String lpNo) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        TELinkPortInfo aInfo = null;
        boolean nullflg = false;
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            aInfo = (TELinkPortInfo)linkPortList.get(i);
            if (aInfo.getLpNo().equals(lpNo)) {
                nullflg = false;
                break;
            }
            nullflg = true;
        }
        if (nullflg) {
            return null;
        }
        return aInfo;
    }

    public ArrayList getLinkIds(String vbid) {
        ArrayList<String> linkIdList = new ArrayList<String>();
        ArrayList portList = null;
        portList = this.getLinkPorts(vbid);
        int listlen = portList.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)portList.get(i);
            if (tempLinkPort.getLinkid().equals("0")) continue;
            linkIdList.add(tempLinkPort.getLinkid());
        }
        return linkIdList;
    }
}

