/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.ethlanservice.TELinkPortInfo;
import com.huawei.nglct.nemgr.ip.sdh.ethlanservice.TENEVBContainer;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQueryVBMountPortBean
extends TENEExplorerBean {
    String vbid = "";
    private static final int VCTRUNC_FLG = 32768;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || 0 == this.operationList.size()) {
                this.handleMessage(neid, this.operationList, subFunc);
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Object> operList = new ArrayList<Object>();
        String slotid = "";
        String portId = "";
        Operation operation = null;
        Input input = null;
        slotid = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.valueOf(slotid).intValue());
        this.vbid = inputData.getBussinessParams().getRowParams(0).getParam("vbid").getValue();
        ArrayList vbinfo = TENEVBContainer.getInstance(neid).getVBList(neid).getLinkPortList(this.vbid);
        TELinkPortInfo linkport = null;
        int infolen = vbinfo.size();
        for (int i = 0; i < infolen; ++i) {
            linkport = (TELinkPortInfo)vbinfo.get(i);
            portId = linkport.getPortId();
            if (!portId.equals("0")) {
                operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_PORT_TYPE");
                input = operation.getInput();
                input.setPartValue("slotid", slotid);
                input.setPartValue("port", portId);
                operList.add(operation.clone());
                if (Integer.parseInt(linkport.getPortId()) < 32768) {
                    if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)Integer.valueOf(portId), (String)"ATTR_ETHOVERSDH_MAC_ENABLE")) {
                        operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_PORTENABLE");
                        input = operation.getInput();
                        input.setPartValue("slotid", slotid);
                        input.setPartValue("port", portId);
                        operList.add(operation.clone());
                    }
                    if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)Integer.valueOf(portId), (String)"ATTR_ETHOVERSDH_MAC_WORKMODE")) {
                        operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_ETHWORKMODE");
                        input = operation.getInput();
                        input.setPartValue("slotid", slotid);
                        input.setPartValue("port", portId);
                        operList.add(operation.clone());
                    }
                }
                operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_ETHTAG");
                input = operation.getInput();
                input.setPartValue("slotID", slotid);
                input.setPartValue("port", portId);
                operList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_VLANID");
                input = operation.getInput();
                input.setPartValue("slotid", slotid);
                input.setPartValue("port", portId);
                operList.add(operation.clone());
            }
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_VBLP_HUBSPOKEN");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("vbid", this.vbid);
            input.setPartValue("vbport", linkport.getLpNo());
            operList.add(operation.clone());
        }
        return operList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowParams = null;
        String errcode = "";
        RowParams errRow = new RowParams();
        RowErrors rowError1 = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        boolean allSucc = true;
        boolean allFail = true;
        Operation operation = null;
        ArrayList portList = TENEVBContainer.getInstance(neid).getVBList(neid).getLinkPorts(this.vbid);
        int listlen = portList.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo linkport = (TELinkPortInfo)portList.get(i);
            rowParams = new RowParams();
            rowParams.addParam("linkid", linkport.getLinkid());
            rowParams.addParam("vbport", linkport.getLpNo());
            rowParams.addParam("portid", linkport.getPortId());
            rowParams.addParam("portname", linkport.getPortName());
            rowParams.addParam("porttype", linkport.getPortType());
            rowParams.addParam("direction", linkport.getDirection());
            rowParams.addParam("portenable", linkport.getPortEnable());
            rowParams.addParam("portTag", linkport.getPortTag());
            rowParams.addParam("VLAN", linkport.getDefaultVlan());
            rowParams.addParam("VLANPRIORITY", linkport.getVlanPriority());
            rowParams.addParam("ATTR_ETHOVERSDH_MAC_WORKMODE", linkport.getWorkMode());
            rowParams.addParam("hubspoke", linkport.getHubspoke());
            rowParams.addParam("opertype", linkport.getLinkType());
            rowParams.addParam("cvlan", linkport.getCVlan());
            rowParams.addParam("svlan", linkport.getSVlan());
            rowParams.addParam("cpriority", linkport.getCpriority());
            rowParams.addParam("spriority", linkport.getSpriority());
            int operlen = operationList.size();
            for (int j = 0; j < operlen; ++j) {
                operation = (Operation)operationList.get(j);
                if (operation.getName().equals("NSCMD_ETHN_GET_PORT_TYPE") && operation.getInput().getPartValue("port").equals(linkport.getPortId())) {
                    if (operation.getOutput(0).getFault(0).getCode().equals("0")) {
                        allFail = false;
                        rowParams.getParam("porttype").setValue(operation.getOutput(0).getPartValue("PE_TYPE"));
                    } else if (operation.getOutput(0).getFault(0).getCode().equals("38737")) {
                        allFail = false;
                        rowParams.getParam("porttype").setValue("-");
                    } else {
                        allSucc = this.handleErroMessage(neid, errRow, rowError1, errorMessage, operation);
                    }
                }
                if (operation.getName().equals("NSCMD_ETHN_GET_PORTENABLE") && operation.getInput().getPartValue("port").equals(linkport.getPortId())) {
                    if (operation.getOutput(0).getFault(0).getCode().equals("0")) {
                        allFail = false;
                        rowParams.getParam("portenable").setValue(operation.getOutput(0).getPartValue("ATTR_ETHOVERSDH_MAC_ENABLE"));
                    } else {
                        allSucc = this.handleErroMessage(neid, errRow, rowError1, errorMessage, operation);
                    }
                }
                if (operation.getName().equals("NSCMD_ETHN_GET_ETHTAG") && operation.getInput().getPartValue("port").equals(linkport.getPortId())) {
                    if (operation.getOutput(0).getFault(0).getCode().equals("0")) {
                        allFail = false;
                        rowParams.getParam("portTag").setValue(operation.getOutput(0).getPartValue("portTag"));
                    } else {
                        allSucc = false;
                        errcode = operation.getOutput(0).getFault(0).getCode();
                        errorMessage.setErrorcode(errcode);
                        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errcode)));
                        rowError1.setErrorMessage(errorMessage);
                        errorparam = new Param("neid", String.valueOf(neid));
                        rowError1.addParam(errorparam);
                        errorparam = new Param("slotid", operation.getInput().getPartValue("slotID"));
                        rowError1.addParam(errorparam);
                        errorparam = new Param("portid", operation.getInput().getPartValue("port"));
                        rowError1.addParam(errorparam);
                        errRow.addRowErrors(rowError1);
                    }
                }
                if (operation.getName().equals("NSCMD_ETHN_GET_VLANID") && operation.getInput().getPartValue("port").equals(linkport.getPortId())) {
                    if (operation.getOutput(0).getFault(0).getCode().equals("0")) {
                        allFail = false;
                        rowParams.getParam("VLAN").setValue(operation.getOutput(0).getPartValue("VLAN"));
                        rowParams.getParam("VLANPRIORITY").setValue(operation.getOutput(0).getPartValue("VLANPRIORITY"));
                    } else {
                        allSucc = this.handleErroMessage(neid, errRow, rowError1, errorMessage, operation);
                    }
                }
                if (operation.getName().equals("NSCMD_ETHN_GET_ETHWORKMODE") && operation.getInput().getPartValue("port").equals(linkport.getPortId())) {
                    if (operation.getOutput(0).getFault(0).getCode().equals("0")) {
                        allFail = false;
                        rowParams.getParam("ATTR_ETHOVERSDH_MAC_WORKMODE").setValue(operation.getOutput(0).getPartValue("ATTR_ETHOVERSDH_MAC_WORKMODE"));
                    } else {
                        allSucc = this.handleErroMessage(neid, errRow, rowError1, errorMessage, operation);
                    }
                }
                if (!operation.getName().equals("NSCMD_ETHN_GET_VBLP_HUBSPOKEN") || !operation.getInput().getPartValue("vbport").equals(linkport.getLpNo())) continue;
                if (operation.getOutput(0).getFault(0).getCode().equals("0")) {
                    allFail = false;
                    rowParams.getParam("hubspoke").setValue(operation.getOutput(0).getPartValue("hubspoke"));
                    continue;
                }
                allSucc = false;
                errcode = operation.getOutput(0).getFault(0).getCode();
                errorMessage.setErrorcode(errcode);
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errcode)));
                rowError1.setErrorMessage(errorMessage);
                errorparam = new Param("neid", String.valueOf(neid));
                rowError1.addParam(errorparam);
                errorparam = new Param("slotid", operation.getInput().getPartValue("slotid"));
                rowError1.addParam(errorparam);
                errorparam = new Param("vbid", operation.getInput().getPartValue("vbid"));
                rowError1.addParam(errorparam);
                errorparam = new Param("vbport", operation.getInput().getPartValue("vbport"));
                rowError1.addParam(errorparam);
                errRow.addRowErrors(rowError1);
            }
            bussinessParams.addRowParams(rowParams);
        }
        if (null != errRow) {
            bussinessParams.addRowParams(errRow);
        }
        this.outputData.setBussinessParams(bussinessParams);
        if (allSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (allFail) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else if (!allFail && !allSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
    }

    private boolean handleErroMessage(int neid, RowParams errRow, RowErrors rowError1, ErrorMessage errorMessage, Operation operation) {
        boolean allSucc = false;
        String errcode = operation.getOutput(0).getFault(0).getCode();
        errorMessage.setErrorcode(errcode);
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errcode)));
        rowError1.setErrorMessage(errorMessage);
        Param errorparam = new Param("neid", String.valueOf(neid));
        rowError1.addParam(errorparam);
        errorparam = new Param("slotid", operation.getInput().getPartValue("slotid"));
        rowError1.addParam(errorparam);
        errorparam = new Param("portid", operation.getInput().getPartValue("port"));
        rowError1.addParam(errorparam);
        errRow.addRowErrors(rowError1);
        return allSucc;
    }
}

