/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.ethlanservice.TELinkPortInfo;
import com.huawei.nglct.nemgr.ip.sdh.ethlanservice.TENEVBContainer;
import com.huawei.nglct.nemgr.ip.sdh.ethlanservice.TEParseEthLanConfFile;
import com.huawei.nglct.nemgr.ip.sdh.ethlanservice.TEVBInfoList;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryVBBean
extends TENEExplorerBean {
    private static final String NA_VALUE = "65535";
    private static final String ADD_SVLAN_BASE_PORT = "0";
    private static final String ADD_SVLAN_BASE_PORT_AND_CVLAN = "1";
    private static final String MOUNT_PORT_AND_BASE_PORT_AND_SVLAN = "3";
    private static final String FILE_NAME = "ip\\sdh\\res\\ethlanservice\\vbdesres_";
    private static final int VCTRUNC_FLG = 32768;
    private static final String PORTCSVLAN_LINK = "13";
    private static final String PORTSVLAN_VBLINK = "12";
    private static final String LINK_COMMON = "1";
    private static final String Bidirection_VBLink = "4";
    private static final String VBTYPE_AD = "2";
    private String vbType = "2";
    private ArrayList tempOperList = new ArrayList();
    private String firstVBId = "";
    private String slotid;
    private int lpCount = 0;
    private String vbtype = "";
    private String vbmode = "";
    private String macenable = "";
    private boolean vbtypeModifyFlg = true;
    private boolean vbmodeModifyFlg = true;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowErrors secondSendErrRow = null;
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            this.addOperationGetLinkByVB(this.neid, inputData);
            if (null == this.operationList || 0 == this.operationList.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (0 == result) {
                this.tempOperList = (ArrayList)this.operationList.clone();
                this.operationList.clear();
                this.handleFirstSendInfo();
                if (0 != this.operationList.size()) {
                    result = this.sendMessage(neid);
                    secondSendErrRow = this.handleSecondSendErr(result);
                }
                this.handleMessage(neid, this.operationList, subFunc, secondSendErrRow);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public RowErrors handleSecondSendErr(int result) {
        RowErrors secondSendErrRow = null;
        if (0 != result) {
            secondSendErrRow = new RowErrors();
            secondSendErrRow.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        return secondSendErrRow;
    }

    public void handleFirstSendInfo() {
        int i;
        Operation tempOper = null;
        Operation priOper = null;
        for (i = 0; i < 3; ++i) {
            tempOper = (Operation)this.tempOperList.get(i);
            if (tempOper.getName().equals("NSCMD_ETHN_GET_VB")) {
                this.handleVBData(tempOper);
                continue;
            }
            if (!tempOper.getName().equals("NSCMD_ETHN_GET_VB_TYPE")) continue;
            this.handleVBType(tempOper);
        }
        for (i = this.tempOperList.size() - 1; i >= 3; --i) {
            tempOper = (Operation)this.tempOperList.get(i);
            this.tempOperList.remove(tempOper);
            if (tempOper.getName().equals("NSCMD_ETHN_GET_QINQINLINKDEFVLANPRI")) {
                priOper = tempOper;
                continue;
            }
            if (tempOper.getName().equals("NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK") || tempOper.getName().equals("NSCMD_ETHN_GET_PORTSVLANVBLINK") || tempOper.getName().equals("NSCMD_ETHN_GET_LINK") || tempOper.getName().equals("NSCMD_ETHN_GET_LINK_BY_VB")) {
                this.handleLinkData(tempOper, priOper);
                continue;
            }
            this.handleOtherLinkData(tempOper);
        }
        if (!this.firstVBId.equals("")) {
            Input input = null;
            Operation operation = null;
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_VBLP_HUBSPOKEN");
            input = operation.getInput();
            input.setPartValue("slotid", this.slotid);
            input.setPartValue("vbid", this.firstVBId);
            input.setPartValue("vbport", ADD_SVLAN_BASE_PORT);
            this.operationList.add(operation.clone());
        }
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue()));
        String bdCpType = String.valueOf(board.getBoardType());
        TEParseEthLanConfFile confFileObj = TEParseEthLanConfFile.getInstance();
        this.lpCount = Integer.parseInt(confFileObj.getNodeAttrValue(neid, bdCpType, "maxNumOfVBLP"));
        if (confFileObj.getChildNodeAttrValue(neid, bdCpType, "vbtyperes", "IsSupportModify").equals("no")) {
            this.vbtypeModifyFlg = false;
            this.vbtype = this.getVBType(confFileObj.getOpetionStr(neid, bdCpType, "vbtyperes", "vbtype")[0]);
        }
        if (confFileObj.getChildNodeAttrValue(neid, bdCpType, "vbswicthmode", "IsSupportModify").equals("no")) {
            this.vbmodeModifyFlg = false;
            this.vbmode = confFileObj.getChildNodeAttrValue(neid, bdCpType, "vbswicthmode", "mode");
        }
        if (confFileObj.getChildNodeAttrValue(neid, bdCpType, "macaddress", "IsSupportModify").equals("no")) {
            this.macenable = this.getMacenable(confFileObj.getChildNodeAttrValue(neid, bdCpType, "macaddress", "EnableStatus"));
        }
        subFunc = this.setSubFunc(subFunc);
        return super.getOperation(neid, subFunc, inputData, memeryData);
    }

    public SubFunc setSubFunc(SubFunc subFunc) {
        QxMapping qxMapping = null;
        for (int i = subFunc.getQxMappingCount(); !(i < 0 || this.vbtypeModifyFlg && this.vbmodeModifyFlg); --i) {
            qxMapping = subFunc.getQxMapping(i);
            if ((!qxMapping.getContent().equals("NSCMD_ETHN_GET_VB_TYPE") || this.vbtypeModifyFlg) && (!qxMapping.getContent().equals("NSCMD_ETHN_GET_BRIDGEMODE") || this.vbmodeModifyFlg)) continue;
            subFunc.removeQxMapping(qxMapping);
        }
        return subFunc;
    }

    public void handleVBData(Operation operation) {
        Output[] outputs = operation.getOutput();
        Output output = null;
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid).getVBList(this.neid);
        vbInfoList.clearMemData();
        int listlen = operation.getOutputCount();
        for (int i = 0; i < listlen; ++i) {
            if (!outputs[i].getFault(0).getCode().equals(ADD_SVLAN_BASE_PORT)) continue;
            output = outputs[i];
            if (0 == i) {
                this.firstVBId = output.getPartValue("vbid").trim();
                this.slotid = output.getPartValue("slotid");
            }
            vbInfoList.addItem(output.getPartValue("vbid").trim());
        }
    }

    public void handleVBType(Operation operation) {
        Output[] outputs = operation.getOutput();
        Output output = null;
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid).getVBList(this.neid);
        int listlen = operation.getOutputCount();
        for (int i = 0; i < listlen; ++i) {
            if (!outputs[i].getFault(0).getCode().equals(ADD_SVLAN_BASE_PORT)) continue;
            this.vbType = outputs[i].getPartValue("vbtype");
            if (this.vbType.equals(VBTYPE_AD)) continue;
            output = outputs[i];
            vbInfoList.initVBLink(output.getPartValue("vbid").trim(), this.lpCount);
        }
    }

    private String getVBType(String vbtypeNo) {
        switch (Integer.parseInt(vbtypeNo)) {
            case 1: {
                return "802.1q";
            }
            case 2: {
                return "802.1d";
            }
            case 3: {
                return "802.1ad";
            }
        }
        return "";
    }

    private String getVBMode(String vbstudytype, String ingressfilter) {
        if (vbstudytype.equals(VBTYPE_AD) && ingressfilter.equals("1")) {
            return "1";
        }
        if (vbstudytype.equals(VBTYPE_AD) && ingressfilter.equals(ADD_SVLAN_BASE_PORT)) {
            return VBTYPE_AD;
        }
        if (vbstudytype.equals("1") && ingressfilter.equals("1")) {
            return MOUNT_PORT_AND_BASE_PORT_AND_SVLAN;
        }
        return Bidirection_VBLink;
    }

    private String getMacenable(String macenableNo) {
        StringBuffer filePath = new StringBuffer(FILE_NAME).append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        switch (Integer.parseInt(macenableNo)) {
            case 0: {
                return res.getString("disable");
            }
            case 1: {
                return res.getString("enable");
            }
        }
        return "";
    }

    public void handleLinkData(Operation operation, Operation priOper) {
        Output[] outputs = operation.getOutput();
        Output[] priOutputs = null;
        if (priOper != null) {
            priOutputs = priOper.getOutput();
        }
        Output output = null;
        Output priOutput = null;
        for (int i = operation.getOutputCount() - 1; i >= 0; --i) {
            output = outputs[i];
            if (priOutputs != null && i < priOutputs.length) {
                priOutput = priOutputs[i];
            }
            if (!output.getFault(0).getCode().equals(ADD_SVLAN_BASE_PORT)) continue;
            if (null != output.getPartValue("linktype") && output.getPartValue("linktype").equals("1")) {
                operation.removeOutput(output);
                continue;
            }
            this.handleAddMemData(this.neid, output, priOutput);
            operation.removeOutput(output);
        }
    }

    public void handleAddMemData(int neid, Output output, Output operOutput) {
        String vbid = "";
        String portid = "";
        String lpid = "";
        String linktype = "";
        String linkid = "";
        String porttype = "";
        String cvlan = NA_VALUE;
        String svlan = NA_VALUE;
        String cpri = "-";
        String spri = "-";
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(neid).getVBList(neid);
        String linkType = output.getPartValue("linktype");
        if (null != linkType && (linkType.equals(PORTCSVLAN_LINK) || linkType.equals(PORTSVLAN_VBLINK)) || null == output.getPartValue("linktype")) {
            vbid = output.getPartValue("vbid");
            portid = output.getPartValue("portid");
            lpid = output.getPartValue("vbport");
            linkid = output.getPartValue("linkid");
            if (output.getPart("cvlan") == null) {
                linktype = MOUNT_PORT_AND_BASE_PORT_AND_SVLAN;
                porttype = "5";
            } else if (output.getPart("cvlan").getValue().equals(NA_VALUE)) {
                linktype = ADD_SVLAN_BASE_PORT;
                porttype = "5";
            } else {
                linktype = "1";
                porttype = "6";
                cvlan = output.getPartValue("cvlan");
            }
            svlan = output.getPartValue("svlan");
            if (operOutput != null && operOutput.getPart("cVlanPri") != null) {
                cpri = operOutput.getPartValue("cVlanPri");
            }
            if (operOutput != null && operOutput.getPart("sVlanPri") != null) {
                spri = operOutput.getPartValue("sVlanPri");
            }
        }
        if (null != output.getPartValue("linktype") && !output.getPartValue("linktype").equals("1")) {
            vbInfoList.addOtherLinkPort(output.getPartValue("ingressport"));
            vbInfoList.addOtherLinkPort(output.getPartValue("egressport"));
            vbInfoList.addLinkIdList(output.getPartValue("linkid"));
        }
        if (output.getPartValue("ingressvbid") != null && !output.getPartValue("ingressvbid").equals(NA_VALUE)) {
            vbid = output.getPartValue("ingressvbid");
            portid = output.getPartValue("egressport");
            lpid = output.getPartValue("ingressport");
        }
        if (output.getPartValue("ingressvbid") != null && !output.getPartValue("egressvbid").equals(NA_VALUE)) {
            vbid = output.getPartValue("egressvbid");
            portid = output.getPartValue("ingressport");
            lpid = output.getPartValue("egressport");
        }
        if (linktype.equals("")) {
            linktype = output.getPartValue("linktype");
        }
        if (linkid.equals("")) {
            linkid = output.getPartValue("linkid");
        }
        this.slotid = output.getPartValue("slotid");
        this.addNewOperation(neid, vbid, portid, lpid, linkid, this.slotid, linktype, porttype, cvlan, svlan, cpri, spri);
    }

    public void addNewOperation(int neid, String vbid, String portid, String lpid, String linkid, String slotid, String opertype, String porttype, String cvlan, String svlan, String cpri, String spri) {
        if (vbid.equals("") || portid.equals("") || lpid.equals("") || linkid.equals("")) {
            return;
        }
        this.addMemVBData(vbid, linkid, portid, lpid, opertype, porttype, cvlan, svlan, cpri, spri);
        this.getPortAttrOper(neid, vbid, portid);
    }

    public void addMemVBData(String vbid, String linkid, String portid, String lpid, String opertype, String porttype, String cvlan, String svlan, String cpri, String spri) {
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid).getVBList(this.neid);
        if (vbInfoList.hasVB(vbid)) {
            if (opertype.equals(Bidirection_VBLink) && cvlan.equals(NA_VALUE) && svlan.equals(NA_VALUE)) {
                vbInfoList.setPortAttribute(linkid, vbid, lpid, portid, Bidirection_VBLink);
            } else {
                vbInfoList.setPortAttribute(vbid, linkid, lpid, portid, Bidirection_VBLink, opertype, porttype, cvlan, svlan, cpri, spri);
            }
        }
    }

    public void getPortAttrOper(int neid, String vbid, String portid) {
        Operation operation = null;
        Input input = null;
        if (vbid.equals(this.firstVBId)) {
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_PORT_TYPE");
            input = operation.getInput();
            input.setPartValue("slotid", this.slotid);
            input.setPartValue("port", portid);
            this.operationList.add(operation.clone());
            if (Integer.parseInt(portid) < 32768) {
                int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.valueOf(this.slotid).intValue());
                if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)Integer.valueOf(portid), (String)"ATTR_ETHOVERSDH_MAC_ENABLE")) {
                    operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_PORTENABLE");
                    input = operation.getInput();
                    input.setPartValue("slotid", this.slotid);
                    input.setPartValue("port", portid);
                    this.operationList.add(operation.clone());
                }
                if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)Integer.valueOf(portid), (String)"ATTR_ETHOVERSDH_MAC_WORKMODE")) {
                    operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_ETHWORKMODE");
                    input = operation.getInput();
                    input.setPartValue("slotid", this.slotid);
                    input.setPartValue("port", portid);
                    this.operationList.add(operation.clone());
                }
            }
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_ETHTAG");
            input = operation.getInput();
            input.setPartValue("slotID", this.slotid);
            input.setPartValue("port", portid);
            this.operationList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_VLANID");
            input = operation.getInput();
            input.setPartValue("slotid", this.slotid);
            input.setPartValue("port", portid);
            this.operationList.add(operation.clone());
        }
    }

    public void handleOtherLinkData(Operation operation) {
        Output[] outputs = operation.getOutput();
        Output output = null;
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid).getVBList(this.neid);
        for (int i = operation.getOutputCount() - 1; i >= 0; --i) {
            output = outputs[i];
            if (!output.getFault(0).getCode().equals(ADD_SVLAN_BASE_PORT)) continue;
            vbInfoList.addOtherLinkPort(output.getPartValue("srcPort"));
            vbInfoList.addOtherLinkPort(output.getPartValue("snkPort"));
            vbInfoList.addLinkIdList(output.getPartValue("linkID"));
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, RowErrors secondSendErrRow) {
        ArrayList<Integer> errcodeList = new ArrayList<Integer>();
        errcodeList.add(38662);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)this.tempOperList, errcodeList);
        int rowlen = this.outputData.getBussinessParams().getRowParamsCount();
        RowErrors[] rowerrors = null;
        if (rowlen > 0 && this.outputData.getBussinessParams().getRowParams(rowlen - 1).getRowErrorsCount() > 0) {
            rowerrors = this.outputData.getBussinessParams().getRowParams(--rowlen).getRowErrors();
        }
        this.addVBAttrParam(rowlen);
        rowerrors = this.addErrAttr(rowerrors);
        if (!this.firstVBId.equals("")) {
            this.initLinkPortParam();
        }
        if (null == operationList || 0 == operationList.size()) {
            return;
        }
        Operation operation = null;
        ArrayList errrowList = new ArrayList();
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        String nename = ne.getNEName();
        String boardname = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(this.slotid)).getBoardName();
        Param param = null;
        if (null == secondSendErrRow) {
            errrowList = this.addErrRow(operationList, nename, boardname);
        } else {
            operation = (Operation)operationList.get(0);
            param = new Param("nename", nename);
            secondSendErrRow.addParam(param);
            this.slotid = operation.getInput().getPartValue("slotid");
            param = new Param("slotid", this.slotid);
            secondSendErrRow.addParam(param);
            boardname = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(this.slotid)).getBoardName();
            param = new Param("boardname", boardname);
            secondSendErrRow.addParam(param);
            param = new Param("attrid", "queryportattr");
            secondSendErrRow.addParam(param);
            errrowList.add(secondSendErrRow);
            operationList.clear();
        }
        param = null;
        if (0 != operationList.size()) {
            int paramlen = this.outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < paramlen; ++i) {
                RowParams rowparam = this.outputData.getBussinessParams().getRowParams(i);
                if (rowparam.getParam("isVBData").getValue().equals("1")) continue;
                String portid = rowparam.getParam("portid").getValue();
                String vbport = rowparam.getParam("vbport").getValue();
                this.setPortAttrValue(rowparam, portid, vbport);
            }
        }
        this.addErrRow(rowerrors, errrowList);
        this.setGlobalErrCode(errrowList);
    }

    public ArrayList addErrRow(ArrayList operationList, String nename, String boardname) {
        ArrayList<RowErrors> errrowList = new ArrayList<RowErrors>();
        RowErrors rowerr = null;
        String errCode = null;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            Operation operation = (Operation)operationList.get(i);
            errCode = operation.getOutput(0).getFault(0).getCode();
            if (errCode.equals(ADD_SVLAN_BASE_PORT) || errCode.equals("38737")) continue;
            rowerr = this.handleErrAttrValue(operation, nename, boardname);
            errrowList.add(rowerr);
            operationList.remove(i);
        }
        return errrowList;
    }

    public void addVBAttrParam(int rowlen) {
        RowParams[] rowparams = this.outputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rowlen; ++i) {
            if (!this.vbtypeModifyFlg) {
                rowparams[i].getParam("vbtype").setValue(this.vbtype);
            }
            if (!this.vbmode.equals("")) {
                rowparams[i].getParam("vbswitchtype").setValue(this.vbmode);
                rowparams[i].getParam("vbstudytype").setValue(this.getStudyMode(this.vbmode));
                rowparams[i].getParam("ingressfilter").setValue(this.getIngressStatus(this.vbmode));
            } else {
                String vbswitchtype = this.getVBMode(rowparams[i].getParam("vbstudytype").getValue(), rowparams[i].getParam("ingressfilter").getValue());
                rowparams[i].getParam("vbswitchtype").setValue(vbswitchtype);
            }
            this.outputData.getBussinessParams().getRowParams(i).getParam("macaddrenable").setValue(this.macenable);
            this.outputData.getBussinessParams().getRowParams(i).getParam("isVBData").setValue("1");
        }
    }

    public RowErrors[] addErrAttr(RowErrors[] rowerrors) {
        Param param = null;
        if (null != rowerrors && rowerrors.length > 0) {
            for (int i = 0; i < rowerrors.length; ++i) {
                param = new Param();
                if (null != rowerrors[i].getParam("vbid")) {
                    param.setName("attrid");
                    param.setValue("queryvb");
                } else {
                    param.setName("attrid");
                    param.setValue("queryvblink");
                }
                rowerrors[i].addParam(param);
            }
        }
        return rowerrors;
    }

    public void initLinkPortParam() {
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid).getVBList(this.neid);
        ArrayList vbLinkList = vbInfoList.getLinkPorts(this.firstVBId);
        Param param = null;
        TELinkPortInfo linkport = null;
        for (int i = 0; i < vbLinkList.size(); ++i) {
            linkport = (TELinkPortInfo)vbLinkList.get(i);
            RowParams rowparam = new RowParams();
            param = new Param("linkid", linkport.getLinkid());
            rowparam.addParam(param);
            String vbport = linkport.getLpNo();
            param = new Param("vbport", vbport);
            rowparam.addParam(param);
            String portid = linkport.getPortId();
            param = new Param("portid", portid);
            rowparam.addParam(param);
            param = new Param("portname", linkport.getPortName());
            rowparam.addParam(param);
            param = new Param("direction", linkport.getDirection());
            rowparam.addParam(param);
            param = new Param("cvlan", linkport.getCVlan());
            rowparam.addParam(param);
            param = new Param("svlan", linkport.getSVlan());
            rowparam.addParam(param);
            param = new Param("cpriority", linkport.getCpriority());
            rowparam.addParam(param);
            param = new Param("spriority", linkport.getSpriority());
            rowparam.addParam(param);
            param = new Param("porttype", "-");
            rowparam.addParam(param);
            param = new Param("portenable", "-");
            rowparam.addParam(param);
            param = new Param("portTag", "-");
            rowparam.addParam(param);
            param = new Param("VLAN", "-");
            rowparam.addParam(param);
            param = new Param("VLANPRIORITY", "-");
            rowparam.addParam(param);
            param = new Param("ATTR_ETHOVERSDH_MAC_WORKMODE", "-");
            rowparam.addParam(param);
            param = new Param("hubspoke", "-");
            rowparam.addParam(param);
            param = new Param("isVBData", ADD_SVLAN_BASE_PORT);
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowparam);
        }
    }

    public RowErrors handleErrAttrValue(Operation operation, String nename, String boardname) {
        RowErrors rowerr = new RowErrors();
        Param param = new Param("nename", nename);
        rowerr.addParam(param);
        this.slotid = operation.getInput().getPartValue("slotid");
        param = new Param("slotid", this.slotid);
        rowerr.addParam(param);
        param = new Param("boardname", boardname);
        rowerr.addParam(param);
        if (operation.getInput().getPart("vbid") != null) {
            param = new Param("lpNo", operation.getInput().getPartValue("vbport"));
            rowerr.addParam(param);
            param = new Param("attrid", "queryhub");
            rowerr.addParam(param);
        }
        if (operation.getInput().getPart("port") != null) {
            param = new Param("portid", operation.getInput().getPartValue("port"));
            rowerr.addParam(param);
            param = new Param("attrid", "queryportattr");
            rowerr.addParam(param);
        }
        rowerr.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(operation.getOutput(0).getFault(0).getCode())));
        return rowerr;
    }

    public void setPortAttrValue(RowParams rowparam, String portid, String vbport) {
        for (int j = 0; j < this.operationList.size(); ++j) {
            String temp;
            Operation operation = (Operation)this.operationList.get(j);
            if (operation.getName().equals("NSCMD_ETHN_GET_PORT_TYPE")) {
                if (portid.equals(ADD_SVLAN_BASE_PORT) || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                String porttype = operation.getOutput(0).getPartValue("PE_TYPE");
                rowparam.getParam("porttype").setValue(porttype);
                continue;
            }
            if (operation.getName().equals("NSCMD_ETHN_GET_PORTENABLE")) {
                if (portid.equals(ADD_SVLAN_BASE_PORT) || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                String portenable = operation.getOutput(0).getPartValue("ATTR_ETHOVERSDH_MAC_ENABLE");
                rowparam.getParam("portenable").setValue(portenable);
                continue;
            }
            if (operation.getName().equals("NSCMD_ETHN_GET_ETHTAG")) {
                if (portid.equals(ADD_SVLAN_BASE_PORT) || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                temp = operation.getOutput(0).getPartValue("portTag");
                rowparam.getParam("portTag").setValue(temp);
                continue;
            }
            if (operation.getName().equals("NSCMD_ETHN_GET_VLANID")) {
                if (portid.equals(ADD_SVLAN_BASE_PORT) || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                temp = operation.getOutput(0).getPartValue("VLAN");
                rowparam.getParam("VLAN").setValue(temp);
                temp = operation.getOutput(0).getPartValue("VLANPRIORITY");
                rowparam.getParam("VLANPRIORITY").setValue(temp);
                continue;
            }
            if (operation.getName().equals("NSCMD_ETHN_GET_ETHWORKMODE")) {
                if (portid.equals(ADD_SVLAN_BASE_PORT) || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                temp = operation.getOutput(0).getPartValue("ATTR_ETHOVERSDH_MAC_WORKMODE");
                rowparam.getParam("ATTR_ETHOVERSDH_MAC_WORKMODE").setValue(temp);
                continue;
            }
            if (!operation.getName().equals("NSCMD_ETHN_GET_VBLP_HUBSPOKEN")) continue;
            this.addHubSpokeValue(rowparam, vbport, operation);
        }
    }

    public void addHubSpokeValue(RowParams rowparam, String vbport, Operation operation) {
        int outputlen = operation.getOutputCount();
        for (int k = 0; k < outputlen; ++k) {
            if (!vbport.equals(operation.getOutput(k).getPartValue("vbport"))) continue;
            String hubspoke = operation.getOutput(k).getPartValue("hubspoke");
            rowparam.getParam("hubspoke").setValue(hubspoke);
            break;
        }
    }

    public void addErrRow(RowErrors[] rowerrors, ArrayList errrowList) {
        RowParams rowparam = new RowParams();
        if (rowerrors != null) {
            rowparam.setRowErrors(rowerrors);
        }
        int errlen = errrowList.size();
        for (int i = 0; i < errlen; ++i) {
            rowparam.addRowErrors((RowErrors)errrowList.get(i));
        }
        if (0 != rowparam.getRowErrorsCount()) {
            this.outputData.getBussinessParams().addRowParams(rowparam);
        }
    }

    public void setGlobalErrCode(ArrayList errrowList) {
        if (errrowList.size() == 0 && this.outputData.getErrorMessage().getErrorcode().equals(ADD_SVLAN_BASE_PORT)) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (errrowList.size() > 0 || !this.outputData.getErrorMessage().getErrorcode().equals(ADD_SVLAN_BASE_PORT)) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
    }

    private String getStudyMode(String vbmode) {
        switch (Integer.parseInt(vbmode)) {
            case 1: 
            case 2: {
                return VBTYPE_AD;
            }
            case 3: 
            case 4: {
                return "1";
            }
        }
        return "";
    }

    private String getIngressStatus(String vbmode) {
        switch (Integer.parseInt(vbmode)) {
            case 1: 
            case 3: {
                return "1";
            }
            case 2: 
            case 4: {
                return ADD_SVLAN_BASE_PORT;
            }
        }
        return "";
    }

    private void addOperationGetLinkByVB(int neID, Datainterface inputData) {
        try {
            String slotID = "";
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                for (Param tempParam : rowParams[i].getParam()) {
                    if (null == tempParam || !tempParam.getName().equals("slotid")) continue;
                    slotID = tempParam.getValue();
                }
            }
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_ETHN_GET_LINK_BY_VB");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(slotID);
            part = input.getPart("vbid");
            part.setValue("1");
            part = input.getPart("lportid");
            part.setValue(ADD_SVLAN_BASE_PORT);
            this.operationList.add(3, oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
    }
}

