/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.convertor.TEVersionConvertUtil;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEParseEthLanConfFile {
    private static TEParseEthLanConfFile instance = null;
    private Map logFuncNodeMap = new HashMap();
    private String FILE_NAME = "ethlanconf.xml";

    private TEParseEthLanConfFile() {
    }

    public static synchronized TEParseEthLanConfFile getInstance() {
        if (instance == null) {
            instance = new TEParseEthLanConfFile();
        }
        return instance;
    }

    private void parseXMLFile(int neid) {
        Document doc = null;
        try {
            StringBuffer filepath = new StringBuffer(TEResourceManager.getPath()).append("nemgr").append(File.separator).append("ip").append(File.separator).append("sdh").append(File.separator).append("conf").append(File.separator).append("ethlanservice").append(File.separator).append(this.FILE_NAME);
            Bundle bundle = FrameworkUtil.getBundle(TEParseEthLanConfFile.class);
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)filepath.toString());
            if (null == doc) {
                TELogFactory.getNormalLogger().info("Parse log file fail!");
                return;
            }
            Element root = doc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node aNode = children.item(i);
                if (!(aNode instanceof Element)) continue;
                String nodeName = aNode.getAttributes().getNamedItem("cp_type").getNodeValue();
                this.logFuncNodeMap.put(nodeName, aNode);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get log info failed", (Throwable)e);
        }
    }

    public Node getNodeByFuncCode(int neid, String cptype) {
        Object returnNode;
        if (this.logFuncNodeMap.size() == 0) {
            this.parseXMLFile(neid);
        }
        return (returnNode = this.logFuncNodeMap.get(cptype)) == null ? null : (Node)returnNode;
    }

    public String getChildNodeAttrValue(int neid, String cptype, String nodeName, String noAttrName) {
        String vbarrStr = "";
        Node boardInfoNode = this.getNodeByFuncCode(neid, cptype);
        if (null == boardInfoNode || null == boardInfoNode.getChildNodes()) {
            return vbarrStr;
        }
        NodeList attrList = boardInfoNode.getChildNodes();
        Node attrNode = null;
        int nodelen = attrList.getLength();
        for (int i = 0; i < nodelen; ++i) {
            attrNode = attrList.item(i);
            if (!(attrNode instanceof Element) || !attrNode.getNodeName().equals(nodeName)) continue;
            vbarrStr = attrNode.getAttributes().getNamedItem(noAttrName).getNodeValue();
            break;
        }
        if (-1 == vbarrStr.indexOf("[")) {
            return vbarrStr;
        }
        vbarrStr = this.parseListString(vbarrStr);
        return vbarrStr;
    }

    public String[] getOpetionStr(int neid, String cptype, String nodeName, String noAttrName) {
        String[] optionStr = new String[]{};
        Node boardInfoNode = this.getNodeByFuncCode(neid, cptype);
        if (null == boardInfoNode || null == boardInfoNode.getChildNodes()) {
            return optionStr;
        }
        NodeList attrList = boardInfoNode.getChildNodes();
        Node attrNode = null;
        NodeList optionNodeList = null;
        int nodelen = attrList.getLength();
        for (int i = 0; i < nodelen; ++i) {
            attrNode = attrList.item(i);
            if (!(attrNode instanceof Element) || !attrNode.getNodeName().equals(nodeName)) continue;
            optionNodeList = attrNode.getChildNodes();
            break;
        }
        if (optionNodeList == null) {
            TELogFactory.getNormalLogger().error("TEParseEthLanConfFile.getOpetionStr() optionNodeList is null");
            return optionStr;
        }
        optionStr = this.handleOptionMap(neid, optionNodeList);
        return optionStr;
    }

    public String[] handleOptionMap(int neid, NodeList optionNodeList) {
        StringBuilder vbtypeStrBuf = new StringBuilder();
        StringBuffer optionStrBuf = new StringBuffer();
        Node attrNode = null;
        int neVersion = TEConvertUtil.convertVerStrToInt((String)TEConfigurationDataMgr.getInstance().getNE(neid).getHostVersion());
        for (int i = 0; i < optionNodeList.getLength(); ++i) {
            String vbtypeStr = "";
            String optionStr = "";
            attrNode = optionNodeList.item(i);
            if (attrNode instanceof Element && attrNode.getNodeName().equals("option")) {
                if (attrNode.getAttributes().getNamedItem("neversion") != null) {
                    int[] from = new int[1];
                    int[] to = new int[1];
                    TEVersionConvertUtil.parseVerFromTo((String)attrNode.getAttributes().getNamedItem("neversion").getNodeValue(), (int[])from, (int[])to);
                    if (from[0] > neVersion || neVersion > to[0]) continue;
                }
                vbtypeStr = attrNode.getAttributes().getNamedItem("vbtype").getNodeValue();
                optionStr = attrNode.getAttributes().getNamedItem("mode").getNodeValue();
            }
            if (-1 != vbtypeStr.indexOf("[")) {
                vbtypeStr = this.parseListString(vbtypeStr);
            }
            if (-1 != optionStr.indexOf("[")) {
                optionStr = this.parseListString(optionStr);
            }
            if (optionStr.equals("") || vbtypeStr.equals("")) continue;
            vbtypeStrBuf.append(vbtypeStr).append(",");
            optionStrBuf.append(vbtypeStr).append(":").append(optionStr).append(";");
        }
        if (optionStrBuf.length() == 0) {
            return new String[0];
        }
        String[] str = new String[]{vbtypeStrBuf.toString().substring(0, vbtypeStrBuf.length() - 1), optionStrBuf.toString().substring(0, optionStrBuf.length() - 1)};
        return str;
    }

    public String getNodeAttrValue(int neid, String cptype, String attrName) {
        String vbStaticStr = "";
        Node boardInfoNode = this.getNodeByFuncCode(neid, cptype);
        if (null == boardInfoNode) {
            return vbStaticStr;
        }
        vbStaticStr = boardInfoNode.getAttributes().getNamedItem(attrName).getNodeValue();
        return vbStaticStr;
    }

    private String parseListString(String vbtypeSting) {
        String arrStr = "";
        StringBuffer arrStrBuf = new StringBuffer();
        if (null == vbtypeSting || "".equals(vbtypeSting.trim())) {
            return arrStr;
        }
        arrStr = vbtypeSting.substring(1, vbtypeSting.length() - 1);
        if (-1 == arrStr.indexOf("-")) {
            return arrStr;
        }
        String[] stringlistarr = arrStr.split(",");
        String listStr = null;
        int minno = -1;
        int maxno = -1;
        for (int i = stringlistarr.length - 1; i >= 0; --i) {
            listStr = stringlistarr[i];
            if (listStr.indexOf("-") > 0) {
                minno = Integer.parseInt(listStr.split("-")[0]);
                maxno = Integer.parseInt(listStr.split("-")[1]);
                for (int portno = minno; portno <= maxno; ++portno) {
                    if (0 != arrStrBuf.length()) {
                        arrStrBuf.append(",");
                    }
                    arrStrBuf.append((Object)portno);
                }
                continue;
            }
            arrStrBuf.append(",");
            arrStrBuf.append(Integer.valueOf(listStr));
        }
        return arrStrBuf.toString();
    }
}

