/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEGetAvailablePortBean
extends TENEExplorerBean {
    private static final int VB_AVAILPORT_NOT_ENOUGH = 140107;
    private static final int VCTRUNKFLG = 32768;
    private static final int IFUPFLG = 36864;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
            TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
            int boardType = configurDataMgr.getBoardType(neid, slotid);
            ArrayList allportList = configurDataMgr.getLogicPortList(neid, slotid);
            ArrayList ethportList = configurDataMgr.getETHMACPort(neid, boardType);
            ethportList.retainAll(allportList);
            ArrayList vctrunkList = configurDataMgr.getETHVCTrunkPort(neid, boardType);
            ethportList.addAll(vctrunkList);
            if (ethportList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)140107));
            } else {
                super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        RowParams rowParams2 = null;
        int portId = -1;
        String portName = "";
        for (RowParams rowParams2 : rowParamses) {
            portId = Integer.parseInt(rowParams2.getParam("port").getValue());
            portName = portId - 36864 > 0 ? "IFUP" + (portId - 36864) : (portId - 32768 > 0 ? "VCTRUNK" + (portId - 32768) : "PORT" + portId);
            rowParams2.getParam("portname").setValue(portName);
            rowParams2.getParam("port").setName("portid");
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

