/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethertest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TESevCnTestProcess {
    private static TESevCnTestProcess instance = null;
    private List resList = new ArrayList();
    private List outTimeList = new ArrayList();
    private int neid;

    public void setNeid(int neid) {
        this.neid = neid;
    }

    private TESevCnTestProcess() {
    }

    public synchronized List getResData() {
        return this.resList;
    }

    public synchronized List getOutTimeData() {
        return this.outTimeList;
    }

    public static synchronized TESevCnTestProcess getInstance(int neid) {
        if (instance == null) {
            instance = new TESevCnTestProcess();
            instance.setNeid(neid);
            instance.registerListener();
        }
        return instance;
    }

    private void registerListener() {
        TESevCnTestNoticeHandler SevCnTestNotice = new TESevCnTestNoticeHandler();
        try {
            TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_ETHN_RMTSRVINFO"), (NoticeHandler)SevCnTestNotice);
            TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)"NSEVT_ETHN_RMTSRVINFO_OVERTIME"), (NoticeHandler)SevCnTestNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESevCnTestProcess registerListener error!", (Throwable)e);
        }
    }

    public void clear() {
        this.resList.clear();
        this.outTimeList.clear();
    }

    static class TESevCnOutTime {
        private String slotid;
        private String port;

        TESevCnOutTime() {
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getSlotid() {
            return this.slotid;
        }

        public void setSlotid(String slotid) {
            this.slotid = slotid;
        }

        public String toString() {
            ErrorMessage errMsg = TEErrorResourceUtil.getErrorMessage((int)1090724359);
            return errMsg.getErrorinfo();
        }
    }

    static class TESevCnResponse {
        private String slotid;
        private String port;
        private String rmNeId;
        private String rmNeName;
        private String rmSlotid;
        private String rmPort;

        TESevCnResponse() {
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getRmNeId() {
            return this.rmNeId;
        }

        public void setRmNeId(String rmNeId) {
            this.rmNeId = rmNeId;
        }

        public String getRmNeName() {
            return this.rmNeName;
        }

        public void setRmNeName(String rmNeName) {
            this.rmNeName = rmNeName;
        }

        public String getRmPort() {
            return this.rmPort;
        }

        public String getRmPortName() {
            StringBuilder name = new StringBuilder("");
            if (Integer.valueOf(this.rmPort) >= 32768) {
                name.append("VCTRUNK").append(Integer.valueOf(this.rmPort) - 32768);
            } else {
                name.append("port").append(this.rmPort);
            }
            return name.toString();
        }

        public void setRmPort(String rmPort) {
            this.rmPort = rmPort;
        }

        public String getRmSlotid() {
            return this.rmSlotid;
        }

        public void setRmSlotid(String rmSlotid) {
            this.rmSlotid = rmSlotid;
        }

        public String getSlotid() {
            return this.slotid;
        }

        public void setSlotid(String slotid) {
            this.slotid = slotid;
        }

        public String toString() {
            StringBuilder res = new StringBuilder("");
            if (!"".equals(this.rmNeId)) {
                res.append("NeID:").append("            ").append(TEConfigurationDataMgr.getInstance().getFullNeID(Integer.valueOf(this.rmNeId).intValue())).append("\n");
            }
            if (!"".equals(this.rmNeName)) {
                res.append("Ne Name:").append("         ").append(this.rmNeName).append("\n");
            }
            if (!"".equals(this.rmSlotid)) {
                res.append("Slot ID:").append("         ").append(this.rmSlotid).append("\n");
            }
            if (!"".equals(this.rmPort)) {
                res.append("Port:").append("            ").append(this.getRmPortName()).append("\n");
            }
            res.append("\n");
            return res.toString();
        }
    }

    static class TESevCnTestNoticeHandler
    implements NoticeHandler {
        TESevCnTestNoticeHandler() {
        }

        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String operName = operation.getName();
            if ("NSEVT_ETHN_RMTSRVINFO".equals(operName)) {
                this.processSevCnRsp(neID, operation);
            } else if ("NSEVT_ETHN_RMTSRVINFO_OVERTIME".equals(operName)) {
                this.processSevCnOutTime(neID, operation);
            }
        }

        private void processSevCnRsp(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            TESevCnTestProcess instance = TESevCnTestProcess.getInstance(neid);
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TESevCnResponse data = new TESevCnResponse();
                data.setSlotid(outputArr[i].getPart("slotid").getValue());
                data.setPort(outputArr[i].getPart("port").getValue());
                data.setRmNeId(outputArr[i].getPart("rmNeId").getValue());
                data.setRmNeName(outputArr[i].getPart("rmNeName").getValue().trim());
                data.setRmSlotid(outputArr[i].getPart("rmSlotid").getValue());
                data.setRmPort(outputArr[i].getPart("rmPort").getValue());
                instance.getResData().add(data);
            }
        }

        private void processSevCnOutTime(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            TESevCnTestProcess instance = TESevCnTestProcess.getInstance(neid);
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TESevCnOutTime data = new TESevCnOutTime();
                data.setSlotid(outputArr[i].getPart("slotid").getValue());
                data.setSlotid(outputArr[i].getPart("port").getValue());
                instance.getOutTimeData().add(data);
            }
        }
    }
}

