/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethertest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.ethertest.TEEtherTestReport;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryEtherTest
extends TENEExplorerBean {
    private static final int BOARDTYPE_EMS = 1210;
    private static final int VCTRUNK = 32768;
    private static final String INVAILEDNUM = "65535";
    private static final String CFGGETISNULL = "38662";
    private static final String TEMPSTATE = "2";
    int slotID = -1;
    private String operObj = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
            this.slotID = Integer.parseInt(slotidParam.getValue());
            TEEtherTestReport ethTestReport = TEEtherTestReport.getTthTestReport(neid, this.slotID);
            Param reportParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"report");
            if (null != reportParam && "true".equals(reportParam.getValue())) {
                return this.reportData(ethTestReport);
            }
            this.outputData = new Datainterface();
            this.operationList = this.convertToOperation(subFunc, inputData, neid);
            int result = this.sendMessage(neid);
            if (result == 0) {
                if (!ethTestReport.hasRegisterd()) {
                    ethTestReport.register();
                }
                this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private Datainterface reportData(TEEtherTestReport ethTestReport) {
        Param portParam = Datainterface.getParam((Param[])this.inputData.getBussinessParams().getRowParams(0).getParam(), (String)"port");
        String ports = portParam.getValue();
        String[] portArray = ports.split(",");
        Datainterface reportData = ethTestReport.getReportData();
        String tempPort = "";
        Datainterface returnReportData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        returnReportData.setBussinessParams(bussinessParams);
        block0: for (int len = reportData.getBussinessParams().getRowParamsCount() - 1; len >= 0; --len) {
            tempPort = reportData.getBussinessParams().getRowParams(len).getParam("portid").getValue();
            RowParams rowparams = reportData.getBussinessParams().getRowParams(len);
            RowParams tempParams = (RowParams)rowparams.clone();
            int portlen = portArray.length;
            for (int i = 0; i < portlen; ++i) {
                if (!tempPort.equals(portArray[i])) continue;
                bussinessParams.addRowParams(tempParams);
                this.setRowParams(rowparams);
                continue block0;
            }
        }
        return returnReportData;
    }

    private void setRowParams(RowParams rowparams) {
        int len = rowparams.getParamCount();
        for (int i = 0; i < len; ++i) {
            rowparams.getParam("testFrameState").setValue(TEMPSTATE);
        }
    }

    private ArrayList convertToOperation(SubFunc subFunc, Datainterface inputData, int neid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        ArrayList supportVCTRUNKPort = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(neid, boardType);
        Operation oper = null;
        Input input = null;
        Part part = null;
        int len = supportVCTRUNKPort.size();
        for (int i = 0; i < len; ++i) {
            oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_TESTEN");
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper);
            oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_TESTCOUNT");
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData) {
            return;
        }
        RowParams rowParams = null;
        String portid = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (0 == rowParams.getParamCount()) continue;
            portid = rowParams.getParam("portid").getValue();
            portid = portid.equals(INVAILEDNUM) ? "" : (Integer.parseInt(portid) > 32768 ? "VCTRUNK" + (Integer.parseInt(portid) - 32768) : "PORT" + portid);
            rowParams.getParam("portid").setValue(portid);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(new Integer(CFGGETISNULL));
        return codeList;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuilder sb = new StringBuilder();
        Param slot = rowparams.getParam("slotid");
        if (slot != null && !slot.getValue().equals("")) {
            int slotID = Integer.parseInt(slot.getValue());
            TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
            int boardType = configurDataMgr.getBoard(this.neid, slotID).getBoardType();
            sb.append(slotID).append('-').append(configurDataMgr.getBoardTypeName(this.neid, boardType));
            Param port = rowparams.getParam("port");
            if (port != null && !port.getValue().equals("")) {
                int portID = Integer.parseInt(port.getValue());
                sb.append('-').append(configurDataMgr.getPortName(this.neid, slotID, boardType, portID));
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return this.subfunc.getSubFuncDes(this.neid);
    }
}

