/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.erps.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.nemgr.ip.sdh.erps.beanplugin.TEETHERPSBeanPluginUtil;
import com.huawei.nglct.po.embeddednemgrmo.TEETHERPSMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEERPSQueryBeanPlugin
extends TEBeanPlugin {
    private HashMap<Integer, TEETHERPSMOPO> erpsMOMap = new HashMap();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        if (operationList.isEmpty()) {
            errRet.setResult(0);
            return errRet;
        }
        Operation opertion = operationList.get(0);
        this.initERPSMap(opertion);
        this.queryErpsDetail(neid);
        HashMap<Integer, TEETHERPSMOPO> dataMOMap = new HashMap<Integer, TEETHERPSMOPO>();
        TEDaoOperationResult dbResult = TEETHERPSBeanPluginUtil.findNEERpsFromDB(neid);
        if (dbResult != null && dbResult.getResult() == 0) {
            List dbDataList = dbResult.getData();
            int size = dbDataList.size();
            for (int i = 0; i < size; ++i) {
                TEETHERPSMOPO dataMO = (TEETHERPSMOPO)dbDataList.get(i);
                dataMOMap.put(dataMO.getErpsID(), dataMO);
            }
        }
        ArrayList<TEETHERPSMOPO> needUpdateData = new ArrayList<TEETHERPSMOPO>();
        for (Map.Entry<Integer, TEETHERPSMOPO> entry : this.erpsMOMap.entrySet()) {
            int erpsID = entry.getKey();
            TEETHERPSMOPO erpsMo = entry.getValue();
            TEETHERPSMOPO tmpMO = (TEETHERPSMOPO)dataMOMap.get(erpsID);
            if (tmpMO != null) {
                needUpdateData.add(erpsMo);
                continue;
            }
            TEETHERPSBeanPluginUtil.createNEERpsToDB(neid, erpsMo, errRet);
        }
        if (!needUpdateData.isEmpty()) {
            TEETHERPSBeanPluginUtil.updateNEERpsToDB(neid, needUpdateData, errRet);
        }
        return errRet;
    }

    private void initERPSMap(Operation opertion) {
        int size = opertion.getOutputCount();
        for (int i = 0; i < size; ++i) {
            Output output = opertion.getOutput(i);
            TEETHERPSMOPO erpsMo = new TEETHERPSMOPO();
            int erpsID = TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("erpsid"));
            erpsMo.setErpsID(erpsID);
            erpsMo.setSlotID(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("slotid")));
            erpsMo.setEastSubSlotId(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("eastSubSlotId")));
            erpsMo.setEastPortID(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("eastPortId")));
            erpsMo.setWestSubSlotId(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("westSubSlotId")));
            erpsMo.setWestPortID(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("westPortId")));
            erpsMo.setRplPortID(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("rplPortId")));
            erpsMo.setIsRplOwner(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("isRPLOwnerFlag")));
            erpsMo.setCtrlVlan(TEETHERPSBeanPluginUtil.getIntValue(output.getPartValue("ctrlVlan")));
            erpsMo.setDesMacAddr(TEETHERPSBeanPluginUtil.getStrValue(output.getPartValue("desMacAddr")));
            this.erpsMOMap.put(erpsID, erpsMo);
        }
    }

    private void queryErpsDetail(int neid) {
        for (Map.Entry<Integer, TEETHERPSMOPO> entry : this.erpsMOMap.entrySet()) {
            int erpsID = entry.getKey();
            TEETHERPSMOPO erpsMo = entry.getValue();
            Datainterface inputData = this.createInputData(neid, erpsID);
            SubFunc subFunc = TEETHERPSBeanPluginUtil.getSubFunc(neid, 2172666);
            if (subFunc == null) continue;
            try {
                Datainterface outputData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neid, (SubFunc)subFunc, (Datainterface)inputData, null, null, null, (int)1);
                this.addErpsDetailToMo(outputData, erpsMo);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("query ERPS Detail fail! erpsID = " + erpsID, (Throwable)e);
            }
        }
    }

    private Datainterface createInputData(int neid, int erpsID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neid));
        row.addParam("erpsid", String.valueOf(erpsID));
        row.addParam("isLogFlag", "0");
        bussiness.addRowParams(row);
        return inputData;
    }

    private void addErpsDetailToMo(Datainterface outputData, TEETHERPSMOPO erpsMo) {
        if (outputData != null && outputData.getBussinessParams() != null) {
            int recordCount = outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < recordCount; ++i) {
                RowParams rowParams = outputData.getBussinessParams().getRowParams(i);
                int erpsID = TEETHERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("erpsid"));
                if (erpsID != erpsMo.getErpsID()) continue;
                erpsMo.setHoldOffTime(TEETHERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("holdoffTime")));
                erpsMo.setWtrTime(TEETHERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("wtrTime")));
                erpsMo.setGuardTime(TEETHERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("guardTime")));
                erpsMo.setEntityLevel(TEETHERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("entityLevel")));
                erpsMo.setPktTrsInterval(TEETHERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("sendInterval")));
            }
        } else if (outputData == null) {
            TELogFactory.getNormalLogger().info("outputData is null");
        } else if (outputData.getBussinessParams() == null) {
            TELogFactory.getNormalLogger().info("outputData.getBussinessParams() is null");
        }
    }
}

