/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.diffserv;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.sdh.diffserv.TEUsableResource;
import com.huawei.nglct.nemgr.ip.sdh.policy.portpolicy.TEQueryLogicalBoardBean;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetPortsBean
implements TENEMgrInterface {
    protected Datainterface datainterface = new Datainterface();
    protected BussinessParams bParams = new BussinessParams();
    protected int neID = -1;
    protected ArrayList usableResourceList = new ArrayList();
    protected static final int TIMEOUT = 10;
    protected static final int INVALID_SUBBOARD = 255;
    protected static final int MLPPP_PORT = 4096;
    protected static final int VIRTUAL_PORT = 10240;
    protected static final int SERIAL_PORT = 6144;
    protected TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    protected static final int LAST_E1_PORTID = 32;
    protected static final int LAST_FE_PORTID = 12;
    protected static final String INVALID_SUBSLOTID = "255";
    protected boolean processingBoardFlag = false;
    protected static final List dynBords = new ArrayList();
    protected ArrayList processingBoardList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getBoardList();
        Collections.sort(boardList);
        if (boardList == null || boardList.isEmpty()) {
            this.datainterface.setBussinessParams(this.bParams);
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        TEQueryLogicalBoardBean getBoardObj = new TEQueryLogicalBoardBean();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            try {
                TEUsableResource usableRes;
                TEBoard board = (TEBoard)boardList.get(i);
                int bdType = board.getBoardType();
                int slotID = board.getSlotID();
                String bdName = board.getBoardName();
                if (bdType == 941 || bdType == 1272) continue;
                List subBoardList = board.getSubBoardList();
                int len = subBoardList.size();
                int subBoardType = 0;
                int subBoardId = 0;
                List portList = null;
                String subdName = "";
                if (0 < len) {
                    for (int k = 0; k < len; ++k) {
                        TEUsableResource usableRes2;
                        TESubBoard subBoard = (TESubBoard)subBoardList.get(k);
                        subBoardId = subBoard.getSubSlotID();
                        subBoardType = subBoard.getSubBoardType();
                        portList = this.cfgDataMgr.getBoardPortList(neid, subBoardType);
                        ArrayList<String> portidList = new ArrayList<String>();
                        ArrayList<String> portNameList = new ArrayList<String>();
                        int size3 = portList.size();
                        for (int l = 0; l < size3; ++l) {
                            int portID = (Integer)portList.get(l);
                            portidList.add(l, portID + "");
                            String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, subBoardType, portID);
                            portNameList.add(l, portName);
                        }
                        if (!getBoardObj.isPortPolicySuppBoard(neid, subBoardType) || portidList.isEmpty() || this.usableResourceList.contains((Object)(usableRes2 = new TEUsableResource(slotID, bdName, subBoardId, subdName = this.cfgDataMgr.getBoardTypeName(this.neID, subBoardType), portidList, portNameList)))) continue;
                        this.usableResourceList.add(usableRes2);
                    }
                    continue;
                }
                portList = this.getPortList(neid, slotID, bdType);
                ArrayList<String> portidList = new ArrayList<String>();
                ArrayList<String> portNameList = new ArrayList<String>();
                int size3 = portList.size();
                for (int l = 0; l < size3; ++l) {
                    int portID = (Integer)portList.get(l);
                    if ((1135 == bdType || 1137 == bdType) && 0 == slotID % 2 && 32 == portID || 1133 == bdType && 2 == slotID % 4 && 12 == portID) continue;
                    portidList.add(l, portID + "");
                    String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, bdType, portID);
                    portNameList.add(l, portName);
                }
                if (portidList.isEmpty() || this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotID, bdName, subBoardId, subdName, portidList, portNameList)))) continue;
                this.usableResourceList.add(usableRes);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("CES");
        if (null != param) {
            this.processingBoardFlag = true;
            this.getProcessingBoard();
        }
        if (null != (param = inputData.getBussinessParams().getRowParams(0).getParam("pppFlag"))) {
            this.getQueryMLPPPOper();
        }
        if (null != (param = inputData.getBussinessParams().getRowParams(0).getParam("serialport"))) {
            this.getQuerySerialPortOper(boardList);
        }
        if (null != (param = inputData.getBussinessParams().getRowParams(0).getParam("vport"))) {
            this.getQueryVportOper();
        }
        return this.constructRtnData();
    }

    protected void getQuerySerialPortOper(Vector boardList) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int slotID = board.getSlotID();
            Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT");
            Input input = operation.getInput();
            input.setPartValue("slotid", slotID + "");
            input.setPartValue("subslotid", "0");
            input.setPartValue("serialport", "0");
            operationList.add(operation);
        }
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        size = operationList.size();
        for (int index = 0; index < size; ++index) {
            int slotid = 0;
            String boardname = "";
            int subslotid = 0;
            String subboardname = "";
            Operation tmpOper = (Operation)operationList.get(index);
            Output[] outputArr = tmpOper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEUsableResource usableRes;
                boolean emptyFlag = false;
                Output output = outputArr[i];
                for (Fault fault : output.getFault()) {
                    String code = fault.getCode();
                    if (null != code && Integer.parseInt(code) == 0) continue;
                    emptyFlag = true;
                    break;
                }
                if (emptyFlag) continue;
                slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardtype = this.cfgDataMgr.getBoardType(this.neID, slotid);
                boardname = this.cfgDataMgr.getBoardTypeName(this.neID, boardtype);
                subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                int subboardtype = 0;
                subboardname = "";
                if (255 == subslotid) {
                    subslotid = 0;
                } else {
                    subboardtype = this.cfgDataMgr.getSubboardType(this.neID, slotid, subslotid);
                    subboardname = this.cfgDataMgr.getBoardTypeName(this.neID, subboardtype);
                }
                int serialport = Integer.parseInt(output.getPartValue("serialport"));
                String portname = serialport - 6144 + "(Serial-" + (serialport - 6144) + ")";
                boolean isExist = false;
                int len2 = this.usableResourceList.size();
                for (int j = 0; j < len2; ++j) {
                    usableRes = (TEUsableResource)((Object)this.usableResourceList.get(j));
                    int slotidInArray = usableRes.getSlotID();
                    int subslotidInArray = usableRes.getSubslotID();
                    if (slotid != slotidInArray || subslotid != subslotidInArray) continue;
                    isExist = true;
                    ArrayList portidList = usableRes.getPortidList();
                    portidList.add(portidList.size(), serialport + "");
                    ArrayList portNameList = usableRes.getPortNameList();
                    portNameList.add(portNameList.size(), portname);
                }
                if (isExist) continue;
                ArrayList<String> portidList = new ArrayList<String>();
                portidList.add(serialport + "");
                ArrayList<String> portNameList = new ArrayList<String>();
                portNameList.add(portname);
                usableRes = new TEUsableResource(slotid, boardname, subslotid, subboardname, portidList, portNameList);
                this.usableResourceList.add(usableRes);
            }
        }
        operationList.clear();
    }

    protected void getQueryMLPPPOper() {
        TEUsableResource usableRes;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_MLPPP_GET_MP");
        Input input = operation.getInput();
        input.setPartValue("mpid", "0");
        operationList.add(operation);
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        int slotid = 255;
        String boardname = "ML-PPP";
        int subslotid = 255;
        String subboardname = "";
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList<String> portNameList = new ArrayList<String>();
        for (Output output : outputArr) {
            int mpid;
            boolean isRepeat;
            Fault[] faultArr = output.getFault();
            boolean isEmpty = false;
            for (Fault fault : faultArr) {
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                isEmpty = true;
                break;
            }
            if (isEmpty || (isRepeat = portidList.contains((mpid = Integer.parseInt(output.getPartValue("mpid"))) + ""))) continue;
            portidList.add(mpid + "");
            portNameList.add(mpid - 4096 + "(MP-" + (mpid - 4096) + ")");
        }
        if (0 < portidList.size() && !this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotid, boardname, subslotid, subboardname, portidList, portNameList)))) {
            this.usableResourceList.add(usableRes);
        }
    }

    protected void getQueryVportOper() {
        TEUsableResource usableRes;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_PORT_GET_VPORT");
        Input input = operation.getInput();
        input.setPartValue("slotid", INVALID_SUBSLOTID);
        input.setPartValue("subslotid", INVALID_SUBSLOTID);
        input.setPartValue("vport", "0");
        operationList.add(operation);
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        int slotid = 255;
        String boardname = "Virtual Ethernet";
        int subslotid = 255;
        String subboardname = "";
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList<String> portNameList = new ArrayList<String>();
        for (Output output : outputArr) {
            Fault[] faultArr = output.getFault();
            boolean isEmpty = false;
            for (Fault fault : faultArr) {
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                isEmpty = true;
                break;
            }
            if (isEmpty) continue;
            int vport = Integer.parseInt(output.getPartValue("vport"));
            portidList.add(vport + "");
            portNameList.add(vport - 10240 + "(VEther-" + (vport - 10240) + ")");
        }
        if (0 < portidList.size() && !this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotid, boardname, subslotid, subboardname, portidList, portNameList)))) {
            this.usableResourceList.add(usableRes);
        }
    }

    public Datainterface constructRtnData() {
        Param param;
        RowParams rParams;
        if (this.processingBoardFlag) {
            StringBuffer boardNameArray = new StringBuffer();
            int size = this.processingBoardList.size();
            for (int i = 0; i < size; ++i) {
                boardNameArray.append((String)this.processingBoardList.get(i)).append(',');
            }
            rParams = new RowParams();
            param = new Param("boardNameArray", boardNameArray.toString());
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            rParams = new RowParams();
            param = new Param("slotid", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("subslotid", String.valueOf(res.getSubslotID()));
            rParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            int size1 = res.getPortidList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortidList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            param = new Param("portName", (String)res.getPortNameList().get(0));
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortNameList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        this.datainterface.setBussinessParams(this.bParams);
        this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        return this.datainterface;
    }

    protected void sortInSlot() {
        int rowCount = this.bParams.getRowParamsCount();
        for (int j = 0; j < rowCount; ++j) {
            int len = this.bParams.getRowParamsCount();
            for (int i = 0; i < len - j - 1; ++i) {
                RowParams rowparam = this.bParams.getRowParams(i);
                RowParams rowparamNext = this.bParams.getRowParams(i + 1);
                String slotid = rowparam.getParam("slotid").getValue();
                String slotnext = rowparamNext.getParam("slotid").getValue();
                if (Integer.parseInt(slotid) <= Integer.parseInt(slotnext)) continue;
                String tempslot = rowparam.getParam("slotid").getValue();
                String tempbdName = rowparam.getParam("boardName").getValue();
                String tempportid = rowparam.getParam("portid").getValue();
                String tempport = rowparam.getParam("portName").getValue();
                rowparam.getParam("slotid").setValue(rowparamNext.getParam("slotid").getValue());
                rowparam.getParam("boardName").setValue(rowparamNext.getParam("boardName").getValue());
                rowparam.getParam("portid").setValue(rowparamNext.getParam("portid").getValue());
                rowparam.getParam("portName").setValue(rowparamNext.getParam("portName").getValue());
                rowparamNext.getParam("slotid").setValue(tempslot);
                rowparamNext.getParam("boardName").setValue(tempbdName);
                rowparamNext.getParam("portid").setValue(tempportid);
                rowparamNext.getParam("portName").setValue(tempport);
            }
        }
    }

    protected List getPortList(int neid, int slotid, int boardType) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getNEType() == 37 && 226 != boardType) {
            return new ArrayList();
        }
        ArrayList<Integer> allPortList = TESpecialAttrMgr.getInstance().getCPAttrListValue(neid, slotid, "TE_FUNC_PORT_GROUP", "BOARD_SUPPORT_MSTP_FEATURE");
        if (null == allPortList || allPortList.isEmpty()) {
            allPortList = this.cfgDataMgr.getBoardPortList(this.neID, boardType);
        }
        List<Integer> existPortList = null;
        if (1171 == boardType || 1125 == boardType || 1134 == boardType) {
            existPortList = this.getExistPortList(allPortList, slotid);
        }
        if (2386 == boardType) {
            allPortList.addAll(this.getExistPortList(allPortList, slotid));
            Collections.sort(allPortList);
        }
        if (TEVirtualPortUtil.isMSOTNBoard((int)neid, (int)slotid)) {
            List portList = TEConfigurationDataMgr.getInstance().getLogicPortList(neid, slotid, 63213);
            allPortList = new ArrayList<Integer>();
            existPortList = new ArrayList<Integer>();
            int len = portList.size();
            for (int i = 0; i < len; ++i) {
                existPortList.add(((TEPort)portList.get(i)).getPortNo());
            }
        }
        if (null == existPortList || existPortList.isEmpty()) {
            return allPortList;
        }
        return existPortList;
    }

    protected List<Integer> getExistPortList(List portList, int slotid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_SUBBD_GET_PORT");
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(String.valueOf(slotid));
        input.setPartValue("subslotid", INVALID_SUBSLOTID);
        input.setPartValue("port", "0");
        operationList.add(oper);
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        if (operationList.isEmpty()) {
            return returnList;
        }
        int result = TENECommMgr.getInstance().sendCommand((int)this.neID, operationList, (int)10).retCode;
        if (result == 0) {
            Operation oOperation = (Operation)operationList.get(0);
            for (Output output : oOperation.getOutput()) {
                if (!String.valueOf(0).equals(output.getFault()[0].getCode())) continue;
                String portId = output.getPartValue("port");
                returnList.add(Integer.valueOf(portId));
            }
        }
        return returnList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    protected void getProcessingBoard() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            String boardName;
            TEBoard board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            int slotid = board.getSlotID();
            if (2125 != boardType && 2111 != boardType && 226 != boardType || this.processingBoardList.contains(boardName = slotid + "-" + this.cfgDataMgr.getBoardTypeName(this.neID, boardType))) continue;
            this.processingBoardList.add(boardName);
        }
    }

    static {
        dynBords.add(1171);
        dynBords.add(1125);
        dynBords.add(2261);
        dynBords.add(2260);
        dynBords.add(1134);
    }
}

