 // url  
var winurlobj = getNeProperty(self);

var ids = null;
var lightcycle = new Object();
lightcycle["0"] = RESOURCE["notCycle"];
lightcycle["1"] = RESOURCE["inCycle"];
lightcycle["2"] = RESOURCE["outCycle"];

var laserswitch = new Object();
laserswitch[0] = RESOURCE["close"];
laserswitch[1] = RESOURCE["open"];
laserswitch[2] = RESOURCE["als"];

var hasApplyRight = true;

var confirmStr1 = "";
var confirmStr2 = "";
var confirmStr3 = "";

var BOARD_TYPE_EFP6 = 2057;

function initpage()
{
	st = new SortTable();
	st.setImage("../../../../images/");
	st.setBodyHeight("280");

	tc = window.tableconf[0];

	var attrArr = getNeProperty(self)["supportAttr"].split(",");

	ids = getIDs();

	createTableHead(st, tc);
	st.setOnCellEditHandler(cellEditHandler);
	document.getElementById("tablecomponent").appendChild(st.getTable());
	window.onresize = function()
	{
		st.setBodyHeight(getTableHeight($("tablecomponent"), st) + "px");
	}
	$("tablecomponent").oncontextmenu = popupMenuHandler;

	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("printBtn").value = RESOURCE["printbutton"];
        $("saveAsFileBtn").value = RESOURCE["savefile"];

	sendQueryInfo();
}

/**
 *           
 */
function changeTableHead(selectAttr)
{
	st.deleteHeadRow();
	st.element.colsArray.length = 0;
	newtc.colArray.length = 0;

	initTableHead(selectAttr);
	createTableHead(st, newtc);

	st.clearTableData();
	sendQueryInfo();
}

/**
 *    tableconf
 */
function initTableHead(selectAttr)
{
	var flag = false;
	var selectedItem;

	if (null == selectAttr)
	{
		return;
	}
	else
	{
		selectedItem = selectAttr;
	}
	for ( var i = 0; i < window.tableconf.length; i++)
	{
		for ( var j = 0; j < window.tableconf[i].colArray.length; j++)
		{
			if (window.tableconf[i].colArray[j].id != selectedItem)
			{
				continue;
			}

			newtc.colArray[0] = window.tableconf[i].colArray[0];
			newtc.colArray[0].width = "10%";
			newtc.colArray[1] = window.tableconf[i].colArray[j];
			newtc.colArray[1].width = "10%";
			flag = true;
			break;
		}

		if (flag)
		{
			break;
		}
	}
}

/**
 *               
 * 
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if (hasApplyRight)
	{
		$("applybtn").disabled = false;
	}
}

function sendQueryInfo()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("printBtn").disabled = true;
        $("saveAsFileBtn").disabled = true;

	var neid = winurlobj.neid;
	var slotid = winurlobj.slotid;

	var xmlstr = createGetXML(neid, slotid, tc);
	urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GETSDHATTR;
	loadXMLdoc(urlreq, "POST", true, queryCallBack, null, "inputdata=" + xmlstr);
}

/**
 *          XML  
 * 
 * @param neid:  ID
 *            slotid:  ID tableconf:        
 * @return String:       XML  
 */

function createGetXML(neid, slotid, tableconf)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcObjType");
	param.setAttribute("value", "ID_OBJECT_TYPE_NE_BOARD");
	row.appendChild(param);

	var colid;
	var attrFlag = false;
	for ( var i = 1; i < tableconf.getColsLength(); i++)
	{
		colid = tableconf.getColId(i);
		param = new tagElement("param");
		param.setAttribute("name", "attrId");
		param.setAttribute("value", colid);
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function queryCallBack(doc)
{
	$("querybtn").disabled = false;
        $("printBtn").disabled = false;
        $("saveAsFileBtn").disabled = false;
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 2)
	{
		showErrorDialog(tc, data);
		return;
	}
	createGenCfgTableBody(st, tc, data, RESOURCE);
	var vc3Path;
	for ( var i = 0, m = st.getDataRowLength(); i < m; i++)
	{
		var nename = st.getCellStoreValue(i, "vc3path", "nename");
		var slotid = st.getCellStoreValue(i, "vc3path", "slotid");
		var boardname = st.getCellStoreValue(i, "vc3path", "boardname");
		vc3Path = nename + "-" + slotid + "-" + boardname + "-";
		var pathtype = parseInt(st.getCellStoreValue(i, "vc3path", "pathtype"));
		var path = parseInt(st.getCellStoreValue(i, "vc3path", "path"));
		if (pathtype == 2)
		{
			vc3Path += "VC4:";
			if (path <= 3)
			{
				vc3Path += "1-VC3:" + path;
			}
			else
			{
				vc3Path += "2-VC3:" + (path - 3);
			}
		}
		st.getCellShow(i, "vc3path").element.innerText = vc3Path;
	}
	addListener();
	if (0 == data.getSErrorCode())
	{
		return;
	}
	showErrorDialog(tc, data);
}

function sendSetInfo()
{
	var alrmStr = "";
	if ("" != confirmStr1 && "" != confirmStr2)
	{
		alrmStr = confirmStr1 + "," + confirmStr2;
	}
	else
	{
		alrmStr = confirmStr1 + confirmStr2 + confirmStr3;
	}
	if ("" != alrmStr)
	{
		if(!confirm(RESOURCE["confirmSetFirst"]))
		{
			return;
		}
		if (!confirm(RESOURCE["confirmSet"] + alrmStr + "?"))
		{
			return;
		}
	}

	$("querybtn").disabled = true;
	$("applybtn").disabled = true;

	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid, st, tc);
	if (null == xmlStr)
	{
		$("querybtn").disabled = false;
		$("applybtn").disabled = false;

		return;
	}
	urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SETSDHATTR;
	loadXMLdoc(urlreq, "POST", true, setCallBack, null, "inputdata=" + xmlStr);
}

function setCallBack(doc)
{
	$("querybtn").disabled = false;

	var data = EncapsulateData(doc);
	initStr();
	if (data.getSErrorCode() != 0)
	{
		showErrorDialog(tc, data);
		return;
	}
	refreshTableState(st, tc, data);
	initStr();
}

function getIDs()
{
	var ids = new Array();
	for ( var i = 0, len = tc.getColsLength(); i < len; i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}

function createSetXML(neid, st, tc)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colid = null;
	var key = null;
	var colkeyarray = null;
	var cellModifyFlag = false;
	var portid = null;
	var index = 0;
	for ( var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!st.getModify(rowindex))
		{
			continue;
		}
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);
		for ( var colindex = 0, collen = st.getColumnCount(); colindex < collen; colindex++)
		{
			colid = tc.getColId(colindex);
			cellModifyFlag = st.getCellModify(rowindex, colid);
			colkeyarray = tc.getColKeyArray(colindex);
			for ( var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++)
			{
				param = new tagElement("param");

				key = colkeyarray[keyindex].name;

				if ("neid" == key)
				{
					continue;
				}

				param.setAttribute("name", key);
				param.setAttribute("value", st.getCellStoreValue(rowindex,
						colid, key));
				param.setAttribute("modifyFlag", cellModifyFlag);
				row.appendChild(param);
			}
		}
		bussiness.appendChild(row);
	}
	if (0 == bussiness.childNodes.length)
	{
		alert(RESOURCE["nochange"]);
		return;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function addListener()
{
	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{

		if (ids.contains("SDHVC3_ATTR_LOOPBACK"))
		{
			var vc3Loop = st.getCellEdit(i, "SDHVC3_ATTR_LOOPBACK");
			vc3Loop.element["onchange"] = function()
			{
				confirmStr3 = RESOURCE["SDHVC3_ATTR_LOOPBACK"];
			}
		}
		else if(ids.contains("SDHVC12_ATTR_LOOPBACK"))
		{
			var vc12Loop = st.getCellEdit(i, "SDHVC12_ATTR_LOOPBACK");
			if(BOARD_TYPE_EFP6 == winurlobj.boardType)
			{
				vc12Loop.clearOptions();
				vc12Loop.addOption(lightcycle[0],"0");
				vc12Loop.addOption(lightcycle[1],"1");
			}
		}
	}
}

function initStr()
{
	confirmStr1 = "";
	confirmStr2 = "";
	confirmStr3 = "";
}
function showErrorDialog(tc, data)
{
	var errArr = [];
	var errorObj = null;
	var errcode;
	var flag = false;
	for ( var i = 0, len = data.getBErrLength(); i < len; i++)
	{
		errcode = data.getError().rowErrors[i].error.code;
		if(errcode == "37926")
		{
			flag = true;
		}
		errorObj = data.getError().rowErrors[i].errorObj;
		errorObj["attrId"] = getAttrName(tc, errorObj["attrId"]);
		errorObj["operationObj"] = errorObj["nename"] + "-"
				+ errorObj["slotid"] + "-" + errorObj["boardname"] + "-";
		var vc3Path = "";

		var pathtype = parseInt(errorObj["pathtype"]);
		if (pathtype == 2)
		{
			vc3Path += "VC4:";
			var path = parseInt(errorObj["path"]);
			if (path <= 3)
			{
				vc3Path += "1-VC3:" + path;
			}
			else
			{
				vc3Path += "2-VC3:" + (path - 3);
			}
			errorObj["operationObj"] += vc3Path + "-";
		}
		errorObj["operationObj"] += errorObj["attrId"];
	}
	
	if(flag)
	{
		st.clearTableData();
	}
	
	errArr[0] = "operationObj";
	openErrPage("../../../../page/", data.getError(), errArr);
	errArr = null;
}

function print()
{
    if(0 == st.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
    openPrintPage('../../../../page/', selectObj.options[selectObj.selectedIndex].innerText,'st');
}

function save()
{
    if(st.getDataRowLength()<=0)
    {
    	alert(RESOURCE["nodata"]);
    	return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
    
    openSaveAsPage("../../../../page/", selectObj.options[selectObj.selectedIndex].innerText, "st");
}
