var winurlobj = getNeProperty(self);
var BDTYPE_SL16 = "140";
var BDTYPE_SL64 = "139";

var lightcycle = new Object();
lightcycle[0] = RESOURCE["notCycle"];
lightcycle[1] = RESOURCE["inCycle"];
lightcycle[2] = RESOURCE["outCycle"];

var laserswitch = new Object();
laserswitch[0] = RESOURCE["close"];
laserswitch[1] = RESOURCE["open"];
laserswitch[2] = RESOURCE["als"];

var regenable = new Object();
regenable[0] = RESOURCE["forbid"];
regenable[1] = RESOURCE["enable"];

var byteMode = new Object();
byteMode[0] = RESOURCE["NotCRC"];
byteMode[1] = RESOURCE["CRC"];

var pauseUse = [];
pauseUse[0] = RESOURCE["disable"];
pauseUse[1] = RESOURCE["enable"];

var multimsp = [];
multimsp[1] = RESOURCE["disable"];
multimsp[2] = RESOURCE["enable"];

var ohmode = [];
ohmode[1] = RESOURCE["gccmode"];
ohmode[0] = RESOURCE["dccmode"];

var hustwbid = [];
hustwbid[0] = RESOURCE["disable"];
hustwbid[1] = RESOURCE["enable"];

var pathHead = "";

function pathShow(obj)
{
	return pathHead + obj;
}

var confirmStr1 = "";

var hasApplyRight = true;

function initpage()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("printBtn").value = RESOURCE["printbutton"];
        $("saveAsFileBtn").value = RESOURCE["savefile"];

	newtc = new TableConf();

	st = new SortTable();
	st.setImage("../../../../images/");
	st.setBodyHeight("280");

	initTableHead();

	createTableHead(st, newtc);
	st.setOnCellEditHandler(cellEditHandler);
	document.getElementById("table").appendChild(st.getTable());
	window.onresize = function()
	{
		st.setBodyHeight(getTableHeight($("table"), st) + "px");
	}
	$("table").oncontextmenu = popupMenuHandler;
	sendQueryInfo();
}

/**
 *           
 */
function changeTableHead(selectAttr)
{
	st.deleteHeadRow();
	st.element.colsArray.length = 0;
	newtc.colArray.length = 0;

	initTableHead(selectAttr);
	createTableHead(st, newtc);

	st.clearTableData();
	st.editdom = null;
	sendQueryInfo();
}

/**
 *    tableconf
 */
function initTableHead(selectAttr)
{
	var flag = false;

	var selectedItem;

	if (null == selectAttr)
	{
		selectedItem = winurlobj["selectedItem"];
	}
	else
	{
		selectedItem = selectAttr;
	}
	var index;
	for ( var i = 0; i < window.tableconf.length; i++)
	{
		for ( var j = 0; j < window.tableconf[i].colArray.length; j++)
		{
			if (window.tableconf[i].colArray[j].id != selectedItem)
			{
				continue;
			}

			newtc.colArray[0] = window.tableconf[i].colArray[0];
			newtc.colArray[0].width = "10%";
			newtc.colArray[1] = window.tableconf[i].colArray[j];
			newtc.colArray[1].width = "10%";
			flag = true;
			break;
		}

		if (flag)
		{
			break;
		}
	}
}

/**
 * key        i  i    j      j 
 */
function addHiddenCol(key, i, j)
{
	index = window.tableconf[i].getIndexByid(key);
	newtc.colArray[j] = window.tableconf[i].colArray[index];
	newtc.colArray[j].width = 0;
}

function sendQueryInfo()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("printBtn").disabled = true;
        $("saveAsFileBtn").disabled = true;

	var neid = winurlobj["neid"];
	var slotid = winurlobj["slotid"];
	var xmlstr = createGetXML(neid, slotid, newtc);

	urlreq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_MAINTAIN_STATE_GET_LASERSTATE;

	loadXMLdoc(urlreq, "POST", true, queryCallBack, null, "inputdata=" + xmlstr);
}

/**
 *          XML  
 * 
 * @param neid:  ID
 *            slotid:  ID tableconf:        
 * @return String:       XML  
 */

function createGetXML(neid, slotid, tableconf)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcObjType");
	param.setAttribute("value", "ID_OBJECT_TYPE_NE_BOARD");
	row.appendChild(param);

	var colid;
	var attrFlag = false;
	for ( var i = 1; i < tableconf.getColsLength(); i++)
	{
		colid = tableconf.getColId(i);
		param = new tagElement("param");
		param.setAttribute("name", "attrId");
		param.setAttribute("value", colid);
		row.appendChild(param);
		if (colid == "SDHVC4_ATTR_LOOPBACK")
		{
			attrFlag = true;
		}
		
		if(colid == "SDHVC4_ATTR_OPTICALLOOPBACK" || colid == "SDHVC4_ATTR_LOOPBACK" || colid == "SDHVC4_ATTR_HSUTWBID")
	    {
			pathHead = "VC4:";
	    }
	}
	if (attrFlag)
	{
		param = new tagElement("param");
		param.setAttribute("name", "pathnum");
		param.setAttribute("value", "1");
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function sendSetInfo()
{
	
	if ("" != confirmStr1)
	{
		if (!confirm(RESOURCE["confirmSet"] + confirmStr1 + "?"))
		{
			return;
		}
	}
  
	$("querybtn").disabled = true;
  $("applybtn").disabled = true;
	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid,st,newtc);

	if (null == xmlStr)
	{
		$("querybtn").disabled = false;
    $("applybtn").disabled = false;
    
		return;
	}
	
	urlreq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_MAINTAIN_STATE_GET_LOOPSTATE;
	loadXMLdoc(urlreq, "POST", true, setCallBack, null, "inputdata=" + xmlStr);
}

function setCallBack(doc)
{
	$("querybtn").disabled = false;
	var data = EncapsulateData(doc);
	initStr();
	if (data.getSErrorCode() != 0)
	{
		showErrorDialog(newtc, data);
	}
	refreshTableState(st, newtc, data);
}

function queryCallBack(doc)
{
	$("querybtn").disabled = false;
	$("printBtn").disabled = false;
        $("saveAsFileBtn").disabled = false;
	var data = EncapsulateData(doc);
		
	createGenCfgTableBody(st, newtc, data, RESOURCE);
	showErrorDialog(newtc, data);
  
  	if(winurlobj["boardType"] == BDTYPE_SL16 || winurlobj["boardType"] == BDTYPE_SL64)
  	{
  		for(var i = 0,len = st.getDataRowLength(); i < len; i++)
  		{
  	    	st.setCellIsEdit(st.getCell(i,"SDHPORT_ATTR_REGSTATE"),true);
  		}
  	}
	addListener();
}

/**
 *               
 * 
 * @param  
 * @return  
 */
function cellEditHandler(param)
{
	if (hasApplyRight && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = false;
	}
}

/**
 * @param neid:  ID
 *            slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetXML(neid, st, tc)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colid = null;
	var key = null;
	var colkeyarray = null;
	var cellModifyFlag = false;
	var portid = null;
	var index = 0;
	var port = null;
	for ( var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!st.getModify(rowindex))
		{
			continue;
		}
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);
		for ( var colindex = 0, collen = st.getColumnCount(); colindex < collen; colindex++)
		{
			colid = tc.getColId(colindex);
			cellModifyFlag = st.getCellModify(rowindex, colid);
			if((colid == "SDHPORT_ATTR_LASERSWITCH" || colid == "SDHVC4_ATTR_OPTICALLOOPBACK" || colid == "SDHVC4_ATTR_LOOPBACK") && cellModifyFlag)
      {
			  confirmStr1 = RESOURCE[colid];
      }
			colkeyarray = tc.getColKeyArray(colindex);
			for ( var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++)
			{
				param = new tagElement("param");

				key = colkeyarray[keyindex].name;

				if ("neid" == key)
				{
					continue;
				}

				if ("portname" == key)
				{
					param.setAttribute("name", "port")
					var portid = st.getCellStoreValue(rowindex, colid, key);
					index = portid.indexOf("(");
					param.setAttribute("value", portid.substring(0, index));
				}
				else
				{
					param.setAttribute("name", key);
					param.setAttribute("value", st.getCellStoreValue(rowindex,
							colid, key));
				}
				param.setAttribute("modifyFlag", cellModifyFlag);
				row.appendChild(param);
			}
		}
		bussiness.appendChild(row);
	}
	if (0 == bussiness.childNodes.length)
	{
		alert(RESOURCE["nochange"]);
		return;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function showErrorDialog(tc, data)
{
	var errArr = [];
	var errorObj = null;
	var errcode;
	var flag = false;
	for ( var i = 0, len = data.getBErrLength(); i < len; i++)
	{
		errcode = data.getError().rowErrors[i].error.code;
		if(errcode == "37926")
		{
			flag = true;
		}
		
		errorObj = data.getError().rowErrors[i].errorObj;

		errorObj["attrId"] = getAttrName(tc, tc.colArray[1].name);

		if (errorObj["port"] == "0" || errorObj["port"] == null)
		{

			errorObj["operationObj"] = errorObj["nename"] + "-"
					+ errorObj["slotid"] + "-" + errorObj["boardname"] + "-"
					+ errorObj["attrId"];
		}
		else
		{
			if (errorObj["path"] == "0" || errorObj["path"] == null)
			{
				errorObj["operationObj"] = errorObj["nename"] + "-"
						+ errorObj["slotid"] + "-" + errorObj["boardname"]
						+ "-" + errorObj["portname"] + "-" + errorObj["attrId"];
			}
			else
			{
				errorObj["operationObj"] = errorObj["nename"] + "-"
						+ errorObj["slotid"] + "-" + errorObj["boardname"]
						+ "-" + errorObj["portname"] + "-" + errorObj["path"]
						+ "-" + errorObj["attrId"];
			}
		}
	}
	
	if(flag)
	{
		st.clearTableData();
	}
	
	errArr[0] = "operationObj";
	openErrPage("../../../../page/", data.getError(), errArr);
	errArr = null;
}

function addListener()
{

}

function initStr()
{
	confirmStr1 = "";
}


function print()
{
    if(0 == st.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
    openPrintPage('../../../../page/', selectObj.options[selectObj.selectedIndex].innerText,'st');
}

function save()
{
    if(st.getDataRowLength()<=0)
    {
    	alert(RESOURCE["nodata"]);
    	return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
    
    openSaveAsPage("../../../../page/", selectObj.options[selectObj.selectedIndex].innerText, "st");
}
