 // url  
var winurlobj = getNeProperty(self);
var BDTYPE_SL16 = "140";
var BDTYPE_SL64 = "139";

var ids = null;
var lightcycle = new Object();
lightcycle["0"] = RESOURCE["notCycle"];
lightcycle["1"] = RESOURCE["inCycle"];
lightcycle["2"] = RESOURCE["outCycle"];

var laserswitch = new Object();
laserswitch[0] = RESOURCE["close"];
laserswitch[1] = RESOURCE["open"];
laserswitch[2] = RESOURCE["als"];

var regenable = new Object();
regenable[0] = RESOURCE["forbid"];
regenable[1] = RESOURCE["enable"];


var byteMode = new Object();
byteMode[0] = RESOURCE["NotCRC"];
byteMode[1] = RESOURCE["CRC"];

var pauseUse = [];
pauseUse[0] = RESOURCE["disable"];
pauseUse[1] = RESOURCE["enable"];

var pauseUse = [];
pauseUse[0] = RESOURCE["disable"];
pauseUse[1] = RESOURCE["enable"];

var multimsp = [];
multimsp[1] = RESOURCE["disable"];
multimsp[2] = RESOURCE["enable"];

var ohmode = [];
ohmode[1] = RESOURCE["gccmode"];
ohmode[0] = RESOURCE["dccmode"];

var hustwbid = [];
hustwbid[0] = RESOURCE["disable"];
hustwbid[1] = RESOURCE["enable"];
var pathHead = "";

function pathShow(obj)
{
	return pathHead + obj;
}

var hasApplyRight = true;

var confirmStr1 = "";
var confirmStr2 = "";
var confirmStr3 = "";

function initpage()
{
	st = new SortTable();
	st.setImage("../../../../images/");
	st.setBodyHeight("280");

	tc = window.tableconf[0];

	var attrArr = getNeProperty(self)["supportAttr"].split(",");

	filterAttrCol(tc, attrArr);

	ids = getIDs();

	createTableHead(st, tc);
	st.setOnCellEditHandler(cellEditHandler);
	document.getElementById("tablecomponent").appendChild(st.getTable());
	window.onresize = function()
	{
		st.setBodyHeight(getTableHeight($("tablecomponent"), st) + "px");
	}
	$("tablecomponent").oncontextmenu = popupMenuHandler;

	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	$("printBtn").value = RESOURCE["printbutton"];
        $("saveAsFileBtn").value = RESOURCE["savefile"];

	sendQueryInfo();
}

/**
 *           
 */
function changeTableHead(selectAttr)
{
	st.deleteHeadRow();
	st.element.colsArray.length = 0;
	newtc.colArray.length = 0;

	initTableHead(selectAttr);
	createTableHead(st, newtc);

	st.clearTableData();
	sendQueryInfo();
}

/**
 *    tableconf
 */
function initTableHead(selectAttr)
{
	var flag = false;
	var selectedItem;

	if (null == selectAttr)
	{
		return;
	}
	else
	{
		selectedItem = selectAttr;
	}
	for ( var i = 0; i < window.tableconf.length; i++)
	{
		for ( var j = 0; j < window.tableconf[i].colArray.length; j++)
		{
			if (window.tableconf[i].colArray[j].id != selectedItem)
			{
				continue;
			}

			newtc.colArray[0] = window.tableconf[i].colArray[0];
			newtc.colArray[0].width = "10%";
			newtc.colArray[1] = window.tableconf[i].colArray[j];
			newtc.colArray[1].width = "10%";
			flag = true;
			break;
		}

		if (flag)
		{
			break;
		}
	}
}

/**
 *               
 * 
 * @param  
 * @return  
 */
function cellEditHandler(param)
{
	if (hasApplyRight && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = false;
	}
}

function sendQueryInfo()
{

	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("printBtn").disabled = true;
        $("saveAsFileBtn").disabled = true;

	var neid = winurlobj.neid;
	var slotid = winurlobj.slotid;

	var xmlstr = createGetXML(neid, slotid, tc);
	urlreq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_MAINTAIN_STATE_GET_LASERSTATE;
	loadXMLdoc(urlreq, "POST", true, queryCallBack, null, "inputdata=" + xmlstr);
}

/**
 *          XML  
 * 
 * @param neid:  ID
 *            slotid:  ID tableconf:        
 * @return String:       XML  
 */

function createGetXML(neid, slotid, tableconf)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcObjType");
	param.setAttribute("value", "ID_OBJECT_TYPE_NE_BOARD");
	row.appendChild(param);
	
	var colid;
	var attrFlag = false;
	for ( var i = 1; i < tableconf.getColsLength(); i++)
	{
		colid = tableconf.getColId(i);
		param = new tagElement("param");
		param.setAttribute("name", "attrId");
		param.setAttribute("value", colid);
		row.appendChild(param);
		
		if(colid == "SDHVC4_ATTR_OPTICALLOOPBACK" || colid == "SDHVC4_ATTR_LOOPBACK" || colid == "PDHPATH_ATTR_LOOPBACKMODE")
	    {
			pathHead = "VC4:";
	    }
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function queryCallBack(doc)
{
	$("querybtn").disabled = false;
        $("printBtn").disabled = false;
        $("saveAsFileBtn").disabled = false;
        
	var data = EncapsulateData(doc);
	
	/**
	 * DTS2011062101638
	 */
	createGenCfgTableBody(st, tc, data, RESOURCE);
  if(winurlobj["boardType"] == BDTYPE_SL16 || winurlobj["boardType"] == BDTYPE_SL64)
  {
  	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
  	{
  			var cell = st.getCell(i,"SDHPORT_ATTR_REGSTATE");
  			if(cell)
  			{
  	    	st.setCellIsEdit(cell,true);
  	    }
  	}
  }
	addListener();
	
	
	if (0 == data.getSErrorCode())
	{
		return;
	}
	showErrorDialog(tc, data);
}

function sendSetInfo()
{
	var alrmStr = "";
	if ("" != confirmStr1 && "" != confirmStr2)
	{
		alrmStr = confirmStr1 + "," + confirmStr2;
	}
	else
	{
		alrmStr = confirmStr1 + confirmStr2 + confirmStr3;
	}
	if ("" != alrmStr)
	{
		if(!confirm(RESOURCE["confirmSetFirst"]))
		{
			return;
		}
		if(!confirm(RESOURCE["confirmSet"] + alrmStr + "?"))
		{
			return;
		}
	}	
	
	$("querybtn").disabled = true;
  $("applybtn").disabled = true;
    
	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid,st,tc);

	if (null == xmlStr)
	{
		$("querybtn").disabled = false;
    $("applybtn").disabled = false;
		return;
	}

	urlreq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_MAINTAIN_STATE_GET_LOOPSTATE;
	loadXMLdoc(urlreq, "POST", true, setCallBack, null, "inputdata=" + xmlStr);
}

function setCallBack(doc)
{
	$("querybtn").disabled = false;

	var data = EncapsulateData(doc);
	if(0 != data.getSErrorCode())
	{
    	$("applybtn").disabled = false;
	}
	initStr();
	if (data.getSErrorCode() != 0)
	{
		showErrorDialog(tc, data);
		return;
	}
	refreshTableState(st, tc, data);
	initStr();
}

function getIDs()
{
	var ids = new Array();
	for ( var i = 0, len = tc.getColsLength(); i < len; i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}

function createSetXML(neid, st, tc)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colid = null;
	var key = null;
	var colkeyarray = null;
	var cellModifyFlag = false;
	var portid = null;
	var index = 0;
	for ( var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!st.getModify(rowindex))
		{
			continue;
		}
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);
		for ( var colindex = 0, collen = st.getColumnCount(); colindex < collen; colindex++)
		{
			colid = tc.getColId(colindex);
			cellModifyFlag = st.getCellModify(rowindex, colid);
			if(colid == "SDHPORT_ATTR_LASERSWITCH" && cellModifyFlag)
      {
			  confirmStr1 = RESOURCE[colid];
      }
      else if(colid == "SDHVC4_ATTR_OPTICALLOOPBACK" && cellModifyFlag)
      {
      	confirmStr2 = RESOURCE[colid];
      }
      else if(colid == "SDHVC4_ATTR_LOOPBACK" && cellModifyFlag)
      {
      	confirmStr3 = RESOURCE[colid];
      }
			colkeyarray = tc.getColKeyArray(colindex);
			for ( var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++)
			{
				param = new tagElement("param");

				key = colkeyarray[keyindex].name;

				if ("neid" == key)
				{
					continue;
				}

				if ("portname" == key)
				{
					param.setAttribute("name", "port")
					var portid = st.getCellStoreValue(rowindex, colid, key);
					index = portid.indexOf("(");
					param.setAttribute("value", portid.substring(0, index));
				} else if("path" == key) {              //           0           
				        var pathVal = st.getCellStoreValue(rowindex, colid, key);
				        if(pathVal == undefined || pathVal == null)
				        {
				            pathVal = '0';
				            param.setAttribute("name", key)
				            param.setAttribute("value", pathVal);
				        } else {
				            param.setAttribute("name", key)
				            param.setAttribute("value", pathVal);
				        }
				}
				else
				{
					param.setAttribute("name", key);
					param.setAttribute("value", st.getCellStoreValue(rowindex,
							colid, key));
				}
				param.setAttribute("modifyFlag", cellModifyFlag);
				row.appendChild(param);
			}
		}
		bussiness.appendChild(row);
	}
	if (0 == bussiness.childNodes.length)
	{
		alert(RESOURCE["nochange"]);
		return;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function addListener()
{
	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if (ids.contains("SDHPORT_ATTR_LASERSWITCH"))
		{
			var laserSwith = st.getCellEdit(i, "SDHPORT_ATTR_LASERSWITCH");
			laserSwith.element["onchange"] = function()
			{
				confirmStr1 = RESOURCE["SDHPORT_ATTR_LASERSWITCH"];
			}
		}

		if (ids.contains("SDHVC4_ATTR_OPTICALLOOPBACK"))
		{
			var opticalLoop = st.getCellEdit(i, "SDHVC4_ATTR_OPTICALLOOPBACK");
			opticalLoop.element["onchange"] = function()
			{
				confirmStr2 = RESOURCE["SDHVC4_ATTR_OPTICALLOOPBACK"];
			}
		}

		if (ids.contains("SDHVC4_ATTR_LOOPBACK"))
		{
			var vc4Loop = st.getCellEdit(i, "SDHVC4_ATTR_LOOPBACK");
			vc4Loop.element["onchange"] = function()
			{
				confirmStr3 = RESOURCE["SDHVC4_ATTR_LOOPBACK"];
			}
		}
		if( ids.contains("SDHPORT_ATTR_SRCACTIVITY") )
		{
			var srcAct = st.getCellEdit(i,"SDHPORT_ATTR_SRCACTIVITY");
		  srcAct.element["onchange"] = setChange;


			var srccellValue = st.getCellStoreValue(i,"SDHPORT_ATTR_SRCACTIVITY","SDHPORT_ATTR_SRCACTIVITY");		
			var srccell = st.getCell(i,"SDHVC4_ATTR_SRCSTAPID");
			if(srccell)
			{
				if( srccellValue == "1" )
				{
					st.setCellIsEdit(srccell,true);
				}
				else
				{
					st.setCellIsEdit(srccell,false);
				}
			}
	 	}
		if( ids.contains("SDHPORT_ATTR_SNKACTIVITY") )
		{
			var srccellValue = st.getCellStoreValue(i,"SDHPORT_ATTR_SNKACTIVITY","SDHPORT_ATTR_SNKACTIVITY");		
			var srccell = st.getCell(i,"SDHVC4_ATTR_SNKSRAPID");
			if(srccell)
			{
				if( srccellValue == "1" )
				{
					st.setCellIsEdit(srccell,true);
				}
				else
				{
					st.setCellIsEdit(srccell,false);
				}
			}
	 	}

		if(ids.contains("SDHVC4_ATTR_SRCSTAPID"))
		{
			var srcAPID = st.getCellEdit(i,"SDHVC4_ATTR_SRCSTAPID");
		  srcAPID.element["ondblclick"] = function()
		  {
			  showMgrDialog(this,"SDHVC4_ATTR_SRCSTAPID");	
		  }
		}
		if(ids.contains("SDHVC4_ATTR_SNKSRAPID"))
		{
			var snkAPID = st.getCellEdit(i,"SDHVC4_ATTR_SNKSRAPID");
		  snkAPID.element["ondblclick"] = function()
		  {
			  showMgrDialog(this,"SDHVC4_ATTR_SNKSRAPID");	
		  }
		}
	}
}

function initStr()
{
	confirmStr1 = "";
	confirmStr2 = "";
	confirmStr3 = "";
}
function showErrorDialog(tc, data)
{
	var errArr = [];
	var errorObj = null;
	var errcode;
	var flag = false;
	for ( var i = 0, len = data.getBErrLength(); i < len; i++)
	{		
		errcode = data.getError().rowErrors[i].error.code;
		if(errcode == "37926")
		{
			flag = true;
		}
		errorObj = data.getError().rowErrors[i].errorObj;
		errorObj["attrId"] = getAttrName(tc, errorObj["attrId"]);

		if (errorObj["port"] == "0" || errorObj["port"] == null)
		{

			errorObj["operationObj"] = errorObj["nename"] + "-"
					+ errorObj["slotid"] + "-" + errorObj["boardname"] + "-"
					+ errorObj["attrId"];
		}
		else
		{
			if (errorObj["path"] == "0" || errorObj["path"] == null)
			{
				errorObj["operationObj"] = errorObj["nename"] + "-"
						+ errorObj["slotid"] + "-" + errorObj["boardname"]
						+ "-" + errorObj["portname"] + "-" + errorObj["attrId"];
			}
			else
			{
				errorObj["operationObj"] = errorObj["nename"] + "-"
						+ errorObj["slotid"] + "-" + errorObj["boardname"]
						+ "-" + errorObj["portname"] + "-" + errorObj["path"]
						+ "-" + errorObj["attrId"];
			}
		}
	}
	
	if(flag)
	{
		st.clearTableData();
	}
	errArr[0] = "operationObj";
	openErrPage("../../../../page/", data.getError(), errArr);
	errArr = null;
	
}

/**
 *   J0  
 * @param cellEle:     
 * @return  
 */
function showMgrDialog(cellElement,key)
{
	if( !cellElement.isEdit )
		return;

	xshowModalDialog("apiddialog.html?neid="+winurlobj.neid,RESOURCE["title"],420,280,"../../../../../../../../images/");
}

function setChange()
{
	var selects = st.getSelectedRows();
	var value = st.getCellEdit(selects[0],"SDHPORT_ATTR_SRCACTIVITY").element.value;
	var srccell = st.getCell(selects[0],"SDHVC4_ATTR_SRCSTAPID");
	if(srccell)
	{
		if( value == "1" )
		{
			st.setCellIsEdit(srccell,1);
		}
		else
		{
			st.setCellIsEdit(srccell,0);
		}
	}
}

function print()
{
    if(0 == st.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
    openPrintPage('../../../../page/', selectObj.options[selectObj.selectedIndex].innerText,'st');
}

function save()
{
    if(st.getDataRowLength()<=0)
    {
    	alert(RESOURCE["nodata"]);
    	return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
    
    openSaveAsPage("../../../../page/", selectObj.options[selectObj.selectedIndex].innerText, "st");
}
