
var atable = null;

var win = getParentWindow();

var winurlobj = getNeProperty(win);

var neid = win.neid;

var usableBoardList = new Array();

var item = new Array();

var RESUME = 1;
var NON_RESUME = 0;

var MIN_PCT_GROUPID = 1;
var MAX_PCT_GROUPID = 65535;
document.title = RESOURCE["titlenewsdh"];

var isOkBtn = false;
var isApplyBtn = false;
var EMS = 1210;
var VC12 = 6;

var BDTYPE_TNF1TSP  = 1622;  
function TESDHList()
{
	this.sdhName = null;
	this.sdhLevel = null;
	this.subrackid = null;
	this.subrackname = null;
	this.showslotid = null;
	this.slotID = null;
	this.bdType = null;
	this.bdName = null;
	this.portNumber = null;
	this.vc4Number = 0;
	this.pathNumber = 0;
}

function initResTable()
{
}

function TEUsablePort()
{
	this.key = null;
	this.slotID = null;
	this.boardName = null;
	this.boardXCLevelList = null;
	this.portName = null;
	this.portXCLevel = []; //        
	this.tuOrLuOptions = [];//      
	this.portXCOptions = [];//      
	this.vc4NumOptions = [];//      VC4   
	this.portNameOptions = [];//       
	this.portNo = null;
	this.tuOrLu = null;
	this.vc4Num = null;
}

function SelectItem(slotID, portNo, vc4Num)
{
	this.slotID = slotID;
	this.portNo = portNo;
	this.vc4Num = vc4Num;
}

function slotSrcChanged(ifportchange)
{
	var sevLevelCombx = atable.getAtom("srcSlotID").element;
	var slotid = sevLevelCombx.value;

	var sevLevel = atable.getAtom("xcLevel").element.value;
	var atom0, atom1, atom2, atom3;

	atom0 = atable.getAtom("srcSlotID");
	atom1 = atable.getAtom("srcPort");

	if (ifportchange)//          
	{
		atom2 = atable.getAtom("srcVC4");
		limitVC4Input(sevLevelCombx, atom2.element, parseInt(sevLevel),
				parseInt(atom1.element.value));
		
		atom3 = atable.getAtom("srcPath");		
		limitTSPPathInput(sevLevelCombx, atom3.element, parseInt(sevLevel), atom2, parseInt(atom1.element.value));		
	}
	else
	{
		limitPortInput(sevLevelCombx, atom1.element, parseInt(sevLevel));

		atom2 = atable.getAtom("srcVC4");
		limitVC4Input(sevLevelCombx, atom2.element, parseInt(sevLevel),
				parseInt(atom1.element.value));

		atom3 = atable.getAtom("srcPath");
		limitPathInput(sevLevelCombx, atom3.element, parseInt(sevLevel), atom2);
	}
}

function slotSnkChanged(ifportchange)
{

	var sevLevelCombx = atable.getAtom("snkSlotID").element;
	var slotid = sevLevelCombx.value;
	var sevLevel = atable.getAtom("xcLevel").element.value;

	var atom0, atom1, atom2, atom3;
	atom0 = atable.getAtom("snkSlotID");
	atom1 = atable.getAtom("snkPort");
	if (ifportchange)
	{
		atom2 = atable.getAtom("snkVC4");
		limitVC4Input(sevLevelCombx, atom2.element, parseInt(sevLevel),
				parseInt(atom1.element.value));
		atom3 = atable.getAtom("snkPath");		
		limitTSPPathInput(sevLevelCombx, atom3.element, parseInt(sevLevel), atom2, parseInt(atom1.element.value));
	}
	else
	{
		limitPortInput(sevLevelCombx, atom1.element, parseInt(sevLevel));

		atom2 = atable.getAtom("snkVC4");
		limitVC4Input(sevLevelCombx, atom2.element, parseInt(sevLevel),
				parseInt(atom1.element.value));

		atom3 = atable.getAtom("snkPath");
		limitPathInput(sevLevelCombx, atom3.element, parseInt(sevLevel), atom2);
	}
}

function initAttrTable()
{
	atable = new CTable();
	atable.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);

	atom = new Atom("select");

	SpecialAttrMgr.getNEFunInfo(neid, "TE_FUNC_CFG_SDH_PAYLOAD");
	var isVC4sp = SpecialAttrMgr.isNENotSupport(neid, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_XCLEVEL_VC4");
	var isVC44Csp = SpecialAttrMgr.isNENotSupport(neid, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_XCLEVEL_VC4_4C");
	var isVC416Csp = SpecialAttrMgr.isNENotSupport(neid, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_XCLEVEL_VC4_16C");
	var isVC464Csp = SpecialAttrMgr.isNENotSupport(neid, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_XCLEVEL_VC4_64C");
	var isVC12sp = SpecialAttrMgr.isNENotSupport(neid, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_XCLEVEL_VC12");
	var isVC3sp = SpecialAttrMgr.isNENotSupport(neid, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_XCLEVEL_VC3");
	
	if(winurlobj["neType"] == "67")
	{
		atom.element.options[atom.element.options.length] = new Option(
			RESOURCE["vc12"], "6");
		if (!isVC3sp) 
		{
			atom.element.options[atom.element.options.length] = new Option(RESOURCE["vc3"], "7");
		}
		atom.element.options[atom.element.options.length] = new Option(
			RESOURCE["vc4"], "1");
		if (!isVC44Csp) 
		{
			atom.element.options[atom.element.options.length] = new Option("VC4-4C", "2");
		}

		if (!isVC416Csp) 
		{
			atom.element.options[atom.element.options.length] = new Option("VC4-16C", "4");
		}
	}
	else
	{
		
		if (!isVC12sp) 
		{
			atom.element.options[atom.element.options.length] = new Option(RESOURCE["vc12"], "6");
		}
		if (!isVC3sp) 
		{
			atom.element.options[atom.element.options.length] = new Option(RESOURCE["vc3"], "7");
		}
		if (!isVC4sp) 
		{
			atom.element.options[atom.element.options.length] = new Option(RESOURCE["vc4"], "1");
		}
		if (!isVC44Csp) 
		{
			atom.element.options[atom.element.options.length] = new Option("VC4-4C", "2");
		}
		if (!isVC416Csp) 
		{
			atom.element.options[atom.element.options.length] = new Option("VC4-16C", "4");
		}
		if (!isVC464Csp) 
		{
			atom.element.options[atom.element.options.length] = new Option("VC4-64C", "5");
		}
	}

	atom.element.style.width = "100%";
	atom.element["onchange"] = function()
	{
		setApplyEnabled();
		sevLevelChanged(this);
	}
	atable.addAttrRow("xcLevel", RESOURCE["sdhlevel"], atom);

	atom = new Atom("select");
	atom.element.options[atom.element.options.length] = new Option(
			RESOURCE["doubleDirection"], "1");
	atom.element.options[atom.element.options.length] = new Option(
			RESOURCE["singleDirection"], "0");
	atom.element.style.width = "100%";
	atom.element["onchange"] = function()
	{
		setApplyEnabled();
	}
	atable.addAttrRow("xcDirection", RESOURCE["direction"], atom);

	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element["onchange"] = function()
	{
		setApplyEnabled();
		slotSrcChanged();
	}
	atable.addAttrRow("srcSlotID", RESOURCE["sdhsrcbrd"], atom);

	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element["onchange"] = function()
	{
		setApplyEnabled();
		slotSrcChanged(true);
	}
	atable.addAttrRow("srcPort", RESOURCE["sdhsrcport"], atom);

	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element.options[atom.element.options.length] = new Option(
			RESOURCE["VC4num"], "1");
	atom.element["onchange"] = setApplyEnabled;
	atable.addAttrRow("srcVC4", RESOURCE["sdhsrcvc4"], atom);

	atom = new Atom("text");
	atom.element.style.width = "100%";
	atom.element.style.imeMode = "disabled";
	atom.element["onchange"] = setApplyEnabled;
	atable.addAttrRow("srcPath", RESOURCE["sdhsrcslot"], atom);

	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element["onchange"] = function()
	{
		setApplyEnabled();
		slotSnkChanged();
	}
	atable.addAttrRow("snkSlotID", RESOURCE["sdhsnkbrd"], atom);

	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element["onchange"] = function()
	{
		setApplyEnabled();
		slotSnkChanged(true);
	}
	atable.addAttrRow("snkPort", RESOURCE["sdhsnkport"], atom);

	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element.options[atom.element.options.length] = new Option(
			RESOURCE["VC4num"], "1");
	atom.element["onchange"] = setApplyEnabled;
	atable.addAttrRow("snkVC4", RESOURCE["sdhsnkvc4"], atom);

	atom = new Atom("text");
	atom.element.style.width = "100%";
	atom.element["onchange"] = setApplyEnabled;
	atable.addAttrRow("snkPath", RESOURCE["sdhsnkslot"], atom);

	setAtomDisabled(true);

	document.body.insertBefore(atable.getTable(), document
			.getElementById("resTable"));
}

function sevLevelChanged(sevLevelCombx)
{
	var sevLevel = sevLevelCombx.value;

	var atomelem = atable.getAtom("srcSlotID").element;
	atomelem.options.length = 0;

	atomelem = atable.getAtom("snkSlotID").element;
	atomelem.options.length = 0;

	var srcSlotID = atable.getAtom("srcSlotID").element.value;
	var snkSlotID = atable.getAtom("snkSlotID").element.value;

	var atom = null;

	var srcvc12Tu = false;
	var snkvc12Tu = false;
	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		var sdhName = usableBoardList[i].sdhName;
		var sdhLevel = usableBoardList[i].sdhLevel;
		var slotID = usableBoardList[i].slotID;
		var bdType = usableBoardList[i].bdType;
		var bdName = usableBoardList[i].bdName;
		var bdPort = usableBoardList[i].portNumber;
		var bdPath = usableBoardList[i].pathNumber; // vc4Number
		var bdVC4 = usableBoardList[i].vc4Number; //

		if (sevLevel == sdhLevel)
		{
			atom = atable.getAtom("srcSlotID");
			atom.element.options[atom.element.options.length] = new Option(
					getShowName(usableBoardList[i]), slotID);

			atom = atable.getAtom("snkSlotID");
			atom.element.options[atom.element.options.length] = new Option(
					getShowName(usableBoardList[i]), slotID);
		}
	}

	var atom0, atom1, atom2, atom3;
	atom0 = atable.getAtom("snkSlotID");
	atom1 = atable.getAtom("snkPort");
	limitPortInput(atom0.element, atom1.element, parseInt(sevLevel));

	atom2 = atable.getAtom("snkVC4");
	limitVC4Input(atom0.element, atom2.element, parseInt(sevLevel),
			parseInt(atom1.element.value));

	atom3 = atable.getAtom("snkPath");
	limitPathInput(atom0.element, atom3.element, parseInt(sevLevel), atom2);

	atom0 = atable.getAtom("srcSlotID");
	atom1 = atable.getAtom("srcPort");
	limitPortInput(atom0.element, atom1.element, parseInt(sevLevel));

	atom2 = atable.getAtom("srcVC4");
	limitVC4Input(atom0.element, atom2.element, parseInt(sevLevel),
			parseInt(atom1.element.value));

	atom3 = atable.getAtom("srcPath");
	limitPathInput(atom0.element, atom3.element, parseInt(sevLevel), atom2);

	if (parseInt(sevLevel) < 6)
	{
		atomSrcVC4 = atable.getAtom("srcVC4");
		atomSrcVC4.element.disabled = true;

		atomSnkVC4 = atable.getAtom("snkVC4");
		atomSnkVC4.element.disabled = true;

		atom = atable.getAtom("srcPath");
		vc4PathPutin(atom.element, atomSrcVC4.element.length);

		atom = atable.getAtom("snkPath");
		vc4PathPutin(atom.element, atomSnkVC4.element.length);
	}
}

function vc4PathPutin(pathobj, maxvalue)
{
	pathobj.onkeypress = function()
	{
		var Evt = window.event;
		return restrictPath2(pathobj, Evt, maxvalue);
	}
	pathobj.onpaste = function()
	{
		var pasteText = window.clipboardData.getData("Text");
		pasteText = pathobj.value + pasteText;
		return pathTextCheck(pasteText, 1, maxvalue);
	}
}

function sevPortChanged(sevPortCombx)
{
	var sevPort = sevPortCombx.value;
	var count = item[sevPort].vc4No;
	for (i = 0; i < count; i++)
	{
		$("wSrcPath").add(new Option("VC4" + "-" + i, i));
		$("pSrcPath").add(new Option("VC4" + "-" + i, i));
		$("wSinkPath").add(new Option("VC4" + "-" + i, i));
	}
}

function getPctGroupID()
{
	var pctGroupIDArr = new Array();
	var pctGPID = -1;
	for ( var i = 0, len = win.workTable.getDataRowLength; i < len; i++)
	{
		pctGroupIDArr.push(win.workTable.getCellStoreValue(i, "pctGroupID",
				"pctGroupID"))
	}

	for ( var i = MIN_PCT_GROUPID; i <= MAX_PCT_GROUPID; i++)
	{
		if (!pctGroupIDArr.contains(i))
		{
			pctGPID = i;
			break;
		}
	}
	return pctGPID;
}

function createBatchXCXML(listsrcPathID, listsnkPathID)
{
	var xcLevel, direction, sdhXCID;
	var srcSlotID, srcPort, srcVC4, srcPath;
	var snkSlotID, snkPort, snkVC4, snkPath;

	var xcFlag = 0;
	direction = atable.getAtom("xcDirection").element.value;
	xcLevel = atable.getAtom("xcLevel").element.value;

	srcSlotID = atable.getAtom("srcSlotID").element.value;
	snkSlotID = atable.getAtom("snkSlotID").element.value;

	sdhXCID = 0;

	var xcListSize = listsrcPathID.length;
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var row = null;
	for ( var ik = 0; ik < xcListSize; ik++)
	{
		if (xcLevel == "1" || xcLevel == "2" || xcLevel == "3" || xcLevel == "4" || xcLevel == "5")
		{
			srcPort = atable.getAtom("srcPort").element.value;
			snkPort = atable.getAtom("snkPort").element.value;
			srcVC4 = listsrcPathID[ik];
			snkVC4 = listsnkPathID[ik];
			srcPath = 0;
			snkPath = 0;
		}
		else
		{
			for ( var i = 0, isize = usableBoardList.length; i < isize; i++)
			{
				if (usableBoardList[i].slotID == srcSlotID)
				{
					if (ispdhboard(usableBoardList[i].bdType))
					{
						srcPath = 0;
						srcVC4 = 0;
						srcPort = listsrcPathID[ik];
					}
					else
					{
						if (isIFIsTu(srcSlotID, xcLevel))
						{
							srcPort = 1;
							srcVC4 = 1;
							srcPath = listsrcPathID[ik];
						}
						else
						{
							srcPort = atable.getAtom("srcPort").element.value;
							srcVC4 = atable.getAtom("srcVC4").element.value;
							srcPath = listsrcPathID[ik];
						}
					}
					if(usableBoardList[i].bdType == BDTYPE_TNF1TSP && atable.getAtom("srcPort").element.value >=5 && atable.getAtom("srcPort").element.value <= 25)
					{
						srcVC4 = 0;
					}
					
				}
				if (usableBoardList[i].slotID == snkSlotID)
				{
					if (ispdhboard(usableBoardList[i].bdType))
					{
						snkPath = 0;
						snkVC4 = 0;
						snkPort = listsnkPathID[ik];
					}
					else
					{
						if (isIFIsTu(snkSlotID, xcLevel))
						{
							snkPort = 1;
							snkVC4 = 1;
							snkPath = listsnkPathID[ik];
						}
						else
						{
							snkPort = atable.getAtom("snkPort").element.value;
							snkVC4 = atable.getAtom("snkVC4").element.value;
							snkPath = listsnkPathID[ik];
						}
					}
					if(usableBoardList[i].bdType == BDTYPE_TNF1TSP && atable.getAtom("snkPort").element.value >=5 && atable.getAtom("snkPort").element.value <= 25)
					{
						snkVC4 = 0;
					}
				}
			}
		}

		row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neID");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "sdhXCID");
		param.setAttribute("value", sdhXCID);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcSlotID");
		param.setAttribute("value", srcSlotID);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcPort");
		param.setAttribute("value", srcPort);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcVC4");
		param.setAttribute("value", srcVC4);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcPathID");
		param.setAttribute("value", srcPath);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkSlotID");
		param.setAttribute("value", snkSlotID);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkPort");
		param.setAttribute("value", snkPort);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkVC4");
		param.setAttribute("value", snkVC4);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkPathID");
		param.setAttribute("value", snkPath);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "xcLevel");
		param.setAttribute("value", xcLevel);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "serviceMode");
		param.setAttribute("value", win.g_pathMode);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "Logdirection");
		param.setAttribute("value", direction);
		row.appendChild(param);

		var atom = atable.getAtom("srcPath").element;
		param = new tagElement("param");
		param.setAttribute("name", "LogsrcPathName");
		param.setAttribute("value", atom.value);
		row.appendChild(param);

		var atom = atable.getAtom("snkPath").element;
		param = new tagElement("param");
		param.setAttribute("name", "LogsnkPathName");
		param.setAttribute("value", atom.value);
		row.appendChild(param);

		business.appendChild(row);

		if (direction == "1")
		{
			var row = new tagElement("row-params");
			var param = new tagElement("param");
			param.setAttribute("name", "neID");
			param.setAttribute("value", neid);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "sdhXCID");
			param.setAttribute("value", sdhXCID);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "srcSlotID");
			param.setAttribute("value", snkSlotID);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "srcPort");
			param.setAttribute("value", snkPort);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "srcVC4");
			param.setAttribute("value", snkVC4);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "srcPathID");
			param.setAttribute("value", snkPath);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "snkSlotID");
			param.setAttribute("value", srcSlotID);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "snkPort");
			param.setAttribute("value", srcPort);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "snkVC4");
			param.setAttribute("value", srcVC4);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "snkPathID");
			param.setAttribute("value", srcPath);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "xcLevel");
			param.setAttribute("value", xcLevel);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "serviceMode");
			param.setAttribute("value", win.g_pathMode);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "Logdirection");
			param.setAttribute("value", direction);
			row.appendChild(param);

			var atom = atable.getAtom("srcPath").element;
			param = new tagElement("param");
			param.setAttribute("name", "LogsrcPathName");
			param.setAttribute("value", atom.value);
			row.appendChild(param);

			var atom = atable.getAtom("snkPath").element;
			param = new tagElement("param");
			param.setAttribute("name", "LogsnkPathName");
			param.setAttribute("value", atom.value);
			row.appendChild(param);

			business.appendChild(row);
		}

	}
	root.getRoot().appendChild(business);

	return root.toString();
}

function getTagListData(str)
{
    var returnValue = new Array();
    if (str == 0) 
    {
        returnValue[0] = 1;
        returnValue[1] = "0";
        return returnValue;
    }
    var tempString = str.trim();
    var returnString = "";
    var stringNumber = 0;
    var stringLength = tempString.length;
    if (stringLength == 0) 
    {
        returnValue[0] = 0;
        returnValue[1] = "";
        return returnValue;
    }
    
    var str = tempString.split(",");
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            if (!(isNaN(rangeStart) || isNaN(rangeEnd))) 
            {
                var start = parseInt(rangeStart);
                var end = parseInt(rangeEnd);
                for (var s1 = start; s1 <= end; s1++) 
                {
                    if (returnString == "") 
                    {
                        returnString = s1.toString();
                    }
                    else 
                    {
                        returnString = returnString + "," + s1.toString();
                    }
                    stringNumber++;
                }
            }
        }
        else 
        {
            if (!isNaN(parseInt(str[i]))) 
            {
                stringNumber++;
                if (returnString == "") 
                {
                    returnString = str[i];
                }
                else 
                {
                    returnString = returnString + "," + str[i];
                }
            }
        }
    }
    returnValue[0] = stringNumber;
    returnValue[1] = returnString;
    return returnValue;
}

function createXCXML()
{
	var xcLevel, direction, sdhXCID;
	var srcSlotID, srcPort, srcVC4, srcPath;
	var snkSlotID, snkPort, snkVC4, snkPath;

	var xcFlag = 0;

	direction = atable.getAtom("xcDirection").element.value;
	xcLevel = atable.getAtom("xcLevel").element.value;

	srcSlotID = atable.getAtom("srcSlotID").element.value;
	snkSlotID = atable.getAtom("snkSlotID").element.value;

	sdhXCID = 0;

	var srcPathString = atable.getAtom("srcPath").element.value;
	var snkPathString = atable.getAtom("snkPath").element.value;
	
	var srcPathDataArr = getTagListData(srcPathString);
	var srcpathnum = srcPathDataArr[0];
	var listsrcPathID = srcPathDataArr[1].split(",");
	
	var snkPathDataArr = getTagListData(snkPathString);
	var snkpathnum = snkPathDataArr[0];
	var listsnkPathID = snkPathDataArr[1].split(",");
	
	
	
	if (listsrcPathID.length == listsnkPathID.length)
	{
		if (listsrcPathID.length != 0)
		{
			return createBatchXCXML(listsrcPathID, listsnkPathID);
		}
	}
	else
	{
		var srcpathnum = atable.getAtom("srcPath").element.value;
		var snkpathnum = atable.getAtom("snkPath").element.value;

		if ((listsrcPathID.length == 1) && (listsnkPathID.length == 0)
				&& parseInt(snkpathnum) < 64)
		{
			listsnkPathID.push(parseInt(srcpathnum));
			return createBatchXCXML(listsrcPathID, listsnkPathID);
		}

		if ((listsnkPathID.length == 1) && (listsrcPathID.length == 0)
				&& parseInt(srcpathnum) < 64)
		{
			listsrcPathID.push(parseInt(srcpathnum));
			return createBatchXCXML(listsrcPathID, listsnkPathID);
		}
	
		if ((listsnkPathID.length == 1) && (listsrcPathID.length > 1))
		{			
			for(var k = 1; k < listsrcPathID.length; k++)
		    {
				listsnkPathID.push(listsnkPathID[0]);
			}
			return createBatchXCXML(listsrcPathID, listsnkPathID);
		}
		
		if ((listsnkPathID.length > 1) && (listsrcPathID.length == 1))
		{			
			for(var s = 1; s < listsnkPathID.length; s++)
		    {
				listsrcPathID.push(listsrcPathID[0]);
			}
			return createBatchXCXML(listsrcPathID, listsnkPathID);
		}
		

		return null;
	}

	var srcpathnum = atable.getAtom("srcPath").element.value;
	var snkpathnum = atable.getAtom("snkPath").element.value;
	var xcsinglecreate = false;
	if ((parseInt(snkpathnum) <= 64) && (parseInt(srcpathnum) <= 64))
	{
		xcsinglecreate = true;
	}

	if (!xcsinglecreate)
	{
		return null;
	}

	if (xcLevel == "1" || xcLevel == "2" || xcLevel == "3" || xcLevel == "4" || xcLevel == "5")
	{
		srcPort = atable.getAtom("srcPort").element.value;
		snkPort = atable.getAtom("snkPort").element.value;
		srcVC4 = atable.getAtom("srcPath").element.value;
		snkVC4 = atable.getAtom("snkPath").element.value;
		srcPath = 0;
		snkPath = 0;
	}
	else
	{
		for ( var i = 0, isize = usableBoardList.length; i < isize; i++)
		{
			if (parseInt(xcLevel) != usableBoardList[i].sdhLevel)
			{
				continue;
			}
			if (usableBoardList[i].slotID == srcSlotID)
			{
				if (ispdhboard(usableBoardList[i].bdType))
				{
					srcPath = 0;
					srcVC4 = 0;
					srcPort = atable.getAtom("srcPath").element.value;
				}
				else
				{
					if (isIFIsTu(srcSlotID, xcLevel))
					{
						srcPort = 1;
						srcVC4 = 1;
						srcPath = atable.getAtom("srcPath").element.value;
					}
					else
					{
						srcPort = atable.getAtom("srcPort").element.value;
						srcVC4 = atable.getAtom("srcVC4").element.value;
						srcPath = atable.getAtom("srcPath").element.value;
					}
				}
				if(usableBoardList[i].bdType == BDTYPE_TNF1TSP && atable.getAtom("srcPort").element.value >=5 && atable.getAtom("srcPort").element.value <= 25)
				{
					srcVC4 = 0;
				}
			}
			if (usableBoardList[i].slotID == snkSlotID)
			{
				if (ispdhboard(usableBoardList[i].bdType))
				{
					snkPath = 0;
					snkVC4 = 0;
					snkPort = atable.getAtom("snkPath").element.value;
				}
				else
				{
					if (isIFIsTu(snkSlotID, xcLevel))
					{
						snkPort = 1;
						snkVC4 = 1;
						snkPath = atable.getAtom("snkPath").element.value;
					}
					else
					{

						snkPort = atable.getAtom("snkPort").element.value;
						snkVC4 = atable.getAtom("snkVC4").element.value;
						snkPath = atable.getAtom("snkPath").element.value;
					}
				}
				if(usableBoardList[i].bdType == BDTYPE_TNF1TSP && atable.getAtom("snkPort").element.value >=5 && atable.getAtom("snkPort").element.value <= 25)
				{
					snkVC4 = 0;
				}
			}
		}
	}

	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");

	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neID");
	param.setAttribute("value", neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "sdhXCID");
	param.setAttribute("value", sdhXCID);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcSlotID");
	param.setAttribute("value", parseInt(srcSlotID));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcPort");
	param.setAttribute("value", parseInt(srcPort));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcVC4");
	param.setAttribute("value", parseInt(srcVC4));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcPathID");
	if (xcLevel == "2" || xcLevel == "3" || xcLevel == "4" || xcLevel == "5")
	{
		param.setAttribute("value", "0");
	}
	else
	{
		param.setAttribute("value", parseInt(srcPath));
	}
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "snkSlotID");
	param.setAttribute("value", parseInt(snkSlotID));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "snkPort");
	param.setAttribute("value", parseInt(snkPort));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "snkVC4");
	param.setAttribute("value", parseInt(snkVC4));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "snkPathID");
	if (xcLevel == "2" || xcLevel == "3" || xcLevel == "4" || xcLevel == "5")
	{
		param.setAttribute("value", "0");
	}
	else
	{
		param.setAttribute("value", parseInt(snkPath));
	}
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "xcLevel");
	param.setAttribute("value", xcLevel);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "serviceMode");
	param.setAttribute("value", win.g_pathMode);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "Logdirection");
	param.setAttribute("value", direction);
	row.appendChild(param);

	var atom = atable.getAtom("srcPath").element;
	param = new tagElement("param");
	param.setAttribute("name", "LogsrcPathName");
	param.setAttribute("value", atom.value);
	row.appendChild(param);

	var atom = atable.getAtom("snkPath").element;
	param = new tagElement("param");
	param.setAttribute("name", "LogsnkPathName");
	param.setAttribute("value", atom.value);
	row.appendChild(param);

	business.appendChild(row);

	if (direction == "1")
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neID");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "sdhXCID");
		param.setAttribute("value", parseInt(sdhXCID));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcSlotID");
		param.setAttribute("value", parseInt(snkSlotID));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcPort");
		param.setAttribute("value", parseInt(snkPort));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcVC4");
		param.setAttribute("value", parseInt(snkVC4));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcPathID");
		if (xcLevel == "2" || xcLevel == "3" || xcLevel == "4"
				|| xcLevel == "5")
		{
			param.setAttribute("value", "0");
		}
		else
		{
			param.setAttribute("value", parseInt(snkPath));
		}
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkSlotID");
		param.setAttribute("value", parseInt(srcSlotID));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkPort");
		param.setAttribute("value", parseInt(srcPort));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkVC4");
		param.setAttribute("value", parseInt(srcVC4));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkPathID");
		if (xcLevel == "2" || xcLevel == "3" || xcLevel == "4"
				|| xcLevel == "5")
		{
			param.setAttribute("value", "0");
		}
		else
		{
			param.setAttribute("value", parseInt(srcPath));
		}
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "xcLevel");
		param.setAttribute("value", xcLevel);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "serviceMode");
		param.setAttribute("value", win.g_pathMode);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "Logdirection");
		param.setAttribute("value", direction);
		row.appendChild(param);

		var atom = atable.getAtom("srcPath").element;
		param = new tagElement("param");
		param.setAttribute("name", "LogsrcPathName");
		param.setAttribute("value", atom.value);
		row.appendChild(param);

		var atom = atable.getAtom("snkPath").element;
		param = new tagElement("param");
		param.setAttribute("name", "LogsnkPathName");
		param.setAttribute("value", atom.value);
		row.appendChild(param);

		business.appendChild(row);
	}

	root.getRoot().appendChild(business);
	return root.toString();
}

function doCreateXC()
{
	var srcPort = atable.getAtom("srcPort").element.value;
	var snkPort = atable.getAtom("snkPort").element.value;
	var srcPath = atable.getAtom("srcPath").element.value;
	var snkPath = atable.getAtom("snkPath").element.value;

	if (srcPath.indexOf("'") > -1)
	{
		alert(RESOURCE["ID00_FORMAT"]);
		$("ok").disabled = false;
		$("apply").disabled = false;// ID00_FORMAT
		return;
	}
	if (snkPath.indexOf("'") > -1)
	{
		alert(RESOURCE["ID00_FORMAT"]);
		$("ok").disabled = false;
		$("apply").disabled = false;
		return;
	}
	
	var srcPathString = atable.getAtom("srcPath").element.value;
	var snkPathString = atable.getAtom("snkPath").element.value;
	
	var srcPathDataArr = getTagListData(srcPathString);
	var srcpathnum = srcPathDataArr[0];	
	var snkPathDataArr = getTagListData(snkPathString);
	var snkpathnum = snkPathDataArr[0];

	
	direction = atable.getAtom("xcDirection").element.value;
	if(direction == 1)
	{
		if((srcpathnum == 1  || snkpathnum == 1) && srcpathnum != snkpathnum)
		{
			alert(RESOURCE["boardcasterror"]);
			$("ok").disabled = false;
			$("apply").disabled = false;
			return;
		}		
	}	
	
	var xml = createXCXML();

	if (isNaN(srcPort) || (isNaN(snkPort)))
	{
		alert(RESOURCE["datainput"]);
		$("ok").disabled = false;
		$("apply").disabled = false;
		return;
	}
	if (xml == null)
	{
		alert(RESOURCE["parametersnotmatching"]);
		$("ok").disabled = false;
		$("apply").disabled = false;
		return;
	}

	var urlReq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_CREATE_SDHXC + "&flag=1" + "&nmUser="
			+ win.obj["nmUser"];
	loadXMLdoc(urlReq, "POST", true, callCreateBack, null, "inputdata=" + xml);
}

function callCreateBack(doc)
{
	var data = EncapsulateData(doc);

	showErrorDialog(data);
	if (data.getSErrorCode() == 0)
	{

		win.queryService();
		if (isOkBtn)
		{
			xcloseDialog();
		}
	}
	else
	{
		$("apply").disabled = false;
	}
	$("ok").disabled = false;

}
function okBtnClicked()
{
	if ($("apply").disabled)
	{
		xcloseDialog();
	}
	var atom = null;
	atom = atable.getAtom("srcSlotID").element;
	if (atom.options.length == 0)
	{
		alert(RESOURCE["noslot"]);
		return;
	}
	atom = atable.getAtom("snkSlotID").element;
	if (atom.options.length == 0)
	{
		alert(RESOURCE["noslot"]);
		return;
	}

	atom = atable.getAtom("srcPath").element;
	if (atom.value.length == 0)
	{
		alert(RESOURCE["datainput"]);
		return;
	}
	atom = atable.getAtom("snkPath").element;
	if (atom.value.length == 0)
	{
		alert(RESOURCE["datainput"]);
		return;
	}
	atom = atable.getAtom("srcPort").element;
	if (!(atom.disabled) && (atom.value.length == 0))
	{
		alert(RESOURCE["datainput"]);
		return;
	}
	atom = atable.getAtom("snkPort").element;
	if (!(atom.disabled) && (atom.value.length == 0))
	{
		alert(RESOURCE["datainput"]);
		return;
	}

	$("ok").disabled = true;
	$("apply").disabled = true;
	isOkBtn = true;
	doCreateXC();
}

function cancelBtnClicked()
{
	xcloseDialog();
}

function applyBtnClicked()
{
	var atom = null;

	atom = atable.getAtom("srcSlotID").element;
	if (atom.options.length == 0)
	{
		alert(RESOURCE["noslot"]);
		return;
	}
	atom = atable.getAtom("snkSlotID").element;
	if (atom.options.length == 0)
	{
		alert(RESOURCE["noslot"]);
		return;
	}

	atom = atable.getAtom("srcPath").element;
	if (atom.value.length == 0)
	{
		alert(RESOURCE["datainput"]);
		return;
	}
	atom = atable.getAtom("snkPath").element;
	if (atom.value.length == 0)
	{
		alert(RESOURCE["datainput"]);
		return;
	}
	atom = atable.getAtom("srcPort").element;
	if (!(atom.disabled) && (atom.value.length == 0))
	{
		alert(RESOURCE["datainput"]);
		return;
	}
	atom = atable.getAtom("snkPort").element;
	if (!(atom.disabled) && (atom.value.length == 0))
	{
		alert(RESOURCE["datainput"]);
		return;
	}
	$("ok").disabled = true;
	$("apply").disabled = true;
	isOkBtn = false;
	isApplyBtn = true;
	doCreateXC();
}

function showErrorDialog(dinterface)
{

	var errCode = dinterface.getSErrorCode();
	if (errCode != 0)
	{
		isApplyBtn = false;
		isOkBtn = false;
	}
	if (parseInt(errCode) == 1)
	{
		dinterface.getError().s_error.code = "2";
		dinterface.getError().s_error.info = RESOURCE.optFail;

	}
	var errArr = [];
    	errArr[0] = "attributeid";
    	
    	var reobj;
		  var errArridStr = "";
		  if(dinterface.getSErrorCode() != 0)
		  {		
		      for(var i = 0, errlen = dinterface.getBErrLength(); i < errlen; i++)
		      {
							errArridStr = "";
							reobj = dinterface.getError().rowErrors[i];
							errArridStr = RESOURCE["source"] + reobj.errorObj.nename + "-" + atable.getAtom("srcSlotID").element.options[atable.getAtom("srcSlotID").element.selectedIndex].text + "-" + atable.getAtom("srcPort").getValue()+ "-"+"VC4" + "-" + atable.getAtom("srcVC4").getValue() + ";";
							errArridStr += RESOURCE["sink"]  + reobj.errorObj.nename + "-" + atable.getAtom("snkSlotID").element.options[atable.getAtom("snkSlotID").element.selectedIndex].text + "-" + atable.getAtom("snkPort").getValue() + "-"+"VC4" + "-" + atable.getAtom("snkVC4").getValue() + ";" ;
							
							
							reobj.errorObj["attributeid"] = errArridStr;            
		      }		
		  }
	openErrPage("../../../../page/", dinterface.getError(), errArr);
}

function createGetPortXml()
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	var sdhlevel = atable.getAtom("xcLevel").element;
	for ( var i = 0, len = sdhlevel.options.length; i < len; i++)
	{
		param = new tagElement("param");
		param.setAttribute("name", "sdhlevel");
		param.setAttribute("value", sdhlevel.options[i].value);
		row.appendChild(param);
	}

	business.appendChild(row);
	root.getRoot().appendChild(business);
	return root.toString();
}

function callGetPortback(doc)
{

	var dinterface = EncapsulateData(doc);
	for ( var i = 0; i < dinterface.getDataRowLength(); i++)
	{
		var enPort = new TEUsablePort();
		enPort.slotID = dinterface.getDataRowParam(i, "slotID");// ??ID
		enPort.boardName = dinterface.getDataRowParam(i, "boardName");//     
		enPort.boardXCLevelList = dinterface.getDataRowParam(i,
				"boardXCLevelList"); //        

		enPort.portXCOptions = dinterface.getDataRowOptions(i, "portXCLevel");
		enPort.portNoOptions = dinterface.getDataRowOptions(i, "portNo");
		enPort.tuOrLuOptions = dinterface.getDataRowOptions(i, "tuOrLu");
		enPort.vc4NumOptions = dinterface.getDataRowOptions(i, "vc4Num");
		enPort.portNameOptions = dinterface.getDataRowOptions(i, "portName");
		usablePortList[i] = enPort;
	}
}

function callGetBoardback(doc)
{
	setAtomDisabled(false);
	var dinterface = EncapsulateData(doc);
	for ( var i = 0; i < dinterface.getDataRowLength(); i++)
	{
		/**
		 *              
		 * TRANSV1R9C00-10942 
		 */
		if (dinterface.getDataRowParam(i, "bdPort") == "")
		{
			continue;
		}
		var sdhList = new TESDHList();
		sdhList.sdhName = dinterface.getDataRowParam(i, "sdhName");
		sdhList.sdhLevel = dinterface.getDataRowParam(i, "sdhLevel");
		sdhList.subrackid = dinterface.getDataRowParam(i, "subrackid");
		sdhList.subrackname = dinterface.getDataRowParam(i, "subrackname");
		sdhList.showslotid = dinterface.getDataRowParam(i, "showslotid");
		sdhList.slotID = dinterface.getDataRowParam(i, "slotID");
		sdhList.bdType = dinterface.getDataRowParam(i, "bdType");
		sdhList.bdName = dinterface.getDataRowParam(i, "bdName");

		sdhList.vc4Number = dinterface.getDataRowParam(i, "bdVC4");
		sdhList.portNumber = dinterface.getDataRowParam(i, "bdPort");
		sdhList.pathNumber = dinterface.getDataRowParam(i, "bdPath");

		usableBoardList[usableBoardList.length] = sdhList;
	}
	slotSrcChanged();
	slotSnkChanged();

	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		var sdhName = usableBoardList[i].sdhName;
		var sdhLevel = usableBoardList[i].sdhLevel;
		var slotID = usableBoardList[i].slotID;
		var bdType = usableBoardList[i].bdType;
		var bdName = usableBoardList[i].bdName;

		if (parseInt(atable.getAtom("xcLevel").element.value) == sdhLevel)
		{
			var atomsrc = atable.getAtom("srcSlotID");
			atomsrc.element.options[atomsrc.element.options.length] = new Option(
					getShowName(usableBoardList[i]), slotID);

			var atomsnk = atable.getAtom("snkSlotID");
			atomsnk.element.options[atomsnk.element.options.length] = new Option(
					getShowName(usableBoardList[i]), slotID);

			var sevLevel = atable.getAtom("xcLevel").element.value;
			if (atomsrc.element.options.length == 1)
			{
				var atom0, atom1, atom2, atom3;
				atom1 = atable.getAtom("snkPort");
				limitPortInput(atomsrc.element, atom1.element,
						parseInt(sevLevel));

				atom2 = atable.getAtom("snkVC4");
				limitVC4Input(atomsrc.element, atom2.element,
						parseInt(sevLevel), parseInt(atom1.element.value));

				atom3 = atable.getAtom("snkPath");
				limitPathInput(atomsrc.element, atom3.element,
						parseInt(sevLevel), atom2);
			}
			if (atomsnk.element.options.length == 1)
			{
				var atom0, atom1, atom2, atom3;
				atom1 = atable.getAtom("srcPort");
				limitPortInput(atomsnk.element, atom1.element,
						parseInt(sevLevel));

				atom2 = atable.getAtom("srcVC4");
				limitVC4Input(atomsnk.element, atom2.element,
						parseInt(sevLevel), parseInt(atom1.element.value));

				atom3 = atable.getAtom("srcPath");
				limitPathInput(atomsnk.element, atom3.element,
						parseInt(sevLevel), atom2);
			}
		}
	}
}

function getBoardResourceList()
{

	var xmlstr = createGetPortXml();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_SDHXCAVAILABLEBD + "&flat=1" + "&nmUser=" + win.obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, callGetBoardback, null, "inputdata=" + xmlstr);
}

function limitBatchInput(textinput)
{
	var code = event.keyCode;

	var ch = String.fromCharCode(code);

	if (code == 8 || code == 46 || code == 9)
	{
		return true; // DEL   
	}
	if (code > 36 && code < 41)
	{
		return true; //    
	}
	if (code > 47 && code < 58)
	{
		return true;
	}
	if ((code == 188) || (code == 189))
	{
		if (textinput.value.length == 0)
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	textcontent = textinput.value;

	if (code == 13)
	{
		if (textcontent.length == 0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	return false;
}

function limitSingleInput(textinput, minvalue, maxvalue)
{
	var code = event.keyCode;
	var ch = String.fromCharCode(code);

	if (code == 8 || code == 46 || code == 9)
	{
		return true; // DEL   
	}
	if (code > 36 && code < 41)
	{
		return true; //    
	}
	if (code > 47 && code < 58)
	{
		return true;
	}

	textcontent = textinput.value;

	if (code == 13)
	{
		if ((textinput.value >= minvalue) && (textinput.value <= maxvalue))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	if (event.shiftKey)
	{
		return false;
	}
	return false;
}

function isValidateSingleInput(inputText, limitLow, limitHigh)
{
	if (inputText.value.length == 0)
	{
		return true;
	}
	if ((parseInt(inputText.value) >= limitLow)
			&& (parseInt(inputText.value) <= limitHigh))
	{
		return true;
	}
	else
	{
		alert(RESOURCE["numberLimit2"]);
		inputText.value = 1;
		return false;
	}
}

function isValidateBatchInput(inputText, limitLow, limitHigh)
{

	var str = inputText.value.split(",");

	if (inputText.value.length == 0)
	{
		return true;
	}

	for ( var i = 0; i < str.length; i++)
	{
		var b = str[i].indexOf("-") != -1;
		if (b)
		{
			var range = str[i].split("-");
			var rangeStart = parseInt(range[0]);
			var rangeEnd = parseInt(range[1]);

			if ((rangeStart > limitHigh) || (rangeEnd > limitHigh)
					|| (rangeStart < limitLow) || (rangeEnd < limitLow))
			{
				alert(RESOURCE["numberLimitX"] + limitLow
						+ RESOURCE["numberLimitZ"] + limitHigh);
				inputText.value = 1;
				return false;
			}
		}
		else
		{
			if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow)
			{
				alert(RESOURCE["numberLimitX"] + limitLow
						+ RESOURCE["numberLimitZ"] + limitHigh);
				inputText.value = 1;
				return false;
			}
		}
	}
	return true;
}

function pathIDInputLimit(obj, minvalue, maxvalue)
{
	obj.style.imeMode = "disabled";
	obj.onkeydown = function()
	{
		return restrict(obj, event, "0123456789,-");
	}
	obj.onpaste = function()
	{
		return false;
	}
	obj.onblur = function()
	{
		return isValidateBatchInput(obj, minvalue, maxvalue);
	}
}

function isMSOTNBd(bdtype)
{
	if (bdtype == "2838" || bdtype == "2840" || bdtype == "2839" 
		|| bdtype == "2960" || bdtype == "2829" || bdtype == "2833")
	{
		return true;
	}
	return false;
}

function limitTSPPathInput(slotobj, pathobj, xcLevel, vc4obj, portID)
{
	var slotID = parseInt(slotobj.value);
	var sdhLevel = parseInt(xcLevel);
	var sdhName, bdName;
	var bdType, bdPort, bdPath, bdVC4;
	var minvalue = 1;
	var maxvalue = 1;
	var isfound = false;
	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		if ((xcLevel == usableBoardList[i].sdhLevel)
				&& (usableBoardList[i].slotID == slotID))
		{
			sdhName = usableBoardList[i].sdhName;
			bdName = usableBoardList[i].bdName;
			bdType = parseInt(usableBoardList[i].bdType);
			bdPort = parseInt(usableBoardList[i].portNumber);
			bdPath = parseInt(usableBoardList[i].pathNumber); // vc4Number
			bdVC4 = parseInt(usableBoardList[i].vc4Number); //
			maxvalue = parseInt(usableBoardList[i].pathNumber);

			isfound = true;
			break;
		}
	}
	if(bdType != BDTYPE_TNF1TSP && !(isMSOTNBd(bdType) && portID >= 51 && portID <= 66))
	{
		return;
	}		
	if(portID >=5 && portID <=25)
	{
		pathobj.value = 0;
		pathobj.disabled = true;
		return;
	}
	
	if (parseInt(xcLevel) < 6)
	{
		maxvalue = vc4obj.element.options.length;
	}

	if (!isfound)
	{
		return;
	}
	
	pathobj.disabled = false;
	pathobj.value = "";
	pathobj.style.imeMode = "disabled";
	pathobj.onkeypress = function()
	{
		var Evt = window.event;
		return restrictPath2(pathobj, Evt, maxvalue);
	}
	pathobj.onpaste = function()
	{
		return false;
	}
	pathobj.onblur = function()
	{

	}
	
	pathobj.onchange = function()
	{	
		var bdtype = getBdType(xcLevel, slotobj);
		if(bdtype == BDTYPE_TNF1TSP && pathobj.value <= vc4obj.element.options.length)
		{
		  vc4obj.element.value = pathobj.value;
		}
	}
	pathobj.onpaste = function()
	{
		var pasteText = window.clipboardData.getData("Text");
		pasteText = pathobj.value + pasteText;
		return pathTextCheck(pasteText, 1, maxvalue);

	}
}

function limitPathInput(slotobj, pathobj, xcLevel, vc4obj)
{
	var slotID = parseInt(slotobj.value);
	var sdhLevel = parseInt(xcLevel);
	var sdhName, bdName;
	var bdType, bdPort, bdPath, bdVC4;
	var minvalue = 1;
	var maxvalue = 1;
	var isfound = false;
	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		if ((xcLevel == usableBoardList[i].sdhLevel)
				&& (usableBoardList[i].slotID == slotID))
		{
			sdhName = usableBoardList[i].sdhName;
			bdName = usableBoardList[i].bdName;
			bdType = parseInt(usableBoardList[i].bdType);
			bdPort = parseInt(usableBoardList[i].portNumber);
			bdPath = parseInt(usableBoardList[i].pathNumber); // vc4Number
			bdVC4 = parseInt(usableBoardList[i].vc4Number); //
			maxvalue = parseInt(usableBoardList[i].pathNumber);

			isfound = true;
			break;
		}
	}
		
	if (parseInt(xcLevel) < 6)
	{
		maxvalue = vc4obj.element.options.length;
	}

	if (!isfound)
	{
		return;
	}
	pathobj.value = "";
	pathobj.style.imeMode = "disabled";
	pathobj.onkeypress = function()
	{
		var Evt = window.event;
		return restrictPath2(pathobj, Evt, maxvalue);
	}
	pathobj.onpaste = function()
	{
		return false;
	}
	pathobj.onblur = function()
	{

	}
	pathobj.onpaste = function()
	{
		var pasteText = window.clipboardData.getData("Text");
		pasteText = pathobj.value + pasteText;
		return pathTextCheck(pasteText, 1, maxvalue);

	}
}
function ispdhboard(boardtype)
{
	var ispdh = false;
	switch (boardtype)
	{
		case "1030":
		case "1031":
		case "1179":
		case "1180":
		case 1030:
		case 1031:
		case 1179:
		case 1180:
			ispdh = true;
			break;

		default:
			break;
	}

	var isPDHBd = SpecialAttrMgr.isCPSupportByType(neid,boardtype,"TE_FUNC_CFG_SDH_PAYLOAD","SDH_ATTR_SUPPORT_PDHBOARD");
	if (isPDHBd)
	{
		ispdh = true;
	}
	
	return ispdh;
}

function isifboard(boardtype)
{
	var ispdh = false;
	switch (boardtype)
	{
		case "1032":
		case "1033":
		case "1179":
		case "1180":
		case 1030:
		case 1031:
		case 1179:
		case 1180:
			ispdh = true;
			break;

		default:
			break;
	}
	
	var isIFBd = SpecialAttrMgr.isCPSupportByType(neid,boardtype,"TE_FUNC_CFG_SDH_PAYLOAD","SDH_ATTR_SUPPORT_IFBOARD");
	if (isIFBd)
	{
		ispdh = true;
	}
	
	return ispdh;
}

function limitPortInput(slotobj, portobj, xcLevel)
{
	var slotID = parseInt(slotobj.value);
	var sdhLevel = parseInt(xcLevel);
	var sdhName, bdName;
	var bdType, bdPort, bdPath, bdVC4;

	var vc12Tu = false;
	var minvalue = 1;
	var maxvalue = 1;

	var isfound = false;

	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		if ((xcLevel == usableBoardList[i].sdhLevel)
				&& (usableBoardList[i].slotID == slotID))
		{
			sdhName = usableBoardList[i].sdhName;
			bdName = usableBoardList[i].bdName;
			bdType = parseInt(usableBoardList[i].bdType);
			bdPort = usableBoardList[i].portNumber;
			bdPath = parseInt(usableBoardList[i].pathNumber); // vc4Number
			bdVC4 = parseInt(usableBoardList[i].vc4Number); //

			if (ispdhboard(bdType))
			{
				vc12Tu = true;
			}

			if (((bdType == 1032) || (bdType == 1033)) && (bdPath < 62)
					&& (parseInt(xcLevel) == 6))
			{
				vc12Tu = true; // IFA,IFB working in PDH mode ;
			}
			isfound = true;
			break;
		}
	}

	if (!isfound)
	{
		portobj.length = 0;
		return;
	}

	if ((vc12Tu) && (xcLevel != 1))
	{
		portobj.length = 0;
		portobj.value = "";
		portobj.disabled = true;
	}
	else
	{
		portobj.disabled = false;
		portobj.length = 0;
		var portList = bdPort.split(",");
		for ( var i = 0, isize = portList.length; i < isize; i++)
		{
			if(bdType == BDTYPE_TNF1TSP && portList[i] >=5 && portList[i] <=25)
			{
				if(xcLevel == 1)
				{
					continue;
				}
				portobj.options[portobj.length] = new Option(portList[i] +"(E1/T1-" + parseInt(portList[i]-4) + ")",
						parseInt(portList[i]));
			}
			else
			{
				portobj.options[portobj.length] = new Option(portList[i],
						parseInt(portList[i]));
			}
		}
	}
}

function limitVC4Input(slotobj, vc4obj, xcLevel, portID)
{
	var slotID = parseInt(slotobj.value);
	var sdhLevel = parseInt(xcLevel);
	var sdhName, bdName;
	var bdType, bdPort, bdPath, bdVC4;

	var vc12Tu = false;
	var minvalue = 1;
	var maxvalue = 1;

	var isfound = false;

	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		if ((xcLevel == usableBoardList[i].sdhLevel)
				&& (usableBoardList[i].slotID == slotID))
		{
			sdhName = usableBoardList[i].sdhName;
			bdName = usableBoardList[i].bdName;
			bdType = parseInt(usableBoardList[i].bdType);
			bdPort = usableBoardList[i].portNumber;
			bdPath = parseInt(usableBoardList[i].pathNumber); // vc4Number
			bdVC4 = usableBoardList[i].vc4Number; //
			maxvalue = parseInt(usableBoardList[i].portNumber);

			if (ispdhboard(bdType))
			{
				vc12Tu = true;
			}

			if (((bdType == 1032) || (bdType == 1033) || (bdType == BDTYPE_TNF1TSP)) && (bdPath < 62)
					&& (parseInt(xcLevel) == 6))
			{
				vc12Tu = true; // IFA,IFB working in PDH mode ;
			}
			if(bdType == BDTYPE_TNF1TSP && (portID >=5 && portID <=25))
			{
				vc12Tu = true; // tsp in PDH mode ;
				vc4obj.value = 0;
			}
			isfound = true;
			break;
		}
	}

	if (!isfound)
	{
		vc4obj.options.length = 0;
		return;
	}

	if (vc12Tu)
	{
		vc4obj.options.length = 0;
		vc4obj.disabled = true;
	}
	else
	{
		vc4obj.disabled = false;
		var vc4List = bdVC4.split(",");
		if (portID == null)
		{
			vc4Len = parseInt(vc4List[0]);
		}
		else
		{
				vc4Len = getPortVCNum(bdPort, bdVC4, portID);;
		}

		vc4obj.options.length = 0;
		for ( var i = 1; i <= vc4Len; i++)
		{
			vc4obj.options[vc4obj.options.length] = new Option("VC4-" + i, i);
		}
	}

	if (xcLevel <= 5)
	{
		vc4obj.disabled = true;
	}
}

function getBdType(xcLevel, slotobj)
{
	var bdType;
	var slotID = parseInt(slotobj.value);
	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		if ((xcLevel == usableBoardList[i].sdhLevel)
				&& (usableBoardList[i].slotID == slotID))
		{
	
			bdType = parseInt(usableBoardList[i].bdType);
			break;
			
		}
	}
	return bdType;
}


function getPortVCNum(bdPort, bdVC4, portID)
{

	var portList = bdPort.split(",");
	var vc4List = bdVC4.split(",");
	for ( var i = 0, isize = portList.length; i < isize; i++)
	{
		if(portList[i] == portID)
		{
		   return vc4List[i];
		}		
	}
	
}

function restrictPort(field, event, maxvalue)
{
	var key, keychar;

	var key = event.keyCode != 0 ? event.keyCode : event.charCode;

	keychar = String.fromCharCode(key);

	if (isIE)
	{
		var rng = document.selection.createRange();
		if (rng.text.length > 0)
		{
			document.selection.clear();
			if (((key > 48) && (key <= 57) && ((key - 48) < maxvalue))
					|| ((key > 96) && (key <= 105) && ((key - 96) < maxvalue)))
			{
				return true;
			}
		}
	}
	else
	{
		return true;
	}
	if (event.shiftKey)
	{
		if ((key == 37) || (key == 39))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if ((field.value.length == 0) && ((key == 48) || (key == 96)))
	{
		return false;
	}
	if ((field.value.length == 0)
			&& (((key > 48) && (key <= 57)) || ((key > 96) && (key <= 105))))
	{
		var tempvalue = 0;
		if ((key > 48) && (key <= 57))
		{
			tempvalue = key - 48;
		}
		else if ((key > 96) && (key <= 105))
		{
			tempvalue = key - 96;
		}
		if (tempvalue > maxvalue)
		{
			alert(RESOURCE["numberLimitX"] + 1 + RESOURCE["numberLimitZ"]
					+ maxvalue);
			return false;
		}
		else
		{
			return true;
		}
	}

	if ((field.value.length != 0)
			&& (((key >= 48) && (key <= 57)) || ((key >= 96) && (key <= 105))))
	{

		var tempvalue = 0;
		if ((key >= 48) && (key <= 57))
		{
			tempvalue = parseInt(field.value) * 10 + key - 48;
		}
		if ((key >= 96) && (key <= 105))
		{
			tempvalue = parseInt(field.value) * 10 + key - 96;
		}
		if (tempvalue > maxvalue)
		{
			alert(RESOURCE["numberLimitX"] + 1 + RESOURCE["numberLimitZ"]
					+ maxvalue);
			return false;
		}
		else
		{
			return true;
		}
	}
	else if ((key == null) || (key == 0) || (key == 8) || (key == 9)
			|| (key == 13) || (key == 46) || (key == 36) || (key == 35)
			|| (key == 37) || (key == 39))
	{
		return true;
	}
	else
	{
		return false;
	}
}

function restrictPath(field, event, maxvalue)
{
	var key, keychar;

	var key = event.keyCode != 0 ? event.keyCode : event.charCode;

	keychar = String.fromCharCode(key);

	if (event.shiftKey)
	{
		if ((key == 37) || (key == 39))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	if ((field.value.length == 0)
			&& ((key == 48) || (key == 189) || (key == 188) || (key == 109)))
	{
		return false;
	}
	if ((field.value.length == 0)
			&& (((key >= 48) && (key <= 57)) || ((key >= 96) && (key <= 105))))
	{
		var tempvalue = 0;

		if ((key >= 48) && (key <= 57))
		{
			tempvalue = key - 48;
		}
		else if ((key >= 96) && (key <= 105))
		{
			tempvalue = key - 96;
		}
		if (tempvalue > maxvalue)
		{
			alert(RESOURCE["numberLimitX"] + 1 + RESOURCE["numberLimitZ"]
					+ maxvalue);
			return false;
		}
		else
		{
			return true;
		}
	}

	if ((field.value.length != 0)
			&& ((key >= 48) && (key <= 57) || (key == 189) || (key == 188)
					|| (key == 109) || ((key >= 96) && (key <= 105))))
	{
		var tmp = field.value;
		var txtlist = field.value.split(",");


		if (((key >= 48) && (key <= 57)) || ((key >= 96) && (key <= 105)))
		{
			var currText = txtlist[txtlist.length - 1];
			var keytmp = 0;
			if ((key >= 48) && (key <= 57))
			{
				keytmp = key - 48;
			}
			else if ((key >= 96) && (key <= 105))
			{
				keytmp = key - 96;
			}

			if (currText == "")
			{
				if ((keytmp == 0) || (keytmp > maxvalue))
				{
					alert(RESOURCE["numberLimitX"] + 1
							+ RESOURCE["numberLimitZ"] + maxvalue);
					return false;
				}
				else
				{
					return true;
				}
			}
			if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-')
					|| (String.fromCharCode(currText
							.charCodeAt(currText.length - 1)) == ','))
			{
				if ((keytmp == 0) || (keytmp > maxvalue))
				{
					alert(RESOURCE["numberLimitX"] + 1
							+ RESOURCE["numberLimitZ"] + maxvalue);
					return false;
				}
				else
				{
					return true;
				}
			}
			else
			{
				if (currText.indexOf("-") == -1)
				{
					if ((parseInt(currText) * 10 + keytmp) > maxvalue)
					{
						alert(RESOURCE["numberLimitX"] + 1
								+ RESOURCE["numberLimitZ"] + maxvalue);
						return false;
					}
					else
					{
						return true;
					}
				}
				else
				{
					var tmpvalue = currText.substring(
							currText.indexOf("-") + 1, currText.length);
					if ((parseInt(tmpvalue) * 10 + keytmp) > maxvalue)
					{
						alert(RESOURCE["numberLimitX"] + 1
								+ RESOURCE["numberLimitZ"] + maxvalue);
						return false;
					}
					else
					{
						return true;
					}
				}
			}
		}
		if ((key == 189) || (key == 188) || (key == 109))
		{
			var currText = txtlist[txtlist.length - 1];
			if (currText == "")
			{
				return false;
			}
			if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-')
					|| (String.fromCharCode(currText
							.charCodeAt(currText.length - 1)) == ','))
			{
				return false;
			}
			else
			{
				if ((currText.indexOf("-") != -1) && (key != 188))
				{
					return false;
				}
				else
				{
					return true;
				}
			}

		}

	}
	else
	{
		if ((key == null) || (key == 0) || (key == 8) || (key == 9)
				|| (key == 13) || (key == 46) || (key == 36) || (key == 35)
				|| (key == 37) || (key == 39))
		{
			return true;
		}
		else
		{
			if (event.ctrlKey)
			{
				if (keychar == 'X' || keychar == 'C' || keychar == 'A'
						|| keychar == 'V')
				{
					return true;
				}
			}
			else
			{
				return false;
			}
		}
	}
}

function pathTextCheck(inputText, limitLow, limitHigh)
{
	for ( var i = 0, isize = inputText.length; i < isize; i++)
	{
		var ch = inputText.charCodeAt(i);
		if (ch < 48 || ch > 57)
		{
			if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ","))
			{
				continue;
			}
			else
			{
				return false;
			}
		}
	}

	var str = inputText.split(",");
	if (inputText.length == 0)
	{
		return true;
	}

	for ( var i = 0; i < str.length; i++)
	{
		var b = str[i].indexOf("-") != -1;
		if (b)
		{
			var range = str[i].split("-");
			var rangeStart = parseInt(range[0]);
			var rangeEnd = parseInt(range[1]);

			if ((rangeStart > limitHigh) || (rangeEnd > limitHigh)
					|| (rangeStart < limitLow) || (rangeEnd < limitLow))
			{
				alert(RESOURCE["numberLimitX"] + limitLow
						+ RESOURCE["numberLimitZ"] + limitHigh);
				inputText.value = 1;
				return false;
			}
		}
		else
		{
			if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow)
			{
				alert(RESOURCE["numberLimitX"] + limitLow
						+ RESOURCE["numberLimitZ"] + limitHigh);
				inputText.value = 1;
				return false;
			}
		}
	}
	return true;
}

function isIFIsTu(slot, level)
{
	var slotID = parseInt(slot);
	var xcLevel = parseInt(level);

	for ( var i = 0, len1 = usableBoardList.length; i < len1; i++)
	{
		if ((xcLevel == usableBoardList[i].sdhLevel)
				&& (usableBoardList[i].slotID == slotID))
		{
			sdhName = usableBoardList[i].sdhName;
			bdName = usableBoardList[i].bdName;
			bdType = parseInt(usableBoardList[i].bdType);
			bdPort = parseInt(usableBoardList[i].portNumber);
			bdPath = parseInt(usableBoardList[i].pathNumber); // vc4Number
			bdVC4 = parseInt(usableBoardList[i].vc4Number); //
			maxvalue = parseInt(usableBoardList[i].portNumber);

			if (((bdType == 1032) || (bdType == 1033)) && (bdPath < 63)
					&& (parseInt(xcLevel) == 6))
			{
				return true; // IFA,IFB working in PDH mode ;
			}
		}
	}
	return false;
}

function restrictPath2(field, event, maxvalue)
{

	var key, keychar;

	key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));

	keychar = String.fromCharCode(key);

	if (event.ctrlKey)
	{
		if (keychar == 'X' || keychar == 'C' || keychar == 'A'
				|| keychar == 'V')
		{
			return true;
		}
	}
	if (event.shiftKey)
	{
		return false;
	}
	if ((key == 8) || (key == 9))
	{
		return true;
	}

	if ((keychar == '\'') && (key == 39))
	{
		return true;
	}
	if ((keychar == '%') && (key == 37))
	{
		return true;
	}
	if ((keychar == '&') && (key == 38))
	{
		return true;
	}
	if ((keychar == '(') && (key == 40))
	{
		return true;
	}

	if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\''
			|| keychar == '[' || keychar == ']' || keychar == '\\'
			|| keychar == '=')
	{
		return false;
	}

	if (key > 36 && key < 41)
	{
		return true;
	}

	if ((field.value.length == 0)
			&& ((keychar == '0') || (keychar == ',') || (keychar == '-')))
	{
		return false;
	}

	if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9')))
	{
		var tempvalue = 0;
		if ((keychar >= '0') && (keychar <= '9'))
		{
			tempvalue = key - 48;
		}
		if (tempvalue > maxvalue)
		{
			alert(RESOURCE["numberLimitX"] + 1 + RESOURCE["numberLimitZ"]
					+ maxvalue);
			return false;
		}
		else
		{
			return true;
		}
	}
	if ((field.value.length != 0)
			&& ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ',')))
	{
		var tmp = field.value;
		var txtlist = field.value.split(",");

		if ((keychar >= '0') && (keychar <= '9'))
		{
			var pos = digitalTag_getPos(field);
			if (keychar == '0')
			{
				var val = tmp.substring(0, pos);
				var vArray = val.split(",");
				var value = vArray[vArray.length - 1].split("-");
				if (parseInt(value[value.length - 1]) == 0)
				{
					return false;
				}
			}
			var newVal = tmp.substring(0, pos) + keychar
					+ tmp.substring(pos + selectionLen(field));
			var vArr = newVal.split(",");
			for ( var i = 0; i < vArr.length; i++)
			{
				var va = vArr[i].split("-");
				for ( var j = 0; j < va.length; j++)
				{
					if (parseInt(va[j]) <= 0 || parseInt(va[j]) > maxvalue)
					{
						alert(RESOURCE["numberLimitX"] + 1
								+ RESOURCE["numberLimitZ"] + maxvalue);
						return false;
					}
				}
			}
		}
		if ((keychar == '-') || (keychar == ','))
		{
			var currText = txtlist[txtlist.length - 1];
			if (currText == "")
			{
				return false;
			}
			if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-')
					|| (String.fromCharCode(currText
							.charCodeAt(currText.length - 1)) == ','))
			{
				return false;
			}
			else
			{
				if ((currText.indexOf("-") != -1) && (keychar != ','))
				{
					return false;
				}
				else
				{
					return true;
				}
			}
		}
	}
	else
	{
		if (event.ctrlKey)
		{
			if (keychar == 'X' || keychar == 'C' || keychar == 'A'
					|| keychar == 'V')
			{
				return true;
			}
		}
		else
		{
			return false;
		}
	}
}

function setApplyEnabled()
{
	$("apply").disabled = false;
}

function setAtomDisabled(flag)
{
	atable.getAtom("xcLevel").element.disabled = flag;
	atable.getAtom("xcDirection").element.disabled = flag;
	atable.getAtom("srcSlotID").element.disabled = flag;
	atable.getAtom("srcPort").element.disabled = flag;
	atable.getAtom("srcVC4").element.disabled = flag;
	atable.getAtom("srcPath").element.disabled = flag;
	atable.getAtom("snkSlotID").element.disabled = flag;
	atable.getAtom("snkPort").element.disabled = flag;
	atable.getAtom("snkVC4").element.disabled = flag;
	atable.getAtom("snkPath").element.disabled = flag;
}

function getShowName(obj)
{
	var showname = "";
	if (obj.subrackid >= 0)
	{
		showname = obj.subrackname + "-" + obj.showslotid + "-" + obj.bdName;
	}
	else
	{
		showname = obj.slotID + "-" + obj.bdName;
	}
	return showname;
}
