 
var atable = null ;

var MAX_TIMESLOT_NUM = 63;
var TIMESLOT_SEPARATE = 21;
var slotnum = 63;
var TIMESLOT_NUM_PER_ROW = 3;

var g_pathMode = getParentWindow().g_pathMode;
var g_curEditFlag = getParentWindow().g_curEditFlag;

var VC12 = 6;
var VC3 = 7;
var VC4 = 1;

var tmpTitleStr = "";
var isSrc = false;
if( g_curEditFlag == 1 || g_curEditFlag == 3 || g_curEditFlag == 5 ) 
{
	tmpTitleStr = RESOURCE["plzselsrc"];
	isSrc = true;
}
if( g_curEditFlag == 2 || g_curEditFlag == 4 ) 
{
	tmpTitleStr = RESOURCE["plzselsink"];
}
document.title = tmpTitleStr;

var currentSelectedportRadioID = null;
var currentSelectedvc4RadioID = null;

var direction = "";
if(getParentWindow().atable.getAtom("xcDirection")!=null)
{
	direction = getParentWindow().atable.getAtom("xcDirection").element.value;
}
else
{
	direction = getParentWindow().atable.getAtom("direction").element.value;
}


var xcLevel = "";
if(getParentWindow().atable.getAtom("xcLevel")!=null)
{
	xcLevel = getParentWindow().atable.getAtom("xcLevel").element.value;
}
else
{
	xcLevel = getParentWindow().atable.getAtom("sdhlevel").element.value;
}


var vcMapList = getParentWindow().getParentWindow().vcMapList;

var tsToPathMap = new Object();

function init()
{	
	initShowText();
	
	initPortField();
	
	initHigherField();

	initLowerFieldSet();

	if(xcLevel == VC12)
	{
		initTimeslotComboxVC12();
		changeShowMode();
		timeslotOccupyVC12();
		onlySelectedFirstTimeslotCombox();
	}
	else if(xcLevel == VC3)
	{
		initTimeslotComboxVC3();
		timeslotOccupyVC3();
		onlySelectedFirstTimeslotCombox();
	}
	else
	{
		
		timeslotOccupyVC4();
		selectedFirstVC4();
	}
	
	
	
}

function clearTimeslotCombox()
{
	for( var i = 0 ; i < 5 ; i++ )
	{
		if($("vc4Radio"+i) == null)
		{
			break;
		}		
		$("vc4Radio"+i).disabled = false;
		if(xcLevel == VC4)	
		{
			$("vc4Radio"+i).checked = false;
		}
		
	}	
	
	if(xcLevel != VC4)	
	{	
		for( var i = 0 ; i < slotnum ; i++ )
		{
			if($("timeslotCombox"+i) == null)
			{
				break;
			}		
			$("timeslotCombox"+i).disabled = false;
			$("timeslotCombox"+i).checked = false;
		}
     }
}


function timeslotOccupyVC12()
{
	if( direction==0 && isSrc) 
	{
		return;
	}

	clearTimeslotCombox();

	var curVC4 = getCurrentVC4();
	var key = getCurrentParentSlot().value+"-"+getCurrentPort()+"-" + curVC4;
	
	
	var vc12MapList = vcMapList[6];
	if(vc12MapList != null && vc12MapList[key]!=null)
	{
		var vc12List = vc12MapList[key];
		for(var i =0,iLength=vc12List.length;i<iLength;i++)
		{
			if(vc12List[i] == 1)
			{
				$("timeslotCombox"+tsToPathMap[i]).disabled = true;
			}
		}
	}
	
	var vc3MapList = vcMapList[7];
	if(vc3MapList != null && vc3MapList[key]!=null)
	{
		var vc3List = vc3MapList[key];
		for(var i =0,iLength=vc3List.length;i<iLength;i++)
		{
			
			if(vc3List[i] == 1)
			{
				for(var j=0;j<TIMESLOT_SEPARATE;j++)
				{
					$("timeslotCombox"+((i-1)*TIMESLOT_SEPARATE+j)).disabled = true;
				}
			}
		}
	}
	
	var vc4MapList = vcMapList[1];
	if(vc4MapList != null && vc4MapList[key]!=null)
	{
		for(var j=0;j<MAX_TIMESLOT_NUM;j++)
		{			
			   $("timeslotCombox"+j).disabled = true;
		}
			
	}
}



function timeslotOccupyVC3()
{
	if( direction==0 && isSrc) 
	{
		return;
	}

	clearTimeslotCombox();

	var curVC4 = getCurrentVC4();
	var key = getCurrentParentSlot().value+"-"+getCurrentPort()+"-" + curVC4;
	
	
	var vc12MapList = vcMapList[6];
	if(vc12MapList != null && vc12MapList[key]!=null)
	{
		var vc12List = vc12MapList[key];
		for(var i =0,iLength=vc12List.length;i<iLength;i++)
		{
			if(vc12List[i] == 1)
			{
				var index = (i-1)%3;
				$("timeslotCombox"+index).disabled = true;
			}
		}
	}
	
	var vc3MapList = vcMapList[7];
	if(vc3MapList != null && vc3MapList[key]!=null)
	{
		var vc3List = vc3MapList[key];
		for(var i =0,iLength=vc3List.length;i<iLength;i++)
		{
			if(vc3List[i] == 1 )
			{
				$("timeslotCombox"+(i-1)).disabled = true;
			}
		}
	}
	
	var vc4MapList = vcMapList[1];
	if(vc4MapList != null && vc4MapList[key]!=null)
	{
		var vc4List = vc4MapList[key];
		for(var j =0;j<3;j++)
		{
			$("timeslotCombox"+j).disabled = true;
		}			
	}
}


function timeslotOccupyVC4()
{
	if( direction==0 && isSrc) 
	{
		return;
	}

	clearTimeslotCombox();

	var tmpVC4RadioArray = document.getElementsByName("vc4Radio");
	for( var i = 0 ; i < tmpVC4RadioArray.length ; i++ )
	{
	    var	tmpVC4Radio = tmpVC4RadioArray[i];
	    var key = getCurrentParentSlot().value+"-"+getCurrentPort()+"-"+tmpVC4Radio.value;
	
	
		var vc4MapList = vcMapList[1];
		if(vc4MapList != null && vc4MapList[key]!=null)
		{
			tmpVC4Radio.disabled = true;
			continue;
		}
		
		
		var vc3MapList = vcMapList[7];
		if(vc3MapList != null && vc3MapList[key]!=null)
		{
			tmpVC4Radio.disabled = true;
			continue;
		}		
	
		var vc12MapList = vcMapList[6];
		if(vc12MapList != null && vc12MapList[key]!=null)
		{
			tmpVC4Radio.disabled = true;
			continue;
		}

 }
 

	
}

function doAllSelect()
{
	if(xcLevel == VC4)
	{
		var tmpVC4RadioArray = document.getElementsByName("vc4Radio");
		for( var i = 0 ; i < tmpVC4RadioArray.length ; i++ )
		{
			var	tmpVC4Radio = tmpVC4RadioArray[i];
			if(tmpVC4Radio !=null && !tmpVC4Radio.disabled)
			{
				tmpVC4Radio.checked = event.srcElement.checked;
			}
		}
	}
	else
	{
	for( var i = 0 ; i < slotnum; i++ )
	{
		if( $("timeslotCombox"+i) == null )
		{
			continue;
		}
		if(!$("timeslotCombox"+i).disabled)
		{
			$("timeslotCombox"+i).checked = $("allSelectCheckBox").checked;
		}
	}
	}
}

function changeShowMode()
{	
	for( var i = 0 ; i < slotnum ; i++ )
	{
		
		if( isHuaweiMode() )	//         
		{
			var ts = convertHuaweiToLucent(i+1);
			$("staticField"+i).innerHTML = $("showModeCheckBox").checked == true ? ts + "(" + (i+1) + ")" : ts;
			tsToPathMap[ts] = i;
		}
		else									//         
		{
			var ts = (i+1);
			$("staticField"+i).innerHTML = $("showModeCheckBox").checked == true ? (i+1) + "(" + convertLucentToHuawei(i+1) + ")" : (i+1);
			tsToPathMap[ts] = i;
		}
	}
}


function initShowText()
{
	$("porttextsubnet").innerHTML = RESOURCE["portstr"];
	$("highertextsubnet").innerHTML = RESOURCE["highleveltimeslot"];
	$("lowertextsubnet").innerHTML = RESOURCE["lowleveltimeslot"];
	$("allSelectSpan").innerHTML= RESOURCE["allselect"];
	if(xcLevel == VC12)
	{
		$("showModeCheckBox").checked	= false;
		$("showModeSpan").innerHTML	= isHuaweiMode() ? RESOURCE["timeslotbyorderM"] : RESOURCE["timeslotbyinterleavedM"]
	}
	else if(xcLevel == VC3)
	{
		$("showModeCheckBox").style.display = 'none';
	}
	else
	{
		$("LowerTimeslotFieldset").style.display = 'none';
		$("highAllSelectTable").style.display = '';
		$("hiAllSelectSpan").innerHTML= RESOURCE["allselect"];
		
	}
}

function initPortField()
{
	var tmpPortElement = getCurrentParentPort();
	
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  tmpTable.insertRow(0);

	for( var i = 0 ; i < tmpPortElement.options.length ; i++ )
	{
		var ifChecked = "";
		if( tmpPortElement.value == tmpPortElement.options[i].value )
		{
			ifChecked = " checked";
		}
		
		var inner = "<input type='radio' name='portRadio' id='portRadio" + i + "' value='" + tmpPortElement.options[i].value + "' "+ ifChecked +" onclick='portChange(this)'>"
							+ "<span>" + tmpPortElement.options[i].value + "</span>";

		if( ifChecked != "" )
		{
			currentSelectedportRadioID = "portRadio"+ i;
		}
		
		var curCell	= curRow.insertCell(i);
		curCell.innerHTML = inner;
	}
	$("PortFieldset").appendChild(tmpTable);
}

function initHigherField()
{
	var tmpVC4Element = getCurrentParentVC4();
	
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  tmpTable.insertRow(0);
	
	for( var i = 0 ; i < tmpVC4Element.options.length ; i++ )
	{
		var ifChecked = "";
		if( tmpVC4Element.value == tmpVC4Element.options[i].value )
		{
			ifChecked = " checked";
		}
		
		var inner ="";
		if(xcLevel == VC4)
		{
			inner = "<input type='checkbox' name='vc4Radio' id='vc4Radio" + i + "' value='" + (i+1) + "' " + " >"
							+ "<span>" + (i+1) + "</span>";
		}
		else
		{
		  inner = "<input type='radio' name='vc4Radio' id='vc4Radio" + i + "' value='" + (i+1) + "' " + ifChecked + " onclick='changeTimeslotState(this,2)'>"
							+ "<span>" + (i+1) + "</span>";
		}
		
		if( ifChecked != "" )
		{
			currentSelectedvc4RadioID = "vc4Radio" + i;
		}
		
		var curCell	= curRow.insertCell(i);
		curCell.innerHTML = inner;
	}
	$("HigherTimeslotFieldset").appendChild(tmpTable);
}

function initLowerFieldSet()
{
	var tmpDomain = parseInt( slotnum / (TIMESLOT_SEPARATE+1) );
	
	for( var i = 0 ; i < tmpDomain+1 ; i++ )
	{
		$("fieldset"+i).style.display = "";
		var tmpTable = document.createElement("table");
		tmpTable.setAttribute("id","table"+i);
		tmpTable.width = "100%";
		tmpTable.height = "100%";
		$("fieldset"+i).appendChild(tmpTable);
	}
}

function initTimeslotComboxVC12()
{
	for( var i = 0 ; i < slotnum ; i++ )
	{
		var tmpComboBoxInput = document.createElement("input");
		tmpComboBoxInput.setAttribute("type","checkbox");
		tmpComboBoxInput.setAttribute("id","timeslotCombox"+i);
		
		/*
		if( i == 0 )
		{
			tmpComboBoxInput.setAttribute("defaultChecked","true");
		}*/
			
		var tmpNum = i % TIMESLOT_SEPARATE;
		var tmpDomain = parseInt(i/TIMESLOT_SEPARATE);
		
		
		var curRow;
		if( tmpNum % TIMESLOT_NUM_PER_ROW == 0 )
		{
			curRow =  $("table"+tmpDomain).insertRow( tmpNum / TIMESLOT_NUM_PER_ROW );
		}
		else
		{
			curRow = $("table"+tmpDomain).rows[$("table"+tmpDomain).rows.length-1];
		}
		
		var curCell	= curRow.insertCell(tmpNum % TIMESLOT_NUM_PER_ROW);
		curCell.appendChild(tmpComboBoxInput);
		
		var staticField = document.createElement("span");
		staticField.setAttribute("id","staticField"+i);

		curCell.appendChild(staticField);
	}
}

function initTimeslotComboxVC3()
{
	for( var i = 0 ; i < 3 ; i++)
	{
		var tmpComboBoxInput = document.createElement("input");
		tmpComboBoxInput.setAttribute("type","checkbox");
		tmpComboBoxInput.setAttribute("id","timeslotCombox"+i);	
		
		
		var curRow =  $("table"+i).insertRow();
		
		var curCell	= curRow.insertCell();
		curCell.appendChild(tmpComboBoxInput);
		
		var staticField = document.createElement("span");
		staticField.setAttribute("id","staticField"+i);
		curCell.appendChild(staticField);
		

		$("staticField"+i).innerHTML = i+1;
	}
}


function convertHuaweiToLucent(pathID)
{
	if( pathID == -1 )
	{
		return "";
	}
	var TUG_COMMON_FLAG = 21;
  var Tu12 = ((pathID - 1) / TUG_COMMON_FLAG) + 1;
  Tu12 = parseInt(Tu12);
  var Tug2 = ((pathID - 1) % TUG_COMMON_FLAG / 3) + 1;
  Tug2 = parseInt(Tug2);
  var Tug3 = ((pathID - 1) % 3) + 1;
  Tug3 = parseInt(Tug3);
  var newpathID = Tu12 + (Tug2-1)* 3 + (Tug3-1)* TUG_COMMON_FLAG ;
  return parseInt(newpathID);
}

function convertLucentToHuawei(pathID)
{
	if( pathID == -1 )
	{
		return "";
	}
	var TUG_COMMON_FLAG = 21;
	var Tu12 = ((pathID - 1) / TUG_COMMON_FLAG) + 1;
	Tu12 = parseInt(Tu12);
  var Tug2 = ((pathID - 1) % TUG_COMMON_FLAG / 3) + 1;
  Tug2 = parseInt(Tug2);
  var Tug3 = ((pathID - 1) % 3) + 1;
  Tug3 = parseInt(Tug3);
  var newpathID = Tu12 + (Tug2-1)* 3 + (Tug3-1)* TUG_COMMON_FLAG ;
  return parseInt(newpathID);
}

function getCurrentPort()
{
	var tmpPortRadio = 0;
	var tmpPortRadioArray = document.getElementsByName("portRadio");
	for( var i = 0 ; i < tmpPortRadioArray.length ; i++ )
	{
		if( tmpPortRadioArray[i].checked )
		{
			tmpPortRadio = tmpPortRadioArray[i].value;
			return tmpPortRadio;
		}
	}
}

function getCurrentVC4()
{
	var tmpVC4Radio = 0;
	var tmpVC4RadioArray = document.getElementsByName("vc4Radio");
	for( var i = 0 ; i < tmpVC4RadioArray.length ; i++ )
	{
		if( tmpVC4RadioArray[i].checked )
		{
			tmpVC4Radio = tmpVC4RadioArray[i].value;
			return tmpVC4Radio;
		}
	}
}

function okBtnClicked()
{
	var tmpParentTimeSlot = getCurrentParentTimeslot();
	var tmpPortRadio = getCurrentPort();	
	var tmpVC4Radio = getCurrentVC4();

	if(xcLevel == VC12)
	{	
	   var timeslotString = convertToStandardTimeslotString();
	   tmpParentTimeSlot.value = timeslotString;
	   getParentWindow().synchronizePathAtomWithPathField(tmpParentTimeSlot);	
	   getCurrentParentPort().value = tmpPortRadio;
	   getCurrentParentPort().onchange();
	   getCurrentParentVC4().value = tmpVC4Radio;
	   getCurrentParentVC4().onchange();
	}
	else if(xcLevel == VC3)
	{
		getCurrentParentPort().value = tmpPortRadio;
		getCurrentParentPort().onchange();
		var tmpStr = "";
		for( var i = 0 ; i < slotnum ; i++ )
		{
		if($("timeslotCombox"+i) == null)
		{
			break;
		}
		if($("timeslotCombox"+i).checked)
		{		
			tmpStr += (i+1)+",";
		}
		}
		getCurrentParentTimeslot().value = tmpStr.substring(0,tmpStr.length-1);
	}
	else
	{
		getCurrentParentPort().value = tmpPortRadio;
		getCurrentParentPort().onchange();
		var tmpStr = "";
		var tmpVC4RadioArray = document.getElementsByName("vc4Radio");
		for( var i = 0 ; i < tmpVC4RadioArray.length ; i++ )
		{
			if(tmpVC4RadioArray[i].checked)
			{
				tmpStr +=tmpVC4RadioArray[i].value+",";
			}
		}

		getCurrentParentTimeslot().value = tmpStr.substring(0,tmpStr.length-1);
	
	}

    getParentWindow().setApplyEnabled();
	xcloseDialog();
}

function cancelBtnClicked()
{
	xcloseDialog();
}


function getCurrentParentSlot()
{
	var tmpPortElement;
	if( g_curEditFlag == 1 ) 
	{
		tmpPortElement = getParentWindow().atable.getAtom("srcSlotID").element;
	}
	if( g_curEditFlag == 2 ) 
	{
		tmpPortElement = getParentWindow().atable.getAtom("snkSlotID").element;
	}
	if( g_curEditFlag == 3 ) 
	{
		tmpPortElement = getParentWindow().$("wsrcSlotID");
	}
	if( g_curEditFlag == 4 ) 
	{
		tmpPortElement = getParentWindow().$("wsnkSlotID");
	}
	if( g_curEditFlag == 5 ) 
	{
		tmpPortElement = getParentWindow().$("psrcSlotID");
	}
	
	return tmpPortElement;
}

function getCurrentParentPort()
{
	var tmpPortElement;
	if( g_curEditFlag == 1 ) 
	{
		tmpPortElement = getParentWindow().atable.getAtom("srcPort").element;
	}
	if( g_curEditFlag == 2 ) 
	{
		tmpPortElement = getParentWindow().atable.getAtom("snkPort").element;
	}
	if( g_curEditFlag == 3 ) 
	{
		tmpPortElement = getParentWindow().$("wsrcPortID");
	}
	if( g_curEditFlag == 4 ) 
	{
		tmpPortElement = getParentWindow().$("wsnkPortID");
	}
	if( g_curEditFlag == 5 ) 
	{
		tmpPortElement = getParentWindow().$("psrcPortID");
	}
	
	return tmpPortElement;
}


function getCurrentParentVC4()
{
	var tmpVC4Element;
	if( g_curEditFlag == 1 ) 
	{
		tmpVC4Element = getParentWindow().atable.getAtom("srcVC4").element;
	}
	if( g_curEditFlag == 2 ) 
	{
		tmpVC4Element = getParentWindow().atable.getAtom("snkVC4").element;
	}
	if( g_curEditFlag == 3 ) 
	{
		tmpVC4Element = getParentWindow().$("wsrcVC4ID");
	}
	if( g_curEditFlag == 4 ) 
	{
		tmpVC4Element = getParentWindow().$("wsnkVC4ID");
	}
	if( g_curEditFlag == 5 ) 
	{
		tmpVC4Element = getParentWindow().$("psrcVC4ID");
	}	
	
	return tmpVC4Element;
}

function getCurrentParentTimeslot()
{
	var tmpTimeslotElement;
	if( g_curEditFlag == 1 ) 
	{
		tmpTimeslotElement = getParentWindow().srcAtom.element;
	}
	if( g_curEditFlag == 2 ) 
	{
		tmpTimeslotElement = getParentWindow().sinkAtom.element;
	}
	if( g_curEditFlag == 3 ) 
	{
		tmpTimeslotElement = getParentWindow().$("wsrcPathID");
	}
	if( g_curEditFlag == 4 ) 
	{
		tmpTimeslotElement = getParentWindow().$("wsnkPathID");
	}
	if( g_curEditFlag == 5 ) 
	{
		tmpTimeslotElement = getParentWindow().$("psrcPathID");
	}	
	
	return tmpTimeslotElement;
}

/**
 *	convert to "1-3,5-40,42-45"
 */
function convertToStandardTimeslotString()
{
	var timeslotString = "";
	var tmpHead = "";
	var tmpTail = "";
	
	for( var i = 0 ; i < slotnum ; i++ )
	{
		var tmpNumber = isHuaweiMode() ? convertLucentToHuawei(i+1)-1 : i;
		
		if( $("timeslotCombox"+tmpNumber).checked == true )
		{
			if( tmpHead == "" )
			{
				tmpHead = i+1;
			}
			
			tmpTail = i+1;
			
		}
		else
		{
			if( tmpHead != "" && tmpTail != "" )
			{
				if( tmpHead == tmpTail )
				{
					timeslotString += tmpHead + ",";
				}
				else
				{
					timeslotString += tmpHead + "-" + tmpTail + ",";
				}
				
				tmpHead = "";
				tmpTail = "";
			}
		}
	}
	
	if( tmpHead != "" && tmpTail != "" )
	{
		if( tmpHead == tmpTail )
		{
			timeslotString += tmpHead + ",";
		}
		else
		{
			timeslotString += tmpHead + "-" + tmpTail + ",";
		}
		
		tmpHead = "";
		tmpTail = "";
	}
	
	if( timeslotString != "" )
	{
		timeslotString = timeslotString.substring(0,timeslotString.length-1);
	}
	
	return timeslotString;
}


function isHuaweiMode()
{
	return g_pathMode==0 ? true : false;
}

function portChange(obj)
{
   var slotID= getCurrentParentSlot().value;
   var portID = obj.value;
   var usableBoardList = getParentWindow().usableBoardList;
   var tmpTable = $("HigherTimeslotFieldset").lastChild;
   var bdVC4, isPDHBoard;
   var vc12Tu = false;
   var isfound = false;
   for (var i = 0, len1 = usableBoardList.length; i < len1; i++) 
   {
       if ((xcLevel == usableBoardList[i].sdhLevel) && (usableBoardList[i].slotID == slotID)) 
       {
          bdVC4 = usableBoardList[i].vc4Number;
          isPDHBoard = usableBoardList[i].isPDHBoard;
          if (isPDHBoard) 
          {
             vc12Tu = true;
          }
          isfound = true;
          break;
       }
   }
   if (!isfound) 
   {
	   if (tmpTable.rows.length>0)
	   {
	      tmpTable.deleteRow(0);
	   }
       return;
   }    
   if (vc12Tu) 
   {
	   if (tmpTable.rows.length>0)
	   {
		   tmpTable.deleteRow(0);
	   } 
   }
   else 
   {
	   if (tmpTable.rows.length>0)
	   {
		   tmpTable.deleteRow(0);
	   } 
	   var curRow =  tmpTable.insertRow(0);
	   if(bdVC4.indexOf(",")>0)
	   {
		   var args = bdVC4.split(",");
		   bdVC4 = args[portID-1];
	   }
	   for (var i = 0; i < bdVC4; i++) 
       {
		   var ifChecked = "";
			if( i == 0 )
			{
				ifChecked = " checked";
			}
			
			var inner ="";
			if(xcLevel == VC4)
			{
				inner = "<input type='checkbox' name='vc4Radio' id='vc4Radio" + i + "' value='" +(i+1) + "' " + " >"
								+ "<span>" + (i+1) + "</span>";
			}
			else
			{
			    inner = "<input type='radio' name='vc4Radio' id='vc4Radio" + i + "' value='" + (i+1) + "' " + ifChecked + " onclick='changeTimeslotState(this,2)'>"
								+ "<span>" + (i+1) + "</span>";
			}
			
			if( ifChecked != "" )
			{
				currentSelectedvc4RadioID = "vc4Radio" + i;
			}
			
			var curCell	= curRow.insertCell(i);
			curCell.innerHTML = inner;
       }
   }    
      
   changeTimeslotState(obj,1);
}


function changeTimeslotState(obj,type)
{
	/* type
	 *     1:"port"
	 *     2:"vc4"
	 */

	var currentSelectedObjID = type == 1 ? currentSelectedportRadioID : currentSelectedvc4RadioID;
	
	if( obj == $(currentSelectedObjID) )
	{
		return;
	}
	else
	{
		
		if( type == 1 )
		{	//             VC1
			if(xcLevel != VC4)
			{
				if($("vc4Radio0").disabled == false)
				{
				  $("vc4Radio0").checked = true;
				}
			}			
			currentSelectedportRadioID = obj.id
		}
		else
		{
			currentSelectedvc4RadioID = obj.id;
		}
	}
	
	if(xcLevel == VC12)
	{
		timeslotOccupyVC12();
		onlySelectedFirstTimeslotCombox();
	}
	else if(xcLevel == VC3)
	{
		timeslotOccupyVC3();
		onlySelectedFirstTimeslotCombox();
	}
	else
	{
		timeslotOccupyVC4();
		selectedFirstVC4();
	}
	
	
}

function onlySelectedFirstTimeslotCombox()
{
   if (getCurrentParentTimeslot().value =="")
   {
	   for( var i = 0 ; i < slotnum ; i++ )
	   {		
		   if( $("timeslotCombox"+i) != null )
		   {
			   $("timeslotCombox"+i).checked = false;
			   if($("timeslotCombox"+i).disabled == false)
			   {
				   $("timeslotCombox"+i).checked = true;
				   break;
			   }
			}
				
		}
   }
   else
   {
	   var tmpParentTimeSlot = covertPathStringToArray(getCurrentParentTimeslot().value);
		for( var i = 0 ; i < slotnum ; i++ )
		{		
			if( $("timeslotCombox"+i) != null )
			{
				$("timeslotCombox"+i).checked = false;
				var tmpNumber = (i+1);
				if(xcLevel == VC12)
				{
				   tmpNumber = isHuaweiMode() ?  convertHuaweiToLucent(i+1) : (i+1);
				}
				if($("timeslotCombox"+i).disabled == false 
						&& tmpParentTimeSlot.contains(tmpNumber))
				{
					  $("timeslotCombox"+i).checked = true;
				}
				
			}
		}
   }
   $("allSelectCheckBox").checked = false;
   var isAllDisabled = true;
   for( var i = 0 ; i < slotnum ; i++ )
   {		
	  if( $("timeslotCombox"+i) != null )
	  {			
		  if( $("timeslotCombox"+i).disabled == false )
		  {
			  isAllDisabled = false;
			  break;
		  }
	  }
   }
   $("allSelectCheckBox").disabled = isAllDisabled;
}


function selectedFirstVC4()
{
	if (getCurrentParentTimeslot().value =="")
	{
	    for( var i = 0 ; i < 5 ; i++ )
	    {
		   if($("vc4Radio"+i)!=null && !$("vc4Radio"+i).disabled)
		   {
			  $("vc4Radio"+i).checked = true;
			   break;
		   }
	    }
	}
	else
	{
		var tmpParentTimeSlot = covertPathStringToArray(getCurrentParentTimeslot().value);
		for( var i = 0 ; i < 5 ; i++ )
		{
			if($("vc4Radio"+i)!=null && !$("vc4Radio"+i).disabled && tmpParentTimeSlot.contains(i+1))
			{
				$("vc4Radio"+i).checked = true;
			}
		}
	}
	
}
