var winobj = getNeProperty(self);
var parentWin = getParentWindow();
var neid = parentWin.neid;
var ringPGTable;
var newringMspDataXML;
var availablePortList = [];
var westLineList = [];
var eastLineList = [];
var MIN_DELAYTIME = 300;
var MAX_DELAYTIME = 720;
var DEFAULT_DELAYTIME = 600;
var LEVEL_STM4 = 6404;
var DEFAULT_LOCAL_NODE = 1;
var DEFAULT_WEST_NODE = 0;
var DEFAULT_EAST_NODE = 2;
var DEFAULT_NODE = 0;
var MAX_NODE = 15;
var MIN_NODE = 0;
var WEST_LINE = 0;
var EAST_LINE = 2;
var groupID = 1;
var doublueRing = 1;
var vc4enable = false;
var convertVc4enable = false;
var mydoc = new Object();
var applyWestList = [];
var applyEastList = [];
loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/ringmsp/ringmsp_" + SYSTEMCONF.getLanguage() + ".xml");
document.title = RESOURCE["createPGTitle"];

function initBody()
{
    $("boardMapTableTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
    $("selectMapDirectTitle").appendChild(document.createTextNode(RESOURCE["selectMapDirectTitle"]));
    $("selectMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectMapBoardTitle"]));
    $("selectedMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectedMapBoardTitle"]));
    $("vc4mode").appendChild(document.createTextNode(RESOURCE["vc4mode"]));
    
    $("okBtn").value = RESOURCE["okbutton"];
    $("cancleBtn").value = RESOURCE["cancelbutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
    
    $("selectMapDirect").options[0] = new Option(RESOURCE["westLine"], WEST_LINE);
    $("selectMapDirect").options[1] = new Option(RESOURCE["eastLine"], EAST_LINE);
    
    initTable();
    getAvailableResourceInfo();
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
    ringPGTable = new CTable();
    ringPGTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option("STM-4", LEVEL_STM4);
    cTableAtomEle.disabled = true;
    cTableAtomEle.style.imeMode = "disabled";
    ringPGTable.addAttrRow("level", RESOURCE["level"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue(RESOURCE["doublering"]);
    cTableAtomEle.disabled = true;
    cTableAtomEle.style.imeMode = "disabled";
    ringPGTable.addAttrRow("protectionType", RESOURCE["protectionType"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue(DEFAULT_NODE);
    checkDataCellEvent(cTableAtomEle, MIN_NODE, MAX_NODE, DEFAULT_NODE);
    cTableAtomEle.style.imeMode = "disabled";
    ringPGTable.addAttrRow("localNode", RESOURCE["localNode"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue(DEFAULT_NODE);
    checkDataCellEvent(cTableAtomEle, MIN_NODE, MAX_NODE, DEFAULT_NODE);
    cTableAtomEle.style.imeMode = "disabled";
    ringPGTable.addAttrRow("westNode", RESOURCE["westNode"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue(DEFAULT_NODE);
    checkDataCellEvent(cTableAtomEle, MIN_NODE, MAX_NODE, DEFAULT_NODE);
    cTableAtomEle.style.imeMode = "disabled";
    ringPGTable.addAttrRow("eastNode", RESOURCE["eastNode"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue(DEFAULT_DELAYTIME);
    checkDataCellEvent(cTableAtomEle, MIN_DELAYTIME, MAX_DELAYTIME, DEFAULT_DELAYTIME);
    cTableAtomEle.style.imeMode = "disabled";
    ringPGTable.addAttrRow("revertiveTime", RESOURCE["revertiveTime"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Disabled"], 0);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Enabled"], 1);
    cTableAtomEle.options[1].selected = true; //    
    cTableAtomEle.onchange = setApplyEnabled;
    ringPGTable.addAttrRow("sdEnable", RESOURCE["sdEnable"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["newProtocol"], 1);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["refactorProtocol"], 2);
    cTableAtomEle.options[0].selected = true; //    
    cTableAtomEle.onchange = setApplyEnabled;
    ringPGTable.addAttrRow("protocolType", RESOURCE["protocolType"], cTableAtom);
    
    $("ringPGTableArea").appendChild(ringPGTable.getTable());
}

function getAvailableResourceInfo()
{
    var xmlstr = createGetAvailableResXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_FREERINGMSP + "&flag=1";
    loadXMLdoc(urlreq, "POST", false, initBoardMap, null, "inputdata=" + xmlstr);
}

function createGetAvailableResXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
        
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "level");
	param.setAttribute("value", ringPGTable.getAttrValue("level"));
	row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();    
}

function initBoardMap(doc, vc4enable)
{    
    mydoc = doc;
    westLineList = []; //            
    eastLineList = []; //            
    var availableportObj = $("availableport");
    clearSelectOptions($("availableport"));
    clearSelectOptions($("selectedport"));
    boardList = new Array();

    var dinterface = EncapsulateData(doc);
    if ((null == dinterface.getSErrorCode()) || (0 == dinterface.getSErrorCode())) 
    {    
        for (var i = 0, len = dinterface.getDataRowLength(); i < len; i++) 
        {
            var TEPort = new Object();
            var obj = dinterface.rows[i];
            if (vc4enable) //-1
            {
                TEPort.slotid = obj["slotid"];
                TEPort.boardname = obj["boardname"];
                TEPort.port = obj["port"];
                TEPort.portname = obj["portname"];
                TEPort.groupid = obj["groupid"];
                
                for (var j = 1; j < 5; j++) 
                {
                    var str = "-VC4:" + j;
                    
                    if(isUsed(TEPort, true, j))
                    {
                        continue;
                    }
                    
                    insertSelectOption(availableportObj, TEPort.slotid.value + ":" + TEPort.port.value + ":" + TEPort.boardname.value + ":" + TEPort.portname.value + ":" + j, getString(TEPort) + str);
                }
            }
            else //0 null
            {
                TEPort.slotid = obj["slotid"];
                TEPort.boardname = obj["boardname"];
                TEPort.port = obj["port"];
                TEPort.portname = obj["portname"];
                TEPort.groupid = obj["groupid"];
                
                if(isUsed(TEPort, false))
                {
                    continue;
                }
                
                insertSelectOption(availableportObj, TEPort.slotid.value + ":" + TEPort.port.value + ":" + TEPort.boardname.value + ":" + TEPort.portname.value, getString(TEPort));
            }
        }
    }
}

function getString(TEPort)
{
    var str = TEPort.slotid.value + "-" + TEPort.boardname.value + "-" + TEPort.portname.value;
    return str;
}

function checkWestEast()
{
    applyWestList = [];
    applyEastList = [];
    convertVc4enable = false;
    var westlen = westLineList.length;
    var eastlen = eastLineList.length;
    if ((westlen + eastlen) != 4 && (westlen + eastlen) != 8 && (westlen + eastlen) != 2) 
    {
        alert(RESOURCE["INFO_WEST_EAST_NOT_FOLLOWED"]);
        return false;
    }
    
    for (var i = 0; i < westlen; i++) 
    {
        var westUnit = westLineList[i].split(":");
        if (westUnit[4] < 3) 
        {
            applyWestList.push(westLineList[i]);
        }
    }
    for (var j = 0; j < eastlen; j++) 
    {
        var eastUnit = eastLineList[j].split(":");
        if (eastUnit[4] < 3) 
        {
            applyEastList.push(eastLineList[j]);
        }
    }
    if (applyEastList.length == 0 || applyWestList.length == 0) 
    {
        alert(RESOURCE["INFO_INVALIDATE_MAPPING"]);
        return false;
    }
    if (applyEastList.length != applyWestList.length) 
    {
        alert(RESOURCE["INFO_WEST_EAST_NOT_FOLLOWED"]);
        return false;
    }
    if (applyEastList.length == 2 && applyWestList.length == 2) 
    {
        convertVc4enable = true;
    }
    return true;
}

/**
 *            
 */
function doCreateringMsp(isApply)
{
    if ($("applyBtn").disabled) 
    {
        self.close();
    }
    
    if (ringPGTable.getAttrValue("localNode") == ringPGTable.getAttrValue("westNode") ||
    ringPGTable.getAttrValue("localNode") == ringPGTable.getAttrValue("eastNode")) 
    {
        alert(RESOURCE["CAN_NOT_EQUALS"]);
        return;
    }
    
    if (westLineList.length == 0) 
    {
        alert(RESOURCE["INFO_WEST_NODE_NOT_SELECTED"]);
        return;
    }
    else if (eastLineList.length == 0) 
    {
        alert(RESOURCE["INFO_EAST_NODE_NOT_SELECTED"]);
        return;
    }
    
    if (vc4enable) 
    {
        if (!checkWestEast()) 
        {
            return;
        }
    }
    $("okBtn").disabled = true;
    $("cancleBtn").disabled = true;
    $("applyBtn").disabled = true;
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_CREATE_RINGMSP + "&nmUser=" + parentWin.winobj["nmUser"];
    loadXMLdoc(url, "POST", true, callbackCreateringMsp, isApply, "inputdata=" + createCreateringMspXMLInfo());    
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createCreateringMspXMLInfo()
{
    newringMspDataXML = new inputxml("datainterface");
    
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", parentWin.winobj["neid"]);
    
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "groupID");
    var groupIDList = getRangeNumber(parentWin.usedPGID,parentWin.MIN_GROUP_ID,parentWin.MAX_GROUP_ID,1);
    param.setAttribute("value", groupIDList[0]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "protectionType");
    param.setAttribute("value", doublueRing);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "localNode");
    param.setAttribute("value", ringPGTable.getAttrValue("localNode"));
    param.setAttribute("modifyFlag", true);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "westNode");
    param.setAttribute("value", ringPGTable.getAttrValue("westNode"));
    param.setAttribute("modifyFlag", true);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eastNode");
    param.setAttribute("value", ringPGTable.getAttrValue("eastNode"));
    param.setAttribute("modifyFlag", true);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "waitreverttime");
    param.setAttribute("value", ringPGTable.getAttrValue("revertiveTime"));
    param.setAttribute("modifyFlag", true);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "sdEnable");
    param.setAttribute("value", ringPGTable.getAttrValue("sdEnable"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "protocoltype");
    param.setAttribute("value", ringPGTable.getAttrValue("protocolType"));
    row.appendChild(param);
    
    if (vc4enable && !convertVc4enable) 
    {
        var westUnit = applyWestList[0].split(":");
        param = new tagElement("param");
        param.setAttribute("name", "Wprotectunit");
        param.setAttribute("value", WEST_LINE);
        
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Wslotid");
        param.setAttribute("value", westUnit[0]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Wport");
        param.setAttribute("value", westUnit[1]);
        row.appendChild(param);
        
        var eastUnit = applyEastList[0].split(":");
        param = new tagElement("param");
        param.setAttribute("name", "Eprotectunit");
        param.setAttribute("value", EAST_LINE);
        
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Eslotid");
        param.setAttribute("value", eastUnit[0]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Eport");
        param.setAttribute("value", eastUnit[1]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vc4enable");
        param.setAttribute("value", "true");
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Wau4used");
        param.setAttribute("value", westUnit[4]);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Eau4used");
        param.setAttribute("value", eastUnit[4]);
        row.appendChild(param);
    }
    else 
    {
        param = new tagElement("param");
        param.setAttribute("name", "vc4enable");
        param.setAttribute("value", "false");
        row.appendChild(param);
        
        var westUnit = westLineList[0].split(":");
        param = new tagElement("param");
        param.setAttribute("name", "Wprotectunit");
        param.setAttribute("value", WEST_LINE);
        
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Wslotid");
        param.setAttribute("value", westUnit[0]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Wport");
        param.setAttribute("value", westUnit[1]);
        row.appendChild(param);
        
        var eastUnit = eastLineList[0].split(":");
        param = new tagElement("param");
        param.setAttribute("name", "Eprotectunit");
        param.setAttribute("value", EAST_LINE);
        
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Eslotid");
        param.setAttribute("value", eastUnit[0]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Eport");
        param.setAttribute("value", eastUnit[1]);
        row.appendChild(param);
    }    
    
    bussiness.appendChild(row);
    newringMspDataXML.getRoot().appendChild(bussiness);
    return newringMspDataXML.toString();
}

/**
 *               
 * @param doc:          
 * @return  
 */
function callbackCreateringMsp(doc, isApply)
{
    var data = EncapsulateData(doc);
    
    var errorCode = data.getSErrorCode();
    showOperResult(data);
    $("okBtn").disabled = false;
    $("cancleBtn").disabled = false;
    
    if (0 == errorCode || 1 == errorCode) 
    {
        parentWin.queryPG();
        
        if (!isApply) //               
        {
            self.close();
        }
        else
        {
        	westLineList = [];
        	eastLineList = [];
        }
        
        clearSelectOptions($("selectedport"));
    }
    else //               
     {
        $("applyBtn").disabled = false;
    }
}

/**
 *     
 */
function removeSelectListData(rightFlag)
{
    $("applyBtn").disabled = false;
    
    var srcObj;
    var sinkObj;
    
    if (rightFlag) 
    {
        srcObj = $("availableport");
        sinkObj = $("selectedport");
    }
    else 
    {
        srcObj = $("selectedport");
        sinkObj = $("availableport");
    }
    
    if (srcObj.selectedIndex == -1) 
    {
        alert(RESOURCE["ID_SELECT"]);
        return;
    }
    
    var option = null;
    for (var i = 0; i < srcObj.options.length; i++) 
    {
        var showText = srcObj.options[i].innerText;
        if (srcObj.options[i].selected) 
        {
            if (rightFlag) 
            {
                if ($("selectMapDirect").value == WEST_LINE) 
                {
                    if (vc4enable) 
                    {
                        if (isSamePort(srcObj.options[i].value, true)) 
                        {
                            alert(RESOURCE["INFO_SAME_SLOTID_PORT"]);
                            break;
                        }
                    }
                    else 
                    {
                        if (westLineList.length == 1) 
                        {
                            alert(RESOURCE["INFO_WEST_LINE_ONE"]);
                            break;
                        }
                    }
                    showText = RESOURCE["westLine"] + ":" + showText;
                    westLineList.push(srcObj.options[i].value);
                }
                else 
                {
                    if (vc4enable) 
                    {
                        if (isSamePort(srcObj.options[i].value, false)) 
                        {
                            alert(RESOURCE["INFO_SAME_SLOTID_PORT"]);
                            break;
                        }
                    }
                    else 
                    {
                        if (eastLineList.length == 1) 
                        {
                            alert(RESOURCE["INFO_EAST_LINE_ONE"]);
                            break;
                        }
                    }
                    showText = RESOURCE["eastLine"] + ":" + showText;
                    eastLineList.push(srcObj.options[i].value);
                }
            }
            else 
            {
                var westUnit = showText.substring(0, showText.indexOf(":"));
                showText = showText.substring(showText.indexOf(":") + 1);
                if (westUnit == RESOURCE["westLine"]) 
                {
                    westLineList.remove(srcObj.options[i].value);
                }
                else 
                {
                    eastLineList.remove(srcObj.options[i].value);
                }
            }
            
            insertSelectOption(sinkObj, srcObj.options[i].value, showText);
            
            srcObj.remove(i);
            i--;
        }
    }
}

function isSamePort(value, isWest)
{
    var temp = value.split(":");
    
    if (isWest && westLineList[0] != undefined) 
    {
        tempWest = westLineList[0].split(":");
        if (temp[0] != tempWest[0] || temp[1] != tempWest[1]) 
        {
            return true;
        }
    }
    if (!isWest && eastLineList[0] != undefined) 
    {
        tempEast = eastLineList[0].split(":");
        if (temp[0] != tempEast[0] || temp[1] != tempEast[1]) 
        {
            return true;
        }
    }
    return false;
}

function insertSelectOption(selectObj, insertValue, insertText)
{
    var option = new Option();
    selectObj.add(option, getInsertIndex(selectObj, insertValue));
    if (null == insertText) 
    {
        insertText = insertValue;
    }
    option.innerText = insertText;
    option.value = insertValue;
}

function getInsertIndex(selectObj, insertValue)
{
    var optionObjArr = insertValue.split(":");
    var slotid = parseInt(optionObjArr[0]);
    var port = parseInt(optionObjArr[1]);
    var vc4 = parseInt(optionObjArr[4]);
    
    var otherOptionObjArr
    var otherSlotid;
    var otherPort;
    var othervc4;
    for (var i = 0; i < selectObj.options.length; i++) 
    {
        otherOptionObjArr = selectObj.options[i].value.split(":");
        otherSlotid = parseInt(otherOptionObjArr[0]);
        otherPort = parseInt(otherOptionObjArr[1]);
        othervc4 = parseInt(otherOptionObjArr[4]);
        if (slotid < otherSlotid) 
        {
            return i;
        }
        else if (slotid == otherSlotid && port <= otherPort && vc4 <= othervc4) 
        {
            return i;
        }
    }
    return selectObj.options.length;
}


function clearSelectOptions(selectObj)
{
    for (var i = selectObj.options.length; i >= 0; i--) 
    {
        selectObj.remove(selectObj.options[i]);
    }
}

function setApplyEnabled()
{
    $("applyBtn").disabled = false;
}

function doVc4Convert()
{
    vc4enable = ~ vc4enable;
    initBoardMap(mydoc, vc4enable);
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data)
{
    var errArr = [];//           
    errArr[0] = "groupid";//           
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        data.getError().rowErrors[i].errorObj["groupid"] = RESOURCE["RING_MSP_ID"] + data.getError().rowErrors[i].errorObj["groupid"];
    }
    openErrPage("../../../../page/", data.getError(), errArr);
}


function isUsed(teport, vc4Flg, vc4Path)
{
    var bdMapData = parentWin.boardMapData;
    
    var portName;
    if(vc4Flg)
    {
        for(var i = 0, len = bdMapData.rows.length; i < len; i++)
        {
            portName = bdMapData.rows[i].portname.value;
            if(teport.slotid.value == bdMapData.rows[i].slotid.value && teport.port.value == bdMapData.rows[i].port.value)
            {
                if(portName.indexOf('VC4:') < 0)
                {
                    return true;
                } else {
                
                    var vc4Arr = portName.substring((portName.indexOf(':') + 1), portName.length).split(',');
                    if(vc4Arr.contains(vc4Path))
                    {
                        return true;
                    }
                }
            }
        }
    } else {
        for(var i = 0, len = bdMapData.rows.length; i < len; i++)
        {
            if(teport.slotid.value == bdMapData.rows[i].slotid.value && teport.port.value == bdMapData.rows[i].port.value)
            {
                return true;
            }
        }
    }
    
    return false;
}
