 var winobj = getNeProperty(self);
var ringPGTable;
var boardMapTable;
var boardMapData = null;
var ALL_CLEAR = 10; //     
var LOCKED = 15; //    
var UNLOCKED = 31; //    
var FORCE_SW = 13; //     
var CLEAN_FORCE_SW = 29; //       
var MANUAL_SW = 6; //     
var CLEAN_MANUAL_SW = 22; //       
var EXERCISE_SW = 3;//     
var CLEAN_EXERCISE_SW = 19; //       

var usedPort = []; //     
var aviablePort = []; //     
var usedPGID = []; //      ID
var delPGList = []; //      
var MIN_GROUP_ID = 1;
var MAX_GROUP_ID = 1;
var REVERTIVE_MODE0 = 0; //    
var REVERTIVE_MODE1 = 1; //     
var PROTECT_TYPE0 = 0; //1+1
var PROTECT_TYPE1 = 1; //1:N

var MIN_GROUP_ID = 1;
var MAX_GROUP_ID = 512;

var obj = getNeProperty(self);
var neid = obj["neid"];
loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);

getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/ringmsp/ringmsp_"+SYSTEMCONF.getLanguage()+".xml");

loadXMLdoc("../../conf/ringmsp/mspprotectgrouptable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);
loadXMLdoc("../../conf/ringmsp/boardmapping_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);

/**
 *      
 * @param  
 * @return  
 */
function initBody()
{
	$("psmProtectGroupTitle").appendChild(document.createTextNode(RESOURCE["PGTitle"]));
	$("boardMappingTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
	
	initTable();
	initButton();
	queryPG();
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	ringPGTable = new SortTable();
	ringPGTable.isUsedForSelectList = true;
    ringPGTable.setImage("../../../../images/");
    
    ringPGTable.setOnRowSelectHandler(rowSelectHandler);  
    
    ringPGTable.setOnCellEditHandler(cellEditHandler);
   
    createTableHead(ringPGTable, window.tableconf[0]); 
    
    ringPGTable.setBodyWidth(window.tableconf[0].width,window.tableconf[0].percent,0);
    
   
    var ringPGTableArea = document.createElement("div");
    ringPGTableArea.setAttribute("id","protectGroupTable");
    ringPGTableArea.className = "adaptTable";
    ringPGTableArea.appendChild(ringPGTable.getTable());
    $("protectGroup").appendChild(ringPGTableArea);

    adjustTableLayout(ringPGTable,window.tableconf[0],0);
    
    boardMapTable = new SortTable();
    boardMapTable.isUsedForSelectList = true;
    boardMapTable.setImage("../../../../images/");
    
	boardMapTable.setSingleChoiceFlg(true);  
   
    createTableHead(boardMapTable, window.tableconf[1]);      
    
    boardMapTable.setBodyWidth(window.tableconf[1].width,window.tableconf[1].percent,0);   
    var boardMapTableArea = document.createElement("div");
    boardMapTableArea.setAttribute("id","boardMapTable");
    boardMapTableArea.className = "adaptTable";
    boardMapTableArea.appendChild(boardMapTable.getTable());
    $("boardMap").appendChild(boardMapTableArea);  
    boardMapTableArea.oncontextmenu=popupMenuHandler;	    
   
   var totalHeight = getComponetHeight($("tablecomponent"),200);
    ringPGTable.setBodyHeight(totalHeight*0.6+"px");
    boardMapTable.setBodyHeight(totalHeight*0.38+"px"); 
}

/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
	if(SYSTEMCONF.getLanguage() == "en")
    {
        $("startBtn").className = "buttonstyle3";
        $("endBtn").className = "buttonstyle3";
        $("queryBtn").className = "buttonstyle5";
    }
    
	$("startBtn").value = RESOURCE["startBtn"];
    $("endBtn").value = RESOURCE["endBtn"]; 
	$("createBtn").value = RESOURCE["createBtn"];
    $("queryBtn").value = RESOURCE["queryBtn"]; 
	$("applyBtn").value = RESOURCE["applyBtn"];
    $("delBtn").value = RESOURCE["delBtn"]; 
}

/**
 *            
 * @param  
 * @return  
 */
function initButtonStatus()
{
		setBtnStatus(false,["createBtn","queryBtn"]);
		if(ringPGTable.getSelectedRowCount()>0) 
		{
			setBtnStatus(false,["startBtn","endBtn","delBtn"]);
		}
		else
		{
			setBtnStatus(true,["startBtn","endBtn","delBtn"]);
		}
		setBtnStatus(true,["applyBtn"]);
    for(var rowindex = 0,rowlen = ringPGTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(ringPGTable.getModify(rowindex))
    	{
    		setBtnStatus(false,["applyBtn"]);
    		break;
    	}
    }
}    

/**
 *             
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	if(rows.length == 0)
	{
		$("startBtn").disabled = true;
	    $("endBtn").disabled = true;
	    $("delBtn").disabled = true;
	    boardMapTable.clearTableData();
	    	
	}
	else
	{	
		$("startBtn").disabled = false;
	    $("endBtn").disabled = false;
	    $("delBtn").disabled = false;
	    	
		var groupid = 0;
		
		groupid = ringPGTable.getCellStoreValue(rows[0],"groupid","groupid")
		
	    queryBoardMapInfo(groupid);	
	}
}

/**
 *             
 * @param  
 * @return  
 */
function cellEditHandler()
{
	$("applyBtn").disabled = false;
}

/**
 *      
 * @param  
 * @return  
 */
function queryPG()
{
	setBtnStatus(true);
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_RINGMSP+"&nmUser="+winobj["nmUser"];
	
    loadXMLdoc(url,"POST",true,callbackQueryPG,null,"inputdata="+createQueryPGXMLInfo());
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createQueryPGXMLInfo()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *             
 * @param doc:          
 * @return  
 */
function callbackQueryPG(doc)
{
	var data = EncapsulateData(doc);
	var errObj = null;
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{		
		ringPGTable.clearTableData();
		boardMapTable.clearTableData();
		fillTableData(data,true);
	}
	else
	{
		errObj = [];
		errObj.push("nename");
	}
	
	initButtonStatus();
	showOperResult(data,errObj);
	
}

/**
 *         
 * @param data:       isQuery        
 * @return  
 */
function fillTableData(data,isQuery)
{
	handQueryData(data,isQuery);
	
	createTableBody(ringPGTable,window.tableconf[0],data,RESOURCE);
	
	if(ringPGTable.getDataRowLength() > 0 && ringPGTable.getSelectedRowCount() == 0)
	{
		ringPGTable.setRowSelect(0);
		rowSelectHandler(ringPGTable.getSelectedRows());
	}
}

/**
 *                  
 * @param doc:          
 * @return  
 */
function handQueryData(data,isQuery)
{
	if(isQuery)
	{
		usedPort = [];
		usedPGID = [];
		boardMapData = new DataInterface();
	}
	var boardMapArr = ["protectunit","slotid","boardname","port","portname","switchStatue","convertstatus"];
	var eastRing = null;
	var westRing = null;
	var ptag = null;
	for(var i = data.getDataRowLength()-1; i >= 0; i--)
	{
		usedPGID.push(data.getDataRowParam(i,"groupid"));
		eastRing = new Object();
		westRing = new Object();
		
		eastRing["groupid"] = data.rows[i].groupid;
		westRing["groupid"] = data.rows[i].groupid;
		
		for(var index = 0, len = boardMapArr.length; index < len; index++)
		{
			eastRing[boardMapArr[index]] = data.rows[i]["E" + boardMapArr[index]];
			westRing[boardMapArr[index]] = data.rows[i]["W" + boardMapArr[index]];
		}
		if(data.rows[i]["vc4enable"].value == 1)
		{
			eastRing["portname"].value = eastRing["portname"].value + "-" + data.rows[i]["Eau4used"].value;
			westRing["portname"].value = westRing["portname"].value + "-" + data.rows[i]["Wau4used"].value;
		}
		
		boardMapData.rows[boardMapData.rows.length] = eastRing;
		boardMapData.rows[boardMapData.rows.length] = westRing;
	}
}

/**
 *         
 * @param groupid    ID
 * @return  
 */
function removeBoardMapData(groupid)
{
	for(var index = boardMapData.getDataRowLength()-1; index >= 0; index--)
	{
		if(boardMapData.getDataRowParam(index,"groupid") == groupid)
		{
			boardMapData.rows.removeAt(index);
		}
	}		
}

/**
 *             
 * @param groupid    ID
 * @return  
 */
function queryBoardMapInfo(groupid)
{
	var tmpSelectRow = -1;
	var tmpSlectPGID = -1;
	if(boardMapTable.getSelectedRowCount() >0 )
	{
		tmpSelectRow = boardMapTable.getSelectedRows()[0];
		tmpSlectPGID= boardMapTable.getCellStoreValue(0,"groupid","groupid");
	}
	
	boardMapTable.clearTableData();
	var boardData = new DataInterface();
	for(var i = 0, len = boardMapData.getDataRowLength(); i < len; i++)
	{
		if(boardMapData.getDataRowParam(i,"groupid") == groupid)
		{
			boardData.rows.push(boardMapData.rows[i]);
		}
	}
	
	createTableBody(boardMapTable,window.tableconf[1],boardData,RESOURCE);
	if(groupid == tmpSlectPGID)
	{
		boardMapTable.setRowSelect(tmpSelectRow);
	}
}


/**
 *       
 * @param  
 * @return  
 */
function querySWStatus(isQuery)
{
	if(ringPGTable.getDataRowLength() == 0)
	{
		return;
	}

	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_RINGMSPSTATE+"&nmUser="+winobj["nmUser"];
	
    loadXMLdoc(url,"POST",true,callbackQuerySWStatus,isQuery,"inputdata="+createQuerySWStatusXMLInfo());
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQuerySWStatusXMLInfo()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;    
    
    delPGList = [];
    
    for(var i = 0,len = ringPGTable.getDataRowLength(); i < len; i++)
    {
    	row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);
	    row.appendChild(param);
	    	    
	    param = new tagElement("param");
	    param.setAttribute("name","groupid");
	    param.setAttribute("value",ringPGTable.getCellStoreValue(i,"groupid","groupid"));
	    row.appendChild(param);    
	    bussiness.appendChild(row);
	    delPGList.push(ringPGTable.getCellStoreValue(i,"groupid","groupid"));
	    
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQuerySWStatus(doc,isQuery)
{
	var data = EncapsulateData(doc);
	
	var errorCode = data.getSErrorCode();
	var groupid = 0;
	var protectunit = 0;
	if(0 == errorCode || 1== errorCode)  
	{	
		for(var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			groupid = data.getDataRowParam(i,"groupid");
			protectunit = data.getDataRowParam(i,"protectunit");
			for(var index = 0, size = ringPGTable.getDataRowLength(); index < size; index++)
			{
				if(groupid == ringPGTable.getCellStoreValue(index,"groupid","groupid"))
				{
					ringPGTable.setCellValue(ringPGTable.getCell(index,"protocolStatus"),"protocolStatus",data.getDataRowParam(i,"protocolStatus"));
					ringPGTable.setAtomValue(ringPGTable.getCellElement(index,"protocolStatus").showElement,protocolStatus[data.getDataRowParam(i,"protocolStatus")]);	
					break;
				}
			}
			for(var index = 0, size = boardMapData.getDataRowLength(); index < size; index++)
			{
				if(boardMapData.getDataRowParam(index,"groupid") == groupid && boardMapData.getDataRowParam(index,"protectunit") == protectunit)
				{
					boardMapData.rows[index].switchStatue.value = data.getDataRowParam(i,"switchStatue");
					boardMapData.rows[index].endIndication.value = data.getDataRowParam(i,"endIndication");
					if(data.getDataRowParam(i,"protectedUnit") == 1)
					{
						boardMapData.rows[index].protectedSlotid = boardMapData.rows[index].slotid;
						boardMapData.rows[index].protectedBoardname = boardMapData.rows[index].boardname;
						boardMapData.rows[index].protectedport = boardMapData.rows[index].port;
						boardMapData.rows[index].protectedPortname = boardMapData.rows[index].portname;
					}
					else
					{
						boardMapData.rows[index].protectedSlotid = "";
						boardMapData.rows[index].protectedBoardname = "";
						boardMapData.rows[index].protectedport = "";
						boardMapData.rows[index].protectedPortname = "";						
					}
				}
			}
		}	
		rowSelectHandler(ringPGTable.getSelectedRows());
	}	
	if(isQuery)
	{
		showOperResult(data);
	}	
}

/**
 *       
 * @param  
 * @return  
 */
function openCreateDialog()
{
	alert(RESOURCE["MSP_CREATE_WARN"]);
	var dialogHeight = "630px";
	var dialogWidth = "550px";
	if(SYSTEMCONF.getLanguage() == "en")
	{
	   dialogHeight = "630px";
	   dialogWidth = "700px";
		
	}
	showModalDialog("createringmsp.html", window, "dialogHeight:"+dialogHeight+";dialogWidth:"+dialogWidth+";center:yes;help:no;resizable:No;status:No;");	
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQueryResXMLInfo()
{
	 var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQueryRes(doc)
{
	var data = EncapsulateData(doc);
	
	var errorCode = data.getSErrorCode();
	
	aviablePort = [];
	
	if(0 != errorCode) 
	{		
		return;
	}
	var tmpPort = 0;	
	for(var i = 0, len = data.getDataRowLength(); i < len; i++)
	{		
		tmpPort = new TEPort(data.getDataRowParam(i,"slotid"),data.getDataRowParam(i,"boardname"),data.getDataRowParam(i,"port"),data.getDataRowParam(i,"portname"));
		if(!usedPort.containsPort(tmpPort))
		{
			aviablePort.push(tmpPort);
		}
	}
}

/**
 *         
 * @param  
 * @return  
 */
function startProtocol(isStart)
{
	if(isStart)
	{
		setBtnStatus(true,["startBtn"]);		
	}
	else
	{
		setBtnStatus(true,["endBtn"]);		
	}
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DEAL_RINGMSPPROTOCOL+"&nmUser="+winobj["nmUser"];	
	
    loadXMLdoc(url,"POST",true,callbackStartProtocol,isStart,"inputdata="+createStartProtocolXMLInfo(isStart));
}

/**
 *          XML  
 * @param  
 * @return  
 */
function createStartProtocolXMLInfo(isStart)
{
	 var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    

    var selectedRow = ringPGTable.getSelectedRows();
    
    for(var i = 0, len = selectedRow.length; i < len; i++)
    {
    	row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","startFlag");
	    if(isStart)
	    {
	    	param.setAttribute("value",1);
	    }
	    else
	    {
	    	param.setAttribute("value",0);
	    }
	    row.appendChild(param);    

	    param = new tagElement("param");
	    param.setAttribute("name","groupid");
	    param.setAttribute("value",ringPGTable.getCellStoreValue(selectedRow[i],"groupid","groupid"));
	    row.appendChild(param);    
	    bussiness.appendChild(row);
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackStartProtocol(doc,isStart)
{
	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode())
	{
		alert(RESOURCE["queryProtocolAlert"]);
	}
	else
	{
		showOperResult(data);		
	}
	
	rowSelectHandler(ringPGTable.getSelectedRows());
}

/**
 *            
 * @param  
 * @return  
 */
function delRingMsp()
{
	if(!confirm(RESOURCE["ID_BELMSP_PROL"]))
	{
		return;
	}
	
    var selectedRow = ringPGTable.getSelectedRows();
	setBtnStatus(true,["delBtn"]);
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_RINGMSP+"&nmUser="+winobj["nmUser"];	
   loadXMLdoc(url,"POST",true,callbackDelRingMsp,null,"inputdata="+createDelRingMspXMLInfo());
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createDelRingMspXMLInfo()
{
	 var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;    
    
    delPGList = [];
    
    var selectedRow = ringPGTable.getSelectedRows();
    for(var i = 0; i < selectedRow.length; i++)
    {
    	row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","groupID");
	    param.setAttribute("value",ringPGTable.getCellStoreValue(selectedRow[i],"groupid","groupid"));
	    row.appendChild(param);    
	    bussiness.appendChild(row);
	    delPGList.push(ringPGTable.getCellStoreValue(selectedRow[i],"groupid","groupid"));
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *               
 * @param doc:          
 * @return  
 */
function callbackDelRingMsp(doc)
{
	var data = EncapsulateData(doc);
	var faultPGList = [];
	if(data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
		for(var i = 0,len = data.getBErrLength(); i < len; i++)
		{
			faultPGList.push(data.getBErrParam(i,"groupid"));
		}
	
		for(var i = 0, len = ringPGTable.getDataRowLength(); i < len; i++)
		{
			var groupid = ringPGTable.getCellStoreValue(i,"groupid","groupid");
			
			if(delPGList.contains(groupid) && !faultPGList.contains(groupid))
			{
				ringPGTable.deleteRow(i);
				
				usedPGID.remove(groupid);	
				usedPort.removePort(groupid);
				removeBoardMapData(groupid);
			}
		}	
		ringPGTable.adjustDataRows();
	}
	if(ringPGTable.getDataRowLength() == 0)
	{
	  adjustTableLayout(ringPGTable,window.tableconf[0],0);
  	}
	showOperResult(data);
    
    boardMapTable.clearTableData();
    
	if(ringPGTable.getDataRowLength() > 0 && ringPGTable.getSelectedRowCount() == 0)
	{
		ringPGTable.setRowSelect(0);
	}
	rowSelectHandler(ringPGTable.getSelectedRows());
	initButtonStatus();
}

/**
 *              
 * @param  
 * @return  
 */
function modifyRingMsp()
{
	setBtnStatus(true,["applyBtn"]);
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_RINGMSPPARA+"&nmUser="+winobj["nmUser"];	
	
	var xmlData = createSetRingMspXMLInfo();
	if(null == xmlData)
	{
	   return;
	}
	
    loadXMLdoc(url,"POST",true,callbackSetRingMsp,null,"inputdata="+xmlData);
}

/**
 *               XML  
 * @param  
 * @return  
 */
function createSetRingMspXMLInfo()
{
	 var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var isModify = false;
    for(var rowindex = 0,rowlen = ringPGTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!ringPGTable.getModify(rowindex))
    	{
    		continue;
    	}
    	isModify = true;
        rowData = ringPGTable.getRow();
    	row = new tagElement("row-params");
    	
    	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",winobj["neid"]); 
		row.appendChild(param);	
		
    	for(var colindex = 0,collen = ringPGTable.getColumnCount();colindex<collen;colindex++)
    	{
    		colid = window.tableconf[0].getColId(colindex);
    		cellModifyFlag = ringPGTable.getCellModify(rowindex,colid);
    		colkeyarray = window.tableconf[0].getColKeyArray(colindex);
    		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
    		{
    			param = new tagElement("param");
    			key = colkeyarray[keyindex].name;
    			param.setAttribute("name",key);
    			param.setAttribute("value",ringPGTable.getCellStoreValue(rowindex,colid,key));   
    			param.setAttribute("modifyFlag",cellModifyFlag); 
    			row.appendChild(param);		
    		}    		
    	}
    	bussiness.appendChild(row);
    }    
    if(!isModify)
    {
    	return null;
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *                 
 * @param doc:          
 * @return  
 */
function callbackSetRingMsp(doc)
{
	var data = EncapsulateData(doc);	
	refreshTableState(ringPGTable,window.tableconf[0],data);
	if(0 != data.getSErrorCode())
	{
		setBtnStatus(false,["applyBtn"]);
	}
	showOperResult(data);	
}

/**
 *       
 * @param  
 * @return  
 */
function switchRingMsp(switchType)
{
	removejsDOMmenu();
	if(15 == switchType)
	{
		if( !confirm(RESOURCE["LockAlarm"]) )
      return;
	}
  
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_RINGMSPSW+"&nmUser="+winobj["nmUser"];	
    loadXMLdoc(url,"POST",true,callbackSwitchRingMsp,switchType,"inputdata="+createSwitchRingMspXMLInfo(switchType));
}

/**
 *        XML  
 * @param  
 * @return  
 */
function createSwitchRingMspXMLInfo(switchType)
{
	 var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    

    var selectedRow = boardMapTable.getSelectedRows();
    
	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","groupid");
    param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRow[0],"groupid","groupid"));
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","convertdirection");
    param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRow[0],"protectunit","protectunit"));
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","converttype");
    param.setAttribute("value",switchType);
    row.appendChild(param);    
    bussiness.appendChild(row);
    
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackSwitchRingMsp(doc,switchType)
{
	var data = EncapsulateData(doc);
	if(0 == data.getSErrorCode())
	{
		alert(RESOURCE["querySWStatus"]);
	}	
	showOperResult(data);
}

 /**
 *             
 * @param data: 
 * @return  
 */
function createjsDOMenu()
{
	removejsDOMmenu();
	var menuSize = 150; 
    if(SYSTEMCONF.getLanguage() == "en")
    {
    	menuSize = 200;
    }  
    var cursorMenu1 = new jsDOMenu(menuSize); 
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryPG"],"",queryPG,null));      	
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["querySwitchStatus"],"",queryPG,true));
    setPopUpMenu(cursorMenu1);
}

 /**
 *           
 * @param data: 
 * @return  
 */
function popupMenuHandler(evt)
{
  	if(!evt)
  	{
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null && elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		  return;
	}  
	
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
    if(rows.contains(rowid))
    {
    	createFuncPopupMenu(rows,evt);    	
    }    
}

/**
 *      ,      ,           ,        
 */
function setCreateBtnStatus()
{
	if(ringPGTable.getDataRowLength()>0)
	{
		$("createBtn").disabled = true;
	}
}

 /**
 *           
 * @param data: 
 * @return  
 */
function createFuncPopupMenu(rows,evt)
{
     removejsDOMmenu(); 
     var menuSize = 150; 
     var cursorMenu1 = new jsDOMenu(menuSize); 

     cursorMenu1.addMenuItem(new menuItem(RESOURCE["QUERYSW"],"",queryPG,null));
     cursorMenu1.addMenuItem(new menuItem('-'));
	 cursorMenu1.addMenuItem(new menuItem(RESOURCE["CLEAN_FORCE_SW"],"",switchRingMsp,[CLEAN_FORCE_SW]));
	 cursorMenu1.addMenuItem(new menuItem(RESOURCE["CLEAN_MANUAL_SW"],"",switchRingMsp,[CLEAN_MANUAL_SW]));
	 cursorMenu1.addMenuItem(new menuItem(RESOURCE["CLEAN_EXERCISE_SW"],"",switchRingMsp,[CLEAN_EXERCISE_SW]));
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["LOCKED"],"",switchRingMsp,[LOCKED]));
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["UNLOCKED"],"",switchRingMsp,[UNLOCKED]));     		
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["FORCE_SW"],"",switchRingMsp,[FORCE_SW]));
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["MANUAL_SW"],"",switchRingMsp,[MANUAL_SW]));
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["EXERCISE_SW"],"",switchRingMsp,[EXERCISE_SW]));
     
     setPopUpMenu(cursorMenu1);
     showMenu(evt);
}

function setBtnStatus(disabledState,btnIDArr)
{
	
	if(null == btnIDArr || btnIDArr.length == 0)
	{	
		btnIDArr = [];		
		btnIDArr.push("startBtn");
		btnIDArr.push("endBtn");
		btnIDArr.push("createBtn");
		btnIDArr.push("queryBtn");
		btnIDArr.push("applyBtn");
		btnIDArr.push("delBtn");
	}
	
	for(var i = 0; i < btnIDArr.length; i++)
	{
		$(btnIDArr[i]).disabled = disabledState;			
	}	
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data,errArr)
{
	if(null == errArr)
	{
		errArr = [];//           
		errArr[0] = "groupid";//           
	
		var temp;
		for(var i = 0, len = data.getBErrLength(); i < len; i++)
		{	
			temp = data.getError().rowErrors[i].errorObj["groupid"];
			if(null == temp)
			{
				temp = data.getError().rowErrors[i].errorObj["groupID"];
			}
			data.getError().rowErrors[i].errorObj["groupid"] = RESOURCE["RING_MSP_ID"]+ temp;
		}		
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = "/";
		}		
		return resValue;
	}
}

 /**
 *               
 * @param data: 
 * @return  
 */
window.onresize=function()
{
	 var totalHeight = getComponetHeight($("tablecomponent"),200);
	 ringPGTable.setBodyHeight(totalHeight*0.6+"px");
	 boardMapTable.setBodyHeight(totalHeight*0.38+"px");
}

function removeAviaPort(slotid,port)
{
	for(var i = aviablePort.length-1; i >=0; i--)
	{
		if(aviablePort[i].slotid == slotid && aviablePort[i].port == port)
		{
			aviablePort.removeAt(i);
		}
	}	
}

Array.prototype.containsPort = function(portObj)
{
	for(var i = 0, len = this.length; i < len; i++)
	{
		if(this[i].equals(portObj))
		{
			return true;
		}
	}
	return false;
}

Array.prototype.removePort = function(groupid)
{
	for(var i = this.length-1; i >=0; i--)
	{
		if(this[i].groupid == groupid)
		{
			this.removeAt(i);
		}
	}
}

function TEPort(slotid,boardname,port,portname,groupid)
{
	this.slotid = slotid;
	this.boardname = boardname;	
	this.port = port;
	this.portname = portname;
	this.groupid = groupid;
}

TEPort.prototype.equals = function(otherPort)
{	
	if(this.slotid == otherPort.slotid && this.port == otherPort.port)
	{
		return true;
	}
	return false;
}

TEPort.prototype.compare = function(otherPort)
{	
	if(this.slotid > otherPort.slotid)
	{
		return 1;
	}
	else if(this.slotid < otherPort.slotid)
	{
		return -1;
	}
	else
	{
		if(this.port > otherPort.port)
		{
			return 1;
		}
		else if(this.port <= otherPort.port)
		{
			return -1;
		}
	}
}

TEPort.prototype.toString = function()
{	
	var str = this.slotid + "-" + this.boardname + "-" + this.portname;
	return str;
}
