loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../../../../res/commonres_" + language +".xml");
getResourse("../../res/reportform/boardreport_" + language +".xml");

var nebdAttr = new Array();
nebdAttr[0] = "boardoutposition";
nebdAttr[1] = "boardinposition";

var st = new SortTable();

function init()
{
    var Tab = new Tabs();
    Tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    Tab.addTab("bdinfoform", RESOURCE["boardreport"], "boardinforeport.html");
    Tab.addTab("soltinfoform",RESOURCE["slotreport"],"slotinforeport.html");
    Tab.selectTab("bdinfoform");
    document.body.appendChild(Tab.getTabs());
}


function initInfoPage(isBoardInfopage)
{
	setBtnValue();
	initTableHead(isBoardInfopage);
	
	if(isBoardInfopage)
	{
        refreshBdInfoTbl();	
	}
	else
	{
        refreshSlotIfoTbl();	    
	} 
}

function initTableHead(isBoardInfopage)
{
    if(isBoardInfopage)
	{
        loadXMLdoc("../../conf/reportform/boardinfotable_" + language + ".xml", "GET", false, EncapsulateTable, null);
    }
    else
    {
        loadXMLdoc("../../conf/reportform/slotinfotable_" + language + ".xml", "GET", false, EncapsulateTable, null);
    }
    st.setImage("../../../../images/");
    st.setBodyHeight(360);
    createTableHead(st, window.tableconf[0]);
    if(isBoardInfopage)
    {
        document.body.insertBefore(st.getTable(), document.getElementById("boardBtnDiv"));
    }
    else
    {
        document.body.insertBefore(st.getTable(), document.getElementById("slotBtnDiv"));
    }   
}

function setBtnValue()
{
    document.getElementById("queryBtn").value = RESOURCE["querybutton"];
    document.getElementById("printBtn").value = RESOURCE["printbutton"];
    document.getElementById("saveAsFileBtn").value = RESOURCE["savefile"];
    if(document.getElementById("statisticBtn"))
    {
        document.getElementById("statisticBtn").value = RESOURCE["statistic"];
    }
    
}

function createQueryXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neID");
    thirdlevel.setAttribute("value",getNeProperty(top)["neid"]);
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    var xml = root.toString();
    return xml;
}

function clearTblData()
{
    var tbllen = st.getDataRowLength();
    for(var i = 0; i < tbllen; i++)
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();
}

function refreshTblData(doc)
{
    var diObj = EncapsulateData(doc);
    handleErrCode(diObj);
    clearTblData();
    createTableBody(st, window.tableconf[0], diObj, RESOURCE);
    document.getElementById("queryBtn").disabled = false;
    adjestOrder();//             
}

function adjestOrder()
{

    for(var i = 0, stlen = st.getDataRowLength(); i < stlen; i++)
    {
        st.setCellValue(st.getCell(i, "serialNum"), "serialNum", i+1);
    }

}

function handleErrCode(diObj)
{
    var errArr = [];
    errArr[0] = "neID";
    errArr[1] = "slotID";
    openErrPage("../../../../page/", diObj.getError(), errArr);
    errArr = null;	
}


function refreshBdInfoTbl()
{
    var sendurl = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_BD_VER+"&flag=1";
    var xml = createQueryXML();
    loadXMLdoc(sendurl, "POST", false, refreshTblData, null, "inputdata="+xml);
}


function refreshSlotIfoTbl()
{
    var sendurl = "../../../../neExlorerServlet?sfid="+TECMDCODE_GETNESLOTINFO+"&flag=1";
    var xml = createQueryXML();
    loadXMLdoc(sendurl, "POST", false, refreshTblData, null, "inputdata="+xml);
}

function countBoardNum()
{
    var boardNum = st.getDataRowLength();//          
    var logicBdNum = 0;//        
    var physicBdNum = 0;//        
    var boardNotFixedNum = 0;//         
    var BOARD_OUT_OPSITION = 0;
    
    if(boardNum > 0)
    {
        for(var i = 0; i < boardNum; i++)
        {
            if("" != st.getCellCurrentValue(i, "neLogicBd", "neLogicBd"))
            {
                logicBdNum++;
            }
            if("" != st.getCellCurrentValue(i, "nePhysicsBd", "nePhysicsBd"))
            {
                physicBdNum++;
            }
            if(BOARD_OUT_OPSITION = st.getCellStoreValue(i, "nebdAttr", "nebdAttr"))
            {
                boardNotFixedNum++;
            }
        }
    }
    
    sendurl = "bdCountPage.html?logicBdNum=" + logicBdNum + "&physicBdNum=" + physicBdNum + "&boardNotFixedNum=" + boardNotFixedNum;
    window.open(sendurl,"bdCountPage");
}
