var WEST_LINE = 1;
var EAST_LINE = 0;
var winobj = getNeProperty(self);
var parentWin = getParentWindow();
var westLineList = []; 
var eastLineList = []; 
var newREGConfigDataXML; 
var sdEnable = [];
sdEnable[0] = "Disabled"; //  
sdEnable[1] = "Enabled"; //  
var mapdirection =[]
mapdirection[0] = "eastLine";
mapdirection[1] = "westLine";


loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);

getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");

getResourse("../../res/regconfig/regconfig_"+SYSTEMCONF.getLanguage()+".xml");

document.title = RESOURCE["createREGTitle"];

function initBody()
{
	$("boardMapTableTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
	$("selectMapDirectTitle").appendChild(document.createTextNode(RESOURCE["selectMapDirectTitle"]));
	$("selectMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectMapBoardTitle"]));
	$("selectedMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectedMapBoardTitle"]));

	$("okBtn").value = RESOURCE["okbutton"];
    $("cancleBtn").value = RESOURCE["cancelbutton"]; 
	$("applyBtn").value = RESOURCE["applybutton"];
	$("selectMapDirect").options[0] = new Option(RESOURCE["eastLine"],EAST_LINE);
	$("selectMapDirect").options[1] = new Option(RESOURCE["westLine"],WEST_LINE);


	initTable();
	initBoardMap();
}

function initTable()
{
	regTable = new CTable();
	regTable.addHead(RESOURCE["attrCol"],RESOURCE["valueCol"]);

	var cTableAtom = null;
	var cTableAtomEle = null;

    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Enabled"],1);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Disabled"],0);  
    cTableAtomEle.onchange = setApplyEnabled;
    regTable.addAttrRow("sdEnable",RESOURCE["sdEnable"],cTableAtom); 
	$("regTableArea").appendChild(regTable.getTable()); 
}

function initBoardMap()
{
	clearSelectOptions($("availableport"));
	clearSelectOptions($("selectedport"));
	
	var availableportObj = $("availableport");


  for(var i = 0; i < parentWin.aviablePort.length; i++)
  {
  	var tmpPort = parentWin.aviablePort[i];
  	if(tmpPort.boardmap.indexOf("SL4")<0 && tmpPort.boardmap.indexOf("EFT")<0 && tmpPort.boardmap.indexOf("EMS")<0)
  	{
  	  insertSelectOption(availableportObj,tmpPort.slotid+":"+tmpPort.portid,tmpPort.boardmap);
  	}
  }
}
function setApplyEnabled()
{
	$("applyBtn").disabled = false;	;
}

function clearSelectOptions(selectObj)
{
	for(var i = selectObj.options.length; i >= 0; i--)
	{
		selectObj.remove(selectObj.options[i]);
	}
}	

function insertSelectOption(selectObj, insertValue, insertText)
{
	var option = new Option(insertText, getInsertIndex(selectObj,insertValue));	
	addOptionToSelect(selectObj, option);
	if(null == insertText)
	{
		insertText = insertValue;	
	}
	option.innerText = insertText;
	option.value = insertValue;	
}

function getInsertIndex(selectObj, insertValue)
{
	var optionObjArr = insertValue.split(":");
	var slotid = parseInt(optionObjArr[0]);
	var port = parseInt(optionObjArr[1]);
	
	var otherOptionObjArr
	var otherSlotid;
	var otherPort;
	for(var i = 0; i < selectObj.options.length; i++)
	{
		otherOptionObjArr = selectObj.options[i].value.split(":");
		otherSlotid = parseInt(otherOptionObjArr[0]);
		otherPort = parseInt(otherOptionObjArr[1]);
		if(slotid < otherSlotid)
		{
			return i;
		}		
		else if(slotid ==otherSlotid && port <= otherPort)	
		{
			return i;
		}
	}
	return selectObj.options.length;
}

function removeSelectListData(rightFlag)
{
	setApplyEnabled();
	
  var srcObj;
  var sinkObj;
  if(rightFlag)
  {
    srcObj = $("availableport");
  	sinkObj = $("selectedport");
  }
  else
  {
  	srcObj = $("selectedport");
  	sinkObj = $("availableport");
  }
  
  if(srcObj.selectedIndex == -1)
  {
  	alert(RESOURCE["SELECT_AVAILABLE_PORT"]);
  	return;
  }
  for(var i = 0; i < srcObj.options.length; i++)
  {
  	var showText = srcObj.options[i].innerText;
  	if(srcObj.options[i].selected)
  	{
  		if(rightFlag)
  		{
  			if($("selectMapDirect").value == WEST_LINE)
  			{
  				if(westLineList.length == 1)
  				{
  					alert(RESOURCE["ONLY_ONE_WESTLINE_EXIST"]);
  					break;
  				}
  				showText = RESOURCE["westLine"] + ":" + showText;
  				westLineList.push(srcObj.options[i].value);
  			}
  			else
  			{
  				if(eastLineList.length == 1)
  				{
  					alert(RESOURCE["ONLY_ONE_EASTLINE_EXIST"]);
  					break;
  				}
  				showText = RESOURCE["eastLine"] + ":" + showText;
  				eastLineList.push(srcObj.options[i].value);
  			}
  		}
  		else
  		{
  			var lineDirection = showText.substring(0,showText.indexOf(":"));
	    	showText = showText.substring(showText.indexOf(":")+1);
	   		if(lineDirection == RESOURCE["westLine"])
	   		{
	   			westLineList.remove(srcObj.options[i].value);
	   		}
    		else
	    	{
	    		eastLineList.remove(srcObj.options[i].value);
	   		}
  		}
  		insertSelectOption(sinkObj,srcObj.options[i].value,showText);	
  		srcObj.remove(i);
        i--;
  	}
  }
}


function doCreateREG(isApply)
{
	
	if($("applyBtn").disabled)
	{
		xcloseDialog();
	}

	if(parentWin.regPGTable.getDataRowLength() >= parentWin.MAX_REG_ID)
	{
		alert(RESOURCE["GOT_MAX_REG_NUM"]+parentWin.MAX_REG_ID);
		self.close();
	}

	if(westLineList.length == 0)
	{
		alert(RESOURCE["WESTLINR_NOT_EXIST"]);
		return;
	}
	else if(eastLineList.length == 0)
	{
		alert(RESOURCE["EASTLINR_NOT_EXIST"]);
		return;
	}

	$("okBtn").disabled = true;
    $("cancleBtn").disabled = true;
	$("applyBtn").disabled = true;

	var url = "../../../../neExlorerServlet?sfid="+Create_REG_Config+"&nmUser="+parentWin.winobj["nmUser"];		
	loadXMLdoc(url,"POST",true,callbackCreateREG,isApply,"inputdata="+createCreateREGXMLInfo());
}

function createCreateREGXMLInfo()
{
	newREGConfigDataXML = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
 
  param = new tagElement("param");
  param.setAttribute("name","neid");
  param.setAttribute("value",parentWin.winobj["neid"]);
  row.appendChild(param);

  param = new tagElement("param");
  param.setAttribute("name","regID");
  var regIDList = getRangeNumber(parentWin.usedPGID,parentWin.MIN_REG_ID,parentWin.MAX_REG_ID,1);
  param.setAttribute("value",regIDList[0]);
  row.appendChild(param);
  
  var eastLine = eastLineList[0].split(":");

  param = new tagElement("param");
  param.setAttribute("name","eastslotid");
  param.setAttribute("value",eastLine[0]);
  row.appendChild(param);

  param = new tagElement("param");
  param.setAttribute("name","eastportid");
  param.setAttribute("value",eastLine[1]);
  row.appendChild(param);

  var westLine = westLineList[0].split(":");

  param = new tagElement("param");
  param.setAttribute("name","westslotid");
  param.setAttribute("value",westLine[0]);
  row.appendChild(param);

  param = new tagElement("param");
  param.setAttribute("name","westportid");
  param.setAttribute("value",westLine[1]);
  row.appendChild(param);

  param = new tagElement("param");
  param.setAttribute("name","sdEnable");
  param.setAttribute("value",regTable.getAttrValue("sdEnable"));
  row.appendChild(param);

	bussiness.appendChild(row);
	newREGConfigDataXML.getRoot().appendChild(bussiness);
	return newREGConfigDataXML.toString();
}

function callbackCreateREG(doc,isApply)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	showOperResult(data);

	$("okBtn").disabled = false;
    $("cancleBtn").disabled = false;		

	if(0 == errorCode) 
	{	
		if(isApply)
		{
			westLineList = [];
			eastLineList = [];
		}				
	 	parentWin.queryREG(); 	
	 	clearSelectOptions($("selectedport"));
	 	
	 	if(!isApply)
		{
			xcloseDialog();
		}
		
	}
	else 
	{
		$("applyBtn").disabled = false;	
	}	
}


function showOperResult(data)
{
	var errArr = [];
	errArr[0] = "nename";	

	openErrPage("../../../../page/",data.getError(),errArr);
}
