var winurlobj = getNeProperty(self);

var hasApplyRight = true;

var boardType = winurlobj["boardType"];

var TND1IFE2 = "1404";
var TND1ODU = "1405";
var TND1FAN = "1409";
var TNC1CXPA = "1410";
var TNC1CXPB = "1411";
var TNC1CXPG = "1607";
var TNC1CXPH = "1608";
var TND1CXP = "1412";
var TND1AUXQ = "1413";
var TND1EF8T = "1414";
var TND1EF8F = "1415";
var TND1EG2 = "1416";
var TND1ML1 = "1417";
var TND1ML1A = "1418";
var TND1CD1 = "1624";
var SL91AUX = "2085";
var SLA1AUX = "2086";
var SLD1AUX = "2472";


var SL71EOW = "1216";
var SLB1CSHN = "2263";
var CSH = "2077";
var SL91MD1 = "2273";
var SL92ML1 = "2274";
var SL91ISU2 = "2266";
var SL91ISX2 = "2267";
var TNH1EFP8 = "2102";
var SLA1EM4T = "2087";
var SLA1CSHA = "2090";
var SL91EM6FA = "2417";
var SL91EM6TA = "2418";
var SL91EMS6 = "2439";
var SL91EM6T = "2082";
var SL91EM6F = "2083";
var SL91IFU2 = "2079";
var SL91IFX2 = "2080";
var SL91IF1  = "2081";
var CX67FCBA = "2407";
var SLF1CSHO  = "2546";
var SLA1CSHC  = "2092";

var MIN_TEMP_HIGH = "60.0";
var MAX_TEMP_HIGH = "70.0";
var MIN_TEMP_LOW = "0.0";
var MAX_TEMP_LOW = "10.0";
var DEFAULT_TEMP_HIGH = "65.0";
var DEFAULT_TEMP_LOW = "0.0";


var TEMP_UPLIMIT_LEFT;
var TEMP_UPLIMIT_RIGHT;
var TEMP_UPLIMIT_DEFAULT;

var TEMP_DOWNLIMIT_LEFT;
var TEMP_DOWNLIMIT_RIGHT;
var TEMP_DOWNLIMIT_DEFAULT;

var attrArray = new Array("", "ENVCTRL_PMU_UPLIMIT", "ENVCTRL_PMU_DOWNLIMIT", "ENVCTRL_PMU_HIGHTEMPERTHOFPILE", "ENVCTRL_PMU_LOWTEMPERTHOFPILE", "ENVCTRL_TCU_TEMPERUPLIMIT", "ENVCTRL_TCU_TEMPERDOWNLIMIT", "ENVCTRL_PMU_ACALARMDOWNLIMIT", "ENVCTRL_PMU_ACALARMUPLIMIT", "ENVCTRL_PMU_DCALARMUPLIMIT", "ENVCTRL_PMU_DCALARMDOWNLIMIT", "ENVCTRL_PMU_AVGVL", "ENVCTRL_PMU_CHGVL", "ENVCTRL_PMU_VOLOFLOADFALLELEC", "ENVCTRL_PMU_VOLOFPILEFALLELEC", "ENVCTRL_PMU_TMPOFPILE");

function initpage()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    var isAUXSp = SpecialAttrMgr.isCPSupportByType(winurlobj.neid, winurlobj.boardType,"TE_FUNC_CFG_PWR_INTERFACE", "SDH_ATTR_SUPPORT_ENV_AUX_ALARMMODE");
    if (winurlobj.boardType == SL91AUX || winurlobj.boardType == SLA1AUX || winurlobj.boardType == SLD1AUX || isAUXSp) 
    {
        alarmLevel = [];
        alarmLevel[0] = RESOURCE["emerAlarm"];
        alarmLevel[1] = RESOURCE["majorAlarm"];
        alarmLevel[2] = RESOURCE["notmajorAlarm"];
        alarmLevel[3] = RESOURCE["ignoreAlarm"];
    }

    if(winurlobj.neType == "54" || winurlobj.neType == "55" || winurlobj.neType == "60" || isRTNNE)
    {
		alarmMode[0] = RESOURCE["inTurnOn"];
		alarmMode[1] = RESOURCE["inTurnOff"];
		
		intputAlarmMode[0] = RESOURCE["inTurnOn"];
		intputAlarmMode[1] = RESOURCE["inTurnOff"];
    }

    st = new SortTable();
    st.setImage("../../../../images/");
    tc = window.tableconf[0];
    var supportAttr = winurlobj["supportAttr"].split(",");
    
    filterAttrCol(tc, supportAttr,["slotid"],window.parent.genCfgAttrList);
    
    if (tc.getIndexByid("ENVCTRL_COM_ALARMCSK_ALARMLEVEL") != -1)//      
    {
        tc.colArray.removeAt(0);
    }
    
    createTableHead(st, window.tableconf[0]);
    
    st.setOnCellEditHandler(cellEditHandler);
    st.setCellEditRangeFunc(gencfgEditRangeFunc);
    $("table").appendChild(st.getTable());
    
    $("table").oncontextmenu = popupMenuHandler;
    
    sendRightInfo();
    
    st.setBodyHeight(getComponetHeight($("table"), 80) + "px");
    
    window.onresize = function()
    {
        st.setBodyHeight(getComponetHeight($("table"), 80) + "px");
    }
    
    if (!$("querybtn").disabled) 
    {
        sendQueryInfo();
    }
}

/**
 *       
 * 
 * @param  
 * @return  
 */
function sendRightInfo()
{
    var url = "../../../../securityServlet?neID=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

/**
 *           XML
 * 
 * @param  
 * @return  
 */
function createRightXML()
{
    var root = new inputxml("datainterface");// Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = null;
    var thirdlevel = null;
    
    secondlevel = new tagElement("row-params"); // bean         
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "btnID");
    thirdlevel.setAttribute("value", "querybtn");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "sfid");
    thirdlevel.setAttribute("value", TECMDCODE_GET_PMUATTRIB);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    
    
    secondlevel = new tagElement("row-params"); // bean         
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "btnID");
    thirdlevel.setAttribute("value", "applybtn");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "sfid");
    thirdlevel.setAttribute("value", TECMDCODE_SET_PMUATTRIB);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
}

/**
 *           
 * 
 * @param  
 * @return  
 */
function rightHandleBack(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getDataRowLength(); i++) //        
     {
        var right = data.getDataRowParam(i, "right");
        
        if (0 == right) 
        {
            if (data.getDataRowParam(i, "btnID") == "applybtn") 
            {
                hasApplyRight = false;
            }
            
            $(data.getDataRowParam(i, "btnID")).disabled = true;
        }
        else 
        {
            $(data.getDataRowParam(i, "btnID")).disabled = false;
        }
    }
}

function sendQueryInfo()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    

    var neid = winurlobj.neid;
    var slotid = winurlobj.slotid;
    var xmlstr = createQueryXML(neid, slotid, tc);
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PMUATTRIB + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, queryCallBack, null, "inputdata=" + xmlstr);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() == 2) 
    {
        showErrorDialog(data);
        return;
    }
    
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        diobj = data.rows[i];
        
        if (null != diobj["ENVCTRL_COM_TEMPERUPLIMIT"] && "/" != diobj["ENVCTRL_COM_TEMPERUPLIMIT"].value) 
        {
            key = "ENVCTRL_COM_TEMPERUPLIMIT";
            addDot(diobj, key);
        }
        
        if (null != diobj["ENVCTRL_COM_TEMPERDOWNLIMIT"] && "/" != diobj["ENVCTRL_COM_TEMPERDOWNLIMIT"].value) 
        {
            key = "ENVCTRL_COM_TEMPERDOWNLIMIT";
            addDot(diobj, key);
        }
        
        if (null != diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_LEFT"] && "/" != diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_LEFT"].value) 
        {
            key = "ENVCTRL_COM_TEMPER_DOWNLIMIT_LEFT";
            addDot(diobj, key);
            TEMP_DOWNLIMIT_LEFT = diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_LEFT"].value;
        }       
        if (null != diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_RIGHT"] && "/" != diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_RIGHT"].value) 
        {
            key = "ENVCTRL_COM_TEMPER_DOWNLIMIT_RIGHT";
            addDot(diobj, key);
            TEMP_DOWNLIMIT_RIGHT = diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_RIGHT"].value;
        }        
        if (null != diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_DEFAULT"] && "/" != diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_DEFAULT"].value) 
        {
            key = "ENVCTRL_COM_TEMPER_DOWNLIMIT_DEFAULT";
            addDot(diobj, key);
            TEMP_DOWNLIMIT_DEFAULT = diobj["ENVCTRL_COM_TEMPER_DOWNLIMIT_DEFAULT"].value;
        }
        
        if (null != diobj["ENVCTRL_COM_TEMPER_UPLIMIT_LEFT"] && "/" != diobj["ENVCTRL_COM_TEMPER_UPLIMIT_LEFT"].value) 
        {
            key = "ENVCTRL_COM_TEMPER_UPLIMIT_LEFT";
            addDot(diobj, key);
            TEMP_UPLIMIT_LEFT = diobj["ENVCTRL_COM_TEMPER_UPLIMIT_LEFT"].value;
        }        
        if (null != diobj["ENVCTRL_COM_TEMPER_UPLIMIT_RIGHT"] && "/" != diobj["ENVCTRL_COM_TEMPER_UPLIMIT_RIGHT"].value) 
        {
            key = "ENVCTRL_COM_TEMPER_UPLIMIT_RIGHT";
            addDot(diobj, key);
            TEMP_UPLIMIT_RIGHT = diobj["ENVCTRL_COM_TEMPER_UPLIMIT_RIGHT"].value;
        }        
        if (null != diobj["ENVCTRL_COM_TEMPER_UPLIMIT_DEFAULT"] && "/" != diobj["ENVCTRL_COM_TEMPER_UPLIMIT_DEFAULT"].value) 
        {
            key = "ENVCTRL_COM_TEMPER_UPLIMIT_DEFAULT";
            addDot(diobj, key);
            TEMP_UPLIMIT_DEFAULT = diobj["ENVCTRL_COM_TEMPER_UPLIMIT_DEFAULT"].value;
        }        
    }
    
    createGenCfgTableBody(st, tc, data, RESOURCE);
    /**
     *       
     *                
     */
    var td=st.element.headRow.element.cols["object"].element; 
    st.sortRows(td,"1");
    
    addSpecialProcess();
	
	addListener();

    
    if (data.getSErrorCode() == 0) 
    {
        return;
    }
    
    showErrorDialog(data);
    data = null;
    
}

function addSpecialProcess()
{
    var showCell;
    var editCell;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var almModeCell = st.getCell(i, 'ENVCTRL_COM_INPUTCSK_ALARMMODE');
        if (almModeCell) 
        {
            var status = st.getCellCurrentValue(i, "ENVCTRL_COM_INPUTCSK_USE", "ENVCTRL_COM_INPUTCSK_USE");
            showCell = st.getCellShow(i, 'ENVCTRL_COM_INPUTCSK_ALARMMODE');
            editCell = st.getCellEdit(i, 'ENVCTRL_COM_INPUTCSK_ALARMMODE');
            if (status == 0) 
            {
                st.setCellIsEdit(almModeCell, 0);
                showCell.element.innerText = '-';
            }
        }
        
        var routeNumCell = st.getCell(i, 'ENVCTRL_EMU_ALMRELAY_ROUTENUM');
        if (routeNumCell) 
        {
            if (SpecialAttrMgr.isCPSupportByType(winurlobj.neid, winurlobj.boardType,"TE_FUNC_CFG_PWR_INTERFACE", "SDH_ATTR_SUPPORT_ALMRELAY_ROUTENUM_EDIT")) 
            {
                st.setCellIsEdit(routeNumCell, 1);
            }
        }
        
        var inputName = st.getCellCurrentValue(i, "ENVCTRL_COM_INPUTCSK_NAME", "ENVCTRL_COM_INPUTCSK_NAME");
        if (inputName != null || inputName != undefined) 
        {
            if (inputName.trim() == '') 
            {
                showCell = st.getCellShow(i, 'ENVCTRL_COM_INPUTCSK_NAME');
                showCell.element.innerText = 'CSK-' + st.getCellCurrentValue(i, "object", "switch");
            }
        }
       
        var outputName = st.getCellCurrentValue(i, "ENVCTRL_EMU_OUTCSK_NAME", "ENVCTRL_EMU_OUTCSK_NAME");
        if (outputName != null || outputName != undefined) 
        {
            if (outputName.trim() == '') 
            {
                showCell = st.getCellShow(i, 'ENVCTRL_EMU_OUTCSK_NAME');
                showCell.element.innerText = 'OUT_CSK-' + st.getCellCurrentValue(i, "object", "switch");
            }
        }
        
        editCell = st.getCellEdit(i, "ENVCTRL_PMU_COEOFBAT");
        
        if (editCell) 
        {
            textCheck(editCell.element, "0.05", "0.25", 2);
        }
        
        editCell = st.getCellEdit(i, "ENVCTRL_TCU_SPEEDADJUSTMODE");
        
        if (editCell) 
        {
            editCell.element.onchange = function()
            {
                var index = st.getSelectedRows()[0];
                var adjMode = this.value;
                var adjModeCell = st.getCell(index, 'ENVCTRL_TCU_SPEEDADJUSTMODE');
                var infoCell1 = st.getCell(index, 'ENVCTRL_TCU_SPEEDADJUSTPARAM');
                var infoCell2 = st.getCell(index, 'ENVCTRL_TCU_INNER_DOWN_FANSPEED');
                var infoCell3 = st.getCell(index, 'ENVCTRL_TCU_OUTSIDE_DOWN_FANSPEED');
                
                switch (adjMode)
                {
                    case '0':
                        st.setCellIsEdit(infoCell1, "0");
                        st.setCellIsEdit(infoCell2, "0");
                        st.setCellIsEdit(infoCell3, "0");
                        infoCell1.element.modify = false;
                        infoCell2.element.modify = false;
                        infoCell3.element.modify = false;
                        infoCell1.element.showElement.element.innerText = '-';
                        infoCell2.element.showElement.element.innerText = '-';
                        infoCell3.element.showElement.element.innerText = '-';
                        break;
                    case '1':
                        st.setCellIsEdit(infoCell1, "1");
                        st.setCellIsEdit(infoCell2, "0");
                        st.setCellIsEdit(infoCell3, "0");
                        infoCell2.element.modify = false;
                        infoCell3.element.modify = false;
                        infoCell1.element.modify = true;
                        infoCell1.element.parentNode.modify = true;
                        infoCell1.element.style.backgroundColor = "#d0f946";
                        st.setCellValue(infoCell1, "ENVCTRL_TCU_SPEEDADJUSTPARAM", '0');
                        infoCell1.element.editElement.element.selectedIndex = 0;
                        infoCell1.element.showElement.element.innerText = infoCell1.element.editElement.element.options[0].innerText;
                        
                        infoCell2.element.showElement.element.innerText = '-';
                        infoCell3.element.showElement.element.innerText = '-';
                        break;
                    case '2':
                        st.setCellIsEdit(infoCell1, "0");
                        st.setCellIsEdit(infoCell2, "1");
                        st.setCellIsEdit(infoCell3, "1");
                        infoCell1.element.modify = false;
                        infoCell1.element.showElement.element.innerText = '-';
                        
                        st.setCellValue(infoCell2, "ENVCTRL_TCU_INNER_DOWN_FANSPEED", '100');
                        infoCell2.element.showElement.element.innerText = '100';
                        infoCell2.element.modify = true;
                        infoCell2.element.parentNode.modify = true;
                        infoCell2.element.style.backgroundColor = "#d0f946";
                        
                        st.setCellValue(infoCell3, "ENVCTRL_TCU_OUTSIDE_DOWN_FANSPEED", '100');
                        infoCell3.element.showElement.element.innerText = '100';
                        infoCell3.element.modify = true;
                        infoCell3.element.parentNode.modify = true;
                        infoCell3.element.style.backgroundColor = "#d0f946";
                        break;
                }
            }
        }
        
        /*
        **OMB-AC                                           
        **                                  254       OMB-AC     
        **               
        **/

        convertInvalidValue(st, i, 'ENVCTRL_PMU_LIMITSTATE');
        convertInvalidValue(st, i, 'ENVCTRL_PMU_CHGSTATE_BECTRL');
        convertInvalidValue(st, i, 'ENVCTRL_PMU_CHARGESTATE');
        convertInvalidValue(st, i, 'ENVCTRL_PMU_ELECSTATEOFBAT');
    }
}

function addDot(diobj, key)
{
    var len = diobj[key].value.length;
    var value = diobj[key].value;
    if (len > 1) 
    {
        if (len == 2 && value.charAt(0) == "-") 
        {
            value = "-0." + value.charAt(1);
        }
        else 
        {
            value = value.substring(0, len - 1) + "." + value.charAt(len - 1);
        }
    }
    else if (value != "0") 
    {
        value = "0." + value;
    }
    
    diobj[key].value = value;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    
    if (tc.getIndexByid("ENVCTRL_COM_INPUTCSK_USE") != -1)//      
    {
        errArr[3] = "switch";
        errArr[4] = "attrId";
    }
    else 
    {
        errArr[3] = "attrId";
    }
    
    var errorObj = null;
    for (var i = data.getBErrLength() - 1; i >= 0; i--) 
    {
        errorObj = data.getError().rowErrors[i].errorObj;
        if (errorObj["attrId"].toLowerCase() == "subcard" || errorObj["attrId"].toLowerCase() == "relaytype") 
        {
            data.getError().rowErrors.removeAt(i);
            continue;
        }
        errorObj["attrId"] = getAttrName(tc, data.getError().getRowKey(i, "attrId"));
    }
    openErrPage("../../../../page/", data.getError(), errArr);
}

function addListener()
{
    var workModeCell;
    var workModeValue;
    var cskidEdit;
    var alarmModeEdit;
    var alarmModeCell;
    var alarmModeShow;
    var ids = getIDs();
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (ids.contains("ENVCTRL_COM_TEMPERUPLIMIT")) 
        {
            tempUpLimitCell = st.getCell(i, "ENVCTRL_COM_TEMPERUPLIMIT");
            
            tempUpLimitCell.element.ondblclick = function()
            {
            	if(TEMP_UPLIMIT_DEFAULT != null && "" != TEMP_UPLIMIT_DEFAULT)
                 {            		
                    tempdbclick(this, TEMP_UPLIMIT_DEFAULT);
            	 }
            	else
            	{
            		var defaultTemp = getGencfgCellEditDefault(st,this.parentNode.rowIndex,"ENVCTRL_COM_TEMPERUPLIMIT",DEFAULT_TEMP_HIGH);
                    tempdbclick(this, defaultTemp);
            	}
            	
            
            }

            tempUpLimit = st.getCellEdit(i, "ENVCTRL_COM_TEMPERUPLIMIT");
            if(TEMP_UPLIMIT_LEFT != null && "" != TEMP_UPLIMIT_LEFT)
            {      
            	
            	 textCheck(tempUpLimit.element, TEMP_UPLIMIT_LEFT, TEMP_UPLIMIT_RIGHT);
             }
            else
            {
            	   textCheck(tempUpLimit.element, MIN_TEMP_HIGH, MAX_TEMP_HIGH);
                   if(boardType == SL91EMS6)
                   {
                   	textCheck(tempUpLimit.element,"60.0","80.0");
                   }
                   else if(boardType == SLF1CSHO)
                   {
                   	textCheck(tempUpLimit.element,"60.0","87.0");
                   }
                   else if(boardType == SLA1CSHC)
                   {
                   	textCheck(tempUpLimit.element,"60.0","76.0");
                   }
             }        
            
        }
        
        if (ids.contains("ENVCTRL_COM_TEMPERDOWNLIMIT")) 
        {
            tempDownLimitCell = st.getCell(i, "ENVCTRL_COM_TEMPERDOWNLIMIT");
            tempDownLimitCell.element.style.imeMode = "disabled";
            tempDownLimitCell.element.ondblclick = function()
            {
            	if(TEMP_DOWNLIMIT_DEFAULT != null && "" != TEMP_DOWNLIMIT_DEFAULT)
                 {            		
                       tempdbclick(this, TEMP_DOWNLIMIT_DEFAULT);
                 }
                 else
                {
                	 var defaultTemp = getGencfgCellEditDefault(st,this.parentNode.rowIndex,"ENVCTRL_COM_TEMPERDOWNLIMIT",DEFAULT_TEMP_LOW);
                     tempdbclick(this, defaultTemp);
                }
            	
            }
            
            tempDownLimit = st.getCellEdit(i, "ENVCTRL_COM_TEMPERDOWNLIMIT");
            if(TEMP_DOWNLIMIT_LEFT != null && "" != TEMP_DOWNLIMIT_LEFT)
            { 
	          	textCheck(tempDownLimit.element, TEMP_DOWNLIMIT_LEFT, TEMP_DOWNLIMIT_RIGHT);
            }
	        else
	        { 
	            textCheck(tempDownLimit.element, MIN_TEMP_LOW, MAX_TEMP_LOW);
	            if(boardType == SL91EMS6)
	            {
	            	textCheck(tempDownLimit.element, "-5.0", "5.0");
	            }
	            else if(boardType == SLF1CSHO)
	            {
	            	textCheck(tempDownLimit.element,"-10.0","15.0");
	            }
	            else if(boardType == SLA1CSHC)
	            {
	            	textCheck(tempDownLimit.element,"-15.0","5.0");
	            }
	         }
        }
        if (ids.contains("ENVCTRL_COM_TEMPEMONITOR")) 
        {
            var tempMonitorCellEdit = st.getCellEdit(i, "ENVCTRL_COM_TEMPEMONITOR");
            var tempMonitorCell = st.getCell(i, "ENVCTRL_COM_TEMPEMONITOR");
            var tempMonitorValue = st.getCellStoreValue(i, "ENVCTRL_COM_TEMPEMONITOR", "ENVCTRL_COM_TEMPEMONITOR");
            
            st.setCellIsEdit(tempMonitorCell, 1);
            if (tempMonitorValue == "0") 
            {
                var tempupCell = st.getCell(i, "ENVCTRL_COM_TEMPERUPLIMIT");
                
                var tempdownCell = st.getCell(i, "ENVCTRL_COM_TEMPERDOWNLIMIT");
                
                st.setCellValue(tempupCell, "ENVCTRL_COM_TEMPERUPLIMIT", "3276.7");
                st.getCellShow(i, "ENVCTRL_COM_TEMPERUPLIMIT").setValue("-");
                
                st.setCellIsEdit(tempupCell, 0);
                tempupCell.element.ondblclick = null;
                tempupCell.element.style.backgroundColor = "";
                
                st.setCellValue(tempdownCell, "ENVCTRL_COM_TEMPERDOWNLIMIT", "3276.7");
                st.getCellShow(i, "ENVCTRL_COM_TEMPERDOWNLIMIT").setValue("-");
                
                st.setCellIsEdit(tempdownCell, 0);
                tempdownCell.element.ondblclick = null;
                tempdownCell.element.style.backgroundColor = "";
            }
            
            tempMonitorCell.element.ondblclick = function()
            {
                var index = this.parentNode.rowIndex;
                var upCell = st.getCell(index, "ENVCTRL_COM_TEMPERUPLIMIT");
                var downCell = st.getCell(index, "ENVCTRL_COM_TEMPERDOWNLIMIT");
                
                var tempValue = st.getCellStoreValue(index, "ENVCTRL_COM_TEMPEMONITOR", "ENVCTRL_COM_TEMPEMONITOR");
                upCell.element.modify = true;
                downCell.element.modify = true;
                
                if (tempValue == 0) 
                {
                    st.setCellValue(upCell, "ENVCTRL_COM_TEMPERUPLIMIT", "3276.7");
                    st.setCellValue(downCell, "ENVCTRL_COM_TEMPERDOWNLIMIT", "3276.7");
                }
                tempdbclick(this, tempValue);
            }
            
            tempMonitorCellEdit.element.onchange = function()
            {
                var index = this.parentNode.parentNode.rowIndex;
                var tempupCell = st.getCell(index, "ENVCTRL_COM_TEMPERUPLIMIT");
                var tempupEdit = st.getCellEdit(index, "ENVCTRL_COM_TEMPERUPLIMIT");
                var tempupShow = st.getCellShow(index, "ENVCTRL_COM_TEMPERUPLIMIT");
                
                var tempdownCell = st.getCell(index, "ENVCTRL_COM_TEMPERDOWNLIMIT");
                var tempdownEdit = st.getCellEdit(index, "ENVCTRL_COM_TEMPERDOWNLIMIT");
                var tempdownShow = st.getCellShow(index, "ENVCTRL_COM_TEMPERDOWNLIMIT");
                
                if (this.value == "0")//    
                {
                    st.setCellValue(tempupCell, "ENVCTRL_COM_TEMPERUPLIMIT", "3276.7");
                    tempupShow.setValue("-");
                    
                    st.setCellIsEdit(tempupCell, 0);
                    tempupCell.element.ondblclick = null;
                    tempupCell.element.modify = true;
                    tempupCell.element.style.backgroundColor = "";
                    
                    st.setCellValue(tempdownCell, "ENVCTRL_COM_TEMPERDOWNLIMIT", "3276.7");
                    tempdownShow.setValue("-");
                    
                    st.setCellIsEdit(tempdownCell, 0);
                    tempdownCell.element.ondblclick = null;
                    tempdownCell.element.modify = true;
                    tempdownCell.element.style.backgroundColor = "";
                }
                else 
                {
                	var defaultTemp = getGencfgCellEditDefault(st,tempupCell.element.parentNode.rowIndex,"ENVCTRL_COM_TEMPERUPLIMIT",DEFAULT_TEMP_HIGH);
                    st.setCellValue(tempupCell, "ENVCTRL_COM_TEMPERUPLIMIT", defaultTemp)//      
                    tempupShow.setValue(defaultTemp);
                    if(boardType == SL91EMS6)
                    {
                    	st.setCellValue(tempupCell, "ENVCTRL_COM_TEMPERUPLIMIT", "70.0");
                    	tempupShow.setValue("70.0");
                    }
                    
                    if(TEMP_UPLIMIT_DEFAULT != null && "" != TEMP_UPLIMIT_DEFAULT)
                    {            		
                    	  st.setCellValue(tempupCell, "ENVCTRL_COM_TEMPERUPLIMIT", TEMP_UPLIMIT_DEFAULT)//      
                    	  tempupShow.setValue(TEMP_UPLIMIT_DEFAULT);
                    }                 
                    tempupCell.element.modify = true;                   
                    
                     if(TEMP_DOWNLIMIT_DEFAULT != null && "" != TEMP_DOWNLIMIT_DEFAULT)
                     {            		
                    	  defaultTemp = TEMP_DOWNLIMIT_DEFAULT;
                   	 }
                   	else
                   	{
                   	   defaultTemp = getGencfgCellEditDefault(st,tempdownCell.element.parentNode.rowIndex,"ENVCTRL_COM_TEMPERDOWNLIMIT",DEFAULT_TEMP_LOW);                         
                   	}                  
                    st.setCellValue(tempdownCell, "ENVCTRL_COM_TEMPERDOWNLIMIT", defaultTemp)//      
                    tempdownShow.setValue(defaultTemp);
                    tempdownCell.element.modify = true;
                    
                    st.setCellIsEdit(tempupCell, 1);
                    tempupCell.element.ondblclick = cellondbclick;
                    tempupCell.element.style.backgroundColor = "#ffffff";
                    
                    st.setCellIsEdit(tempdownCell, 1);
                    tempdownCell.element.ondblclick = cellondbclick;
                    tempdownCell.element.style.backgroundColor = "#ffffff";
                }
            }
            
        }
        
        if(SpecialAttrMgr.isCPSupportByType(winurlobj["neid"], boardType, "TE_FUNC_CFG_PWR_INTERFACE", "ENVCTRL_COM_TEMPERLIMIT_READONLY"))//TRANSV1R9C10-2672:OSN1800II  PL3T/PL3D                  
	{
        	var tempupCell = st.getCell(i,"ENVCTRL_COM_TEMPERUPLIMIT");
			var tempdownCell = st.getCell(i,"ENVCTRL_COM_TEMPERDOWNLIMIT");
				
			if(tempupCell != null)
			{
				st.setCellIsEdit(tempupCell,0);
			}
			if(tempupCell != null)
			{
				st.setCellIsEdit(tempdownCell,0);
			}
        }
        
        if (ids.contains("ENVCTRL_PMU_CSKCTRLSWMODE")) 
        {
            ctrlModecell = st.getCellEdit(i, "ENVCTRL_PMU_CSKCTRLSWMODE");
            
            ctrlModecell.element.onchange = function()
            {
                var index = this.parentNode.parentNode.rowIndex;
                var majorAlarmStatus = st.getCell(index, "ENVCTRL_PMU_K0STATE");
				var k0Value = parseInt(st.getCellCurrentValue(index, "ENVCTRL_PMU_K0STATE", "ENVCTRL_PMU_K0STATE"));
                var criticalAlarmStatus = st.getCell(index, "ENVCTRL_PMU_K1STATE");
				var k1Value = parseInt(st.getCellCurrentValue(index, "ENVCTRL_PMU_K1STATE", "ENVCTRL_PMU_K1STATE"));
                
                if (this.value == "0") 
                {
                    st.setCellValue(majorAlarmStatus, "ENVCTRL_PMU_K0STATE", k0Value == 255 ? "255" : "0");
                    st.setAtomValue(majorAlarmStatus.element.showElement, k0Value == 255 ? "-" : RESOURCE["closed"]);
					
                    st.setCellValue(criticalAlarmStatus, "ENVCTRL_PMU_K1STATE", k1Value == 255 ? "255" : "0");
                    st.setAtomValue(criticalAlarmStatus.element.showElement, k1Value == 255 ? "-" : RESOURCE["closed"]);
                    
                    st.setCellIsEdit(criticalAlarmStatus, 0);
                    st.setCellIsEdit(majorAlarmStatus, 0);
                }
                else 
                {
                    st.setCellIsEdit(majorAlarmStatus, k0Value != 255 ? 1 : 0);
                    st.setCellIsEdit(criticalAlarmStatus, k1Value != 255 ? 1 : 0);
                }
            }
            
            ctrlModeValue = st.getCellStoreValue(i, "ENVCTRL_PMU_CSKCTRLSWMODE", "ENVCTRL_PMU_CSKCTRLSWMODE");
            var majorAlarmStatus = st.getCellElement(i, "ENVCTRL_PMU_K0STATE");
            var criticalAlarmStatus = st.getCellElement(i, "ENVCTRL_PMU_K1STATE");
            
            if (ctrlModeValue == "0") 
            {
                st.setCellIsEdit(majorAlarmStatus, 0);
                st.setCellIsEdit(criticalAlarmStatus, 0);
            }
			
			var kValue = parseInt(st.getCellCurrentValue(i, "ENVCTRL_PMU_K0STATE", "ENVCTRL_PMU_K0STATE"));
			if (kValue == 255)
			{
				st.getCellShow(i, "ENVCTRL_PMU_K0STATE").element.innerHTML = "-";
				st.setCellIsEdit(majorAlarmStatus, 0);
			}
			kValue = parseInt(st.getCellCurrentValue(i, "ENVCTRL_PMU_K1STATE", "ENVCTRL_PMU_K1STATE"));
			if (kValue == 255)
			{
				st.getCellShow(i, "ENVCTRL_PMU_K1STATE").element.innerHTML = "-";
				st.setCellIsEdit(criticalAlarmStatus, 0);
			}
        }
        
        if (ids.contains("ENVCTRL_EMU_OUTCSK_WORKMODE")) 
        {
            workModeCell = st.getCellEdit(i, "ENVCTRL_EMU_OUTCSK_WORKMODE");
            
            workModeValue = st.getCellStoreValue(i, "ENVCTRL_EMU_OUTCSK_WORKMODE", "ENVCTRL_EMU_OUTCSK_WORKMODE");
            
            cskidEdit = st.getCellEdit(i, "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID");//       
            alarmModeEdit = st.getCellEdit(i, "ENVCTRL_EMU_OUTCSK_ALARMMODE");//     
            alarmModeCell = st.getCell(i, "ENVCTRL_EMU_OUTCSK_ALARMMODE");
            alarmModeShow = st.getCellShow(i, "ENVCTRL_EMU_OUTCSK_ALARMMODE");
            
            if (workModeValue == "0")//          
            {
                cskidEdit.clearOptions();
                cskidEdit.addOption(alarmConditions[22], "22");
                cskidEdit.addOption(alarmConditions[23], "23");
                
                alarmModeEdit.clearOptions();
                alarmModeEdit.addOption(alarmMode[0], "0");
            }
            else//            
             {
                cskidEdit.clearOptions();
                cskidEdit.addOption(alarmConditions[1], "1");
                cskidEdit.addOption(alarmConditions[2], "2");
                cskidEdit.addOption(alarmConditions[3], "3");
                if (winurlobj.boardType != SL71EOW) 
                {
                    cskidEdit.addOption(alarmConditions[4], "4");
                    cskidEdit.addOption(alarmConditions[5], "5");
                    cskidEdit.addOption(alarmConditions[6], "6");
                }
                cskidEdit.addOption(alarmConditions[19], "19");
                cskidEdit.addOption(alarmConditions[20], "20");
                cskidEdit.addOption(alarmConditions[21], "21");
                
                alarmModeEdit.clearOptions();
                alarmModeEdit.addOption(alarmMode[0], "0");
                alarmModeEdit.addOption(alarmMode[1], "1");
            }
            
            workModeCell.element.onchange = function()
            {
                var index = this.parentNode.parentNode.rowIndex;
                
                var cskidCell = st.getCell(index, "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID");//       
                var cskidEdit = st.getCellEdit(index, "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID");
                var cskidShow = st.getCellShow(index, "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID");
                
                var alarmModeEdit = st.getCellEdit(index, "ENVCTRL_EMU_OUTCSK_ALARMMODE");//     
                var alarmModeCell = st.getCell(index, "ENVCTRL_EMU_OUTCSK_ALARMMODE");
                var alarmModeShow = st.getCellShow(index, "ENVCTRL_EMU_OUTCSK_ALARMMODE");
                
                var value = st.getCellStoreValue(index, "ENVCTRL_EMU_OUTCSK_WORKMODE", "ENVCTRL_EMU_OUTCSK_WORKMODE");
                
                if (this.value == "1")//     
                {
                
                    cskidEdit.clearOptions();
                    cskidEdit.addOption(alarmConditions[1], "1");
                    cskidEdit.addOption(alarmConditions[2], "2");
                    cskidEdit.addOption(alarmConditions[3], "3");
                    if (winurlobj.boardType != SL71EOW) 
                    {
                        cskidEdit.addOption(alarmConditions[4], "4");
                        cskidEdit.addOption(alarmConditions[5], "5");
                        cskidEdit.addOption(alarmConditions[6], "6");
                    }
                    cskidEdit.addOption(alarmConditions[19], "19");
                    cskidEdit.addOption(alarmConditions[20], "20");
                    cskidEdit.addOption(alarmConditions[21], "21");
                    
                    cskidShow.setValue(alarmConditions[21]);
                    st.setCellValue(cskidCell, "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID", "21");
                    cskidCell.element.style.backgroundColor = "#d0f946";
                    cskidCell.element.modify = true;
                    cskidCell.element.parentNode.modify = true;
                    
                    alarmModeEdit.clearOptions();
                    alarmModeEdit.addOption(alarmMode[0], "0");
                    alarmModeEdit.addOption(alarmMode[1], "1");
                    
                }
                else 
                {
                    cskidEdit.clearOptions();
                    cskidEdit.addOption(alarmConditions[22], "22");
                    cskidEdit.addOption(alarmConditions[23], "23");
                    
                    alarmModeEdit.clearOptions();
                    alarmModeEdit.addOption(alarmMode[0], "0");
                    
                    
                    cskidShow.setValue(alarmConditions[22]);
                    st.setCellValue(cskidCell, "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID", "22");
                    cskidCell.element.style.backgroundColor = "#d0f946";
                    cskidCell.element.modify = true;
                    cskidCell.element.parentNode.modify = true;
                    
                    alarmModeShow.setValue(alarmMode[0]);
                    st.setCellValue(alarmModeCell, "ENVCTRL_EMU_OUTCSK_ALARMMODE", "0");
                    alarmModeCell.element.style.backgroundColor = "#d0f946";
                    alarmModeCell.element.modify = true;
                    alarmModeCell.element.parentNode.modify = true;
                    
                }
            }
        }
        
        if (ids.contains("ENVCTRL_COM_INPUTCSK_NAME")) 
        {
            checkPathNameLength(st.getCellEdit(i, "ENVCTRL_COM_INPUTCSK_NAME"));
        }
        
        if (ids.contains("ENVCTRL_EMU_OUTCSK_NAME")) 
        {
            checkPathNameLength(st.getCellEdit(i, "ENVCTRL_EMU_OUTCSK_NAME"));
        }
        
        if (ids.contains("ENVCTRL_COM_INPUTCSK_USE")) 
        {
            inputUse = st.getCellEdit(i, "ENVCTRL_COM_INPUTCSK_USE");
            inputUse.element.onchange = function()
            {
                var index = this.parentNode.parentNode.rowIndex;
                var almModeCell = st.getCell(index, 'ENVCTRL_COM_INPUTCSK_ALARMMODE');
                if (almModeCell) 
                {
                    var showCell = st.getCellShow(index, 'ENVCTRL_COM_INPUTCSK_ALARMMODE');
                    var editCell = st.getCellEdit(index, 'ENVCTRL_COM_INPUTCSK_ALARMMODE');
                    var curValue = st.getCellStoreValue(index, 'ENVCTRL_COM_INPUTCSK_ALARMMODE', 'ENVCTRL_COM_INPUTCSK_ALARMMODE');
                    
                    if (this.value == 0) 
                    {
                        st.setCellIsEdit(almModeCell, 0);
                        showCell.element.innerText = '-';
                    }
                    else 
                    {
                        st.setCellIsEdit(almModeCell, 1);
                        showCell.element.innerText = intputAlarmMode[curValue];
                    }
                }
            }
        }
        
       
        var isAUXSp = SpecialAttrMgr.isCPSupportByType(winurlobj.neid, winurlobj.boardType,"TE_FUNC_CFG_PWR_INTERFACE", "SDH_ATTR_SUPPORT_ENV_AUX_ALARMMODE");
        if (ids.contains("ENVCTRL_COM_INPUTCSK_ALARMLEVEL") && (winurlobj.boardType == SL91AUX || winurlobj.boardType == SLA1AUX || winurlobj.boardType == SLD1AUX || isAUXSp)) 
        {
            inputUse = st.getCellEdit(i, "ENVCTRL_COM_INPUTCSK_ALARMLEVEL");
            inputUse.element.options.length = 0;
            inputUse.element.options[inputUse.element.options.length] = new Option(alarmLevel[0], 0);
            inputUse.element.options[inputUse.element.options.length] = new Option(alarmLevel[1], 1);
            inputUse.element.options[inputUse.element.options.length] = new Option(alarmLevel[2], 2);
            inputUse.element.options[inputUse.element.options.length] = new Option(alarmLevel[3], 3);
        }
        
        if (ids.contains("ENVCTRL_PMU_CTRLSTATE")) 
        {
            inputUse = st.getCellEdit(i, "ENVCTRL_PMU_CTRLSTATE");
            var showCell = st.getCellShow(i, 'ENVCTRL_PMU_CTRLTYPE');
            var ctrlStateValue = st.getCellStoreValue(i, "ENVCTRL_PMU_CTRLSTATE", "ENVCTRL_PMU_CTRLSTATE");
            if (ctrlStateValue == "85") 
            {
                st.setCellIsEdit(st.getCell(i, "ENVCTRL_PMU_CTRLTYPE"), 0);
            }
            
            inputUse.element.onchange = function()
            {
                var index = this.parentNode.parentNode.rowIndex;
                var ctrlTypeCell = st.getCell(index, "ENVCTRL_PMU_CTRLTYPE");//     
                ctrlTypeCell.element.modify = true;
                ctrlTypeCell.element.parentNode.modify = true;

                if (this.value == "85" && winurlobj.neType != '76' && winurlobj.neType != '77') {
                    st.setCellIsEdit(ctrlTypeCell, 0);
                    st.setCellValue(ctrlTypeCell, "ENVCTRL_PMU_CTRLTYPE", "187");
                } else if(this.value == "85" && (winurlobj.neType == '76' || winurlobj.neType == '77')) {
                    st.setCellIsEdit(ctrlTypeCell, 0);
                    ctrlTypeCell.element.showElement.element.innerText = '-';
                }
                else if (ctrlTypeCell.element.isEdit != "1") 
                {
                    st.setCellIsEdit(ctrlTypeCell, 1);
                    ctrlTypeCell.element.style.backgroundColor = "#d0f946";
                    st.setCellValue(ctrlTypeCell, "ENVCTRL_PMU_CTRLTYPE", "170");
                    st.setAtomValue(showCell, RESOURCE["ctrlType0"]);
                }
            }
        }
        if (ids.contains("ENVCTRL_PMU_STATEOFLOADFALLELEC") || ids.contains("ENVCTRL_PMU_VOLOFLOADFALLELEC")) 
        {
            var loadCell1 = st.getCell(i, 'ENVCTRL_PMU_STATEOFLOADFALLELEC');
            var loadCell2 = st.getCell(i, 'ENVCTRL_PMU_VOLOFLOADFALLELEC');
            var loadCell1Show = st.getCellShow(i, 'ENVCTRL_PMU_STATEOFLOADFALLELEC');
            var loadCell2Show = st.getCellShow(i, 'ENVCTRL_PMU_VOLOFLOADFALLELEC');
            var loadCell2Val = st.getCellStoreValue(i, 'ENVCTRL_PMU_VOLOFLOADFALLELEC', 'ENVCTRL_PMU_VOLOFLOADFALLELEC');
            
            if (loadCell2Val == '/') 
            {
                st.setCellIsEdit(loadCell1, "0");
                st.setCellIsEdit(loadCell2, "0");
                loadCell1Show.setValue("-");
                loadCell2Show.setValue("-");
            }
        }
    }
}

function checkPathNameLength(cellEdit)
{
    cellEdit.element["onkeydown"] = function()
    {
        return calStrSinoLen(this, 20);
    }
    cellEdit.element["onkeyup"] = function()
    {
        return calStrSinoLen(this, 20);
    }
    
    cellEdit.element.onblur = function()
    {
        calStrSinoLenCheck(this, 20);
        
        this.style.position = "static";
        this.style.border = "1px solid #999999";
        this.style.width = this.parentNode.offsetWidth;
        var rows = this.parentNode.parent.getSelectedRows();
        for (var j = 0; j < rows.length; j++) 
        {
            var cell = this.parentNode.parent.getCell(rows[j], this.parentNode.colid);
            if (null == cell.element.editElement || cell.element.isEdit == 0) 
            {
                continue;
            }
            
            if(this.value.trim()==""&&this.parentNode.colid=="ENVCTRL_COM_INPUTCSK_NAME")
            {
            	cell.element.showElement.setValue('CSK-' + st.getCellCurrentValue(rows[j], "object", "switch"));  
            }
            else if(this.value.trim()==""&&this.parentNode.colid=="ENVCTRL_EMU_OUTCSK_NAME")
            {
            	cell.element.showElement.setValue('OUT_CSK-' + st.getCellCurrentValue(rows[j], "object", "switch"));  
            }
            else
            {
              cell.element.showElement.setValue(this.value);   
            }
            
            cell.element.modify = true;
            cell.element.parentNode.modify = true;
            cell.element.style.backgroundColor = "#d0f946";
            cell.element.parent.setTdCellValue(cell.element, this.parentNode.colid, this.value);
            cell.element.showElement.element.style.display = "";
            handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
        }
        
        var pnode = this.parentNode;
        pnode.removeChild(pnode.lastChild);
        
        pnode.showElement.element.style.display = "";
        handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
    }
}

function getIDs()
{
    var ids = new Array();
    for (var i = 0, len = tc.getColsLength(); i < len; i++) 
    {
        ids[ids.length] = tc.getColId(i);
    }
    return ids;
}

function tempdbclick(obj, value)
{
    obj.style.backgroundColor = "#d0f946";
    obj.modify = true;
    obj.parentNode.modify = true;
    obj.showElement.element.style.display = "none";
    obj.editElement.element.style.display = "";
    
    var colid = obj.colid;
    var editdom = obj.parent.editdom[colid];
    obj.appendChild(editdom.element);
    
    if (editdom.type == "text") 
    {
        if (obj.showElement.getValue() == "/") 
        {
            editdom.setValue(value);
        }
        else 
        {
            editdom.setValue(obj.showElement.getValue());
        }
    }
    else if (editdom.type == "select") 
    {
        editdom.setValue(value);
    }
    
    editdom.element.focus();
    
    handleCellEdit(obj, TABLE_CONSTANT.BEFOREEDIT);
}

function sendSetInfo()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var neid = winurlobj.neid;
    var xmlstr = createSetXML(neid, st, tc);
    if (xmlstr != null) 
    {
        urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PMUATTRIB + "&nmUser=" + winurlobj["nmUser"];
        loadXMLdoc(urlreq, "POST", true, setCallBack, null, "inputdata=" + xmlstr);
    }
    else 
    {
        $("querybtn").disabled = false;
        $("applybtn").disabled = false;
    }
}

/**
 *          XML  
 * 
 * @param neid:  ID
 *            slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetXML(neid, st, tc)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var rowData = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
        rowData = st.getRow();
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        for (var colindex = 0, collen = st.getColumnCount(); colindex < collen; colindex++) 
        {
            colid = tc.getColId(colindex);
            
            cellModifyFlag = st.getCellModify(rowindex, colid);

            if ((colid == "ENVCTRL_COM_TEMPERDOWNLIMIT" || colid == "ENVCTRL_COM_TEMPERUPLIMIT") &&
            cellModifyFlag == true) 
            {
                var acalup = st.getCellShow(rowindex, "ENVCTRL_COM_TEMPERUPLIMIT").getValue();
                var acaldown = st.getCellShow(rowindex, "ENVCTRL_COM_TEMPERDOWNLIMIT").getValue();
                if (acalup != "-" && acalup != "-" &&
                acalup != "/" &&
                acalup != "/" &&
                parseFloat(acaldown) >= parseFloat(acalup)) 
                {
                    alert(RESOURCE["errorinfo8"]);
                    return null;
                }
            }
            
            if ((colid == "ENVCTRL_PMU_ACALARMUPLIMIT" || colid == "ENVCTRL_PMU_ACALARMDOWNLIMIT") &&
            cellModifyFlag == true) 
            {
                var acalup = st.getCellShow(rowindex, "ENVCTRL_PMU_ACALARMUPLIMIT").getValue();
                var acaldown = st.getCellShow(rowindex, "ENVCTRL_PMU_ACALARMDOWNLIMIT").getValue();
                if (acalup != "-" && acalup != "-" &&
                acalup != "/" &&
                acalup != "/" &&
                parseFloat(acaldown) >= parseFloat(acalup)) 
                {
                    alert(RESOURCE["errorinfo7"]);
                    return null;
                }
            }
            
            if ((colid == "ENVCTRL_PMU_DCALARMUPLIMIT" || colid == "ENVCTRL_PMU_AVGVL" || colid == "ENVCTRL_PMU_CHGVL") &&
            cellModifyFlag == true) 
            {
                var avgvl = st.getCellShow(rowindex, "ENVCTRL_PMU_AVGVL").getValue();
                var dcaup = st.getCellShow(rowindex, "ENVCTRL_PMU_DCALARMUPLIMIT").getValue();
                var chgvl = st.getCellShow(rowindex, "ENVCTRL_PMU_CHGVL").getValue();
                
                if (avgvl != "-" && dcaup != "-" &&
                avgvl != "/" &&
                dcaup != "/" &&
                parseFloat(avgvl) >= (parseFloat(dcaup) - 1)) 
                {
                    alert(RESOURCE["errorinfo1"]);
                    return null;
                }
                if (avgvl != "-" && chgvl != "-" &&
                avgvl != "/" &&
                chgvl != "/" &&
                parseFloat(chgvl) >= parseFloat(avgvl)) 
                {
                    alert(RESOURCE["errorinfo2"]);
                    return null;
                }
            }
            if ((colid == "ENVCTRL_PMU_DCALARMDOWNLIMIT" || colid == "ENVCTRL_PMU_CHGVL") &&
            cellModifyFlag == true) 
            {
                var dcadown = st.getCellShow(rowindex, "ENVCTRL_PMU_DCALARMDOWNLIMIT").getValue();
                var chgvl = st.getCellShow(rowindex, "ENVCTRL_PMU_CHGVL").getValue();
                
                if (dcadown != "-" && chgvl != "-" &&
                dcadown != "/" &&
                chgvl != "/" &&
                parseFloat(dcadown) >= (parseFloat(chgvl) - 2)) 
                {
                    alert(RESOURCE["errorinfo3"]);
                    return null;
                }
            }
            
            if ((colid == "ENVCTRL_PMU_VOLOFLOADFALLELEC" || colid == "ENVCTRL_PMU_STATEOFLOADFALLELEC" ||
            colid == "ENVCTRL_PMU_DCALARMDOWNLIMIT") &&
            cellModifyFlag == true) 
            {
                var dcadown = st.getCellShow(rowindex, "ENVCTRL_PMU_DCALARMDOWNLIMIT").getValue();
                var floadEnable = st.getCellStoreValue(rowindex, "ENVCTRL_PMU_STATEOFLOADFALLELEC", "ENVCTRL_PMU_STATEOFLOADFALLELEC");
                var fload = st.getCellShow(rowindex, "ENVCTRL_PMU_VOLOFLOADFALLELEC").getValue();
                
                if (floadEnable == "1" && dcadown != "-" && fload != "-" &&
                dcadown != "/" &&
                fload != "/" &&
                parseFloat(fload) >= parseFloat(dcadown)) 
                {
                    alert(RESOURCE["errorinfo4"]);
                    return null;
                }
            }
            if ((colid == "ENVCTRL_PMU_VOLOFPILEFALLELEC" || colid == "ENVCTRL_PMU_STATEOFPILEFALLELEC" ||
            colid == "ENVCTRL_PMU_VOLOFLOADFALLELEC" ||
            colid == "ENVCTRL_PMU_STATEOFLOADFALLELEC" ||
            colid == "ENVCTRL_PMU_DCALARMDOWNLIMIT") &&
            cellModifyFlag == true) 
            {
                var pileEnable = st.getCellStoreValue(rowindex, "ENVCTRL_PMU_STATEOFPILEFALLELEC", "ENVCTRL_PMU_STATEOFPILEFALLELEC");
                var pile = st.getCellShow(rowindex, "ENVCTRL_PMU_VOLOFPILEFALLELEC").getValue();
                if (pileEnable == "1") 
                {
                    var floadEnable = st.getCellStoreValue(rowindex, "ENVCTRL_PMU_STATEOFLOADFALLELEC", "ENVCTRL_PMU_STATEOFLOADFALLELEC");
                    var fload = st.getCellShow(rowindex, "ENVCTRL_PMU_VOLOFLOADFALLELEC").getValue();
                    if (floadEnable == "1" && fload != "-" && fload != "/") 
                    {
                        if (parseFloat(pile) >= parseFloat(fload)) 
                        {
                            alert(RESOURCE["errorinfo5"]);
                            return null;
                        }
                    }
                    else 
                    {
                        var dcadown = st.getCellShow(rowindex, "ENVCTRL_PMU_DCALARMDOWNLIMIT").getValue();
                        if (parseFloat(pile) >= parseFloat(dcadown)) 
                        {
                            alert(RESOURCE["errorinfo6"]);
                            return null;
                        }
                    }
                }
            }
            
            colkeyarray = tc.getColKeyArray(colindex);
            for (var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++) 
            {
                param = new tagElement("param");
                key = colkeyarray[keyindex].name;
                
                
                param.setAttribute("name", key);
                var tmpEmp = st.getCellStoreValue(rowindex, colid, key);
                
                if (attrArray.contains(colid)) 
                {
                    tmpEmp = st.getCellShow(rowindex, colid).element.innerText;
                    if (tmpEmp == "-" && colid == "ENVCTRL_PMU_VOLOFLOADFALLELEC") 
                    {
                        tmpEmp = 44;
                    }
                }
                
                if (tmpEmp == null || typeof(tmpEmp) == "undefined") 
                {
                    continue;
                }
                
                if (key == "ENVCTRL_COM_TEMPERDOWNLIMIT" || key == "ENVCTRL_COM_TEMPERUPLIMIT" || attrArray.contains(key)) 
                {
                    tmpEmp = tmpEmp * 10;
                }
                
                if (key == "ENVCTRL_PMU_COEOFBAT") 
                {
                    tmpEmp = parseInt(tmpEmp * 100);
                }
                
                param.setAttribute("value", tmpEmp);
                param.setAttribute("modifyFlag", cellModifyFlag);
                row.appendChild(param);
            }
        }
        bussiness.appendChild(row);
    }
    if (0 == bussiness.childNodes.length) 
    {
        alert(RESOURCE["osinochange"]);
        return null;
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function setCallBack(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;
        showErrorDialog(data);
    }
    
    refreshTableState(st, tc, data);
}

/**
 *               
 * 
 * @param  
 * @return  
 */
function cellEditHandler(param)
{
    var colid = param.colid;
    var st = param.st;
    var rowindex = param.rowindex;
    
    if (colid == "ENVCTRL_PMU_UPLIMIT") 
    {
        var thType = st.getCellStoreValue(rowindex, "ENVCTRL_PMU_ALMTHTYPE", "ENVCTRL_PMU_ALMTHTYPE");
        var editElm = st.getCellEdit(rowindex, colid).element;
        
        switch (thType)
        {
            case '1':
                textCheck(editElm, "35", "80", 0);
                break;
            case '2':
                textCheck(editElm, "50", "100", 0);
                break;
        }
        
    }
    else if (colid == "ENVCTRL_PMU_DOWNLIMIT") 
    {
        var thType = st.getCellStoreValue(rowindex, "ENVCTRL_PMU_ALMTHTYPE", "ENVCTRL_PMU_ALMTHTYPE");
        var editElm = st.getCellEdit(rowindex, colid).element;
        
        switch (thType)
        {
            case '1':
                textCheck(editElm, "-20", "20", 0);
                break;
            case '2':
                textCheck(editElm, "0", "50", 0);
                break;
        }
    }
    else if (colid == "ENVCTRL_PMU_TMPOFPILE") 
    {
        var editElm = st.getCellEdit(rowindex, colid).element;
        textCheck(editElm, "40", "70", 0);
        
    }
    else if (colid == "ENVCTRL_PMU_HIGHTEMPERTHOFPILE") 
    {
        var thType = st.getCellStoreValue(rowindex, "ENVCTRL_PMU_HIGHTEMPERTHOFPILE", "ENVCTRL_PMU_HIGHTEMPERTHOFPILE");
        var editElm = st.getCellEdit(rowindex, colid).element;
        
        textCheck(editElm, "35", "80", 0);
        
    }
    else if (colid == "ENVCTRL_PMU_LOWTEMPERTHOFPILE") 
    {
        var thType = st.getCellStoreValue(rowindex, "ENVCTRL_PMU_LOWTEMPERTHOFPILE", "ENVCTRL_PMU_LOWTEMPERTHOFPILE");
        var editElm = st.getCellEdit(rowindex, colid).element;
        
        textCheck(editElm, "-20", "20", 0);
    }
    else if (colid == "ENVCTRL_TCU_TEMPERUPLIMIT") 
    {
        var thType = st.getCellStoreValue(rowindex, "ENVCTRL_TCU_TEMPERUPLIMIT", "ENVCTRL_TCU_TEMPERUPLIMIT");
        var editElm = st.getCellEdit(rowindex, colid).element;
        
        textCheck(editElm, "20.0", "80.0");
    }
    else if (colid == "ENVCTRL_TCU_TEMPERDOWNLIMIT") 
    {
        var thType = st.getCellStoreValue(rowindex, "ENVCTRL_TCU_TEMPERDOWNLIMIT", "ENVCTRL_TCU_TEMPERDOWNLIMIT");
        var editElm = st.getCellEdit(rowindex, colid).element;
        
        textCheck(editElm, "-40.0", "10.0");
    }
    /**
     * NA910       1   
     *       
     */
    else if (colid == "ENVCTRL_EMU_ALMRELAY_ROUTENUM")
    {
    	var outPutChannelCell = st.getCellEdit(rowindex,"ENVCTRL_EMU_ALMRELAY_ROUTENUM");
    	if(winurlobj["neType"] == "89" || winurlobj["boardType"] == SLD1AUX || winurlobj["boardType"] == SLA1AUX)
    	{
	    	outPutChannelCell.clearOptions();
	    	outPutChannelCell.addOption(routeNum[1],1);//CSK-1
    	}
    }
    
    else if(colid == "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
    {
		var index = rowindex;
		var workModeCellValue = st.getCellStoreValue(index, "ENVCTRL_EMU_OUTCSK_WORKMODE", "ENVCTRL_EMU_OUTCSK_WORKMODE");
	    var cskidEdit = st.getCellEdit(index, "ENVCTRL_EMU_OUTCSK_CORRINPUTCSKID");
	    
	    if( workModeCellValue == "1" )	//     
	    {
	        cskidEdit.clearOptions();
	        cskidEdit.addOption(alarmConditions[1], "1");
	        cskidEdit.addOption(alarmConditions[2], "2");
	        cskidEdit.addOption(alarmConditions[3], "3");
	        if (winurlobj.boardType != SL71EOW) 
	        {
	            cskidEdit.addOption(alarmConditions[4], "4");
	            cskidEdit.addOption(alarmConditions[5], "5");
	            cskidEdit.addOption(alarmConditions[6], "6");
	        }
	        cskidEdit.addOption(alarmConditions[19], "19");
	        cskidEdit.addOption(alarmConditions[20], "20");
	        cskidEdit.addOption(alarmConditions[21], "21");
	    }
	    else
	    {
	        cskidEdit.clearOptions();
	        cskidEdit.addOption(alarmConditions[22], "22");
	        cskidEdit.addOption(alarmConditions[23], "23");
	    }
    }
    else if(colid == "ENVCTRL_EMU_OUTCSK_ALARMMODE")
    {
    	var index = rowindex;
    	var workModeCellValue = st.getCellStoreValue(index, "ENVCTRL_EMU_OUTCSK_WORKMODE", "ENVCTRL_EMU_OUTCSK_WORKMODE");
    	var almModeCell = st.getCellEdit(i, "ENVCTRL_EMU_OUTCSK_ALARMMODE");

        var alarmModeEdit = st.getCellEdit(index, "ENVCTRL_EMU_OUTCSK_ALARMMODE");//     
            
        if( workModeCellValue == "1" )	//     
        {
            alarmModeEdit.clearOptions();
            alarmModeEdit.addOption(alarmMode[0], "0");
            alarmModeEdit.addOption(alarmMode[1], "1");
        }
        else
        {
            alarmModeEdit.clearOptions();
            alarmModeEdit.addOption(alarmMode[0], "0");
        }
    }
    else if(colid == "ENVCTRL_COM_TEMPERUPLIMIT")
    {
    	  var tempUpLimit = st.getCellEdit(index, "ENVCTRL_COM_TEMPERUPLIMIT");
          if(TEMP_UPLIMIT_LEFT != null && "" != TEMP_UPLIMIT_LEFT)
          {        	
          	 textCheck(tempUpLimit.element, TEMP_UPLIMIT_LEFT, TEMP_UPLIMIT_RIGHT);
         }     
    }
    else if(colid == "ENVCTRL_COM_TEMPERDOWNLIMIT")
    {
    	  var tempDownLimit = st.getCellEdit(index, "ENVCTRL_COM_TEMPERDOWNLIMIT");
           if(TEMP_DOWNLIMIT_LEFT != null && "" != TEMP_DOWNLIMIT_LEFT)
           {         	 
	          	textCheck(tempDownLimit.element, TEMP_DOWNLIMIT_LEFT, TEMP_DOWNLIMIT_RIGHT);
           }
    }
    
    
    if (hasApplyRight && param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        $("applybtn").disabled = false;
    }
}
