var winurlobj = getNeProperty(self);

var PAYLOAD_E3 = 2;
var PAYLOAD_T1 = 1;
var NOTBALANCE = 0;
var BALANCE = 1;

var ids = null;
var cycle = [];
cycle["0"] = RESOURCE["notCycle"];
cycle["1"] = RESOURCE["inCycle"];
cycle["2"] = RESOURCE["outCycle"];

var opshow = [];
opshow["0"] = RESOURCE["noshow"];
opshow["1"] = RESOURCE["show"];

var resistance = [];
resistance["0"] = RESOURCE["normal"];
resistance["1"] = RESOURCE["offset"]; 
resistance["2"] = RESOURCE["cross"];

var timemod = [];
timemod["0"] = RESOURCE["normal"];
timemod["1"] = RESOURCE["offset"]; 
timemod["2"] = RESOURCE["cross"];

var impedenceCovert = [];
impedenceCovert["1"] = RESOURCE["one"];
impedenceCovert["2"] = RESOURCE["two"];

var balance = [];
balance["0"] = RESOURCE["notBalance"];
balance["1"] = RESOURCE["balance"];

var payload = [];
payload["0"] = "E1";
payload["1"] = "T1";
payload["2"] = "E3";
payload["3"] = "T3";

var e1frm = [];
e1frm[0] = RESOURCE["E1FRM0"];//   
e1frm[1] = RESOURCE["E1FRM1"];//Double 
e1frm[2] = RESOURCE["E1FRM2"];//CRC-4  

var codetype = [];
codetype["0"] = "B8ZS";
codetype["1"] = "AMI";

var btnRightArr = new Object();
var applyRight = false;

function initpage()
{
    st = new SortTable();
    st.setImage("../../../../images/");
    st.setBodyHeight("280");
    tc = window.tableconf[0];

	if (SpecialAttrMgr.isCPSupportByType(winurlobj.neid, winurlobj.boardType, 'TE_FUNC_CFG_PDH_UNIT', 'W32PORT_ATTR_PDH_NOTSUPPORT_NAME'))
	{
		for (var len = tc.getColsLength() - 1; len >= 0; len--) 
		{
			if (tc.colArray[len].id == "W32PORT_ATTR_NAME")
			{
				tc.colArray.removeAt(len);
				break;
			}
		}
	}
    var attrArr = getNeProperty(self)["supportAttr"].split(",");
  
    filterAttrCol(tc,attrArr);
  
    ids = getIDs();

    createTableHead(st, tc);
    st.setOnCellEditHandler(cellEditHandler);
    document.getElementById("table").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight($("table"),st)+"px");
    st.element.oncontextmenu=popupMenuHandler;
    
    var hc=st.getHeadCell("path");
    st.setHCAttribute(hc,1,0,comparePath);

    $("querybtn").value=RESOURCE["querybutton"];
	  $("applybtn").value=RESOURCE["applybutton"];
	  $("printBtn").value = RESOURCE["printbutton"];
        $("saveAsFileBtn").value = RESOURCE["savefile"];
	  
	  btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_PDHBRDATTRIB);    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_GET_PDHBRDATTRIB);    
    sendRightInfo(btnRightArr);  
    initBtnStatue(); 	  
	  if(btnRightArr.querybtn.right)
	  {
	      sendQueryInfo();
	  } 	

}

function sendQueryInfo()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("printBtn").disabled = true;
        $("saveAsFileBtn").disabled = true;
	
    var neid = winurlobj.neid;
    var slotid = winurlobj.slotid;  
    
    var xmlstr = createQueryXML(neid,slotid,tc);
    urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET_PDHBRDATTRIB+ "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,queryCallBack,null,"inputdata="+xmlstr);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = false;
    $("printBtn").disabled = false;
        $("saveAsFileBtn").disabled = false;
    var data = EncapsulateData(doc);
    createGenCfgTableBody(st, tc, data, RESOURCE);
  	addListener();
  	showErrorDialog(data);
}

function addListener()
{
	var ids = getIDs();
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
		if(ids.contains("PDHPATH_ATTR_PAYLOAD"))
		{
			var payloadCell = st.getCellEdit(i,"PDHPATH_ATTR_PAYLOAD");
			var payloadValue = st.getCellStoreValue(i,"PDHPATH_ATTR_PAYLOAD","PDHPATH_ATTR_PAYLOAD");
			
			if(payloadValue == PAYLOAD_E3)
			{
				var inputBalanceCell = st.getCell(i,"PDHPATH_ATTR_INPUTBALANCE");
				var outputBalanceCell = st.getCell(i,"PDHPATH_ATTR_OUTPUTBALANCE");
				
				
				if(inputBalanceCell != null)
				{
					setCellEdit(inputBalanceCell,false);
				}
				if(outputBalanceCell != null)
				{
					setCellEdit(outputBalanceCell,false);
				}
	
			}
			
			if(payloadValue == PAYLOAD_T1)
			{
				var codetypeCell = st.getCell(i,"PDHPATH_ATTR_E1T1_CODETYPE");
				if(codetypeCell != null)
				{
					setCellEdit(codetypeCell,true);
				}
			}
			
			payloadCell.element.onchange = function()
			{
				var indexes = st.getSelectedRows();
				for (var i = 0; i < indexes.length; i++) 
				{
					var index = indexes[i];
				var payloadValue = st.getCellStoreValue(index,"PDHPATH_ATTR_PAYLOAD","PDHPATH_ATTR_PAYLOAD");
				var inputBalanceCell = st.getCell(index,"PDHPATH_ATTR_INPUTBALANCE");
				var outputBalanceCell = st.getCell(index,"PDHPATH_ATTR_OUTPUTBALANCE");
				var codetypeCell = st.getCell(index,"PDHPATH_ATTR_E1T1_CODETYPE");
				
				if(this.value == PAYLOAD_E3)
				{
					if(inputBalanceCell != null)
					{
						setCellEdit(inputBalanceCell,false);
					}
					if(outputBalanceCell != null)
					{
						setCellEdit(outputBalanceCell,false);
					}
				}
				else
				{
					if(inputBalanceCell != null)
					{
						setCellEdit(inputBalanceCell,true);
						st.setCellValue(inputBalanceCell,"PDHPATH_ATTR_INPUTBALANCE",NOTBALANCE);
						st.setAtomValue(inputBalanceCell.element.showElement,balance[NOTBALANCE]);
					}
					
					if(outputBalanceCell != null)
					{
						setCellEdit(outputBalanceCell,true);
						st.setCellValue(outputBalanceCell,"PDHPATH_ATTR_OUTPUTBALANCE",NOTBALANCE);
						st.setAtomValue(outputBalanceCell.element.showElement,balance[NOTBALANCE]);
					}
					
				}
				
				if(this.value == PAYLOAD_T1)
				{
					if(codetypeCell != null)
					{
						setCellEdit(codetypeCell,true);
						st.setCellValue(codetypeCell,"PDHPATH_ATTR_E1T1_CODETYPE",0);
						st.setAtomValue(codetypeCell.element.showElement,codetype["0"]);
					}
					
					
				}
				else
				{
					if(codetypeCell != null)
					{
						setCellEdit(codetypeCell,false);
					}			
					
				}	
				
				}
			}
		}
	}
}

/**
 *            
 */
function setCellEdit(cell,isEditable)
{
	if(isEditable)
	{
		st.setCellIsEdit(cell,1);
		cell.element.ondblclick = cellondbclick;
		cell.element.modify = false;
		cell.element.style.background = "#ffffff";
	}
	else
	{
		st.setCellIsEdit(cell,0);
		cell.element.ondblclick = null;
		st.setAtomValue(cell.element.showElement,"-");
		cell.element.style.backgroundColor = "";
		cell.element.modify = false;
	}
}

function cellEditHandler(param)
{	
     var colid = param.colid;
    var st = param.st;
    var rowindex = param.rowindex;

    if(colid == "PDHPATH_ATTR_PAYLOAD")
	{
			var codeTypeEdit = st.getCellEdit(rowindex,"PDHPATH_ATTR_PAYLOAD");
			var codeTypeValue = st.getCellStoreValue(rowindex,"PDHPATH_ATTR_PAYLOAD","PDHPATH_ATTR_PAYLOAD")
			
			if (codeTypeValue == 0 || codeTypeValue == 1 )//   TNH1SP3D     E1 T1
			{
			        codeTypeEdit.clearOptions();
			        
		    		codeTypeEdit.addOptionObj(new Option(payload["0"],0));
		    		codeTypeEdit.addOptionObj(new Option(payload["1"],1));
			}
	}

     
     if(applyRight)
    {
    	$("applybtn").disabled = false;
    }		
}

function sendSetInfo()
{    
	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid,st,tc);

	if(null == xmlStr)
	{	        
        return;
	}
	
	$("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
	urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_PDHBRDATTRIB+ "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST",true,setCallBack,null,"inputdata="+xmlStr);
}

function setCallBack(doc)
{
	$("querybtn").disabled = false;
    $("applybtn").disabled = true;
    
	var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
    	
		if(applyRight)
	    {
	    	$("applybtn").disabled = false;
	    }		
    }
    refreshTableState(st,tc,data);
}

function getIDs()
{
	var ids = new Array();
	for(var i=0,len=tc.getColsLength();i<len;i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}


function showErrorDialog(result)
{
    var errArr = [];
    
    var errorObj = null;
    var tmpObj = null;
    for(var i = result.getBErrLength() - 1; i >= 0; i--)
	{	
		errorObj = result.getError().rowErrors[i].errorObj;
		tmpObj =  errorObj["attrId"];
		errorObj["attrId"] = getAttrName(tc, errorObj["attrId"]);
		if (tmpObj == errorObj["attrId"])
		{
			result.getError().rowErrors.removeAt(i);
			continue;  
		}
    	errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"]+"-"+errorObj["attrId"];		
	}
	
    errArr[0] = "operationObj";
    openErrPage("../../../../page/", result.getError(), errArr);
    errArr = null;

}

/**
 *        
 * @param btnId       ID  sfid             ID
 * @return  
 */ 
function BtnRightObj(btnId,sfid)
{
	if(null != btnId)
	{
		this.btnId = btnId;
	}
	else
	{
		this.btnId = "";
	}
	
	if(isNaN(parseInt(sfid)))
	{
		this.sfid = -1;
	}
	else
	{
		this.sfid = sfid;
	}
	this.right = true;
}

/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	  var root = new inputxml("datainterface");//Create the root of a xml file
	  var firstlevel = new tagElement("bussiness-params");
	
	  var secondlevel=null;;
	  var thirdlevel=null;
	
      for(var btnrightobj in btnRightArr)
	  {
		    secondlevel = new tagElement("row-params"); //bean         	
		
		    thirdlevel = new tagElement("param");
		    thirdlevel.setAttribute("name","btnID");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		    secondlevel.appendChild(thirdlevel);
		
		    thirdlevel = new tagElement("param");	
		    thirdlevel.setAttribute("name","sfid");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		    secondlevel.appendChild(thirdlevel);
		
		    firstlevel.appendChild(secondlevel);
	  }
	  root.getRoot().appendChild(firstlevel);
	  return root.toString();
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	  var url = "../../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	  loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}
/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	  var data = EncapsulateData(doc);
    
	  for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
      	var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
    	  } 
      	else
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
    	  }        
    }   
}
/**
 *         
 * @param  
 * @return  
 */
function initBtnStatue()
{	
    $("querybtn").disabled = !btnRightArr.querybtn.right;		
    applyRight = btnRightArr.applybtn.right;	
}

window.onresize=function()
{
	st.setBodyHeight(getTableHeight($("table"),st)+"px");
}

function createSetXML(neid,st,tc)
{
  var di = new inputxml("datainterface");
  var bussiness = new tagElement("bussiness-params");
  var row = null;
  var param = null;
  var colid = null;
  var key = null;
  var colkeyarray = null;
  var cellModifyFlag = false;
  var portid = null;
  var index = 0;
  var confirmed = false;
  
  for(var rowindex = 0,rowlen = st.getDataRowLength();rowindex<rowlen;rowindex++)
  {
  	if(!st.getModify(rowindex))
  	{
  		continue;
  	}
  	row = new tagElement("row-params");
  	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid); 
		row.appendChild(param);	
  	
  	for(var colindex = 0,collen = st.getColumnCount();colindex < collen;colindex++)
  	{
  		colid = tc.getColId(colindex);
  		cellModifyFlag = st.getCellModify(rowindex,colid);
  		
  		if((colid == "PDHPATH_ATTR_LOOPBACKMODE" || colid == "PDHPATH_ATTR_LOOPBACK") && cellModifyFlag && !confirmed)
  		{
  			if(!confirm(RESOURCE["confirmSet"] + RESOURCE["PDHPATH_ATTR_LOOPBACK"] + "?"))
			{
				return;
			}
			
			confirmed = true;
  		}
  		
  		
  		colkeyarray = tc.getColKeyArray(colindex);
  		for(var keyindex = 0,keylen = colkeyarray.length;keyindex < keylen;keyindex++)
  		{
  			param = new tagElement("param");
  			
  			key = colkeyarray[keyindex].name;
    		
    		if("neid" == key)
    		{
    			continue;
    		}

    		   		    			
    			if("portname" == key)
    			{
    				param.setAttribute("name","port")
    				var portid = st.getCellStoreValue(rowindex,colid,key);
    				index = portid.indexOf("(");
    				param.setAttribute("value",portid.substring(0,index));
    			}
    			else
    			{
    	     	param.setAttribute("name",key); 
    	     	param.setAttribute("value",st.getCellStoreValue(rowindex,colid,key));
    	    }
    		param.setAttribute("modifyFlag",cellModifyFlag); 
    		row.appendChild(param);		
    	}    		
    }
    bussiness.appendChild(row);
	} 
	if(0 == bussiness.childNodes.length)
	{
		return;
	}  
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *        ,    NE123-1-FIU-1(RX/TX)
 * @param str1 str2
 * @return int
 */
function comparePath(str1,str2)
{
   var tmp1;
   var tmp2;
   
   if (str1.charAt(str1.length-3) == '-') //-5)  ;
   {
       tmp1=parseInt(str1.substring(str1.length-2,str1.length-1));    
   }
   else
   {
       tmp1=parseInt(str1.substring(str1.length-3,str1.length-1));  
   }
   
   if (str2.charAt(str2.length-3) == '-') //-5)  ;
   {
       tmp2=parseInt(str2.substring(str2.length-2,str2.length-1));
   }
   else
   {
       tmp2=parseInt(str2.substring(str2.length-3,str2.length-1));
   }

   return compare(tmp1,tmp2);        
}


function print()
{
    if(0 == st.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    
    var par = window.parent; 
     var selectObj = par.document.getElementById("selectObj");
   
    openPrintPage("../../../../page/", selectObj.options[selectObj.selectedIndex].innerText, "st");
}

function save()
{
    if(st.getDataRowLength()<=0)
    {
    	alert(RESOURCE["nodata"]);
    	return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
   
    openSaveAsPage("../../../../page/", selectObj.options[selectObj.selectedIndex].innerText, "st");
}
