var winurlobj = getNeProperty(self);

var MODE_E1 = 0;

var ids = null;
var cycle = [];
cycle["0"] = RESOURCE["notCycle"];
cycle["1"] = RESOURCE["inCycle"];
cycle["2"] = RESOURCE["outCycle"];


var opshow = [];
opshow["0"] = RESOURCE["noshow"];
opshow["1"] = RESOURCE["show"];

var resistance = [];
resistance["0"] = RESOURCE["normal"];
resistance["1"] = RESOURCE["offset"]; 
resistance["2"] = RESOURCE["cross"];

var timemod = [];
timemod["0"] = RESOURCE["normal"];
timemod["1"] = RESOURCE["offset"]; 
timemod["2"] = RESOURCE["cross"];

var impedenceCovert = [];
impedenceCovert["1"] = RESOURCE["one"];
impedenceCovert["2"] = RESOURCE["two"];

var balance = [];
balance["0"] = RESOURCE["notBalance"];
balance["1"] = RESOURCE["balance"];

var payload = [];
payload["2"] = "E3";
payload["3"] = "T3";

var e1t1mode = [];
e1t1mode["0"] = "E1";
e1t1mode["1"] = "T1";

var btnRightArr = new Object();
var applyRight = false;

function initpage()
{
    st = new SortTable();
    st.setImage("../../../../images/");
    st.setBodyHeight("280");
    tc = window.tableconf[0];

    var attrArr = getNeProperty(self)["supportAttr"].split(",");
  
    filterAttrCol(tc,attrArr);
  
    ids = getIDs();

    createTableHead(st, tc);
    st.setOnCellEditHandler(cellEditHandler);
    document.getElementById("table").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight($("table"),st)+"px");
    st.element.oncontextmenu=popupMenuHandler;
    
    var hc=st.getHeadCell("board");
    st.setHCAttribute(hc,1,0,comparePath);

    $("querybtn").value=RESOURCE["querybutton"];
	  $("applybtn").value=RESOURCE["applybutton"];
	   $("printBtn").value = RESOURCE["printbutton"];
        $("saveAsFileBtn").value = RESOURCE["savefile"];
	 
	  
	  btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_PDHBRDATTRIB);    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_GET_PDHBRDATTRIB);    
    sendRightInfo(btnRightArr);  
    initBtnStatue(); 	  
	  if(btnRightArr.querybtn.right)
	  {
	      sendQueryInfo();
	  } 	

}

function sendQueryInfo()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	 $("printBtn").disabled = true;
        $("saveAsFileBtn").disabled = true;
	
    var neid = winurlobj.neid;
    var slotid = winurlobj.slotid;  
    
    var xmlstr = createQueryXML(neid,slotid,tc);
    urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET_PDHBRDATTRIB;
    loadXMLdoc(urlreq, "POST",true,queryCallBack,null,"inputdata="+xmlstr);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = false;
     $("printBtn").disabled = false;
        $("saveAsFileBtn").disabled = false;
    var data = EncapsulateData(doc);
    createGenCfgTableBody(st, tc, data, RESOURCE);
  	addListener();
  	showErrorDialog(data);
}

function addListener()
{
	var ids = getIDs();
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
		if(ids.contains("PDHBRD_ATTR_E1T1MODE"))
		{
			var payloadCell = st.getCellEdit(i,"PDHBRD_ATTR_E1T1MODE");
			var payloadValue = st.getCellStoreValue(i,"PDHBRD_ATTR_E1T1MODE","PDHBRD_ATTR_E1T1MODE");
		}
	}
}

/**
 *            
 */
function setCellEdit(cell,isEditable)
{
	if(isEditable)
	{
		st.setCellIsEdit(cell,1);
		cell.element.ondblclick = cellondbclick;
		cell.element.modify = false;
		cell.element.style.background = "#ffffff";
	}
	else
	{
		st.setCellIsEdit(cell,0);
		cell.element.ondblclick = null;
		st.setAtomValue(cell.element.showElement,"-");
		cell.element.style.backgroundColor = "";
		cell.element.modify = false;
	}
}

function cellEditHandler()
{	
	if(applyRight)
    {
    	$("applybtn").disabled = false;
    }		
}

function sendSetInfo()
{    
	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid,st,tc);

	if(null == xmlStr)
	{	        
        return;
	}
	
	$("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
	urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_PDHBRDATTRIB;
	loadXMLdoc(urlreq, "POST",true,setCallBack,null,"inputdata="+xmlStr);
}

function setCallBack(doc)
{
	$("querybtn").disabled = false;
    $("applybtn").disabled = true;
    
	var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
    	
		if(applyRight)
	    {
	    	$("applybtn").disabled = false;
	    }		
    }
    refreshTableState(st,tc,data);
}

function getIDs()
{
	var ids = new Array();
	for(var i=0,len=tc.getColsLength();i<len;i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}


function showErrorDialog(result)
{
    var errArr = [];
    
    var errorObj = null;
    var tmpObj = null;
    for(var i = result.getBErrLength() - 1; i >= 0; i--)
	{	
		errorObj = result.getError().rowErrors[i].errorObj;
		tmpObj =  errorObj["attrId"];
		errorObj["attrId"] = getAttrName(tc, errorObj["attrId"]);
		if (tmpObj == errorObj["attrId"])
		{
			result.getError().rowErrors.removeAt(i);
			continue;  
		}
    	errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"]+"-"+errorObj["attrId"];		
	}
	
    errArr[0] = "operationObj";
    openErrPage("../../../../page/", result.getError(), errArr);
    errArr = null;

}

/**
 *        
 * @param btnId       ID  sfid             ID
 * @return  
 */ 
function BtnRightObj(btnId,sfid)
{
	if(null != btnId)
	{
		this.btnId = btnId;
	}
	else
	{
		this.btnId = "";
	}
	
	if(isNaN(parseInt(sfid)))
	{
		this.sfid = -1;
	}
	else
	{
		this.sfid = sfid;
	}
	this.right = true;
}

/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	  var root = new inputxml("datainterface");//Create the root of a xml file
	  var firstlevel = new tagElement("bussiness-params");
	
	  var secondlevel=null;;
	  var thirdlevel=null;
	
      for(var btnrightobj in btnRightArr)
	  {
		    secondlevel = new tagElement("row-params"); //bean         	
		
		    thirdlevel = new tagElement("param");
		    thirdlevel.setAttribute("name","btnID");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		    secondlevel.appendChild(thirdlevel);
		
		    thirdlevel = new tagElement("param");	
		    thirdlevel.setAttribute("name","sfid");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		    secondlevel.appendChild(thirdlevel);
		
		    firstlevel.appendChild(secondlevel);
	  }
	  root.getRoot().appendChild(firstlevel);
	  return root.toString();
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	  var url = "../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	  loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}
/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	  var data = EncapsulateData(doc);
    
	  for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
      	var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
    	  } 
      	else
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
    	  }        
    }   
}
/**
 *         
 * @param  
 * @return  
 */
function initBtnStatue()
{	
    $("querybtn").disabled = !btnRightArr.querybtn.right;		
    applyRight = btnRightArr.applybtn.right;	
}

window.onresize=function()
{
	st.setBodyHeight(getTableHeight($("table"),st)+"px");
}

function createSetXML(neid,st,tc)
{
  var di = new inputxml("datainterface");
  var bussiness = new tagElement("bussiness-params");
  var row = null;
  var param = null;
  var colid = null;
  var key = null;
  var colkeyarray = null;
  var cellModifyFlag = false;
  var portid = null;
  var index = 0;
  var confirmed = false;
  
  for(var rowindex = 0,rowlen = st.getDataRowLength();rowindex<rowlen;rowindex++)
  {
  	if(!st.getModify(rowindex))
  	{
  		continue;
  	}
  	row = new tagElement("row-params");
  	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid); 
		row.appendChild(param);	
  	
  	for(var colindex = 0,collen = st.getColumnCount();colindex < collen;colindex++)
  	{
  		colid = tc.getColId(colindex);
  		cellModifyFlag = st.getCellModify(rowindex,colid);
  		
  		if(colid == "PDHPATH_ATTR_LOOPBACK"&&cellModifyFlag&&!confirmed)
  		{
  			if(!confirm(RESOURCE["confirmSet"] + RESOURCE["PDHPATH_ATTR_LOOPBACK"] + "?"))
			{
				return;
			}
			
			confirmed = true;
  		}
  		
  		
  		colkeyarray = tc.getColKeyArray(colindex);
  		for(var keyindex = 0,keylen = colkeyarray.length;keyindex < keylen;keyindex++)
  		{
  			param = new tagElement("param");
  			
  			key = colkeyarray[keyindex].name;
    		
    		if("neid" == key)
    		{
    			continue;
    		}

    		   		    			
    			if("portname" == key)
    			{
    				param.setAttribute("name","port")
    				var portid = st.getCellStoreValue(rowindex,colid,key);
    				index = portid.indexOf("(");
    				param.setAttribute("value",portid.substring(0,index));
    			}
    			else
    			{
    	     	param.setAttribute("name",key); 
    	     	param.setAttribute("value",st.getCellStoreValue(rowindex,colid,key));
    	    }
    		param.setAttribute("modifyFlag",cellModifyFlag); 
    		row.appendChild(param);		
    	}    		
    }
    bussiness.appendChild(row);
	} 
	if(0 == bussiness.childNodes.length)
	{
		return;
	}  
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *        ,    NE123-1-FIU-1(RX/TX)
 * @param str1 str2
 * @return int
 */
function comparePath(str1,str2)
{
	if(str1.indexOf("-") == -1 || str2.indexOf("-") == -1)
	{
		return compare(str1,str2);
	}
	str1 = str1.substring(str1.indexOf("-")+1);
	str2 = str2.substring(str2.indexOf("-")+1);
	if(str1.indexOf("-") == -1 || str2.indexOf("-") == -1)
	{
		return compare(str1,str2);
	}
	var str1Arr = str1.split("-");
	var str2Arr = str2.split("-");
	var slot1 = parseInt(str1Arr[0]);
	var port1 = parseInt(str1Arr[2].substring(0,str1Arr[2].indexOf('(')));	
	var slot2 = parseInt(str2Arr[0]);
	var port2 = parseInt(str2Arr[2].substring(0,str2Arr[2].indexOf('(')));	
	
	if(slot1 > slot2)
	{
		return 1;
	}
	else if(slot1 < slot2)
	{
		return -1;
	}
	else
	{
		if(port1 > port2)
		{
			return 1;
		}
		else if(port1 < port2)
		{
			return -1;
		}
		return 0;
	}
}

function print()
{
    if(0 == st.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    
    var par = window.parent; 
     var selectObj = par.document.getElementById("selectObj");
   
    openPrintPage("../../../../page/", selectObj.options[selectObj.selectedIndex].innerText, "st");
}

function save()
{
    if(st.getDataRowLength()<=0)
    {
    	alert(RESOURCE["nodata"]);
    	return;
    }
    
    var par = window.parent; 
    var selectObj = par.document.getElementById("selectObj");
   
    openSaveAsPage("../../../../page/", selectObj.options[selectObj.selectedIndex].innerText, "st");
}
