var st = null;
var btnRightArr = new Object();
var winobj = getNeProperty(self);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var vc12FrameFormat = [];
vc12FrameFormat[0] = "vc12FrameFormat_0";
vc12FrameFormat[1] = "vc12FrameFormat_1";
vc12FrameFormat[2] = "vc12FrameFormat_2";

var vc12Loop = [];
vc12Loop[0] = "notLoopBack";
vc12Loop[1] = "inLoopBack";
vc12Loop[2] = "outLoopBack";

var convertClockMode = [];
convertClockMode[0] = "convertClockMode_0";
convertClockMode[1] = "convertClockMode_1";
var isNotSupportLoopback = SpecialAttrMgr.isCPSupport(neid, winobj.slotid,"TE_FUNC_SDH_PATH_CONFIG","ETH_ATTR_PATHCONFIG_NOT_SUPPORT_LOOPBACK");
var isNotSupportClockMode = SpecialAttrMgr.isCPSupport(neid, winobj.slotid,"TE_FUNC_SDH_PATH_CONFIG","ETH_ATTR_PATHCONFIG_SUPPORT_RETIMING_VC12");
function init()
{   
    st = new SortTable();
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());

    st.setOnCellEditHandler(cellEditHandler);
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
	$("tbdiv").oncontextmenu = popupMenuHandler;
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    initRight();
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("applybtn").disabled = true;
	
	if(btnRightArr.querybtn.right)
	{
	    doQuery();
	}
}


function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_CMD_SDH_GET_E1FRM_VC12);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_CMD_SDH_SET_E1FRM_VC12);
    getRightInfo(winobj, btnRightArr);
}

function cellEditHandler()
{
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("slotid", winobj.slotid));
    rowparams.appendChild(createTagElement("port", "0"));
    rowparams.appendChild(createTagElement("highpath", "0"));
    rowparams.appendChild(createTagElement("lowpath", "0"));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function doQuery()
{
    if ($("querybtn").disabled) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../neExlorerServlet?sfid=" + TE_CMD_SDH_GET_E1FRM_VC12 + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addMyEvent();
    }
}

function addMyEvent()
{
	var cell = null;
	
	for(var i = 0,len = st.getDataRowLength();i<len;i++)
	{
            cell = st.getCellEdit(i, "vc12frameformat");
            if (null != cell) 
            {
                cell.element["onchange"] = function()
                {
                    e1FrmChanged(this);
                }

                var e1FrmModeCell = st.getCell(i, "framemode");
                var vc12frameformat = st.getCellStoreValue(i, "vc12frameformat", "vc12frameformat");
                if (vc12frameformat == 0)
                {
                    st.setCellIsEdit(e1FrmModeCell, false);
                    var cellShow = st.getCellShow(i, "framemode");
                    cellShow.setValue("-");
                }
                else 
                {
                	st.setCellIsEdit(e1FrmModeCell, true);
                }
            }
            
            cell = st.getCell(i, "vc12loop");
            if( null != cell )
            {
            	if (isNotSupportLoopback)
            	{
            		setCellEdit(cell, "vc12loop", 255, "-", false);
            	}
            	else
            	{
            		var cellShow = st.getCellShow(i, "vc12loop");
                    cellShow.setValue("/");
            	}  
            }
	    cell = st.getCell(i, "clockmode");
            if( null != cell )
            {
            	if (!isNotSupportClockMode)
            	{
            		setCellEdit(cell, "clockmode", 255, "-", false);
            	}
            	  
            } 
    }
}

function setCellEdit(cell, colId, defaultValue, defaultShow, isEdit)
{
    st.setCellIsEdit(cell, isEdit);
    
    if (isEdit == 0) 
    {
        cell.element.modify = false;
        cell.element.ondblclick = null;
        cell.element.style.backgroundColor = "";
    }
    else 
    {
        cell.element.modify = false;
        cell.element.ondblclick = cellondbclick;
        cell.element.style.backgroundColor = "#d0f946";
    }
    
    st.setCellValue(cell, colId, defaultValue);
    st.setAtomValue(cell.element.showElement, defaultShow);
}

function e1FrmChanged(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var e1FrmModeCell = st.getCell(rowindex, "framemode");
    var e1FrmMode = atom.value;
    if (e1FrmMode == 0)
    {
        setCellEdit(e1FrmModeCell, "framemode", 255, "-", false);
    }
    else 
    {
    	var storevalue = st.getCellStoreValue(rowindex, "framemode", "framemode");
    	if( storevalue == null || storevalue == "" || storevalue == "undefined" || storevalue == "255" )
    	{
    		storevalue = "30";
    	}
        setCellEdit(e1FrmModeCell, "framemode", storevalue, storevalue, true);
    }
}

function createSetXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, size = st.getDataRowLength(); i < size; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var obj = st.getCellShow(i, "obj").element.innerHTML;
        var port = st.getCellStoreValue(i, "obj", "portname");
        var highPath = st.getCellStoreValue(i, "obj", "highpath");
        var lowPath = st.getCellStoreValue(i, "obj", "lowpath");
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("slotid", winobj.slotid));
        rowparams.appendChild(createTagElement("port", port.substring(0, port.indexOf("("))));
        rowparams.appendChild(createTagElement("sdhport", port.substring(0, port.indexOf("("))));
        rowparams.appendChild(createTagElement("highpath", highPath.split(":")[1]));
        rowparams.appendChild(createTagElement("lowpath", lowPath.split(":")[1]));
        rowparams.appendChild(createTagElement("obj", obj));
        
        if (st.getCellModify(i, "vc12frameformat")) 
        {
            var vc12frameformat = st.getCellStoreValue(i, "vc12frameformat", "vc12frameformat");
            rowparams.appendChild(createTagElement("vc12frameformat", vc12frameformat));

            st.getCell(i, "framemode").element.modify = true;
        }
        
        if (st.getCellModify(i, "framemode")) 
        {
        	var vc12_format = st.getCellStoreValue(i, "vc12frameformat", "vc12frameformat");
        	var framemode;
        	if( vc12_format != "0" )
        	{
        		framemode = st.getCellStoreValue(i, "framemode", "framemode");
        		rowparams.appendChild(createTagElement("framemode", framemode));
        	}
        }
        
        if (st.getCellModify(i, "vc12loop")) 
        {
            var vc12mode = st.getCellStoreValue(i, "vc12loop", "vc12loop");
            rowparams.appendChild(createTagElement("vc12loop", vc12mode));
        }
	if (st.getCellModify(i, "clockmode")) 
        {
            var clockmode = st.getCellStoreValue(i, "clockmode", "clockmode");
            rowparams.appendChild(createTagElement("clockmode", clockmode));
            
        }
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doSet()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createSetXml();
    var url = "../../../../neExlorerServlet?sfid=" + TE_CMD_SDH_SET_E1FRM_VC12 + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, setCallBack, null, "inputdata=" + xml);
}


function setCallBack(doc)
{
    $("querybtn").disabled = false;
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;
    }
    refreshTableState(st, window.tableconf[0], data);
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "obj";
    openErrPage("../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
}
