var winobj = getNeProperty(parent);
var routewayTable;
var routwayid = 0;
var availablePort;
var ROUTWAY_NUM = 2;
var F1ROUTEWAY = "F1";
var DEFAULT_BOARDID = -1;
var publicboardid;
var availablePortData;
var routewayTableData;

var ExistDataId = [];

loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/orderwire/f1datarouteway_" + SYSTEMCONF.getLanguage() + ".xml");
loadXMLdoc("../../conf/orderwire/f1dataroutewaytable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

var btnRightArr = new Object();

function initBody()
{
    $("availablePortTitle").appendChild(document.createTextNode(RESOURCE["availablePortTitle"]));
    initTable();
    initButton();
    
    var url = "../../../../neExlorerServlet?sfid=" + Query_Public_Board +
    "&nmUser=" +
    winobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackPublicBoardData, null, "inputdata=" +
    queryXMLInfo());
    
    queryData();
    
}

function tabSelectHandler()
{
	if(btnRightArr.queryBtn.right)
	{
        queryData();
    }
}

function queryData()
{
    queryAvailablePort();
    if (publicboardid < 0) 
    {
        return;
    }
    
    queryRouteway();
    fillAvailablePort(availablePortData);
    addDataToRoutewayTable(routewayTableData);
    availablePort = document.getElementById("availablePort");
    compareData(availablePort, routewayTable);
}

function callbackPublicBoardData(doc)
{
    var data = EncapsulateData(doc);
    if ((data.getSErrorCode() == 0 || data.getSErrorCode() == 1) &&
    publicboardid != DEFAULT_BOARDID) 
    {
        publicboardid = data.getDataRowParam(0, "publicboardid");
    }
    else 
    {
        $("queryBtn").disabled = true;
        $("applyBtn").disabled = true;
    }
}

function queryXMLInfo()
{
    var queryXMLInfo = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winobj["neid"]);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    queryXMLInfo.getRoot().appendChild(bussiness);
    return queryXMLInfo.toString();
}

function initTable()
{
    routewayTable = new SortTable();
    routewayTable.setImage("../../../../images/");
    routewayTable.setBodyHeight("400px");
    routewayTable.isUsedForSelectList = true;
    createTableHead(routewayTable, window.tableconf[0]);
    document.getElementById("routewaytable").appendChild(routewayTable.getTable());
}

function initButton()
{
    btnRightArr.queryBtn = new BtnRightObj("queryBtn", Query_Routeway);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn", Set_Routeway);
    getRightInfo(winobj, btnRightArr);
    $("queryBtn").value = RESOURCE["queryBtn"];
    $("applyBtn").value = RESOURCE["applyBtn"];
}

function queryAvailablePort()
{
    var url = "../../../../neExlorerServlet?sfid=" + Query_Available_Port + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackAvailablePortData, null, "inputdata=" + queryXMLInfo());
}

function callbackAvailablePortData(doc)
{
    var data = EncapsulateData(doc);
    var errObj = null;
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        availablePortData = data;
    }
}

function fillAvailablePort(data)
{
    availablePort = document.getElementById("availablePort");
    for (var i = availablePort.size - 1; i >= 0; i--) 
    {
        availablePort.remove(i);
    }
    var value;
    var text;
    var option;
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        value = data.getDataRowParam(i, "availableport");
        var valueArr = value.split("-");
        var tmpSlotID = valueArr[0];
        var isNotSupport = SpecialAttrMgr.isCPNotSupport(winobj["neid"], tmpSlotID, "TE_FUNC_WEBLCT_ORDERWIRE", "SDH_ATTR_NOTSUPPORT_ORDERWIRE_F1_BD");
        if (value.indexOf("EFT") < 0 && value.indexOf("EMS") < 0 && value.indexOf("EFP6") < 0 && !isNotSupport) // F1 don't support EFT board
        {
            option = new Option(value, "availableport");
            addOptionToSelect(availablePort, option);
        }
    }
    
    option = new Option(F1ROUTEWAY, "availableport")
    addOptionToSelect(availablePort, option);
}

function queryRouteway()
{
    $("queryBtn").disabled = true;
	$("applyBtn").disabled = true;
    var url = "../../../../neExlorerServlet?sfid=" + Query_Routeway + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackQueryRoutewayData, null, "inputdata=" + createQueryRoutewayXMLInfo());
}

function createQueryRoutewayXMLInfo()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", publicboardid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function callbackQueryRoutewayData(doc)
{
    var data = EncapsulateData(doc);
    var errorObj = null;
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        routewayTable.clearTableData();
        routewayTableData = data;
        ExistDataId = [];
    }
    else 
    {
        errorObj = [];
        errorObj.push("");
    }
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    showOperResult(data, errorObj);
}


function refreshExistDataId()
{
	ExistDataId.clear();
	for (var i = 0, len = routewayTable.getDataRowLength(); i < len; i++) 
  {
  	var routwayid = routewayTable.getCellStoreValue(i, "routwayid", "routwayid");
  	ExistDataId.push(routwayid);
  }
}
function addDataToRoutewayTable(data)
{
    var obj = null;
    var tag = null;
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        obj = new Object();
        
        var tag = new ParamTag();
        tag.value = data.getDataRowParam(i, "routwayid");
        ExistDataId.push(data.getDataRowParam(i, "routwayid"));
        
        obj["routwayid"] = tag;
        var tag = new ParamTag();
        tag.value = data.getDataRowParam(i, "firstdatarouteway");
        obj["firstdatarouteway"] = tag;
        var tag = new ParamTag();
        tag.value = data.getDataRowParam(i, "seconddatarouteway");
        obj["seconddatarouteway"] = tag;
        
        data.rows[i] = obj;
    }

    createTableBody(routewayTable, window.tableconf[0], data, RESOURCE);
    
    adjustRoutewayTable(routewayTable);
}

function addRouteway()
{
    availablePort = document.getElementById("availablePort");
    var selectedRowIndex = [];
    var selectedRowNum = 0;
    if (availablePort.options.selectedIndex == -1) 
    {
        alert(RESOURCE["twoRoutewaySelected"]);
        $("moveToRightBtn").disabled = false;
        return;
    }
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    for (var i = 0, len = availablePort.options.length; i < len; i++) 
    {
        if (availablePort.options[i].selected) 
        {
            selectedRowNum++;
            selectedRowIndex[selectedRowIndex.length] = i;
        }
    }
    if (selectedRowNum != 2) 
    {
        selectedRow = [];
        alert(RESOURCE["twoRoutewaySelected"]);
        return;
    }
    addToRoutewayTable(availablePort, routewayTable, selectedRowIndex);
}

function addToRoutewayTable(availablePort, routewayTable, selectedRowIndex)
{
    var dataInterface = new DataInterface();
    var obj = new Object();
    
    var para = new ParamTag();
    para.value = (routewayTable.getDataRowLength() + 1) + "";
    obj["routwayid"] = para;
    
    para = new ParamTag();
    para.value = availablePort.options[selectedRowIndex[0]].text;
    obj["firstdatarouteway"] = para;
    para = new ParamTag();
    para.value = availablePort.options[selectedRowIndex[1]].text;
    obj["seconddatarouteway"] = para;
    dataInterface.rows[0] = obj
    
    availablePort.remove(selectedRowIndex[1]);
    availablePort.remove(selectedRowIndex[0]);
    
    createTableBody(routewayTable, window.tableconf[0], dataInterface, RESOURCE);
    routewayTable.adjustDataRows();
    
    if (!routewayTable.element.colsArray.selectedId) 
    {
        routewayTable.element.colsArray.selectedId = "routwayid";
        routewayTable.element.colsArray.imgflag = 1;
    }
    var td = routewayTable.element.headRow.element.cols[routewayTable.element.colsArray.selectedId].element;
    routewayTable.sortRows(td, routewayTable.element.colsArray.imgflag);
    
    selectedRowIndex = [];
}

function sortAvailablePort()
{
    var t_availablePort = document.getElementById("availablePort");
    var t_text;
    var t_value;
    var t_option;
    var tobject_availablePort = [];
    var tobject_port = 0;
    var t_slotid;
    var t_portid;
    var t_boardmap;
    var t_arr;
    
    var hasF1Flg = false;
    for (i = t_availablePort.options.length - 1; i >= 0; i--) 
    {
        t_option = t_availablePort.options[i];
        t_text = t_option.text;
        
        if (t_text != "F1") 
        {
            t_arr = t_text.split("-");
            t_slotid = t_arr[0];
            t_portid = t_arr[2];
            t_boardmap = t_arr[1];
            
            tobject_port = new TEPort(t_slotid, t_portid, t_boardmap);
            tobject_availablePort.push(tobject_port);
        } else {
            hasF1Flg = true;
        }
        
        t_availablePort.remove(i);
    }
    
    tobject_availablePort.sort(sortfun);
    
    for (var i = 0; i < tobject_availablePort.length; i++) 
    {
        t_value = tobject_availablePort[i].slotid + "-" +
        tobject_availablePort[i].boardmap +
        "-" +
        tobject_availablePort[i].portid;
        t_option = new Option(t_value, "availableport");
        addOptionToSelect(t_availablePort, t_option);
    }
    
    if(hasF1Flg)
    {
        t_option = new Option(F1ROUTEWAY, "availableport")
        addOptionToSelect(t_availablePort, t_option);  
    } 
}

function deleteRouteway()
{
    var availablePort = document.getElementById("availablePort");
    var selectedRows = routewayTable.getSelectedRows();
    if (selectedRows.length == 0) 
    {
        alert(RESOURCE["selectRouteway"]);
        return;
    }
    
    for (var i = selectedRows.length - 1; i >= 0; i--) 
    {
        var insertValue = routewayTable.getCellStoreValue(selectedRows[i], "firstdatarouteway", "firstdatarouteway");
        var option = new Option(insertValue, insertValue);
        addOptionToSelect(availablePort, option);
        var insertValue = routewayTable.getCellStoreValue(selectedRows[i], "seconddatarouteway", "seconddatarouteway");
        var option = new Option(insertValue, insertValue);
        addOptionToSelect(availablePort, option);
        routewayTable.deleteRow(selectedRows[i]);
    }
    routewayTable.adjustDataRows();
    adjustRoutewayTable(routewayTable);
    
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    sortAvailablePort();    
}

function adjustRoutewayTable(routewayTable)
{
    var len = routewayTable.getDataRowLength();
    if (len == 0) 
    {
        return;
    }
    for (var i = 0; i < len; i++) 
    {
        var routwayid = i + 1;
        routewayTable.setAtomValue(routewayTable.getCell(i, "routwayid").element.showElement, routwayid);
        routewayTable.setCellValue(routewayTable.getCell(i, "routwayid"), "routwayid", routwayid);
    }
    routewayTable.adjustDataRows();
}

function setRouteway()
{
    $("applyBtn").disabled = true;
    var url = "../../../../neExlorerServlet?sfid=" + Set_Routeway + "&nmUser=" +
    winobj["nmUser"];
    var xml = createSetRoutewayXMLInfo();
    if(xml != null)
    {
    	loadXMLdoc(url, "POST", false, callbackSetRoutewayData, null, "inputdata=" + xml);
  	}
}

function createSetRoutewayXMLInfo()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
   	for(var i = 0,m = ExistDataId.length;i < m;i++)
	  {
	  		row = getDeleteRoutWay(ExistDataId[i]);
	  		bussiness.appendChild(row);
	  }
    for (var i = 0, len = routewayTable.getDataRowLength(); i < len; i++) 
    {
    	var rid = routewayTable.getCellStoreValue(i, "routwayid", "routwayid");
      row = new tagElement("row-params");
      
      param = new tagElement("param");
      param.setAttribute("name", "neid");
      param.setAttribute("value", winobj["neid"]);
      row.appendChild(param);
      
      param = new tagElement("param");
      param.setAttribute("name", "slotid");
      param.setAttribute("value", publicboardid);
      row.appendChild(param);
      
      var routewayRow = routewayTable.getRow(i);
      
      
      param = new tagElement("param");
      param.setAttribute("name", "routwayid");
      param.setAttribute("value", parseInt(rid));
      row.appendChild(param);
      
      var firstRouteway = routewayTable.getCellStoreValue(i, "firstdatarouteway", "firstdatarouteway");
      if (firstRouteway == F1ROUTEWAY) 
      {
          var firstslotid = 255;
          var firstportid = 0;
      }
      else 
      {
          var firstRoutewayList = firstRouteway.split("-");
          var firstslotid = parseInt(firstRoutewayList[0]);
          var firstportid = parseInt(firstRoutewayList[2]);
      }
      param = new tagElement("param");
      param.setAttribute("name", "firstslotid");
      param.setAttribute("value", firstslotid);
      row.appendChild(param);
      param = new tagElement("param");
      param.setAttribute("name", "firstportid");
      param.setAttribute("value", firstportid);
      row.appendChild(param);
      
      param = new tagElement("param");
      param.setAttribute("name", "firstdatarouteway");
      param.setAttribute("value", routewayTable.getCellShow(i, "firstdatarouteway").getValue());
      row.appendChild(param);
      
      param = new tagElement("param");
      param.setAttribute("name", "seconddatarouteway");
      param.setAttribute("value", routewayTable.getCellShow(i, "seconddatarouteway").getValue());
      row.appendChild(param);
      
      var secondRouteway = routewayTable.getCellStoreValue(i, "seconddatarouteway", "seconddatarouteway");
      if (secondRouteway == F1ROUTEWAY) 
      {
          var secondslotid = 255;
          var secondportid = 0;
      }
      else 
      {
          var secondRoutewayList = secondRouteway.split("-");
          var secondslotid = parseInt(secondRoutewayList[0]);
          var secondportid = parseInt(secondRoutewayList[2]);
      }
      param = new tagElement("param");
      param.setAttribute("name", "secondslotid");
      param.setAttribute("value", secondslotid);
      row.appendChild(param);
      param = new tagElement("param");
      param.setAttribute("name", "secondportid");
      param.setAttribute("value", secondportid);
      row.appendChild(param);
      
      bussiness.appendChild(row);
	  }

		if(bussiness && bussiness.childNodes.length > 0)
		{
			root.getRoot().appendChild(bussiness);
			return root.toString();
		}
    else
    {
    	return null;
    }
    
}

function getDeleteRoutWay(rid)
{
  var row = new tagElement("row-params");
  
  var param = new tagElement("param");
  param.setAttribute("name", "neid");
  param.setAttribute("value", winobj["neid"]);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "slotid");
  param.setAttribute("value", publicboardid);
  row.appendChild(param);
  
  var routwayid = 1;
  param = new tagElement("param");
  param.setAttribute("name", "routwayid");
  param.setAttribute("value", rid);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "firstslotid");
  param.setAttribute("value", 0);
  row.appendChild(param);
  param = new tagElement("param");
  param.setAttribute("name", "firstportid");
  param.setAttribute("value", 0);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "secondslotid");
  param.setAttribute("value", 0);
  row.appendChild(param);
  param = new tagElement("param");
  param.setAttribute("name", "secondportid");
  param.setAttribute("value", 0);
  row.appendChild(param);
  return row;
}

function callbackSetRoutewayData(doc)
{
    var data = EncapsulateData(doc);
    refreshTableState(routewayTable, window.tableconf[0], data);
    if (0 != data.getSErrorCode()) 
    {
        $("applyBtn").disabled = true;
    }
    else
    {
    	refreshExistDataId();
    }
    showOperResult(data);
}

function showOperResult(data, errArr)
{
    if (null == errArr) 
    {
        errArr = [];
        errArr[0] = "nename";
    }
    openErrPage("../../../../page/", data.getError(), errArr);
}

function compareData(selectData, tableData)
{
    for (var i = 0, tblen = tableData.getDataRowLength(); i < tblen; i++) 
    {
        for (var j = 0, len = selectData.options.length; j < len; j++) 
        {
            if ((tableData.getCellStoreValue(i, "firstdatarouteway", "firstdatarouteway") ==
            selectData.options[j].text) ||
            (tableData.getCellStoreValue(i, "seconddatarouteway", "seconddatarouteway") ==
            selectData.options[j].text)) 
            {
                selectData.remove(j);
                j = j - 1;
                len--;
            }
        }
    }
}

function TEPort(slotid, portid, boardmap)
{
    this.slotid = slotid;
    this.portid = portid;
    this.boardmap = boardmap;
}

TEPort.prototype.toString = function()
{
    return this.boardmap;
}

function sortfun(a, b)
{
    if (a.slotid > b.slotid) 
    {
        return 1;
    }
    else if (a.slotid < b.slotid) 
    {
        return -1;
    }
    else if (a.portid > b.portid) 
    {
        return 1;
    }
    else if (a.portid <= b.portid) 
    {
        return -1;
    }
}
