
loadXMLdoc("../../../../../conf/system.xml", "GET", false,EncapsulateSConf);
loadXMLdoc("../../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);

getResourse("../../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml"); 
getResourse("../../../res/ohpbytemgr/ohpbytemgr_"+ SYSTEMCONF.getLanguage() +".xml"); 

var winurlobj = getNeProperty(self);
var netype = winurlobj.neType;

if (isRTN900NEtype(netype))
{
	loadXMLdoc("../../../conf/ohpbytemgr/vc12ohpbyte/rtn900_ohpbytev5table_" + SYSTEMCONF.getLanguage() +".xml", "GET", false, EncapsulateTable);
}
else
{
	loadXMLdoc("../../../conf/ohpbytemgr/vc12ohpbyte/ohpbytev5table_" + SYSTEMCONF.getLanguage() +".xml", "GET", false, EncapsulateTable);
}

var ohpbytev5 = [];
ohpbytev5[0] = RESOURCE["unequippedv5"];
ohpbytev5[1] = RESOURCE["reserved01v5"];
ohpbytev5[2] = RESOURCE["TUGStructurev5"];
ohpbytev5[3] = RESOURCE["lockedTUv5"];
ohpbytev5[4] = RESOURCE["intoc3v5"];
ohpbytev5[5] = RESOURCE["mappingv5"];
ohpbytev5[6] = RESOURCE["intoc4v5"];
ohpbytev5[7] = RESOURCE["atmMappingv5"];

ohpbytev5[8] = RESOURCE["dqdbMappingv5"];
ohpbytev5[9] = RESOURCE["fddiMappingv5"];
ohpbytev5[10] = RESOURCE["pppMappingv5"];
ohpbytev5[11] = RESOURCE["purpose17v5"];
ohpbytev5[12] = RESOURCE["lapsMappingv5"];
ohpbytev5[13] = RESOURCE["purpose19v5"];

var vc4level = [];
vc4level[1] = "VC4:1";
vc4level[2] = "VC4:2";

var vc12level = [];
for (var i=1;i<=63;i++)
{
	vc12level[i] = "VC12:"+i;
}
function convertvc4name(id)
{
	return "VC4:"+id;
}
function convertvc12name(id)
{
	return "VC12:"+id;
}
var BOARDTYPE_IFH2 = 1548;
var hasApplyRight = true;
var tabflag = false;

var isBack = true;
var lastData = new DataInterface();
var currentData = new DataInterface();

function tabSelectHandler()
{
	if(!tabflag)
	{
		initpage();
	}
	tabflag = true;
}

function initpage()
{
	$("textdisplay").innerHTML = RESOURCE["text"];
	$("hexdisplay").innerHTML = RESOURCE["hex"];
	$("querybtn").value=RESOURCE["querybutton"];
	$("applybtn").value=RESOURCE["applybutton"];
	$("backbtn").value=RESOURCE["backbtn"];
	$("backbtn").disabled = true;

	
	$("text").disabled = true;
	$("hex").disabled = true;
	$("textdisplay").disabled = true;
	$("hexdisplay").disabled = true;
	
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setBodyHeight("240");
    tc = window.tableconf[0];
    var supportAttr = winurlobj["supportAttr"].split(",");
    
    filterAttrCol(tc,supportAttr);

    createTableHead(st, tc);
    $("tablecomponent").appendChild(st.getTable());
    
    st.setOnCellEditHandler(cellEditHandler);

    $("tablecomponent").oncontextmenu=popupMenuHandler;
    
    var hc=st.getHeadCell("object");
    st.setHCAttribute(hc,1,1,comparePath);
    
    sendRightInfo();
    
    if(!$("querybtn").disabled)
    {
    	sendQueryInfo();
    }
}


function sendQueryInfo()
{
	$("querybtn").disabled = true;
  $("applybtn").disabled = true;
  $("backbtn").disabled = true;
    
  isBack = true;
  
    flag = true;
    var neid = getNeProperty(self).neid;
    var slotid = getNeProperty(self).slotid;
    
    var xmlstr = createQueryXML(neid,slotid,tc);

    urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_GETSDHLOWOVERHEADATTR+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,queryCallBack,null,"inputdata="+xmlstr);
}

function queryCallBack(doc)
{
	  $("querybtn").disabled = false;
    
	  	  $("backbtn").disabled = true;
	 var data;
	 if(doc.nodeName!=null)//
    {
    	data = EncapsulateData(doc);
    	
    	currentData = data;

    	lastData.rows = currentData.cloneRows();
	 		lastData.errObj = currentData.errObj;
	  	lastData.page = currentData.page; 
    }
    else//
    {
    	 data = doc;	
    }

	flag = false;
	$("backbtn").disabled = true;

	  createGenCfgTableBody(st, tc, data, RESOURCE);
	  isBack = true;

		if(data.getSErrorCode() == 0)
    {
        return;
    }
    
    if(doc.nodeName!=null)
    {
       showErrorDialog(data);
    }


}

function sendSetInfo()
{
	  if(!confirm(RESOURCE["confirmset"]))
	  {
		  return;
	  }
	  $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var neid = getNeProperty(self).neid;
    var xmlstr = createSetXML(neid,st,tc);
    
    
    if(null == xmlstr)
    {
    	$("querybtn").disabled = false;
    	return;
    }
    
    $("backbtn").disabled = true;
    isBack = true;

    
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_SETSDHLOWOVERHEADATTR+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,setCallBack,null,"inputdata="+xmlstr);
}

/**
 *         
 */
function setCallBack(doc)
{
	  $("querybtn").disabled = false;
    
	  var data = EncapsulateData(doc);  
    refreshTableState(st,tc,data);
    
    if(data.getSErrorCode() != 2)
    {
    	$("backbtn").disabled = false;
	
	  	if(data.getSErrorCode() == 0)
	  	{
	  	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	  	{
	  		 for ( var j = 0, size = tc.getColsLength(); j < size; j++)
	  		 {
	  		 	  if (st.getCell(i, tc.getColId(j)).element.isEdit == 1)
					{
						st.getCellElement(i, tc.getColId(j)).style.background = "#ffffff";
					}
	  		 }
	  	}

    		return;
    	}
    }
    showErrorDialog(data);
    
    if(data.getSErrorCode() == 2)
    {
    	 $("applybtn").disabled = false;
    }
}


function showErrorDialog(data)
{
    var errArr = [];
    
    var errorObj = null;
    for(var i = data.getBErrLength()-1;i>=0;i--)
	{	
		errorObj = data.getError().rowErrors[i].errorObj;
		if(errorObj["attrId"] == "grade"||errorObj["attrId"] == "highpathid"&&data.getError().rowErrors[i].error.code!="37926")
		{
			data.getError().rowErrors.removeAt(i);
			continue;
		}
		errorObj["attrId"] = getAttrName(tc,data.getError().getRowKey(i,"attrId"));
		if(data.getError().rowErrors[i].error.code=="37926")
		{
			errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"];
		}
		else 
		{
    		errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"]+"-" + VC4Convert(errorObj["portname"])+"-"+errorObj["attrId"];
		}
	}
	
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    errArr = null;
}

/**
 *               
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if(hasApplyRight)
	{
		$("applybtn").disabled = false; 
	}
}

function createSetXML(neid,st,tc)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    var portid = null;
    var index = 0;
    var port = null;
    var mdband;
    var wave1;
    var wave2;
    var temp;
    
    lastData = new DataInterface();
	  lastData.rows = currentData.cloneRows();
	 	lastData.errObj = currentData.errObj;
	  lastData.page = currentData.page;


    for(var rowindex = 0,rowlen = st.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!st.getModify(rowindex))
    	{
    		continue;
    	}
    	row = new tagElement("row-params");
    	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid); 
		row.appendChild(param);	
    	for(var colindex = 0,collen = st.getColumnCount();colindex<collen;colindex++)
    	{
    		colid = tc.getColId(colindex);
    		cellModifyFlag = st.getCellModify(rowindex,colid);
    		colkeyarray = tc.getColKeyArray(colindex);
    		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
    		{
    			param = new tagElement("param");
    			
    			key = colkeyarray[keyindex].name;
    			
    			if("portname" == key)
    			{
    				param.setAttribute("name","port");
    				port = st.getCellStoreValue(rowindex,colid,key);
    				param.setAttribute("value",port.substring(0,port.indexOf("(")));
    				row.appendChild(param);
    				
    				continue;
    			}

    			param.setAttribute("name",key);
    			
    			if(currentData.rows[rowindex][key]!=null)
    			{
    				currentData.rows[rowindex][key].value = st.getCellStoreValue(rowindex, colid, key);
    			}

    		  param.setAttribute("value",st.getCellStoreValue(rowindex,colid,key));

    			param.setAttribute("modifyFlag",cellModifyFlag); 
    			row.appendChild(param);		
    		}    		
    	}
    	bussiness.appendChild(row);
    } 
    if(0 == bussiness.childNodes.length)
    {
    	alert(RESOURCE["nochange"]);
    	return;
    }  
    
     isBack = true;
   	 $("backbtn").value=RESOURCE["backbtn"];

     di.getRoot().appendChild(bussiness);
     return di.toString();
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	var url = "../../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","querybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",TECMDCODE_GETSDHLOWOVERHEADATTR);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","applybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",TECMDCODE_SETSDHLOWOVERHEADATTR);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
		
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
    
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
    	var right = data.getDataRowParam(i,"right");
    	
    	if(0 == right)
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = true;
    		if(data.getDataRowParam(i,"btnID") == "applybtn")
    		{
    		    hasApplyRight = false;
    		}
    	} 
    	else
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = false;
    	}        
    }   
}
     window.onresize=function()
     {
	    st.setBodyHeight(getTableHeight($("tablecomponent"),st)+"px");
     }
 
 function comparePath(str1,str2)
{
   var tmp1;
   var tmp2;
   
   if (str1.charAt(str1.length-3) == '-') //-5)  ;
   {
       tmp1=parseInt(str1.substring(str1.length-2,str1.length-1));    
   }
   else
   {
       tmp1=parseInt(str1.substring(str1.length-3,str1.length-1));  
   }
   
   if (str2.charAt(str2.length-3) == '-') //-5)  ;
   {
       tmp2=parseInt(str2.substring(str2.length-2,str2.length-1));
   }
   else
   {
       tmp2=parseInt(str2.substring(str2.length-3,str2.length-1));
   }

   return compare(tmp1,tmp2);        
}



function goBack()
{
	if(isBack)
	{
	  queryCallBack(lastData);

  	isBack = false;
		$("backbtn").value=RESOURCE["forwordbtn"]
		$("applybtn").disabled = false;
		
		for (var i = 0; i < lastData.getDataRowLength(); i++) 
   {
       var row = lastData.rows[i];
       for(var p in row)
			{
			 		var lastObj = row[p];
			 		var currentObj = currentData.rows[i][p];
			 		if(lastObj.value != currentObj.value)
			 		{
			 			var cell = st.getCell(i,p);
			 			if(cell!=null)
			 			{
	    				cell.element.style.backgroundColor = "#d0f946";
	    				st.setCellModify(i, p,true);
	    				st.element.datarows[i].element.modify = true;
	    			}
	    		
			 		}
			 }
   }

  }
  else
  {	
  	queryCallBack(currentData);
 		isBack = true;
  	$("backbtn").value=RESOURCE["backbtn"]
  	$("applybtn").disabled = true;
  }
   
  $("backbtn").disabled = false;
  
}
function VC4Convert(port)
{
	if(winurlobj.boardType == BOARDTYPE_IFH2)
	{
		var portid = port.substring(0,port.indexOf("("));
		var vc4level = 1;
		var vc12level = portid;
		if(parseInt(portid) > 63)
		{
			vc4level = 2;
			vc12level = portid - 63;
		}
		port = "1(SDH-1)-VC4:" + vc4level + "-VC12:" + vc12level;
	}
	return port;
}
