
var clockidst;
var portmode = new Object();
portmode[0] = RESOURCE["extclock1"];
portmode[1] = RESOURCE["extclock2"];
portmode[2] = RESOURCE["exttime1"];
portmode[3] = RESOURCE["exttime2"];
portmode[4] = RESOURCE["mon"];
portmode[5] = RESOURCE["orderwire"];
portmode[6] = RESOURCE["s1f1"];
portmode[7] = RESOURCE["debugger"];
portmode[8] = RESOURCE["outextclock"];
portmode[9] = RESOURCE["exts1"];
portmode[10] = RESOURCE["mon2"];
portmode[11] = RESOURCE["sixteenthe1"];

var btnRightArr = new Object();

var neobject = getNeProperty(self);
  

function init()
{
    $("querybtn").value = RESOURCE["query"];
    $("applybtn").value = RESOURCE["apply"];
    
    clockidst = new SortTable();
    clockidst.setImage("../../../../images/");
    createTableHead(clockidst, window.tableconf[0]);
    
    document.getElementById("autoacross").appendChild(clockidst.getTable());
    clockidst.setBodyHeight(getTableHeight($("autoacross"), clockidst) + "px");
    $("autoacross").oncontextmenu = popupMenuHandler;
    clockidst.setOnCellEditHandler(cellEditHandler);
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_TOP_CLOCKDOMAIN);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_TOP_CLOCKDOMAIN);
    
    getRightInfo(neobject, btnRightArr);
    
    initrightbtn(btnRightArr);
    
    $("applybtn").disabled = true;
    
    
    if (btnRightArr.querybtn.right) 
    {
        query();
    }    
}

function query()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_MULTIPORTMODE + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, callbackQuery, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    var neidvalue = getNeProperty(self).neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    


    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function callbackQuery(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return;
    }
    
    clockidst.clearTableData();
    
    createTableBody(clockidst, window.tableconf[0], data, RESOURCE);
    
    clockidst.setOnCellEditHandler(cellEditHandler);
}

function cellEditHandler(param)
{
	if (btnRightArr.applybtn.right) 
    {
        $("applybtn").disabled = false;
    } 
	 
    var colid = param.colid;
    var st = param.st;
    var rowindex = param.rowindex;
    
    var portNameValue = st.getCellStoreValue(rowindex, "clockname", "portname");
    var valArray = portNameValue.split('(');
    var isPort1Flag = false
    if( valArray.length > 0 && valArray[0] == "1" )
    {
    	isPort1Flag = true;
    }
    
	var portModeElm = st.getCellEdit(rowindex, "portmode").element;
	portModeElm.options.length = 0;
    
    if ( neobject.neType == "114" && colid == "portmode" && isPort1Flag )
    {
		portModeElm.options[0] = new Option(RESOURCE["extclock1"], '0');
		portModeElm.options[1] = new Option(RESOURCE["extclock2"], '1');
		portModeElm.options[2] = new Option(RESOURCE["exttime1"], '2');
		portModeElm.options[3] = new Option(RESOURCE["exttime2"], '3');
		portModeElm.options[4] = new Option(RESOURCE["orderwire"], '5');
		portModeElm.options[5] = new Option(RESOURCE["s1f1"], '6');
		portModeElm.options[6] = new Option(RESOURCE["debugger"], '7');
		portModeElm.options[7] = new Option(RESOURCE["outextclock"], '8');
		portModeElm.options[8] = new Option(RESOURCE["exts1"], '9');
		portModeElm.options[9] = new Option(RESOURCE["sixteenthe1"], '11');	   
    }
    else
    {
		portModeElm.options[0] = new Option(RESOURCE["extclock1"], '0');
		portModeElm.options[1] = new Option(RESOURCE["extclock2"], '1');
		portModeElm.options[2] = new Option(RESOURCE["exttime1"], '2');
		portModeElm.options[3] = new Option(RESOURCE["exttime2"], '3');
		portModeElm.options[4] = new Option(RESOURCE["mon"], '4');
		portModeElm.options[5] = new Option(RESOURCE["orderwire"], '5');
		portModeElm.options[6] = new Option(RESOURCE["s1f1"], '6');
		portModeElm.options[7] = new Option(RESOURCE["debugger"], '7');
		portModeElm.options[8] = new Option(RESOURCE["outextclock"], '8');
		portModeElm.options[9] = new Option(RESOURCE["exts1"], '9');
		portModeElm.options[10] = new Option(RESOURCE["mon2"], '10');
		portModeElm.options[11] = new Option(RESOURCE["sixteenthe1"], '11');
    }
}

function apply()
{
    
    document.getElementById("applybtn").disabled = true;
    
    var xmlstr = createApplyXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MULTIPORTMODE + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, callbackApply, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < clockidst.getDataRowLength(); i++) 
    {
        if (!clockidst.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        var neidvalue = getNeProperty(top)["neid"];
        param.setAttribute("name", "neid");
        param.setAttribute("value", neidvalue);
        row.appendChild(param);        
        
     
		    param = new tagElement("param");
        var slotid = clockidst.getCellCurrentValue(i, "clockname", "slotid");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotid);
        row.appendChild(param);           
        
        param = new tagElement("param");
        var port = clockidst.getCellCurrentValue(i, "port", "port");
        param.setAttribute("name", "port");
        param.setAttribute("value", port);
        row.appendChild(param);
        
         param = new tagElement("param");
        var portmode = clockidst.getCellCurrentValue(i, "portmode", "portmode");
        param.setAttribute("name", "portmode");
        param.setAttribute("value", portmode);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function callbackApply(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        document.getElementById("applybtn").disabled = false;
        showErrorDialog(data);
        return;
    }
    refreshTableState(clockidst, window.tableconf[0], data);
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
}
