
var winobj = getNeProperty(self);
var linePGTable;
var boardMapTable;
var boardMapData = null;
var ALL_CLEAR = 16; //     
var LOCKED =  15; //      
var FOCUS_SW = 14; //    
var MANUAL_SW = 8; //    
var EXERCISE_SW = 4; //    
var usedPort = []; //     
var aviablePort = []; //     
var usedPGID = []; //      ID
var delPGList = []; //      
var MIN_GROUP_ID = 1;
var MAX_GROUP_ID = 12;
var REVERTIVE_MODE0 = 0; //    
var REVERTIVE_MODE1 = 1; //     
var PROTECT_TYPE0 = 0; //1+1
var PROTECT_TYPE1 = 1; //1:N
var btnRightArr = new Object();
var INVALID_SUBSLOT = "255";

loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);
getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/logicsys/linemsp_"+SYSTEMCONF.getLanguage()+".xml");
loadXMLdoc("../../conf/logicsys_v2r8c01_ptn/linemsppgtable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);
loadXMLdoc("../../conf/logicsys_v2r8c01_ptn/linemspmaptable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);

/**
 *      
 * @param  
 * @return  
 */
function initBody()
{
		$("pgTableTitle").appendChild(document.createTextNode(RESOURCE["PGTitle"]));
		$("boardMapTableTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
		
		initTable();
		initButton();
		if(btnRightArr.queryBtn.right)
		{
		    queryPG();
		}
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
    linePGTable = new SortTable();
    linePGTable.head.setAttribute("id", "htmlTable_STHead_linemsp");
    linePGTable.body.setAttribute("id", "htmlTable_STBody_linemsp");
    linePGTable.setImage("../../../../images/");
    linePGTable.setOnRowSelectHandler(rowSelectHandler); 
    linePGTable.setOnCellEditHandler(cellEditHandler);
	linePGTable.isUsedForSelectList = true;
    createTableHead(linePGTable, window.tableconf[0]); 
    
    var linePGTableArea = document.createElement("div");
    linePGTableArea.setAttribute("id","protectGroupTable");
    linePGTableArea.className = "adaptTable";
    linePGTableArea.appendChild(linePGTable.getTable());
    $("protectGroup").appendChild(linePGTableArea);
    linePGTableArea.oncontextmenu=popupMenuHandler;

    boardMapTable = new SortTable();
    boardMapTable.head.setAttribute("id", "htmlTable_STHead_linemsp1");
    boardMapTable.body.setAttribute("id", "htmlTable_STBody_linemsp1");
    boardMapTable.setImage("../../../../images/");
    
    boardMapTable.setSingleChoiceFlg(true);
    boardMapTable.isUsedForSelectList = true;
    createTableHead(boardMapTable, window.tableconf[1]);
    
    var boardMapTableArea = document.createElement("div");
    boardMapTableArea.setAttribute("id","boardMapTable");
    boardMapTableArea.className = "adaptTable";
    boardMapTableArea.appendChild(boardMapTable.getTable());
    $("boardMap").appendChild(boardMapTableArea);  
    boardMapTableArea.oncontextmenu=popupMenuHandlerLocal;	    
   
   	var totalHeight = getComponetHeight($("tablecomponent"),220);
    linePGTable.setBodyHeight(totalHeight*0.6+"px");
    boardMapTable.setBodyHeight(totalHeight*0.38+"px"); 
}

/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
		if(SYSTEMCONF.getLanguage() == "en")
    {
        $("startBtn").className = "buttonstyle3";
        $("endBtn").className = "buttonstyle3";
        $("queryBtn").className = "buttonstyle5";
    }
    
		$("startBtn").value = RESOURCE["startBtn"];
    $("endBtn").value = RESOURCE["endBtn"]; 
		$("createBtn").value = RESOURCE["createBtn"];
    $("queryBtn").value = RESOURCE["queryBtn"]; 
		$("applyBtn").value = RESOURCE["applyBtn"];
    $("delBtn").value = RESOURCE["delBtn"]; 
		
		btnRightArr.startBtn = new BtnRightObj("startBtn",TECMDCODE_DEAL_LINEMSPPROTOCOL);
    btnRightArr.endBtn = new BtnRightObj("endBtn",TECMDCODE_DEAL_LINEMSPPROTOCOL);
    btnRightArr.createBtn = new BtnRightObj("createBtn",TECMDCODE_CREATE_LINEMSP);
    btnRightArr.queryBtn = new BtnRightObj("queryBtn",TECMDCODE_GET_LINEMSP);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn",TECMDCODE_SET_LINEMSPPARA);
    btnRightArr.delBtn = new BtnRightObj("delBtn",TECMDCODE_DELETE_LINEMSP);
    
    getRightInfo(winobj, btnRightArr);
    initrightbtn(btnRightArr);
}

/**
 *            
 * @param  
 * @return  
 */
function initButtonStatus()
{
		setBtnStatus(false,["createBtn","queryBtn"]);
		
		if(linePGTable.getSelectedRowCount()>0) 
		{
				setBtnStatus(false,["startBtn","endBtn","delBtn"]);
		}
		else
		{
				setBtnStatus(true,["startBtn","endBtn","delBtn"]);
		}
		setBtnStatus(true,["applyBtn"]);

    for(var rowindex = 0,rowlen = linePGTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
	    	if(linePGTable.getModify(rowindex))
	    	{
		    		setBtnStatus(false,["applyBtn"]);
		    		break;
	    	}
    }
}

/**
 *             
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
		if(rows.length == 0)
		{
				$("startBtn").disabled = true;
		    $("endBtn").disabled = true;
		    $("delBtn").disabled = true;
		    
		    boardMapTable.clearTableData();	    	
		}
		else
		{	
				$("startBtn").disabled = !btnRightArr.applyBtn.right;
		    $("endBtn").disabled = !btnRightArr.applyBtn.right;
		    $("delBtn").disabled = !btnRightArr.applyBtn.right;
		    	
				var groupID = 0;
			
				groupID = linePGTable.getCellStoreValue(rows[0],"groupID","groupID")
			
		    queryBoardMapInfo(groupID);
		}
}

/**
 *             
 * @param  
 * @return  
 */
function cellEditHandler()
{
		$("applyBtn").disabled = !btnRightArr.applyBtn.right;
}

/**
 *      
 * @param  
 * @return  
 */
function queryPG(isFirst)
{
		setBtnStatus(true);
	
		var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_LINEMSP_PTN+"&nmUser="+winobj["nmUser"];
    loadXMLdoc(url,"POST",true,callbackQueryPG,isFirst,"inputdata="+createQueryPGXMLInfo());
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createQueryPGXMLInfo()
{
		var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

/**
 *             
 * @param doc:          
 * @return  
 */
function callbackQueryPG(doc,isFirst)
{
		var data = EncapsulateData(doc);
		var errObj = null;
		if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
		{		
				linePGTable.clearTableData();
				boardMapTable.clearTableData();
				fillTableData(data,true);
		}
		else
		{
				errObj = [];
				errObj.push("nename");
		}
		
		mozillaSort(linePGTable, "groupID");
		if(isFirst)
		{
			querySWStatus();
		}
		initButtonStatus();
		showErrorDialog(data,errObj);		
}

/**
 *         
 * @param data:       isQuery        
 * @return  
 */
function fillTableData(data,isQuery)
{
		handQueryData(data,isQuery);
		
		createTableBody(linePGTable,window.tableconf[0],data,RESOURCE);
		
		if(linePGTable.getDataRowLength() > 0 && linePGTable.getSelectedRowCount() == 0)
		{
				linePGTable.setRowSelect(0);
				rowSelectHandler(linePGTable.getSelectedRows());
		}
		addCellEvent();
}

/**
 *                  
 * @param doc:          
 * @return  
 */
function handQueryData(data,isQuery)
{
		if(isQuery)
		{
				usedPort = [];
				usedPGID = [];
				boardMapData = new DataInterface();
		}
		
		var boardMapArr = ["slotid","boardname","subslotid","subboardname","port","portname","switchStatue","endIndication","protectedUnit"];
		var workUnitObj = null;
		var protectUnitObj = null;
		var ptag = null;
		
		for(var i = data.getDataRowLength()-1; i >= 0; i--)
		{
				usedPGID.push(data.getDataRowParam(i,"groupID"));
				workUnitObj = new Object();
				protectUnitObj =  new Object();
				
				workUnitObj["groupID"] = data.rows[i].groupID;
				ptag = new ParamTag();
		    ptag.value = "1";
				workUnitObj["protectUnit"] = ptag;
				
				protectUnitObj["groupID"] = data.rows[i].groupID;
				ptag = new ParamTag();
		    ptag.value = "0";
				protectUnitObj["protectUnit"] = ptag;
				
				for(var index = 0, len = boardMapArr.length; index < len; index++)
				{
						workUnitObj[boardMapArr[index]] = data.rows[i]["W" + boardMapArr[index]];
						
						protectUnitObj[boardMapArr[index]] = data.rows[i]["P" + boardMapArr[index]];
				}		
				
				if(data.rows[i].WprotectedUnit.value == 1)
				{
						workUnitObj.protectedSlotid = workUnitObj.slotid;
						workUnitObj.protectedBoardname = workUnitObj.boardname;
						workUnitObj.protectedSubslotid = workUnitObj.subslotid;
						workUnitObj.protectedSubboardname = workUnitObj.subboardname;
						workUnitObj.protectedport = workUnitObj.port;
						workUnitObj.protectedPortname = workUnitObj.portname;
						protectUnitObj.protectedSlotid = workUnitObj.slotid;
						protectUnitObj.protectedBoardname = workUnitObj.boardname;
						protectUnitObj.protectedSubslotid = workUnitObj.subslotid;
						protectUnitObj.protectedSubboardname = workUnitObj.subboardname;
						protectUnitObj.protectedport = workUnitObj.port;
						protectUnitObj.protectedPortname = workUnitObj.portname;						
				}
					
				boardMapData.rows[boardMapData.rows.length] = workUnitObj;
				boardMapData.rows[boardMapData.rows.length] = protectUnitObj;
				
				usedPort.push(new TEPort(workUnitObj.slotid.value,workUnitObj.boardname.value,workUnitObj.port.value,workUnitObj.portname.value,data.rows[i].groupID.value,workUnitObj.subslotid.value,workUnitObj.subboardname.value));	
				usedPort.push(new TEPort(protectUnitObj.slotid.value,protectUnitObj.boardname.value,protectUnitObj.port.value,protectUnitObj.portname.value,data.rows[i].groupID.value,workUnitObj.subslotid.value,workUnitObj.subboardname.value));	
			  removeAviaPort(workUnitObj.slotid.value,workUnitObj.subslotid.value,workUnitObj.port.value);
		    removeAviaPort(protectUnitObj.slotid.value,protectUnitObj.subslotid.value,protectUnitObj.port.value);
		}
}

/**
 *         
 * @param groupID    ID
 * @return  
 */
function removeBoardMapData(groupID)
{
		for(var index = boardMapData.getDataRowLength()-1; index >= 0; index--)
		{
				if(boardMapData.getDataRowParam(index,"groupID") == groupID)
				{
						boardMapData.rows.removeAt(index);
				}
		}
}

/**
 *         
 * @param  
 * @return  
 */
function addCellEvent()
{
		var protectType = 0;
		var revertiveModeCell = null;
		var revertiveTimeCell = null;
		
		for(var i = 0, len = linePGTable.getDataRowLength(); i < len; i++)
		{
				revertiveModeCell = linePGTable.getCell(i,"revertiveMode");
				revertiveModeCellEle = revertiveModeCell.element;
				revertiveTimeCell = linePGTable.getCell(i,"revertiveTime");
				revertiveTimeCellEle = revertiveTimeCell.element;
				
				protectType = linePGTable.getCellStoreValue(i,"protectionType","protectionType");
			
				if(protectType == PROTECT_TYPE1)
				{
						revertiveModeCellEle.style.background = "#E3E8E6";
						revertiveModeCellEle.isEdit = 0;
						revertiveModeCellEle.ondblclick = null;
						
						linePGTable.getCellElement(i, "switchMode").style.backgroundColor = "#e3e8e6";
						linePGTable.getCellElement(i, "switchMode").ondblclick = null;
						linePGTable.getCellElement(i, "switchMode").isEdit = 0;
				}		
			
					/**
					 *    OptiX TransData V100R005      (    ).xls
					 *   http://imp/transfer/index.html   
					 * NSCMD_PTN_LMS_SET_WTRTIME 
					 *                 6 720     600                        
					 */
					textCheck(revertiveTimeCell.element.editElement.element,"6","720");
				
				var revertiveMode = linePGTable.getCellStoreValue(i,"revertiveMode","revertiveMode");
				if(revertiveMode == REVERTIVE_MODE0)
				{
						linePGTable.setCellValue(revertiveTimeCell,"revertiveTime",0);
						linePGTable.setAtomValue(revertiveTimeCellEle.showElement,"0");
						revertiveTimeCellEle.style.background = "#E3E8E6";
						revertiveTimeCellEle.isEdit = 0;
						revertiveTimeCellEle.ondblclick = null;
				}
				
				revertiveModeCell.element.editElement.element.onchange = function()
				{
						revertiveModeCellEvent(this);
				}
		}
}

/**
 *            
 * @param atom:       isShowModify         
 * @return  
 */
function revertiveModeCellEvent(atom,isShowModify)
{
  	var rowindex = atom.parentNode.parentNode.rowIndex;
  	var revertiveTimeCell = linePGTable.getCell(rowindex,"revertiveTime");
  	var revertiveTimeCellEle = revertiveTimeCell.element;
		if(atom.value == REVERTIVE_MODE0)
		{
				linePGTable.setCellValue(revertiveTimeCell,"revertiveTime",0);
				linePGTable.setAtomValue(revertiveTimeCellEle.showElement,"0");
				revertiveTimeCellEle.modify = false;
				revertiveTimeCellEle.style.background = "#E3E8E6";
				revertiveTimeCellEle.isEdit = 0;
				revertiveTimeCellEle.ondblclick = null;
		}
		else
		{
				linePGTable.setCellValue(revertiveTimeCell,"revertiveTime",600);
				revertiveTimeCellEle.style.background = "#ffffff";
				revertiveTimeCellEle.modify = false;
				revertiveTimeCellEle.isEdit = 1;
				revertiveTimeCellEle.ondblclick = cellondbclick;
				linePGTable.setAtomValue(revertiveTimeCellEle.showElement,"600");
		}
}

/**
 *             
 * @param groupID    ID
 * @return  
 */
function queryBoardMapInfo(groupID)
{
		var tmpSelectRow = -1;
		var tmpSlectPGID = -1;
		if(boardMapTable.getSelectedRowCount() >0 )
		{
				tmpSelectRow = boardMapTable.getSelectedRows()[0];
				tmpSlectPGID= boardMapTable.getCellStoreValue(0,"groupID","groupID");
		}
		
		boardMapTable.clearTableData();
		
		var boardData = new DataInterface();
		
		for(var i = 0, len = boardMapData.getDataRowLength(); i < len; i++)
		{
				if(boardMapData.getDataRowParam(i,"groupID") == groupID)
				{
						boardData.rows.push(boardMapData.rows[i]);
				}
		}
	
		for (var i=0,len=boardData.rows.length; i<len; i++)
		{
				var subId = boardData.rows[i].subslotid.value;
				if (subId == "255")
				{
						boardData.rows[i].subslotid.value = "";
						boardData.rows[i].subboardname.value = "";
				}
		}		

		createTableBody(boardMapTable,window.tableconf[1],boardData,RESOURCE);
		
		if(groupID == tmpSlectPGID)
		{
				boardMapTable.setRowSelect(tmpSelectRow);
		}
}


/**
 *       
 */
function querySWStatus(isQuery)
{
		if(linePGTable.getDataRowLength() == 0)
		{
				return;
		}
		var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LINEMSPSTATE_PTN+"&nmUser="+winobj["nmUser"];
	  loadXMLdoc(url,"POST",true,callbackQuerySWStatus,isQuery,"inputdata="+createQuerySWStatusXMLInfo());

}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQuerySWStatusXMLInfo()
{
		var root = new inputxml("datainterface");

    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;    
    
    delPGList = [];
    
    for(var i = 0,len = linePGTable.getDataRowLength(); i < len; i++)
    {
	    	row = new tagElement("row-params");

		    param = new tagElement("param");
		    param.setAttribute("name","neid");
		    param.setAttribute("value",winobj["neid"]);
		    row.appendChild(param);
		    	    
		    param = new tagElement("param");
		    param.setAttribute("name","groupID");
		    param.setAttribute("value",linePGTable.getCellStoreValue(i,"groupID","groupID"));
		    row.appendChild(param);    
		    bussiness.appendChild(row);
		    delPGList.push(linePGTable.getCellStoreValue(i,"groupID","groupID"));	    
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQuerySWStatus(doc,isQuery)
{
		var data = EncapsulateData(doc);
		
		var errorCode = data.getSErrorCode();
		var groupID = 0;
		var protectUnit = 0;
		
		/*    ,          
		 */
		if(0 == errorCode || 1== errorCode)  
		{	
				for(var i = 0, len = data.getDataRowLength(); i < len; i++)
				{
						groupID = data.getDataRowParam(i,"groupID");
						protectUnit = data.getDataRowParam(i,"protectUnit");
						
						/*         
						 */
						for(var index = 0, size = linePGTable.getDataRowLength(); index < size; index++)
						{
								if(groupID == linePGTable.getCellStoreValue(index,"groupID","groupID"))
								{
									  var protocolStatusValue = data.getDataRowParam(i,"protocolStatus");
									  
									  if (protectUnit == "0" || (protectUnit == "1" && protocolStatusValue != "0"))
									  {
										    var switchStatue = parseInt(data.getDataRowParam(i,"switchStatue"));
										    linePGTable.setCellValue(linePGTable.getCell(index,"protocolStatus"),"protocolStatus",protocolStatusValue);
										    linePGTable.setAtomValue(linePGTable.getCellElement(index,"protocolStatus").showElement,protocolStatus[protocolStatusValue]);	
								    }
								}
						}
						
						/*        
						*/
						for(var index = 0, size = boardMapData.getDataRowLength(); index < size; index++)
						{
								var gId = boardMapData.getDataRowParam(index,"groupID");
								var pUnit = boardMapData.getDataRowParam(index,"protectUnit");
								
								if(gId != groupID || pUnit != protectUnit)
								{
										continue;
								}
								
								boardMapData.rows[index].switchStatue.value = data.getDataRowParam(i,"switchStatue");
								boardMapData.rows[index].endIndication.value = data.getDataRowParam(i,"endIndication");
								
								/*      1:1          1            
								 *        1:N          
								 */
								if(data.getDataRowParam(i,"protectedUnit") == 1)
								{
										var key = pUnit == 0 ? (index-1) : index;
										
										boardMapData.rows[index].protectedSlotid = boardMapData.rows[key].slotid;
										boardMapData.rows[index].protectedBoardname = boardMapData.rows[key].boardname;
										boardMapData.rows[index].protectedSubslotid = boardMapData.rows[key].subslotid;
										boardMapData.rows[index].protectedSubboardname = boardMapData.rows[key].subboardname;
										boardMapData.rows[index].protectedport = boardMapData.rows[key].port;
										boardMapData.rows[index].protectedPortname = boardMapData.rows[key].portname;
								}
								else
								{
										boardMapData.rows[index].protectedSlotid = "";
										boardMapData.rows[index].protectedBoardname = "";
										boardMapData.rows[index].protectedSubslotid = "";
										boardMapData.rows[index].protectedSubboardname = "";
										boardMapData.rows[index].protectedport = "";
										boardMapData.rows[index].protectedPortname = "";
								}
						}
				}	
				
				rowSelectHandler(linePGTable.getSelectedRows());
		}	

		if(isQuery)
		{
				showErrorDialog(data);
		}	
}

/**
 *       
 * @param  
 * @return  
 */
function openCreateDialog()
{
		var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_FREELINEMSP_PTN+"&nmUser="+winobj["nmUser"];	
		
	  loadXMLdoc(url,"POST",false,callbackQueryRes,null,"inputdata="+createQueryResXMLInfo());
		
	    var netype = winobj.neType;
	    var neversion = winobj.neversion;
	    var versionArray = neversion.split(".");
	    var remove1P1Flag = false;
	    var isSupport = SpecialAttrMgr.isNESupport(winobj["neid"], "TE_GROUPING_LINEAR_MS", "SDH_ATTR_SUPPORT_GROUPLINEAR_SP1V1");
	    if( ((netype == "76" || netype == "77" || netype == "83"|| netype == "114") && versionArray[2] >= "05") 
	    	|| netype == "62" || netype == "81" || isSupport)
	    {
	    	remove1P1Flag = true;
	    }
	    if( remove1P1Flag )		//For RTN 900 5.76.05.10
	    {
	    	xshowModalDialog("createlinemsp_1to1.html", RESOURCE["createPGTitle"], 700, 650, "../../../../images/");
	    }
	    else					//For RTN 900 5.76.01.20
	    {
	    	xshowModalDialog("createlinemsp.html", RESOURCE["createPGTitle"], 700, 650, "../../../../images/");
	    }
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQueryResXMLInfo()
{
	 	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQueryRes(doc)
{
		var data = EncapsulateData(doc);
		var errorCode = data.getSErrorCode();
		if(0 != errorCode) 
		{		
				return;
		}
		
		aviablePort = [];
		var tmpPort = 0;

		for(var i = 0, len = data.getDataRowLength(); i < len; i++)
		{		
			  var subslotid = data.getDataRowParam(i,"subslotid");
			  var subboardname = data.getDataRowParam(i,"subboardname");
			  if ("0" == subslotid)
			  {
			  	  subslotid = INVALID_SUBSLOT;
			  	  subboardname = "UNKNOWN";
			  }
				tmpPort = new TEPort(data.getDataRowParam(i,"slotid"),data.getDataRowParam(i,"boardname"),												 
														 data.getDataRowParam(i,"port"),data.getDataRowParam(i,"portname"),"",
														 subslotid,subboardname);
				if(!usedPort.containsPort(tmpPort))
				{
						aviablePort.push(tmpPort);
				}
		}
}

/**
 *         
 * @param  
 * @return  
 */
function startProtocol(isStart)
{
	if(isStart)
	{
		setBtnStatus(true,["startBtn"]);		
	}
	else
	{
		setBtnStatus(true,["endBtn"]);		
	}
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DEAL_LINEMSPPROTOCOL_PTN+"&nmUser="+winobj["nmUser"];	
	
    loadXMLdoc(url,"POST",true,callbackStartProtocol,isStart,"inputdata="+createStartProtocolXMLInfo(isStart));
    
}

/**
 *          XML  
 * @param  
 * @return  
 */
function createStartProtocolXMLInfo(isStart)
{
	 	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
    var selectedRow = linePGTable.getSelectedRows();
    for(var i = 0, len = selectedRow.length; i < len; i++)
    {
	    	row = new tagElement("row-params");
		    
		    param = new tagElement("param");
		    param.setAttribute("name","neid");
		    param.setAttribute("value",winobj["neid"]);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name","startFlag");
		    if(isStart)
		    {
		    		param.setAttribute("value",1);
		    }
		    else
		    {
		    		param.setAttribute("value",0);
		    }
		    row.appendChild(param);    
	
		    param = new tagElement("param");
		    param.setAttribute("name","groupID");
		    param.setAttribute("value",linePGTable.getCellStoreValue(selectedRow[i],"groupID","groupID"));
		    row.appendChild(param);    
		    bussiness.appendChild(row);
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackStartProtocol(doc,isStart)
{
		var data = EncapsulateData(doc);
		
		if(0 == data.getSErrorCode())
		{
				alert(RESOURCE["queryProtocolAlert"]);
		}
		else
		{
				showErrorDialog(data);		
		}
		
		rowSelectHandler(linePGTable.getSelectedRows());
}

/**
 *            
 * @param  
 * @return  
 */
function delLineMsp()
{
	if(!confirm(RESOURCE["ID_BELMSP_PROL"]))
	{
		return;
	}
	
    var selectedRow = linePGTable.getSelectedRows();
    
    var has1J1Pro = false; //         1+1    
    for(var i = 0; i < selectedRow.length; i++)
    {	    
		if(linePGTable.getCellStoreValue(selectedRow[i],"protectionType","protectionType") == PROTECT_TYPE0)
		{
			has1J1Pro = true;
		}
    }
    
	if(has1J1Pro && !confirm(RESOURCE["ID_QX5MSP_PROL"]))
	{
		return;
	}
	setBtnStatus(true,["delBtn"]);
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_LINEMSP_PTN+"&nmUser="+winobj["nmUser"];	
	
    loadXMLdoc(url,"POST",true,callbackDelLineMsp,null,"inputdata="+createDelLineMspXMLInfo());
    
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createDelLineMspXMLInfo()
{
	 	var root = new inputxml("datainterface");

    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;    
    
    delPGList = [];
    
    var selectedRow = linePGTable.getSelectedRows();
    for(var i = 0; i < selectedRow.length; i++)
    {
	    	row = new tagElement("row-params");
		   
		    param = new tagElement("param");
		    param.setAttribute("name","neid");
		    param.setAttribute("value",winobj["neid"]);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name","groupID");
		    param.setAttribute("value",linePGTable.getCellStoreValue(selectedRow[i],"groupID","groupID"));
		    row.appendChild(param);    
		    bussiness.appendChild(row);
		    delPGList.push(linePGTable.getCellStoreValue(selectedRow[i],"groupID","groupID"));
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *               
 * @param doc:          
 * @return  
 */
function callbackDelLineMsp(doc)
{
	var data = EncapsulateData(doc);
	var faultPGList = [];
	if(data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
		for(var i = 0,len = data.getBErrLength(); i < len; i++)
		{
			faultPGList.push(data.getBErrParam(i,"groupID"));
		}
	
		for(var i = 0, len = linePGTable.getDataRowLength(); i < len; i++)
		{
			var groupID = linePGTable.getCellStoreValue(i,"groupID","groupID");
			
			if(delPGList.contains(groupID) && !faultPGList.contains(groupID))
			{
				linePGTable.deleteRow(i);
				
				usedPGID.remove(groupID);	
				usedPort.removePort(groupID);
				removeBoardMapData(groupID);
			}
		}	
		linePGTable.adjustDataRows();
	}
	if(linePGTable.getDataRowLength() == 0)
	{
  }
	showErrorDialog(data);
    
    boardMapTable.clearTableData();
    
	if(linePGTable.getDataRowLength() > 0 && linePGTable.getSelectedRowCount() == 0)
	{
		linePGTable.setRowSelect(0);
	}
	rowSelectHandler(linePGTable.getSelectedRows());
	initButtonStatus();
}

/**
 *              
 * @param  
 * @return  
 */
function setLineMsp()
{
	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_LINEMSPPARA_PTN+"&nmUser="+winobj["nmUser"];	
	
	var xmlData = createSetLineMspXMLInfo();
	if(null == xmlData)
	{
	   return;
	}
	setBtnStatus(true,["applyBtn"]);
    loadXMLdoc(url,"POST",true,callbackSetLineMsp,null,"inputdata="+xmlData);
    
}

/**
 *               XML  
 * @param  
 * @return  
 */
function createSetLineMspXMLInfo()
{
	  var inactiveConfirm = true;
	  var activeConfirm = true;
	  
	 	var root = new inputxml("datainterface");

    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var isModify = false;

    for(var rowindex = 0,rowlen = linePGTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
	    	if(!linePGTable.getModify(rowindex))
	    	{
	    		continue;
	    	}
    		isModify = true;
    		
        rowData = linePGTable.getRow();
    		row = new tagElement("row-params");    	

	    	param = new tagElement("param");
				param.setAttribute("name","neid");
				param.setAttribute("value",winobj["neid"]);
				row.appendChild(param);	
	    	for(var colindex = 0,collen = linePGTable.getColumnCount();colindex<collen;colindex++)
	    	{
		    		colid = window.tableconf[0].getColId(colindex);
		    		cellModifyFlag = linePGTable.getCellModify(rowindex,colid);
		    		colkeyarray = window.tableconf[0].getColKeyArray(colindex);
		    		    
		    		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
		    		{
			    			param = new tagElement("param");
			    			key = colkeyarray[keyindex].name;
		    				    		
			    	    var cellValue = linePGTable.getCellStoreValue(rowindex,colid,key);
		    		    if (cellModifyFlag && "activationStatus" == colid )
		    		    {
		    		    	  if ("0" == cellValue && inactiveConfirm)
		    		    	  {
		    		    	  	  inactiveConfirm = false;
		    		    	  	  if (!confirm(RESOURCE["inactiveSwitchApply"]))
		    		    	  	  {
		    		    	  	  	  return null;
		    		    	  	  }		    		    	  	  
		    		    	  }
		    		    	  		    			  
		    		    	  if( "1" == cellValue && activeConfirm)
		    		    	  {
		    		    	  	  activeConfirm = false;
		    		    	  	  if (!confirm(RESOURCE["activeSwitchApply"]))
		    		    	  	  {
		    		    	  	  	  return null;
		    		    	  	  }		    		    	  	  
		    		    	  }	        
		    		    }
		    		
			    			param.setAttribute("name",key);
			    			param.setAttribute("value",cellValue);   
			    			param.setAttribute("modifyFlag",cellModifyFlag); 
			    			row.appendChild(param);		
		    		}    		
	    	}
	    	bussiness.appendChild(row);
    }    
    if(!isModify)
    {
    		return null;
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *                 
 * @param doc:          
 * @return  
 */
function callbackSetLineMsp(doc)
{
	var data = EncapsulateData(doc);	
	refreshTableState(linePGTable,window.tableconf[0],data);
	if(0 != data.getSErrorCode())
	{
		setBtnStatus(false,["applyBtn"]);
	}
	showErrorDialog(data);	
}

/**
 *       
 * @param  
 * @return  
 */
function switchLineMsp(switchType)
{
    var selectedRows = linePGTable.getSelectedRows();
    if("0" == linePGTable.getCellStoreValue(selectedRows[0],"activationStatus","activationStatus") 
    && !confirm(RESOURCE["inactiveSwitch"]))
	  {
	  	return;
	  }
	  
    if("1" == linePGTable.getCellStoreValue(selectedRows[0],"activationStatus","activationStatus") 
    && !confirm(RESOURCE["activeSwitch"]))
	  {
	  	return;
	  }
	  
	  var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_LINEMSPSW_PTN+"&nmUser="+winobj["nmUser"];	
	
    loadXMLdoc(url,"POST",true,callbackSwitchLineMsp,switchType,"inputdata="+createSwitchLineMspXMLInfo(switchType));
    
}

/**
 *        XML  
 * @param  
 * @return  
 */
function createSwitchLineMspXMLInfo(switchType)
{
	 	var root = new inputxml("datainterface");

    var bussiness = new tagElement("bussiness-params");
    var row, param;

    var selectedRow = boardMapTable.getSelectedRows();
    
  	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","groupID");
    param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRow[0],"groupID","groupID"));
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","protectUnit");
    param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRow[0],"protectUnit","protectUnit"));
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","switchType");
    param.setAttribute("value",switchType);
    row.appendChild(param);    
    bussiness.appendChild(row);
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackSwitchLineMsp(doc,switchType)
{
		var data = EncapsulateData(doc);
		
		if(0 == data.getSErrorCode())
		{
				alert(RESOURCE["querySWStatus"]);
		}	
		showErrorDialog(data);
}

 /**
 *             
 * @param data: 
 * @return  
 */
function createjsDOMenu()
{
		removejsDOMmenu();
		var menuSize = 150; 
    if(SYSTEMCONF.getLanguage() == "en")
    {
    		menuSize = 200;
    }  
    var cursorMenu1 = new jsDOMenu(menuSize); 
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryPG"],"",queryPG,null));      	
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["querySwitchStatus"],"",querySWStatus,true));
    setPopUpMenu(cursorMenu1);
}

/**
 *           
 * @param data: 
 * @return  
 */
function popupMenuHandlerLocal(evt)
{
  	if(!evt)
  	{
  	  	evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if(elem!= null && elem.blur)
    {
    	elem.blur();	  	
    }
   
		while(elem!=null)
		{
		    if(elem.tagName == 'TD')
		    {
		        break;	
		    }
		    else
		    {
			    	elem =elem.parentNode;	  	
		    }	
   	} 
  
		if(elem == null || elem.tagName != 'TD' || null == elem.parent)
		{
			  return;
		}  
		
		var rowid= elem.parentNode.rowIndex;
		var rows =elem.parent.getSelectedRows();
		var colid = elem.colid;

		if(rows.contains(rowid))
		{
				createFuncPopupMenu(rows,evt);    	
		}    
}

 /**
 *           
 * @param data: 
 * @return  
 */
function createFuncPopupMenu(rows,evt)
{
		removejsDOMmenu(); 
		var menuSize = 150; 
		var cursorMenu1 = new jsDOMenu(menuSize); 
		var isClear = true;
		var protectUnit = boardMapTable.getCellStoreValue(rows[0],"protectUnit","protectUnit"); //   0     1     
		var protectionType ; //    
		var revertiveMode = linePGTable.getCellStoreValue(linePGTable.getSelectedRows()[0],"revertiveMode","revertiveMode"); //    
		
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["querySW"],"",querySWStatus,true));
		cursorMenu1.addMenuItem(new menuItem('-'));
		
		if(254 == boardMapTable.getCellStoreValue(rows[0],"switchStatue","switchStatue"))
		{
				isClear =  false;
    }
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearSW"],"",switchLineMsp,[ALL_CLEAR],(isClear && btnRightArr.applyBtn.right)));
     
    if(1 == protectUnit)
    {
	     	if(1 == revertiveMode) //    
	     	{
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["lockProtect"],"",switchLineMsp,[LOCKED],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW], btnRightArr.applyBtn.right));     		
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW], btnRightArr.applyBtn.right));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW], btnRightArr.applyBtn.right));
	     	} 
	     	else //     
	     	{
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["lockProtect"],"",switchLineMsp,[LOCKED],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToWork"],"",switchLineMsp,[FOCUS_SW],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW], btnRightArr.applyBtn.right));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToWork"],"",switchLineMsp,[MANUAL_SW],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW], btnRightArr.applyBtn.right));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW], btnRightArr.applyBtn.right));
     		}    
    }
    else //      
    {
	     	if(1 == revertiveMode) //    
	     	{
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["lockProtect"],"",switchLineMsp,[LOCKED], btnRightArr.applyBtn.right));
	      		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToWork"],"",switchLineMsp,[FOCUS_SW],false));    		
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToWork"],"",switchLineMsp,[MANUAL_SW],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW],false));
     				cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW],false));
     		} 
	     	else //     
	     	{
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["lockProtect"],"",switchLineMsp,[LOCKED], btnRightArr.applyBtn.right));
		      	cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToWork"],"",switchLineMsp,[FOCUS_SW], btnRightArr.applyBtn.right));    		
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToWork"],"",switchLineMsp,[MANUAL_SW], btnRightArr.applyBtn.right));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW],false));
		     		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW], btnRightArr.applyBtn.right));
     		}       	
    }
    setPopUpMenu(cursorMenu1);
    showMenu(evt);
}

function setBtnStatus(disabledState,btnIDArr)
{
		if(null == btnIDArr || btnIDArr.length == 0)
		{	
				btnIDArr = [];		
				btnIDArr.push("startBtn");
				btnIDArr.push("endBtn");
				btnIDArr.push("createBtn");
				btnIDArr.push("queryBtn");
				btnIDArr.push("applyBtn");
				btnIDArr.push("delBtn");
		}
	
	
		for(var i = 0; i < btnIDArr.length; i++)
		{
				$(btnIDArr[i]).disabled = disabledState;
				if (!disabledState)
				{
					  $(btnIDArr[i]).disabled = !btnRightArr[btnIDArr[i]].right;
				}			
		}	
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showErrorDialog(data,errArr)
{
		if(null == errArr)
		{
				errArr = [];//           
				errArr[0] = "groupID";//          ID
			
				for(var i = 0, len = data.getBErrLength(); i < len; i++)
				{	
						data.getError().rowErrors[i].errorObj["groupID"] = RESOURCE["Line_MSP_ID"]+ data.getError().rowErrors[i].errorObj["groupID"];
				}		
		}
		
		openErrPage("../../../../page/",data.getError(),errArr);
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
		if("function" == (typeof obj))	
		{
				return obj(key);
		}
		else //       
		{
				if(null == obj)
				{
						return key;
				}
				var resValue = obj[key];
				if(null == resValue)
				{
						resValue = "/";
				}		
				return resValue;
		}
}

 /**
 *               
 * @param data: 
 * @return  
 */
window.onresize=function()
{
		var totalHeight = getComponetHeight($("tablecomponent"),220);
		linePGTable.setBodyHeight(totalHeight*0.6+"px");
		boardMapTable.setBodyHeight(totalHeight*0.38+"px");
}

function removeAviaPort(slotid,subslotid,port)
{
		for(var i = aviablePort.length-1; i >=0; i--)
		{
				if(aviablePort[i].slotid == slotid && aviablePort[i].subslotid ==subslotid && aviablePort[i].port == port)
				{
						aviablePort.removeAt(i);
				}
		}
}

Array.prototype.containsPort = function(portObj)
{
	for(var i = 0, len = this.length; i < len; i++)
	{
		if(this[i].equals(portObj))
		{
			return true;
		}
	}
	return false;
}

Array.prototype.removePort = function(groupID)
{
	for(var i = this.length-1; i >=0; i--)
	{
		if(this[i].groupID == groupID)
		{
			this.removeAt(i);
		}
	}
}

function TEPort(slotid,boardname,port,portname,groupID,subslotid,subboardname)
{
	this.slotid = slotid;
	this.boardname = boardname;
	this.subslotid = subslotid;
	this.subboardname = subboardname;
	this.port = port;
	this.portname = portname;
	this.groupID = groupID;
}

/**
 * TEPort   equals  
 * @param
 * @return boolean
 */
TEPort.prototype.equals = function(otherPort)
{	
		if(this.slotid == otherPort.slotid && this.subslotid == otherPort.subslotid
		   && this.port == otherPort.port)
		{
				return true;
		}
		return false;
}

/**
 * TEPort   compare
 * @param
 * @return boolean
 */
TEPort.prototype.compare = function(otherPort)
{	
		if(this.slotid > otherPort.slotid)
		{
				return 1;
		}
		else if(this.slotid < otherPort.slotid)
		{
				return -1;
		}
		else if (this.subslotid > otherPort.subslotid)
		{
				return 1;
		}
		else if (this.subslotid < otherPort.subslotid)
		{
				return -1;
		}
		else if(this.port > otherPort.port)
		{
				return 1;
		}
		else if(this.port <= otherPort.port)
		{
				return -1;
		}	
}

/**
 * TEPort   toString
 * @param
 * @return String
 */
TEPort.prototype.toString = function()
{	
		var str = "";
		
		if (this.subslotid != "0" && this.subslotid != "255")
		{
				str = this.slotid + "-" + this.boardname + "-" +
							this.subslotid + "-" + this.subboardname + "-" + this.portname;
		}
		else
		{
				str = this.slotid + "-" + this.boardname + "-" + this.portname;
		}
		return str;
}

function mozillaSort(st, key)
{
		if(!st.element.colsArray.selectedId)
    {
  	   st.element.colsArray.selectedId = key;
  	   st.element.colsArray.imgflag = 1;
    }
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
    st.sortRows(td,st.element.colsArray.imgflag);
}
