var winobj = getNeProperty(self);
var parentWin = getParentWindow();
var netype = parentWin.winobj.neType;
var linePGTable; //         
var newLineMspDataXML; //        XML  
var availablePortList = []; //          
var workUnitList = []; //            
var protectUnitList = []; //            
var MIN_DELAYTIME = 300; //      
var MAX_DELAYTIME = 720; //      
var DEFAULT_DELAYTIME = 600; //      
var WEST_WORK_UNIT = 1; //      
var WEST_PROTECT_UNIT = 2; //      
var groupID = 1;
var vc4enable = false;
var lastSlotPort = null;    
var DEV_1800V = "121";
var DEV_OSN1832X16 = "122";
var DEV_OSN1832X8 = "136";
var DEV_1800 = "67";
var MIN_HOLDTIME = 0;
var MAX_HOLDTIME = 100;
var DEFAULT_HOLDTIME = 0;
  
loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);

getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/logicsys/linemsp_"+SYSTEMCONF.getLanguage()+".xml");
document.title = RESOURCE["createPGTitle"];

/**
 *      
 * @param  
 * @return  
 */
function initBody()
{
	$("vc4mode").appendChild(document.createTextNode(RESOURCE["vc4mode"]));
	$("boardMapTableTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
	$("selectMapDirectTitle").appendChild(document.createTextNode(RESOURCE["selectMapDirectTitle"]));
	$("selectMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectMapBoardTitle"]));
	$("selectedMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectedMapBoardTitle"]));

	$("okBtn").value = RESOURCE["okbutton"];
    $("cancleBtn").value = RESOURCE["cancelbutton"]; 
	$("applyBtn").value = RESOURCE["applybutton"];

	$("selectMapDirect").options[0] = new Option(RESOURCE["westWorkUnit"],WEST_WORK_UNIT);
	$("selectMapDirect").options[1] = new Option(RESOURCE["westProtectUnit"],WEST_PROTECT_UNIT);

	initTable();
	initBoardMap(false);
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	linePGTable = new CTable();
	
	linePGTable.addHead(RESOURCE["attrCol"],RESOURCE["valueCol"]);
	
	var cTableAtom = null;
	var cTableAtomEle = null;
	
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["oneplusone"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["oneToMore"],1);  
    cTableAtomEle.onchange = protectTypeListener;
    linePGTable.addAttrRow("protectionType",RESOURCE["protectionType"],cTableAtom); 
    
    cTableAtom = new Atom("select"); 
    cTableAtomEle = cTableAtom.element;    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["singleSwitch"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["bothSwitch"],1);
    cTableAtomEle.onchange = setApplyEnabled;  
    linePGTable.addAttrRow("switchMode",RESOURCE["switchMode"],cTableAtom); 
      
    cTableAtom = new Atom("select"); 
    cTableAtomEle = cTableAtom.element;         
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Non-Revertive"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Revertive"],1);
    cTableAtomEle.onchange = revertiveModeListener;  
    linePGTable.addAttrRow("revertiveMode",RESOURCE["revertiveMode"],cTableAtom); 

    cTableAtom = new Atom("text"); 
    cTableAtomEle = cTableAtom.element; 
    cTableAtom.setValue(DEFAULT_DELAYTIME);
    cTableAtomEle.disabled = true;
    var isSupportNewRange = SpecialAttrMgr.isNESupport(parentWin.winobj["neid"], "TE_FUNC_CFG_LINEMS_UNIT", "W32PORT_ATTR_LINEMS_NEW_RANGE");
    if(isSupportNewRange)
    {
    	checkDataCellEvent(cTableAtomEle,6,64800,DEFAULT_DELAYTIME);
    }
    else
    {
        checkDataCellEvent(cTableAtomEle,MIN_DELAYTIME,MAX_DELAYTIME,DEFAULT_DELAYTIME);
    }
    cTableAtomEle.style.imeMode = "disabled"; 
    
    linePGTable.addAttrRow("revertiveTime",RESOURCE["revertiveTime"],cTableAtom); 

    cTableAtom = new Atom("select"); 
    cTableAtomEle = cTableAtom.element;    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Disabled"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Enabled"],1); 
    cTableAtomEle.options[1].selected = true; //    
    cTableAtomEle.onchange = setApplyEnabled;  
    linePGTable.addAttrRow("sdEnable",RESOURCE["sdEnable"],cTableAtom); 

    cTableAtom = new Atom("select");  
    cTableAtomEle = cTableAtom.element;    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["NewProtocol"],1);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["OldProtocol"],2); 
    cTableAtomEle.onchange = setApplyEnabled;     
    linePGTable.addAttrRow("protocolType",RESOURCE["protocolType"],cTableAtom); 

    if(netype == DEV_1800V || netype ==DEV_OSN1832X16)
    {
	cTableAtom = new Atom("text");
	cTableAtomEle = cTableAtom.element;
	cTableAtom.setValue(DEFAULT_HOLDTIME);
	checkDataCellEvent(cTableAtomEle, MIN_HOLDTIME, MAX_HOLDTIME,
			DEFAULT_HOLDTIME);
	cTableAtomEle.style.imeMode = "disabled";
	linePGTable.addAttrRow("holdtime", RESOURCE["delaytime"], cTableAtom);
    }
    else if(netype == DEV_1800  ||  netype == DEV_OSN1832X8)
    {
    
    }
    else
    { 	
        cTableAtom = new Atom("select");
        cTableAtomEle = cTableAtom.element;      
        cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Hight-Priority"],0);    
        cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Low-Priority"],1); 
        cTableAtomEle.onchange = setApplyEnabled;     
        linePGTable.addAttrRow("switchTag",RESOURCE["switchTag"],cTableAtom); 

        cTableAtom = new Atom("select");
        cTableAtomEle = cTableAtom.element;      
        cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["No-Indication"],0);    
        cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Indication"],1); 
        cTableAtomEle.onchange = setApplyEnabled;     
        linePGTable.addAttrRow("switchIndication",RESOURCE["switchIndication"],cTableAtom); 
    }
	
    $("linePGTableArea").appendChild(linePGTable.getTable()); 
}

/**
 *           
 * @param  
 * @return  
 */
function initBoardMap(vc4enable)
{
	clearSelectOptions($("availableport"));
	clearSelectOptions($("selectedport"));
	workUnitList = []; //            
    protectUnitList = []; //            
    var optionIndex = 0;
	var availableportObj = $("availableport");
	for(var i = 0; i < parentWin.aviablePort.length; i++)
	{
		var tmpPort = parentWin.aviablePort[i];
		if(vc4enable)
		{
			 for(var j = 1; j <= tmpPort.inflevel; j++)
	     {
	         var str = "-VC4:"+j;
	         insertSelectOption(availableportObj,tmpPort.slotid+":"+tmpPort.port+":"+tmpPort.boardname+":"+tmpPort.portname+":"+j,getString(tmpPort)+str, optionIndex++);
	     }
		}
		else
		{
		     insertSelectOption(availableportObj,tmpPort.slotid+":"+tmpPort.port+":"+tmpPort.boardname+":"+tmpPort.portname,tmpPort.toString(), optionIndex++);
	  }
	}
}

/**
 *                  
 * @param  
 * @return  
 */
function protectTypeListener()
{
	setApplyEnabled();
	linePGTable.setAttrValue("sdEnable",1);
	linePGTable.setAttrValue("protocolType",1);
	if(netype != DEV_1800V  && netype !=DEV_OSN1832X16 )
	{
		linePGTable.setAttrValue("switchTag",0);
		linePGTable.setAttrValue("switchIndication",1);
	}

	if(this.value == 0) //1+1  
	{
		linePGTable.setAttrValue("switchMode",0);
	    linePGTable.getAtom("switchMode").element.options.add(new Option(RESOURCE["singleSwitch"],0),0);    
		
	    linePGTable.getAtom("revertiveMode").element.options.add(new Option(RESOURCE["Non-Revertive"],0),0);    
	     
		linePGTable.setAttrValue("revertiveMode",0);		
		linePGTable.setAttrValue("revertiveTime",DEFAULT_DELAYTIME);
		linePGTable.getAtom("revertiveTime").element.disabled = true;
	}
	else //1:N  
	{
		alert(RESOURCE["MSP_CREATE_WARN"]);
		linePGTable.setAttrValue("switchMode",1);
	    linePGTable.getAtom("switchMode").element.options.remove(0);
		
	    linePGTable.getAtom("revertiveMode").element.options.remove(0);
	    
		linePGTable.setAttrValue("revertiveMode",1);		
		linePGTable.setAttrValue("revertiveTime",DEFAULT_DELAYTIME);
		linePGTable.getAtom("revertiveTime").element.disabled = false;
	}
	
	initBoardMap(false);
}

/**
 *         
 * @param  
 * @return  
 */
function revertiveModeListener()
{
	setApplyEnabled();
    linePGTable.setAttrValue("revertiveTime",DEFAULT_DELAYTIME);
    
	if(this.value == 0)
	{
		linePGTable.getAtom("revertiveTime").element.disabled = true;
	}
	else //    
	{
		linePGTable.getAtom("revertiveTime").element.disabled = false;		
	}
}

/**
 *            
 * @param   
 * @return   
 */
function doCreateLineMsp(isApply)
{
	if($("applyBtn").disabled)
	{
		self.close();
	}
	
	if(workUnitList.length == 0)
	{
		alert(RESOURCE["INFO_WEST_WORK_NOT_SELECTED"]);
		return;
	}
	else if(protectUnitList.length == 0)
	{
		alert(RESOURCE["INFO_WEST_PROTECT_NOT_SELECTED"]);
		return;
	}
	

  var checkFlg = true;
	for(var i = 0; i < protectUnitList.length; i++)
  {
		    var protectUnit = protectUnitList[i].split(":");
		    for(var i = 0; i < workUnitList.length; i++)
		    {
		    	var workUnit = workUnitList[i].split(":");
		    	if(checkFlg)
		    	{
		    	if(workUnit[0] == protectUnit[0])
		    	{
		    		if(!confirm(RESOURCE["INFO_ONSAMEBOARD"]) )
		    		{
		          return;
		        }
		        else
		        {
		        	checkFlg = false;
		        	continue;
		        }
		    	}
		     }
		    }
	}	 
	
	$("okBtn").disabled = true;
    $("cancleBtn").disabled = true;
	$("applyBtn").disabled = true;
	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_LINEMSP+"&nmUser="+parentWin.winobj["nmUser"];
	
	
    loadXMLdoc(url,"POST",true,callbackCreateLineMsp,isApply,"inputdata="+createCreateLineMspXMLInfo());
    
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createCreateLineMspXMLInfo()
{
	newLineMspDataXML = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.winobj["neid"]);
    row.appendChild(param);
   
    param = new tagElement("param");
    param.setAttribute("name","groupID");
    var groupIDList = getRangeNumber(parentWin.usedPGID,parentWin.MIN_GROUP_ID,parentWin.MAX_GROUP_ID,1);
    groupID = groupIDList[0];
    param.setAttribute("value",groupID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","protectionType");
    param.setAttribute("value",linePGTable.getAttrValue("protectionType"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","switchMode");
    param.setAttribute("value",linePGTable.getAttrValue("switchMode"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","revertiveMode");
    param.setAttribute("value",linePGTable.getAttrValue("revertiveMode"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","revertiveTime");
    if(linePGTable.getAttrValue("revertiveMode") == 1)
    {
    	param.setAttribute("value",linePGTable.getAttrValue("revertiveTime"));	
    }
    else //            0
    {
    	param.setAttribute("value","0");
    }
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","sdEnable");
    param.setAttribute("value",linePGTable.getAttrValue("sdEnable"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","protocolType");
    param.setAttribute("value",linePGTable.getAttrValue("protocolType"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","protocolStatus");
    param.setAttribute("value","254");
    row.appendChild(param);

    if(netype == DEV_1800V  || netype ==DEV_OSN1832X16 )
    {  
        param = new tagElement("param");
        param.setAttribute("name","holdtime");
        param.setAttribute("value",linePGTable.getAttrValue("holdtime"));
        row.appendChild(param);
    }
    else if(netype == DEV_1800 ||  netype == DEV_OSN1832X8)
    {
    
    }
    else
    {
        param = new tagElement("param");
        param.setAttribute("name","switchTag");
        param.setAttribute("value",linePGTable.getAttrValue("switchTag"));
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name","switchIndication");
        param.setAttribute("value",linePGTable.getAttrValue("switchIndication"));
        row.appendChild(param);
    }
    
     param = new tagElement("param");
	    param.setAttribute("name","workUnitNum");
	    param.setAttribute("value",workUnitList.length);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","protectUnitNum");
	    param.setAttribute("value",protectUnitList.length);
	    row.appendChild(param);
    
    if(linePGTable.getAttrValue("protectionType") == parentWin.PROTECT_TYPE1)
    {
        param = new tagElement("param");
	    param.setAttribute("name","workUnitNum");
	    param.setAttribute("value",workUnitList.length);
	    row.appendChild(param);
    	for(var i = 0; i < workUnitList.length; i++)
    	{
    	    param = new tagElement("param");
		    param.setAttribute("name","protectUnit"+i);
		    param.setAttribute("value",i+1);
		    row.appendChild(param);
		    
		    var workUnit = workUnitList[i].split(":");
		    param = new tagElement("param");
		    param.setAttribute("name","slotid"+i);
		    param.setAttribute("value",workUnit[0]);
            row.appendChild(param);
            
		    param = new tagElement("param");
		    param.setAttribute("name","port"+i);
		    param.setAttribute("value",workUnit[1]);
		    row.appendChild(param);
		    
		 
		    if(workUnit[4]!=null)
		    {
		    	 param = new tagElement("param");
		    	 param.setAttribute("name","au4_"+i);
		    	 param.setAttribute("value",workUnit[4]);
		    	 row.appendChild(param);
		    }
    	}
    	
    }
    else
    {
	    param = new tagElement("param");
	    param.setAttribute("name","protectUnit");
	    param.setAttribute("value",1);
	    row.appendChild(param);
	
	    var workUnit = workUnitList[0].split(":");
	    param = new tagElement("param");
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",workUnit[0]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","port");
	    param.setAttribute("value",workUnit[1]);
	    row.appendChild(param);
	    
	     if(workUnit[4]!=null)
		   {
	    		if(workUnitList.length == 1)
	    		{
	    			param = new tagElement("param");
	    			param.setAttribute("name","au4");
	    			param.setAttribute("value",workUnit[4]);
	    			row.appendChild(param);
	    		}
	    		else
	    		{			
	    			for(var i = 0; i < workUnitList.length; i++)
	    			 {
	    			 	   var temp = workUnitList[i].split(":");
	    			 	   param = new tagElement("param");
		    	 			 param.setAttribute("name","au4_"+i);
		    	       param.setAttribute("value",temp[4]);
		    	       row.appendChild(param);
	    			 }
	    		}
	   }

    }
    var protectUnit = protectUnitList[0].split(":");
    param = new tagElement("param");
    param.setAttribute("name","Pslotid");
    param.setAttribute("value",protectUnit[0]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","Pboardname");
    param.setAttribute("value",protectUnit[2]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","Pport");
    param.setAttribute("value",protectUnit[1]);
    row.appendChild(param);    
    param = new tagElement("param");
    param.setAttribute("name","Pportname");
    param.setAttribute("value",protectUnit[3]);
    row.appendChild(param); 
    
    if(protectUnit[4]!= null)
    {
    	
    	
    	if(workUnitList.length == 1)
	    {
	    			param = new tagElement("param");
    				param.setAttribute("name","Pau4");
    				param.setAttribute("value",protectUnit[4]);
    				row.appendChild(param); 
	    }
	    else
	    {			
	    		for(var i = 0; i < workUnitList.length; i++)
	    		{
	    			 var temp = workUnitList[i].split(":");
	    			 param = new tagElement("param");
		    	 	 param.setAttribute("name","Pau4_"+i);
		    	   param.setAttribute("value",temp[4]);
		    	   row.appendChild(param);
	    			 }
	    		}
    }   


    param = new tagElement("param");
    param.setAttribute("name","PswitchStatue");
    param.setAttribute("value","0");
    row.appendChild(param);  
    param = new tagElement("param");
    param.setAttribute("name","PendIndication");
    param.setAttribute("value","");
    row.appendChild(param);     
    param = new tagElement("param");
    param.setAttribute("name","PprotectedUnit");
    param.setAttribute("value","255");
    row.appendChild(param);    

    param = new tagElement("param");
    param.setAttribute("name","WswitchStatue");
    param.setAttribute("value","0");
    row.appendChild(param);  
    param = new tagElement("param");
    param.setAttribute("name","WendIndication");
    param.setAttribute("value","");
    row.appendChild(param);   
    param = new tagElement("param");
    param.setAttribute("name","WprotectedUnit");
    param.setAttribute("value","255");
    row.appendChild(param);    
    
    bussiness.appendChild(row);
    newLineMspDataXML.getRoot().appendChild(bussiness);
    return newLineMspDataXML.toString();
}

/**
 *               
 * @param doc:          
 * @return  
 */
function callbackCreateLineMsp(doc,isApply)
{
	var data = EncapsulateData(doc);

	var errorCode = data.getSErrorCode();
	showOperResult(data);
	$("okBtn").disabled = false;
  $("cancleBtn").disabled = false;		
	
	if(0 == errorCode || 1 == errorCode) 
	{
		workUnitList = []; //
		protectUnitList = []; 
 		
 		parentWin.queryPG();
		if(!isApply) //               
		{
			self.close();
		}
		
		clearSelectOptions($("selectedport"));
	}
	else //               
	{
		$("applyBtn").disabled = false;	
	}	
}


function removeSelectListData(rightFlag)
{
	$("applyBtn").disabled = false;	
	  
    var srcObj;
    var sinkObj;
    
    if(rightFlag)
    {
    	srcObj = $("availableport");
    	sinkObj = $("selectedport");
    }
    else
    {
    	srcObj = $("selectedport");
    	sinkObj = $("availableport");
    }
    
    if(srcObj.selectedIndex == -1)
    {
    	alert(RESOURCE["ID_SELECT"]);
    	return;
    }
       
    var option = null;
    
    for(var i = 0 ; i < srcObj.options.length; i++)
    {
    	var showText = srcObj.options[i].innerText;
    	if(srcObj.options[i].selected)
    	{   
	    	if(rightFlag)
	    	{
	    		if($("selectMapDirect").value == WEST_WORK_UNIT)
	    		{
	    			if(workUnitList.length >= 1)
		    		{
		    			if(linePGTable.getAttrValue("protectionType") == parentWin.PROTECT_TYPE0)
		    			{
		    				if(!vc4enable)
		    				{
		    				    alert(RESOURCE["INFO_1PLUS1_ONE"]);
		    				    break;
		    			  }
		    			  else
		    			  {
		    			  	 var temp = srcObj.options[i].value.split(":");
		    			  	 currentSlotPort = temp[0]+"-"+temp[1];   			  	
		    			  	 if(lastSlotPort != null && lastSlotPort != currentSlotPort )
		    			  	 {
		    			  	 	   alert(RESOURCE["INFO_1PLUS1_ONE"]);
		    				       break;
		    			  	 } 			  	 
		    			  	 lastSlotPort = currentSlotPort;
		    			  }
		    			}
		    		}
		    		if(vc4enable)
		    		{
		    			var temp = srcObj.options[i].value.split(":");
		    			if(lastSlotPort == null)
		    			{
		    				 lastSlotPort = temp[0]+"-"+temp[1];
		    			}
		    		}
	    			showText = RESOURCE["westWorkUnit"] + ":" + showText;
	    			workUnitList.push(srcObj.options[i].value);
	    		}
	    		else
	    		{
	    			if(protectUnitList.length >= 1 && !vc4enable)
		    		{
		    			alert(RESOURCE["INFO_PROTECT_UNIT_ONE"]);
		    			break;
		    		}
	    			showText = RESOURCE["westProtectUnit"] + ":" + showText;
	    			protectUnitList.push(srcObj.options[i].value);
	    		}
	    	}
	    	else
	    	{
	    		var workUnit = showText.substring(0,showText.indexOf(":"));
	    		showText = showText.substring(showText.indexOf(":")+1);
	    		if(workUnit == RESOURCE["westWorkUnit"])
	    		{
	    			workUnitList.remove(srcObj.options[i].value);
	    		}
	    		else
	    		{
	    			protectUnitList.remove(srcObj.options[i].value);
	    		}
	    		if(workUnitList.length == 0)
	    		{
	    			lastSlotPort = null;
	    		}
	    	}
    		insertSelectOption(sinkObj,srcObj.options[i].value,showText);	
    		
    		srcObj.remove(i);
    		i--;
    	}
    }    
}

/**
 *   option      
 * @param
 * @return
 */
function insertSelectOption(selectObj,insertValue,insertText,optionIndex)
{
	var option = new Option();	
	
	
	if(optionIndex!=null)
	{
		selectObj.add(option,optionIndex);
	}
	else
	{
		selectObj.add(option,getInsertIndex(selectObj,insertValue));
	}
	if(null == insertText)
	{
		insertText = insertValue;	
	}
	option.innerText = insertText;
	option.value = insertValue;
}

/**
 *        
 * @param
 * @return int
 */
function getInsertIndex(selectObj,insertValue)
{
	var optionObjArr = insertValue.split(":");
	var slotid = parseInt(optionObjArr[0]);
	var port = parseInt(optionObjArr[1]);
	var VC4Number = parseInt(optionObjArr[optionObjArr.length-1]);
	
	var otherOptionObjArr
	var otherSlotid;
	var otherPort;
	var otherVC4Number;
	for(var i = 0; i < selectObj.options.length; i++)
	{
		otherOptionObjArr = selectObj.options[i].value.split(":");
		otherSlotid = parseInt(otherOptionObjArr[0]);
		otherPort = parseInt(otherOptionObjArr[1]);
		otherVC4Number = parseInt(otherOptionObjArr[otherOptionObjArr.length-1]);
		if(slotid < otherSlotid)
		{
			return i;
		}		
		else if(slotid ==otherSlotid && port < otherPort)	
		{
			return i;
		}else if(slotid ==otherSlotid && port == otherPort && VC4Number <= otherVC4Number)
		{
			return i;
		}
	}
	return selectObj.options.length;
}

/**
 *      option
 * @param
 * @return
 */
function clearSelectOptions(selectObj)
{
	for(var i = selectObj.options.length; i >= 0; i--)
	{
		selectObj.remove(selectObj.options[i]);
	}
}

function setApplyEnabled()
{
	$("applyBtn").disabled = false;	;
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data)
{
	var errArr = [];//           
	errArr[0] = "groupID";//           

	for(var i = 0, len = data.getBErrLength(); i < len; i++)
	{	
		data.getError().rowErrors[i].errorObj["groupID"] = RESOURCE["Line_MSP_ID"]+ data.getError().rowErrors[i].errorObj["groupID"];
	}		
	openErrPage("../../../../page/",data.getError(),errArr);
}

function doVc4Convert()
{
	vc4enable = !vc4enable;
	initBoardMap(vc4enable);
}
 
function getString(TEPort)
{
	var str;
	if (TEPort.subrackid >= 0)
	{
		str = TEPort.subrackname + "-" + TEPort.showslotid + "-" + TEPort.boardname + "-" + TEPort.portname;
	}
	else
	{
		str = TEPort.slotid + "-" + TEPort.boardname + "-" + TEPort.portname;
	}
	return str;
}
