 var winobj = getNeProperty(self);
var linePGTable;
var boardMapTable;
var boardMapData = null;
var ALL_CLEAR = 16; //     
var LOCKED =  15; //      
var FOCUS_SW = 14; //    
var MANUAL_SW = 8; //    
var EXERCISE_SW = 4; //    
var usedPort = []; //     
var aviablePort = []; //     
var usedPGID = []; //      ID
var delPGList = []; //      
var MIN_GROUP_ID = 1;
var MAX_GROUP_ID = 512;
var REVERTIVE_MODE0 = 0; //     
var REVERTIVE_MODE1 = 1; //    
var PROTECT_TYPE0 = 0; //1+1
var PROTECT_TYPE1 = 1; //1:N
var DEV_OSN1832X16 = "122";
var DEV_OSN1832X8 = "136";

loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);

getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/logicsys/linemsp_"+SYSTEMCONF.getLanguage()+".xml");

if(winobj.neType == "121"  || winobj.neType ==DEV_OSN1832X16)
{
	loadXMLdoc("../../conf/logicsys_v2r8c01/linemsppgtable1800v_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);
	
}
else if(winobj.neType == "67"  ||  winobj.neType == DEV_OSN1832X8)
{
	loadXMLdoc("../../conf/logicsys_v2r8c01/linemsppgtable1800v_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);
	window.tableconf[0].getColFromColId("holdtime").setWidth("0");
	
}
else
{
	loadXMLdoc("../../conf/logicsys_v2r8c01/linemsppgtable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);
}

loadXMLdoc("../../conf/logicsys_v2r8c01/linemspmaptable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);

/**
 *      
 * @param  
 * @return  
 */
function initBody()
{
	$("pgTableTitle").appendChild(document.createTextNode(RESOURCE["PGTitle"]));
	$("boardMapTableTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
	
	initTable();
	initButton();
	queryPG();
	setInterval(querySWStatus,10000); //  10S        
}


/**
 *       
 * @param  
 * @return  
 */
function queryPort()
{
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_FREELINEMSP+"&nmUser="+winobj["nmUser"];		
	loadXMLdoc(url,"POST",false,callbackQueryRes,null,"inputdata="+createQueryResXMLInfo());
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	linePGTable = new SortTable();
	
  linePGTable.setImage("../../../../images/");  
  linePGTable.setOnRowSelectHandler(rowSelectHandler);  
  linePGTable.setOnCellEditHandler(cellEditHandler); 
  linePGTable.isUsedForSelectList = true;
  createTableHead(linePGTable, window.tableconf[0]);  
  linePGTable.setBodyWidth(window.tableconf[0].width,window.tableconf[0].percent,0);
   
  var linePGTableArea = document.createElement("div");
  linePGTableArea.setAttribute("id","protectGroupTable");
  linePGTableArea.className = "adaptTable";
  linePGTableArea.appendChild(linePGTable.getTable());
  $("protectGroup").appendChild(linePGTableArea);

  adjustTableLayout(linePGTable,window.tableconf[0],0);
  
  boardMapTable = new SortTable();	
	boardMapTable.setImage("../../../../images/");    
	boardMapTable.setSingleChoiceFlg(true); 
	boardMapTable.isUsedForSelectList = true;
  createTableHead(boardMapTable, window.tableconf[1]);      
  
  boardMapTable.setBodyWidth(window.tableconf[1].width,window.tableconf[1].percent,0);   
  var boardMapTableArea = document.createElement("div");
  boardMapTableArea.setAttribute("id","boardMapTable");
  boardMapTableArea.className = "adaptTable";
  boardMapTableArea.appendChild(boardMapTable.getTable());
  $("boardMap").appendChild(boardMapTableArea);  
  boardMapTableArea.oncontextmenu=popupMenuHandler;	    
 
	var totalHeight = getComponetHeight($("tablecomponent"),200);
  linePGTable.setBodyHeight(totalHeight*0.6+"px");
  boardMapTable.setBodyHeight(totalHeight*0.38+"px"); 
}

/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
	if(SYSTEMCONF.getLanguage() == "en")
    {
        $("startBtn").className = "buttonstyle3";
        $("endBtn").className = "buttonstyle3";
        $("queryBtn").className = "buttonstyle5";
    }
    
	$("startBtn").value = RESOURCE["startBtn"];
    $("endBtn").value = RESOURCE["endBtn"]; 
	$("createBtn").value = RESOURCE["createBtn"];
    $("queryBtn").value = RESOURCE["queryBtn"]; 
	$("applyBtn").value = RESOURCE["applyBtn"];
    $("delBtn").value = RESOURCE["delBtn"]; 
}

/**
 *            
 * @param  
 * @return  
 */
function initButtonStatus()
{
		setBtnStatus(false,["createBtn","queryBtn"]);
		if(linePGTable.getSelectedRowCount()>0) 
		{
			setBtnStatus(false,["startBtn","endBtn","delBtn"]);
		}
		else
		{
			setBtnStatus(true,["startBtn","endBtn","delBtn"]);
		}
		setBtnStatus(true,["applyBtn"]);
    for(var rowindex = 0,rowlen = linePGTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(linePGTable.getModify(rowindex))
    	{
    		setBtnStatus(false,["applyBtn"]);
    		break;
    	}
    }
}    

/**
 *             
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	if(rows.length == 0)
	{
		$("startBtn").disabled = true;
    $("endBtn").disabled = true;
    $("delBtn").disabled = true;
    boardMapTable.clearTableData();
	}
	else
	{	
		$("startBtn").disabled = false;
    $("endBtn").disabled = false;
    $("delBtn").disabled = false;
	    	
		var groupID = 0;
		
		groupID = linePGTable.getCellStoreValue(rows[0],"groupID","groupID")
		
		queryBoardMapInfo(groupID);	
	}
}

/**
 *             
 * @param  
 * @return  
 */
function cellEditHandler()
{
	$("applyBtn").disabled = false;
}

/**
 *      
 * @param  
 * @return  
 */
function queryPG()
{
	setBtnStatus(true);

	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_LINEMSP+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",true,callbackQueryPG,null,"inputdata="+createQueryPGXMLInfo());
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createQueryPGXMLInfo()
{
		var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *             
 * @param doc:          
 * @return  
 */
function callbackQueryPG(doc)
{
	var data = EncapsulateData(doc);
	var errObj = null;
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{		
		linePGTable.clearTableData();
		boardMapTable.clearTableData();
		fillTableData(data,true);
	}
	else
	{
		errObj = [];
		errObj.push("nename");
	}
	
	initButtonStatus();
	showOperResult(data,errObj);
}

/**
 *         
 * @param data:       isQuery        
 * @return  
 */
function fillTableData(data,isQuery)
{
	handQueryData(data,isQuery);
	
	createTableBody(linePGTable,window.tableconf[0],data,RESOURCE);
	
	if(linePGTable.getDataRowLength() > 0 && linePGTable.getSelectedRowCount() == 0)
	{
		linePGTable.setRowSelect(0);
		rowSelectHandler(linePGTable.getSelectedRows());
	}
	addCellEvent();
}

/**
 *                  
 * @param doc:          
 * @return  
 */
function handQueryData(data,isQuery)
{
	if(isQuery)
	{
		usedPort = [];
		usedPGID = [];
		boardMapData = new DataInterface();
	}

	var boardMapArr = ["vc4_","protectUnit","slotid","boardname","port","portname","switchStatue","endIndication","protectedUnit",
										 "subrackid","subrackname","showslotid"];
	for(var i = data.getDataRowLength()-1; i >= 0; i--)
	{
		usedPGID.push(data.getDataRowParam(i,"groupID"));
		var worknum = data.getDataRowParam(i,"wordPathNum");
		
		var workUnitObj ;
		var ptag;
		
		for (var j = 0 ; j <= worknum ; j++)
		{
	    workUnitObj = new Object();
	    workUnitObj["groupID"] = data.rows[i].groupID;
	   
	    for(var index = 0, len = boardMapArr.length; index < len; index++)
	   	{
	   	  workUnitObj[boardMapArr[index]] = data.rows[i][boardMapArr[index]+j];
	   	}
			boardMapData.rows[boardMapData.rows.length] = workUnitObj;
			
			usedPort.push(new TEPort(workUnitObj.slotid.value,workUnitObj.boardname.value,workUnitObj.port.value,workUnitObj.portname.value,data.rows[i].groupID.value,workUnitObj.vc4_.value,
						workUnitObj.subrackid.value, workUnitObj.subrackname.value,workUnitObj.showslotid.value));	
			removeAviaPort(workUnitObj.slotid.value,workUnitObj.port.value);
		}
		
		/*
		if(data.rows[i].WprotectedUnit.value == 1)
		{
			workUnitObj.protectedSlotid = workUnitObj.slotid;
			workUnitObj.protectedBoardname = workUnitObj.boardname;
			workUnitObj.protectedport = workUnitObj.port;
			workUnitObj.protectedPortname = workUnitObj.portname;
		}*/			
	}
}

/**
 *         
 * @param groupID    ID
 * @return  
 */
function removeBoardMapData(groupID)
{
	for(var index = boardMapData.getDataRowLength()-1; index >= 0; index--)
	{
		if(boardMapData.getDataRowParam(index,"groupID") == groupID)
		{
			boardMapData.rows.removeAt(index);
		}
	}		
}

/**
 *         
 * @param  
 * @return  
 */
function addCellEvent()
{
	var protectType = 0;
	var revertiveModeCell = null;
	var revertiveTimeCell = null;
	var switchModeCellEle = null;
	
	for(var i = 0, len = linePGTable.getDataRowLength(); i < len; i++)
	{
		revertiveModeCell = linePGTable.getCell(i,"revertiveMode");
		revertiveModeCellEle = revertiveModeCell.element;
		revertiveTimeCell = linePGTable.getCell(i,"revertiveTime");
		revertiveTimeCellEle = revertiveTimeCell.element;
		
		switchModeCellEle = linePGTable.getCell(i,"switchMode").element;
		
		protectType = linePGTable.getCellStoreValue(i,"protectionType","protectionType");
		
		if(protectType == PROTECT_TYPE1)
		{
			revertiveModeCellEle.style.backgroundColor = "";
			linePGTable.setCellIsEdit(revertiveModeCell, 0);
			revertiveModeCellEle.ondblclick = null;
			
			switchModeCellEle.style.backgroundColor = "";
			linePGTable.setCellIsEdit(linePGTable.getCell(i,"switchMode"), 0);
			switchModeCellEle.ondblclick = null;
		}		
		
		var isSupportNewRange = SpecialAttrMgr.isNESupport(winobj["neid"], "TE_FUNC_CFG_LINEMS_UNIT", "W32PORT_ATTR_LINEMS_NEW_RANGE");
	    if (isSupportNewRange)
	    {
	    	textCheck(linePGTable.getCellEdit(i, "revertiveTime").element, 6, 64800);
	    }
	    else
	    {
	        textCheck(linePGTable.getCellEdit(i, "revertiveTime").element, 300, 720);
	    }
		var revertiveMode = linePGTable.getCellStoreValue(i,"revertiveMode","revertiveMode");
		if(revertiveMode == REVERTIVE_MODE0)
		{
			revertiveTimeCellEle.style.backgroundColor = "";
			linePGTable.setCellIsEdit(revertiveTimeCell, 0);
			revertiveTimeCellEle.ondblclick = null;
		}
		revertiveModeCell.element.editElement.element.onchange = function()
		{
			revertiveModeCellEvent(this);
		}
	}
}

/**
 *            
 * @param atom:       isShowModify         
 * @return  
 */
function revertiveModeCellEvent(atom,isShowModify)
{
  	var rowindex = atom.parentNode.parentNode.rowIndex;
  	var revertiveTimeCell = linePGTable.getCell(rowindex,"revertiveTime");
  	var revertiveTimeCellEle = revertiveTimeCell.element;
	if(atom.value == REVERTIVE_MODE0)
	{
		
		revertiveTimeCellEle.modify = false;
		linePGTable.setCellValue(revertiveTimeCell,"revertiveTime",0);
		linePGTable.setAtomValue(revertiveTimeCellEle.showElement,"0");
		revertiveTimeCellEle.style.backgroundColor = "";
		linePGTable.setCellIsEdit(revertiveTimeCell, 0);
		revertiveTimeCellEle.ondblclick = null;
	}
	else
	{
		linePGTable.setCellValue(revertiveTimeCell,"revertiveTime",600);
		linePGTable.setAtomValue(revertiveTimeCellEle.showElement,"600");
		revertiveTimeCellEle.style.background = "#ffffff";
		revertiveTimeCellEle.modify = true;
		linePGTable.setCellIsEdit(revertiveTimeCell, 1);
		revertiveTimeCellEle.ondblclick = cellondbclick;		
	}
}

/**
 *             
 * @param groupID    ID
 * @return  
 */
function queryBoardMapInfo(groupID)
{
	var tmpSelectRow = -1;
	var tmpSlectPGID = -1;
	if(boardMapTable.getSelectedRowCount() >0 )
	{
		tmpSelectRow = boardMapTable.getSelectedRows()[0];
		tmpSlectPGID = boardMapTable.getCellStoreValue(0,"groupID","groupID");
	}
	
	boardMapTable.clearTableData();
	var boardData = new DataInterface();
	for(var i = 0, len = boardMapData.getDataRowLength(); i < len; i++)
	{
	  if(boardMapData.rows[i].vc4_.value!="" && boardMapData.rows[i].vc4_.value.indexOf("VC4")<0)
	  {
	  	 boardMapData.rows[i].vc4_.value = "VC4:"+boardMapData.rows[i].vc4_.value;
	  }
		if(boardMapData.getDataRowParam(i,"groupID") == groupID)
		{
			boardData.rows.push(boardMapData.rows[i]);
		}
	}
	
	createTableBody(boardMapTable,window.tableconf[1],boardData,RESOURCE);
	if(groupID == tmpSlectPGID)
	{
		boardMapTable.setRowSelect(tmpSelectRow);
	}
}

/**
 *       
 * @param  
 * @return  
 */
function querySWStatus(isQuery)
{
	if(linePGTable.getDataRowLength() == 0)
	{
		return;
	}

	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LINEMSPSTATE+"&nmUser="+winobj["nmUser"];
	
  loadXMLdoc(url,"POST",true,callbackQuerySWStatus,isQuery,"inputdata="+createQuerySWStatusXMLInfo(isQuery));
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQuerySWStatusXMLInfo(isQuery)
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;    
    delPGList = [];
    var isNeedLog = 0;
    
    if(isQuery)
    {
    	isNeedLog = 1;
    }
    
    for(var i = 0,len = linePGTable.getDataRowLength(); i < len; i++)
    {
    	row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);
	    row.appendChild(param);	    
	    
	    param = new tagElement("param");
	    param.setAttribute("name","isNeedLog");
	    param.setAttribute("value",isNeedLog);
	    row.appendChild(param);
	    	    
	    param = new tagElement("param");
	    param.setAttribute("name","groupID");
	    param.setAttribute("value",linePGTable.getCellStoreValue(i,"groupID","groupID"));
	    row.appendChild(param);    
	    bussiness.appendChild(row);
	    delPGList.push(linePGTable.getCellStoreValue(i,"groupID","groupID"));
	    
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQuerySWStatus(doc,isQuery)
{
	var data = EncapsulateData(doc);
	
	var errorCode = data.getSErrorCode();
	var groupID = 0;
	var protectUnit = 0;
	if(0 == errorCode || 1== errorCode)  
	{	
		for(var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			groupID = data.getDataRowParam(i,"groupID");
			protectUnit = data.getDataRowParam(i,"protectUnit");
			for(var index = 0, size = linePGTable.getDataRowLength(); index < size; index++)
			{
				if(groupID == linePGTable.getCellStoreValue(index,"groupID","groupID"))
				{
					linePGTable.setCellValue(linePGTable.getCell(index,"protocolStatus"),"protocolStatus",data.getDataRowParam(i,"protocolStatus"));
					linePGTable.setAtomValue(linePGTable.getCellElement(index,"protocolStatus").showElement,protocolStatus[data.getDataRowParam(i,"protocolStatus")]);	
					break;
				}
			}
			for(var index = 0, size = boardMapData.getDataRowLength(); index < size; index++)
			{
				if(boardMapData.getDataRowParam(index,"groupID") == groupID && boardMapData.getDataRowParam(index,"protectUnit") == protectUnit)
				{
					boardMapData.rows[index].switchStatue.value = data.getDataRowParam(i,"switchStatue");
					boardMapData.rows[index].endIndication.value = data.getDataRowParam(i,"endIndication");
					if(data.getDataRowParam(i,"protectedUnit") == 1)
					{
						boardMapData.rows[index].protectedSlotid = boardMapData.rows[index].slotid;
						boardMapData.rows[index].protectedBoardname = boardMapData.rows[index].boardname;
						boardMapData.rows[index].protectedport = boardMapData.rows[index].port;
						boardMapData.rows[index].protectedPortname = boardMapData.rows[index].portname;
					}
					else
					{
						boardMapData.rows[index].protectedSlotid = "";
						boardMapData.rows[index].protectedBoardname = "";
						boardMapData.rows[index].protectedport = "";
						boardMapData.rows[index].protectedPortname = "";						
					}
				}
			}
		}	
		rowSelectHandler(linePGTable.getSelectedRows());
	}	
	if(isQuery)
	{
		showOperResult(data);
	}	
}

/**
 *       
 * @param  
 * @return  
 */
function openCreateDialog()
{
	queryPort();
	var dialogHeight = "600px";
	var dialogWidth = "800px";
	showModalDialog("createlinemsp.html", window, "dialogHeight:"+dialogHeight+";dialogWidth:"+dialogWidth+";center:yes;help:no;resizable:No;status:No;");	
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQueryResXMLInfo()
{
	 var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQueryRes(doc)
{
	var data = EncapsulateData(doc);
	
	var errorCode = data.getSErrorCode();
	
	aviablePort = [];
	
	if(0 != errorCode) 
	{		
		return;
	}
	var tmpPort = 0;	
	for(var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		tmpPort = new TEPort(data.getDataRowParam(i,"slotid"),data.getDataRowParam(i,"boardname"),data.getDataRowParam(i,"port"),data.getDataRowParam(i,"portname"),data.getDataRowParam(i,"groupID"),data.getDataRowParam(i,"inflevel"),
			0,data.getDataRowParam(i,"subrackid"),data.getDataRowParam(i,"subrackname"),data.getDataRowParam(i,"showslotid"));
		if(!usedPort.containsPort(tmpPort))
		{
			aviablePort.push(tmpPort);
		}
	}
}

/**
 *         
 * @param  
 * @return  
 */
function startProtocol(isStart)
{
	if(isStart)
	{
		setBtnStatus(true,["startBtn"]);		
	}
	else
	{
		setBtnStatus(true,["endBtn"]);		
	}
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DEAL_LINEMSPPROTOCOL+"&nmUser="+winobj["nmUser"];	
	
  loadXMLdoc(url,"POST",true,callbackStartProtocol,isStart,"inputdata="+createStartProtocolXMLInfo(isStart));
}

/**
 *          XML  
 * @param  
 * @return  
 */
function createStartProtocolXMLInfo(isStart)
{
	var root = new inputxml("datainterface");
	
  var bussiness = new tagElement("bussiness-params");
  var row = null;
  var param = null;  

  var selectedRow = linePGTable.getSelectedRows();
  
  for(var i = 0, len = selectedRow.length; i < len; i++)
  {
  	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","startFlag");
    if(isStart)
    {
    	param.setAttribute("value",1);
    }
    else
    {
    	param.setAttribute("value",0);
    }
    row.appendChild(param);    

    param = new tagElement("param");
    param.setAttribute("name","groupID");
    param.setAttribute("value",linePGTable.getCellStoreValue(selectedRow[i],"groupID","groupID"));
    row.appendChild(param);    
    bussiness.appendChild(row);
  }
  
  root.getRoot().appendChild(bussiness);
  return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackStartProtocol(doc,isStart)
{
	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode())
	{
		alert(RESOURCE["queryProtocolAlert"]);
	}
	else
	{
		showOperResult(data);		
	}
	
	rowSelectHandler(linePGTable.getSelectedRows());
}

/**
 *            
 * @param  
 * @return  
 */
function delLineMsp()
{
	if(!confirm(RESOURCE["ID_BELMSP_PROL"]))
	{
		return;
	}
	
  var selectedRow = linePGTable.getSelectedRows();
  
  var has1J1Pro = false; //         1+1    
  for(var i = 0; i < selectedRow.length; i++)
  {	    
	if(linePGTable.getCellStoreValue(selectedRow[i],"protectionType","protectionType") == PROTECT_TYPE0)
	{
		has1J1Pro = true;
	}
  }
  
	if(has1J1Pro && !confirm(RESOURCE["ID_QX5MSP_PROL"]))
	{
		return;
	}
	setBtnStatus(true,["delBtn"]);
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_LINEMSP+"&nmUser="+winobj["nmUser"];	
	
  loadXMLdoc(url,"POST",true,callbackDelLineMsp,null,"inputdata="+createDelLineMspXMLInfo());
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createDelLineMspXMLInfo()
{
	 var root = new inputxml("datainterface");
	
  var bussiness = new tagElement("bussiness-params");
  var row = null;
  var param = null;    
  
  delPGList = [];
  
  var selectedRow = linePGTable.getSelectedRows();
  
  for(var i = 0; i < selectedRow.length; i++)
  {
  	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","groupID");
    param.setAttribute("value",linePGTable.getCellStoreValue(selectedRow[i],"groupID","groupID"));
    row.appendChild(param);    
    bussiness.appendChild(row);
    delPGList.push(linePGTable.getCellStoreValue(selectedRow[i],"groupID","groupID"));
  }
  
  root.getRoot().appendChild(bussiness);
  return root.toString();
}

/**
 *               
 * @param doc:          
 * @return  
 */
function callbackDelLineMsp(doc)
{

	var data = EncapsulateData(doc);
	var faultPGList = [];
	if(data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
		for(var i = 0,len = data.getBErrLength(); i < len; i++)
		{
			faultPGList.push(data.getBErrParam(i,"groupID"));
		}
	
		for(var i = 0, len = linePGTable.getDataRowLength(); i < len; i++)
		{
			var groupID = linePGTable.getCellStoreValue(i,"groupID","groupID");
			
			if(delPGList.contains(groupID) && !faultPGList.contains(groupID))
			{
				linePGTable.deleteRow(i);
				
				usedPGID.remove(groupID);	
				usedPort.removePort(groupID);
				removeBoardMapData(groupID);
			}
		}	
		linePGTable.adjustDataRows();
	}
	if(linePGTable.getDataRowLength() == 0)
	{
	  adjustTableLayout(linePGTable,window.tableconf[0],0);
  }
	showOperResult(data);
    
  boardMapTable.clearTableData();
    
	if(linePGTable.getDataRowLength() > 0 && linePGTable.getSelectedRowCount() == 0)
	{
		linePGTable.setRowSelect(0);
	}
	rowSelectHandler(linePGTable.getSelectedRows());
	initButtonStatus();
	
  queryPG();
}

/**
 *              
 * @param  
 * @return  
 */
function setLineMsp()
{
	setBtnStatus(true,["applyBtn"]);
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_LINEMSPPARA+"&nmUser="+winobj["nmUser"];	
	
	var xmlData = createSetLineMspXMLInfo();
	if(null == xmlData)
	{
	   return;
	}
	
 	loadXMLdoc(url,"POST",true,callbackSetLineMsp,null,"inputdata="+xmlData);    
}

/**
 *               XML  
 * @param  
 * @return  
 */
function createSetLineMspXMLInfo()
{
	var root = new inputxml("datainterface");
	
  var bussiness = new tagElement("bussiness-params");
  var row = null;
  var param = null;
  var isModify = false;
  for(var rowindex = 0,rowlen = linePGTable.getDataRowLength();rowindex<rowlen;rowindex++)
  {
  	if(!linePGTable.getModify(rowindex))
  	{
  		continue;
  	}
  	isModify = true;
      rowData = linePGTable.getRow();
  	row = new tagElement("row-params");
  	
  	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",winobj["neid"]); 
		row.appendChild(param);	
		
  	for(var colindex = 0,collen = linePGTable.getColumnCount();colindex<collen;colindex++)
  	{
  		colid = window.tableconf[0].getColId(colindex);
  		cellModifyFlag = linePGTable.getCellModify(rowindex,colid);
  		colkeyarray = window.tableconf[0].getColKeyArray(colindex);
  		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
  		{
  			param = new tagElement("param");
  			key = colkeyarray[keyindex].name;
  			param.setAttribute("name",key);
  			param.setAttribute("value",linePGTable.getCellStoreValue(rowindex,colid,key));   
  			param.setAttribute("modifyFlag",cellModifyFlag); 
  			row.appendChild(param);		
  		}    		
  	}
  	bussiness.appendChild(row);
  }    
  if(!isModify)
  {
  	return null;
  }
  root.getRoot().appendChild(bussiness);
  return root.toString();
}

/**
 *                 
 * @param doc:          
 * @return  
 */
function callbackSetLineMsp(doc)
{
	var data = EncapsulateData(doc);	
	refreshTableState(linePGTable,window.tableconf[0],data);
	if(0 != data.getSErrorCode())
	{
		setBtnStatus(false,["applyBtn"]);
	}
	showOperResult(data);	
}

/**
 *       
 * @param  
 * @return  
 */
function switchLineMsp(switchType)
{
	if(15 == switchType)
	{
		if( !confirm(RESOURCE["LockAlarm"]) )
		return;
	}
	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_LINEMSPSW+"&nmUser="+winobj["nmUser"];	
	
	loadXMLdoc(url,"POST",true,callbackSwitchLineMsp,switchType,"inputdata="+createSwitchLineMspXMLInfo(switchType));
}

/**
 *        XML  
 * @param  
 * @return  
 */
function createSwitchLineMspXMLInfo(switchType)
{
	var root = new inputxml("datainterface");
	
  var bussiness = new tagElement("bussiness-params");
  var row = null;
  var param = null;
  

  var selectedRow = boardMapTable.getSelectedRows();
  
	row = new tagElement("row-params");
  param = new tagElement("param");
  param.setAttribute("name","neid");
  param.setAttribute("value",winobj["neid"]);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name","groupID");
  param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRow[0],"groupID","groupID"));
  row.appendChild(param);    
  
  param = new tagElement("param");
  param.setAttribute("name","protectUnit");
  param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRow[0],"protectUnit","protectUnit"));
  row.appendChild(param);    
  
  param = new tagElement("param");
  param.setAttribute("name","switchType");
  param.setAttribute("value",switchType);
  row.appendChild(param);    
  bussiness.appendChild(row);

  root.getRoot().appendChild(bussiness);
  return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackSwitchLineMsp(doc,switchType)
{
	var data = EncapsulateData(doc);
	if(0 == data.getSErrorCode())
	{
		alert(RESOURCE["querySWStatus"]);
	}	
	showOperResult(data);
}

 /**
 *             
 * @param data: 
 * @return  
 */
function createjsDOMenu()
{
  removejsDOMmenu();
	var menuSize = 150; 
  if(SYSTEMCONF.getLanguage() == "en")
  {
  	menuSize = 200;
  }  
  var cursorMenu1 = new jsDOMenu(menuSize); 
  cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryPG"],"",queryPG,null));      	
  cursorMenu1.addMenuItem(new menuItem(RESOURCE["querySwitchStatus"],"",querySWStatus,true));
  setPopUpMenu(cursorMenu1);
}

 /**
 *           
 * @param data: 
 * @return  
 */
function popupMenuHandler(evt)
{
  	if(!evt)
  	{
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null && elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		  return;
	}  
	
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;

    if(rows.contains(rowid))
    {
    	createFuncPopupMenu(rows,evt);    	
    }    
}

 /**
 *           
 * @param data: 
 * @return  
 */
function createFuncPopupMenu(rows,evt)
{
	removejsDOMmenu(); 
	var menuSize = 150; 
	var cursorMenu1 = new jsDOMenu(menuSize); 
	var isClear = true;
	
	var protectUnit = boardMapTable.getCellStoreValue(rows[0],"protectUnit","protectUnit"); //   0     1     
	
	
	var protectionType ; //    
	var revertiveMode = linePGTable.getCellStoreValue(linePGTable.getSelectedRows()[0],"revertiveMode","revertiveMode"); //    
	
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["querySW"],"",querySWStatus,true));
	cursorMenu1.addMenuItem(new menuItem('-'));
	
	if(254 == boardMapTable.getCellStoreValue(rows[0],"switchStatue","switchStatue"))
	{
	isClear =  false;
	}
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearSW"],"",switchLineMsp,[ALL_CLEAR],isClear));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["lockProtect"],"",switchLineMsp,[LOCKED]));
	
	if( protectUnit >0)
	{
	if(1 == revertiveMode) //    
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW]));     		
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW]));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW]));
	} 
	else //     
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToWork"],"",switchLineMsp,[FOCUS_SW],false));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW]));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToWork"],"",switchLineMsp,[MANUAL_SW],false));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW]));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW]));
	}    
	}
	else //      
	{
	if(1 == revertiveMode) //    
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToWork"],"",switchLineMsp,[FOCUS_SW],false));    		
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW],false));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToWork"],"",switchLineMsp,[MANUAL_SW],false));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW],false));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW],false));
	} 
	else //     
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToWork"],"",switchLineMsp,[FOCUS_SW]));    		
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"],"",switchLineMsp,[FOCUS_SW],false));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToWork"],"",switchLineMsp,[MANUAL_SW]));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"],"",switchLineMsp,[MANUAL_SW],false));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"],"",switchLineMsp,[EXERCISE_SW]));
	}       	
	}
	setPopUpMenu(cursorMenu1);
	showMenu(evt);
}

function setBtnStatus(disabledState,btnIDArr)
{	
	if(null == btnIDArr || btnIDArr.length == 0)
	{	
		btnIDArr = [];		
		btnIDArr.push("startBtn");
		btnIDArr.push("endBtn");
		btnIDArr.push("createBtn");
		btnIDArr.push("queryBtn");
		btnIDArr.push("applyBtn");
		btnIDArr.push("delBtn");
	}
	
	for(var i = 0; i < btnIDArr.length; i++)
	{
		$(btnIDArr[i]).disabled = disabledState;			
	}	
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data,errArr)
{
	if(null == errArr)
	{
		errArr = [];//           
		errArr[0] = "groupid";//           
	
		for(var i = 0, len = data.getBErrLength(); i < len; i++)
		{	
			temp = data.getError().rowErrors[i].errorObj["groupid"];
			if(null == temp)
			{
				temp = data.getError().rowErrors[i].errorObj["groupID"];
			}
			data.getError().rowErrors[i].errorObj["groupid"] = RESOURCE["Line_MSP_ID"]+ temp;
		}		
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = "/";
		}		
		return resValue;
	}
}

 /**
 *               
 * @param data: 
 * @return  
 */
window.onresize=function()
{
	 var totalHeight = getComponetHeight($("tablecomponent"),200);
	 linePGTable.setBodyHeight(totalHeight*0.6+"px");
	 boardMapTable.setBodyHeight(totalHeight*0.38+"px");
}

function removeAviaPort(slotid,port)
{
	for(var i = aviablePort.length-1; i >=0; i--)
	{
		if(aviablePort[i].slotid == slotid && aviablePort[i].port == port)
		{
			aviablePort.removeAt(i);
		}
	}	
}

Array.prototype.containsPort = function(portObj)
{
	for(var i = 0, len = this.length; i < len; i++)
	{
		if(this[i].equals(portObj))
		{
			return true;
		}
	}
	return false;
}

Array.prototype.removePort = function(groupID)
{
	for(var i = this.length-1; i >=0; i--)
	{
		if(this[i].groupID == groupID)
		{
			this.removeAt(i);
		}
	}
}

/**
 * TEPort  
 * @param 
 * @return
 */ 
function TEPort(slotid,boardname,port,portname,groupID,inflevel,vc4,
	subrackid, subrackname, showslotid)
{
	this.slotid = slotid;
	this.boardname = boardname;	
	this.port = port;
	this.portname = portname;
	this.groupID = groupID;
	this.vc4 = vc4;
	this.inflevel = inflevel;
	this.subrackid = subrackid;
	this.subrackname = subrackname;
	this.showslotid = showslotid;
}

/**
 * TEPort   equals  
 * @param
 * @return boolean
 */
TEPort.prototype.equals = function(otherPort)
{	
	if(this.slotid == otherPort.slotid && this.port == otherPort.port)
	{
		return true;
	}
	return false;
}

/**
 * TEPort   equals  
 * @param
 * @return boolean
 */
TEPort.prototype.compare = function(otherPort)
{	
	if(this.slotid > otherPort.slotid)
	{
		return 1;
	}
	else if(this.slotid < otherPort.slotid)
	{
		return -1;
	}
	else
	{
		if(this.port > otherPort.port)
		{
			return 1;
		}
		else if(this.port <= otherPort.port)
		{
			return -1;
		}
	}
}

/**
 * TEPort   toString  
 * @param
 * @return String
 */
TEPort.prototype.toString = function()
{
	var str;

	if (this.subrackid && this.subrackid >= 0)
	{
		str = this.subrackname + "-" + this.showslotid + "-" + this.boardname + "-" + this.portname;
	}
	else
	{
		str = this.slotid + "-" + this.boardname + "-" + this.portname;
	}
	return str;
}
