var winobj = getNeProperty(self);
var parentWin = getParentWindow();
var linePGTable; //          
var newLineMspDataXML; //         XML  
var availablePortList = []; //           
var workUnitList = []; //             
var protectUnitList = []; //             
var MIN_DELAYTIME = 300; //       
var MAX_DELAYTIME = 720; //       
var DEFAULT_DELAYTIME = 600; //       
var WEST_WORK_UNIT = 1; //       
var WEST_PROTECT_UNIT = 2; //       
var groupID = 1;
loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);

getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/logicsys/linemsp_"+SYSTEMCONF.getLanguage()+".xml");
document.title = RESOURCE["createPGTitle"];

/**
 *      
 * 
 * @param  
 * @return  
 */
function initBody()
{
	$("boardMapTableTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
	$("selectMapDirectTitle").appendChild(document.createTextNode(RESOURCE["selectMapDirectTitle"]));
	$("selectMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectMapBoardTitle"]));
	$("selectedMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectedMapBoardTitle"]));

	$("okBtn").value = RESOURCE["okbutton"];
    $("cancleBtn").value = RESOURCE["cancelbutton"]; 
	$("applyBtn").value = RESOURCE["applybutton"];

	$("selectMapDirect").options[0] = new Option(RESOURCE["westWorkUnit"],WEST_WORK_UNIT);
	$("selectMapDirect").options[1] = new Option(RESOURCE["westProtectUnit"],WEST_PROTECT_UNIT);

	initTable();
	initBoardMap();
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	linePGTable = new CTable();
	
	linePGTable.addHead(RESOURCE["attrCol"],RESOURCE["valueCol"]);
	
	var cTableAtom = null;
	var cTableAtomEle = null;
	
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["oneplusone"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["oneToMore"],1);  
    cTableAtomEle.onchange = protectTypeListener;
    linePGTable.addAttrRow("protectionType",RESOURCE["protectionType"],cTableAtom); 
    
    cTableAtom = new Atom("select"); 
    cTableAtomEle = cTableAtom.element;    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["singleSwitch"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["bothSwitch"],1);
    cTableAtomEle.onchange = setApplyEnabled;  
    linePGTable.addAttrRow("switchMode",RESOURCE["switchMode"],cTableAtom); 
      
    cTableAtom = new Atom("select"); 
    cTableAtomEle = cTableAtom.element;         
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Non-Revertive"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Revertive"],1);
    cTableAtomEle.onchange = revertiveModeListener;  
    linePGTable.addAttrRow("revertiveMode",RESOURCE["revertiveMode"],cTableAtom); 

    cTableAtom = new Atom("text"); 
    cTableAtomEle = cTableAtom.element; 
    cTableAtom.setValue(DEFAULT_DELAYTIME);
    cTableAtomEle.disabled = true;
    checkDataCellEvent(cTableAtomEle,MIN_DELAYTIME,MAX_DELAYTIME,DEFAULT_DELAYTIME);
    cTableAtomEle.style.imeMode = "disabled"; 
    
    linePGTable.addAttrRow("revertiveTime",RESOURCE["revertiveTime"],cTableAtom); 

    cTableAtom = new Atom("select"); 
    cTableAtomEle = cTableAtom.element;    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Disabled"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Enabled"],1); 
    cTableAtomEle.options[1].selected = true; //     
    cTableAtomEle.onchange = setApplyEnabled;  
    linePGTable.addAttrRow("sdEnable",RESOURCE["sdEnable"],cTableAtom); 

    cTableAtom = new Atom("select");  
    cTableAtomEle = cTableAtom.element;    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["NewProtocol"],1);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["OldProtocol"],2); 
    cTableAtomEle.onchange = setApplyEnabled;     
    linePGTable.addAttrRow("protocolType",RESOURCE["protocolType"],cTableAtom); 

    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;      
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Hight-Priority"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Low-Priority"],1); 
    cTableAtomEle.onchange = setApplyEnabled;     
    linePGTable.addAttrRow("switchTag",RESOURCE["switchTag"],cTableAtom); 

    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;      
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["No-Indication"],0);    
    cTableAtomEle.options[cTableAtomEle.options.length]= new Option(RESOURCE["Indication"],1); 
    cTableAtomEle.onchange = setApplyEnabled;     
    linePGTable.addAttrRow("switchIndication",RESOURCE["switchIndication"],cTableAtom); 
    
    $("linePGTableArea").appendChild(linePGTable.getTable()); 
}

/**
 *           
 * 
 * @param  
 * @return  
 */
function initBoardMap()
{
	clearSelectOptions($("availableport"));
	clearSelectOptions($("selectedport"));
	workUnitList = []; //             
    protectUnitList = []; //             
	var availableportObj = $("availableport");
	for(var i = 0; i < parentWin.aviablePort.length; i++)
	{
		var tmpPort = parentWin.aviablePort[i]
		insertSelectOption(availableportObj,tmpPort.slotid+":"+tmpPort.port+":"+tmpPort.boardname+":"+tmpPort.portname,tmpPort.toString());
	}
}

/**
 *                  
 * 
 * @param  
 * @return  
 */
function protectTypeListener()
{
	setApplyEnabled();
	linePGTable.setAttrValue("sdEnable",1);
	linePGTable.setAttrValue("protocolType",1);
	linePGTable.setAttrValue("switchTag",0);
	linePGTable.setAttrValue("switchIndication",1);
	
	if(this.value == 0) // 1+1  
	{
		linePGTable.setAttrValue("switchMode",0);
	    linePGTable.getAtom("switchMode").element.options.add(new Option(RESOURCE["singleSwitch"],0),0);    
		
	    linePGTable.getAtom("revertiveMode").element.options.add(new Option(RESOURCE["Non-Revertive"],0),0);    
	     
		linePGTable.setAttrValue("revertiveMode",0);		
		linePGTable.setAttrValue("revertiveTime",DEFAULT_DELAYTIME);
		linePGTable.getAtom("revertiveTime").element.disabled = true;
	}
	else // 1:N  
	{
		alert(RESOURCE["MSP_CREATE_WARN"]);
		linePGTable.setAttrValue("switchMode",1);
	    linePGTable.getAtom("switchMode").element.options.remove(0);
		
	    linePGTable.getAtom("revertiveMode").element.options.remove(0);
	    
		linePGTable.setAttrValue("revertiveMode",1);		
		linePGTable.setAttrValue("revertiveTime",DEFAULT_DELAYTIME);
		linePGTable.getAtom("revertiveTime").element.disabled = false;
	}
	
	initBoardMap();
}

/**
 *         
 * 
 * @param  
 * @return  
 */
function revertiveModeListener()
{
	setApplyEnabled();
    linePGTable.setAttrValue("revertiveTime",DEFAULT_DELAYTIME);
    
	if(this.value == 0)
	{
		linePGTable.getAtom("revertiveTime").element.disabled = true;
	}
	else //     
	{
		linePGTable.getAtom("revertiveTime").element.disabled = false;		
	}
}

/**
 *            
 */
function doCreateLineMsp(isApply)
{
	if($("applyBtn").disabled)
	{
		self.close();
	}
	
	if(workUnitList.length == 0)
	{
		alert(RESOURCE["INFO_WEST_WORK_NOT_SELECTED"]);
		return;
	}
	else if(protectUnitList.length == 0)
	{
		alert(RESOURCE["INFO_WEST_PROTECT_NOT_SELECTED"]);
		return;
	}
	
	 var checkFlg = true;
	for(var i = 0; i < protectUnitList.length; i++)
  {
		    var protectUnit = protectUnitList[i].split(":");
		    for(var i = 0; i < workUnitList.length; i++)
		    {
		    	var workUnit = workUnitList[i].split(":");
		    	if(checkFlg)
		    	{
		    	if(workUnit[0] == protectUnit[0])
		    	{
		    		if(!confirm(RESOURCE["INFO_ONSAMEBOARD"]) )
		    		{
		          return;
		        }
		        else
		        {
		        	checkFlg = false;
		        	continue;
		        }
		    	}
		     }
		    }
	}	 
	
	$("okBtn").disabled = true;
    $("cancleBtn").disabled = true;
	$("applyBtn").disabled = true;
	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_LINEMSP+"&nmUser="+parentWin.winobj["nmUser"];
	
	
    loadXMLdoc(url,"POST",true,callbackCreateLineMsp,isApply,"inputdata="+createCreateLineMspXMLInfo());	
}

/**
 *             XML  
 * 
 * @param  
 * @return  
 */
function createCreateLineMspXMLInfo()
{
	newLineMspDataXML = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.winobj["neid"]);
    row.appendChild(param);
   
    param = new tagElement("param");
    param.setAttribute("name","groupID");
    var groupIDList = getRangeNumber(parentWin.usedPGID,parentWin.MIN_GROUP_ID,parentWin.MAX_GROUP_ID,1);
    groupID = groupIDList[0];
    param.setAttribute("value",groupID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","protectionType");
    param.setAttribute("value",linePGTable.getAttrValue("protectionType"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","switchMode");
    param.setAttribute("value",linePGTable.getAttrValue("switchMode"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","revertiveMode");
    param.setAttribute("value",linePGTable.getAttrValue("revertiveMode"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","revertiveTime");
    if(linePGTable.getAttrValue("revertiveMode") == 1)
    {
    	param.setAttribute("value",linePGTable.getAttrValue("revertiveTime"));	
    }
    else //             0
    {
    	param.setAttribute("value","0");
    }
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","sdEnable");
    param.setAttribute("value",linePGTable.getAttrValue("sdEnable"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","protocolType");
    param.setAttribute("value",linePGTable.getAttrValue("protocolType"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","protocolStatus");
    param.setAttribute("value","254");
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","switchTag");
    param.setAttribute("value",linePGTable.getAttrValue("switchTag"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","switchIndication");
    param.setAttribute("value",linePGTable.getAttrValue("switchIndication"));
    row.appendChild(param);
    if(linePGTable.getAttrValue("protectionType") == parentWin.PROTECT_TYPE1){
        param = new tagElement("param");
	    param.setAttribute("name","workUnitNum");
	    param.setAttribute("value",workUnitList.length);
	    row.appendChild(param);
    	for(var i = 0; i < workUnitList.length; i++){
    	    param = new tagElement("param");
		    param.setAttribute("name","protectUnit"+i);
		    param.setAttribute("value",i+1);
		    row.appendChild(param);
		    
		    var workUnit = workUnitList[i].split(":");
		    param = new tagElement("param");
		    param.setAttribute("name","slotid"+i);
		    param.setAttribute("value",workUnit[0]);
            row.appendChild(param);
            
		    param = new tagElement("param");
		    param.setAttribute("name","port"+i);
		    param.setAttribute("value",workUnit[1]);
		    row.appendChild(param);
    	}
    }
    else
    {
	    param = new tagElement("param");
	    param.setAttribute("name","protectUnit");
	    param.setAttribute("value",1);
	    row.appendChild(param);
	
	    var workUnit = workUnitList[0].split(":");
	    param = new tagElement("param");
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",workUnit[0]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","port");
	    param.setAttribute("value",workUnit[1]);
	    row.appendChild(param);

    }
    var protectUnit = protectUnitList[0].split(":");
    param = new tagElement("param");
    param.setAttribute("name","Pslotid");
    param.setAttribute("value",protectUnit[0]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","Pboardname");
    param.setAttribute("value",protectUnit[2]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","Pport");
    param.setAttribute("value",protectUnit[1]);
    row.appendChild(param);    
    param = new tagElement("param");
    param.setAttribute("name","Pportname");
    param.setAttribute("value",protectUnit[3]);
    row.appendChild(param);    


    param = new tagElement("param");
    param.setAttribute("name","PswitchStatue");
    param.setAttribute("value","0");
    row.appendChild(param);  
    param = new tagElement("param");
    param.setAttribute("name","PendIndication");
    param.setAttribute("value","");
    row.appendChild(param);     
    param = new tagElement("param");
    param.setAttribute("name","PprotectedUnit");
    param.setAttribute("value","255");
    row.appendChild(param);    

    param = new tagElement("param");
    param.setAttribute("name","WswitchStatue");
    param.setAttribute("value","0");
    row.appendChild(param);  
    param = new tagElement("param");
    param.setAttribute("name","WendIndication");
    param.setAttribute("value","");
    row.appendChild(param);   
    param = new tagElement("param");
    param.setAttribute("name","WprotectedUnit");
    param.setAttribute("value","255");
    row.appendChild(param);    
    
    bussiness.appendChild(row);
    newLineMspDataXML.getRoot().appendChild(bussiness);
    return newLineMspDataXML.toString();
}

/**
 *               
 * 
 * @param doc:          
 * @return  
 */
function callbackCreateLineMsp(doc,isApply)
{
	var data = EncapsulateData(doc);

	var errorCode = data.getSErrorCode();
	showOperResult(data);
	$("okBtn").disabled = false;
    $("cancleBtn").disabled = false;		
	
	if(0 == errorCode || 1 == errorCode) 	
	{	
 		parentWin.queryPG();
		if(!isApply) //                
		{
			self.close();
		}
		
		clearSelectOptions($("selectedport"));
		workUnitList = [];
		protectUnitList = [];

	}
	else //                
	{
		$("applyBtn").disabled = false;	
	}	
}

/**
 *     
 */
function removeSelectListData(rightFlag)
{
	$("applyBtn").disabled = false;	
	
    var srcObj;
    var sinkObj;
    
    if(rightFlag)
    {
    	srcObj = $("availableport");
    	sinkObj = $("selectedport");
    }
    else
    {
    	srcObj = $("selectedport");
    	sinkObj = $("availableport");
    }
    
    if(srcObj.selectedIndex == -1)
    {
    	alert(RESOURCE["ID_SELECT"]);
    	return;
    }
       
    var option = null;    
    
    for(var i = 0 ; i < srcObj.options.length; i++)
    {
    	var showText = srcObj.options[i].innerText;

    	if(srcObj.options[i].selected)
    	{   
	    	if(rightFlag)
	    	{
	    		if($("selectMapDirect").value == WEST_WORK_UNIT)
	    		{
	    			if(workUnitList.length == 1)
		    		{
		    			if(linePGTable.getAttrValue("protectionType") == parentWin.PROTECT_TYPE0)
		    			{
		    				alert(RESOURCE["INFO_1PLUS1_ONE"]);
		    				break;
		    			}
		    		}
	    			showText = RESOURCE["westWorkUnit"] + ":" + showText;
	    			workUnitList.push(srcObj.options[i].value);
	    		}
	    		else
	    		{
	    			if(protectUnitList.length == 1)
		    		{
		    			alert(RESOURCE["INFO_PROTECT_UNIT_ONE"]);
		    			break;
		    		}
	    			showText = RESOURCE["westProtectUnit"] + ":" + showText;
	    			protectUnitList.push(srcObj.options[i].value);
	    		}
	    	}
	    	else
	    	{
	    		var workUnit = showText.substring(0,showText.indexOf(":"));
	    		showText = showText.substring(showText.indexOf(":")+1);
	    		if(workUnit == RESOURCE["westWorkUnit"])
	    		{
	    			workUnitList.remove(srcObj.options[i].value);
	    		}
	    		else
	    		{
	    			protectUnitList.remove(srcObj.options[i].value);
	    		}
	    	}
    		     		
    		insertSelectOption(sinkObj,srcObj.options[i].value,showText);	
    		
    		srcObj.remove(i);
    		i--;
    	}
    }    
}

function insertSelectOption(selectObj,insertValue,insertText)
{
	var option = new Option();	
	selectObj.add(option,getInsertIndex(selectObj,insertValue));
	if(null == insertText)
	{
		insertText = insertValue;	
	}
	option.innerText = insertText;
	option.value = insertValue;
}

/**
 *        
 */
function getInsertIndex(selectObj,insertValue)
{
	var optionObjArr = insertValue.split(":");
	var slotid = parseInt(optionObjArr[0]);
	var port = parseInt(optionObjArr[1]);
	
	var otherOptionObjArr
	var otherSlotid;
	var otherPort;
	for(var i = 0; i < selectObj.options.length; i++)
	{
		otherOptionObjArr = selectObj.options[i].value.split(":");
		otherSlotid = parseInt(otherOptionObjArr[0]);
		otherPort = parseInt(otherOptionObjArr[1]);
		if(slotid < otherSlotid)
		{
			return i;
		}		
		else if(slotid ==otherSlotid && port <= otherPort)	
		{
			return i;
		}
	}
	return selectObj.options.length;
}

/**
 *      option
 */
function clearSelectOptions(selectObj)
{
	for(var i = selectObj.options.length; i >= 0; i--)
	{
		selectObj.remove(selectObj.options[i]);
	}
}

function setApplyEnabled()
{
	$("applyBtn").disabled = false;	;
}

/**
 *       
 * 
 * @param data:           
 *            errArr:       
 * @return  
 */
function showOperResult(data)
{
	var errArr = [];//            
	errArr[0] = "groupID";//            

	for(var i = 0, len = data.getBErrLength(); i < len; i++)
	{	
		data.getError().rowErrors[i].errorObj["groupID"] = RESOURCE["Line_MSP_ID"]+ data.getError().rowErrors[i].errorObj["groupID"];
	}		
	openErrPage("../../../../page/",data.getError(),errArr);
}
