var st;
var clockslotno = parent.clockslot;
var statedoc;

var btnRightArr = new Object();
var neobject = getNeProperty(parent);

var clockstate = new Object();
clockstate[0] = "noability";
clockstate[1] = "ability";

var lockstate = new Object();
lockstate[0] = "lock";
lockstate[1] = "nolock";
var timeoutid;

function tabSelectHandler()
{
    if (st == null) 
    {
        init();
    }
}

function init()
{
    $("querybtn").value = RESOURCE["query"];
    $("applybtn").value = RESOURCE["apply"];
    $("newbtn").value = RESOURCE["new"];
    $("delbtn").value = RESOURCE["del"];
    $("srctext").innerHTML = RESOURCE["switchsrc"];
    $("statetext").innerHTML = RESOURCE["switchstate"];
    $("cursrctext").innerHTML = RESOURCE["cursrctext"];
    $("s1bytetext").innerHTML = RESOURCE["s1bytetext"];
    
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_SortTableHead_clock2m1");
    st.body.setAttribute("id", "htmlTable_SortTableBody_clock2m1");
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    
    $("autoacross").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("autoacross"), 70) + "px");
    window.onresize = function()
    {
        st.setBodyHeight(getComponetHeight($("autoacross"), 70) + "px");
    };
    
    st.setOnRowSelectHandler(stSelectFun);
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_CLOCKIDENABLE);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SETCLKLOCKSTATE);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_SETCLKLOCKSTATE);
    btnRightArr.delbtn = new BtnRightObj("delbtn", TECMDCODE_SETCLKLOCKSTATE);
    
    getRightInfo(neobject, btnRightArr);
    
    if (btnRightArr.applybtn.right) 
    {
        $("autoacross").oncontextmenu = rightlist;//popupMenuHandler1; 
    }
    else 
    {
        $("down").disabled = true;
        $("up").disabled = true;
        $("newbtn").disabled = true;
    }
    $("delbtn").disabled = true;
    $("applybtn").disabled = true;
    $("querybtn").disabled = true;
    
    if (btnRightArr.querybtn.right) 
    {
        query();
    }
}

function query()
{
    timeoutid = null;
    $("querybtn").disabled = true;
    
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_2M_PRI_TBL + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, updatePG, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clockslotno");
    param.setAttribute("value", clockslotno);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clock2mindex");
    param.setAttribute("value", clock2mindex);
    row.appendChild(param);
    
    var logstr; 
    if (clock2mindex == 2) // 2 2M      
    {
    	logstr = RESOURCE["clockpriority2m2"];
    }
    else  // 1 2M      
    {
    	logstr = RESOURCE["clockpriority2m1"];
    }
    param = new tagElement("param");
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", logstr);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function updatePG(doc)
{
    statedoc = doc;
    var data = EncapsulateData(doc);
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    if (0 != data.getSErrorCode()) 
    {
        $("querybtn").disabled = false;
        
        if (st.getDataRowLength() == 0) 
        {
			$("newbtn").disabled = true;
            $("delbtn").disabled = true;
            $("applybtn").disabled = true;
        }
        
        if (st.getSelectedRowCount() <= 0) 
        {
            $("delbtn").disabled = true;
        }
        showErrorDialog(data);
        return;
    }
    
    querySwitch();
}

function querySwitch()
{
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET2MPLL + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, refreshWorkBoard, null, "inputdata=" + xmlstr);
}

function refreshWorkBoard(doc)
{
    $("querybtn").disabled = false;
    
    updataTable(statedoc);
    
    refreshSwitchInfo(doc);
}

function refreshSwitchInfo(doc)
{
    var newdata = EncapsulateData(doc);
    
    if (0 != newdata.getSErrorCode()) 
    {
        showErrorDialog(newdata);
        return;
    }
    
    var switchsrc = newdata.rows[0]["switchsrc"].value;
    $("switchsrc").value = switchsrc;
    
    var switchstate = newdata.rows[0]["switchstate"].value;
    $("switchstate").value = switchstate;
    
    var cursrc = newdata.rows[0]["cursrc"].value;
    $("cursrc").value = cursrc;
    
    var s1byte = newdata.rows[0]["s1quality"].value;
    
    $("s1byte").value = s1byte;
}

function updataTable(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        $("querybtn").disabled = false;
        showErrorDialog(data);
        return;
    }
    st.clearTableData();
    
    createTableBody(st, window.tableconf[0], data, RESOURCE);
    
    if (st.getDataRowLength() == 0) 
    {
        $("delbtn").disabled = true;
        $("applybtn").disabled = true;
    }
    if (st.getSelectedRowCount() <= 0) 
    {
        $("delbtn").disabled = true;
    }
}

function lock(lockstate)
{
    var xmlstr = createLockXML(lockstate);
    if (xmlstr == null) 
    {
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_2M_LOCK_STATE + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshTable, null, "inputdata=" + xmlstr);
}

function refreshTable(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return;
    }
    query();
}

/**
 * 0       1     
 */
function createLockXML(lockstate)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            var row = new tagElement("row-params");
            var param = new tagElement("param");
            var neidvalue = neobject.neid;
            param.setAttribute("name", "neid");
            param.setAttribute("value", neidvalue);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "clockslotno");
            param.setAttribute("value", clockslotno);
            row.appendChild(param);
            
            param = new tagElement("param");
            var clockid = st.getCellCurrentValue(i, "clockid", "clockid");
            param.setAttribute("name", "clockid");
            param.setAttribute("value", clockid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "lockstate");
            param.setAttribute("value", lockstate);
            row.appendChild(param);
            
            param = new tagElement("param");
            var clockname = st.getCellCurrentValue(i, "clockname", "clockname");
            param.setAttribute("name", "clockname");
            param.setAttribute("value", clockname);
            row.appendChild(param);
            
            bussiness.appendChild(row);
        }
    }
    
    if (bussiness.childNodes.length <= 0) 
    {
        return null;
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createSwitchXML(switchstate)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var selectnum = st.getSelectedRowCount();
    var sel = st.getSelectedRows();
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clockslotno");
    param.setAttribute("value", clockslotno);
    row.appendChild(param);
    
    param = new tagElement("param");
    var clockid = "";
    var portName = "";
    var desc = RESOURCE["switchstate"] + ":";
    if (selectnum >= 1) 
    {
        clockid = st.getCellCurrentValue(sel[0], "clockid", "clockid");
        portName = st.getCellCurrentValue(sel[0], "clockname", "clockname");
    }
    
    if (switchstate == "2") 
    {
        desc += RESOURCE["forceswitch"];
    }
    else if (switchstate == "0") 
    {
        desc += RESOURCE["clearswitch"];
    }
    else if (switchstate == "1") 
    {
        desc += RESOURCE["manualswitch"];
    }
    desc = portName + " " + desc;
    param.setAttribute("name", "clockid");
    param.setAttribute("value", clockid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "switchstate");
    param.setAttribute("value", switchstate);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clock2mindex");
    param.setAttribute("value", clock2mindex);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", desc);
    row.appendChild(param);
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function switchclock(switchstate)
{
    var xmlstr = createSwitchXML(switchstate);
    
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_2M_SWITCH_STATE + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshSwitch, null, "inputdata=" + xmlstr);
}

function refreshSwitch(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return;
    }
    
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET2MPLL + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, refreshSwitchInfo, null, "inputdata=" + xmlstr);
}


function rightlist()
{
    removejsDOMmenu();
    var count = st.getSelectedRowCount();
    var length = st.getDataRowLength();
    var cursorMenu1 = new jsDOMenu(120);
    var menulength = 0;
    if (count > 0) 
    {
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearswitch"], "", switchclock, "0"));
    }
    else 
    {
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearswitch"], "", switchclock, "0", false));
    }
	cursorMenu1.addMenuItem(new menuItem('-'));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["lock"], "", lock, "0"));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearlock"], "", lock, "1"));
    
	cursorMenu1.addMenuItem(new menuItem('-'));
	
    if (count == 1) 
    {
        var sel = st.getSelectedRows();
        
        var state = st.getCellCurrentValue(sel[0], "lockstate", "lockstate");
        if (state == 1) 
        {
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2"));
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1"));
        }
        else 
        {
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2", false));
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1", false));
        }
    }
    else 
    {
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2", false));
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1", false));
        
        menulength = menulength + 3;
    }
    
    
    setPopUpMenu(cursorMenu1);
    rightClickHandler();
}

/**
 *                 
 */
function stSelectFun()
{
    if (btnRightArr.applybtn.right) 
    {
        var selcount = st.getSelectedRowCount();
        
        if (selcount > 1) 
        {
            $("up").disabled = true;
            $("down").disabled = true;
        }
        else 
        {
            $("up").disabled = !btnRightArr.applybtn.right;
            $("down").disabled = !btnRightArr.applybtn.right;
        }
        
        var rowsize = st.getDataRowLength();
        
        if (selcount <= 0) 
        {
            $("delbtn").disabled = true;
            return;
        }
        
        if (rowsize == 1) 
        {
            var s = st.getCellCurrentValue(0, "clockid", "clockid");
            if (s == 15794177) 
            {
                $("delbtn").disabled = true;
                return;
            }
        }
        $("delbtn").disabled = !btnRightArr.delbtn.right;
    }
}

function testdata()
{
    var rowsize = st.getDataRowLength();
    for (var j = 0; j < st.getDataRowLength(); j++) 
    {
        if (st.getRowSelFlag(j)) 
        {
            var s = st.getCellCurrentValue(j, "outclockmode", "outclockmode");
            alert("outclockmode" + s);
            s = st.getCellCurrentValue(j, "s1byte", "s1byte");
            alert("s1byte" + s);
            s = st.getCellCurrentValue(j, "clockid", "clockid");
            alert("clockid" + s);
        }
    }
}

function setClockPriority(op)
{
    timeoutid = null;
    $("applybtn").disabled = true;
    if (op != "del") 
    {
        op = "create";
    }
    var xmlstr = createSetXML(op);
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_2M_PRI_TBL + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshtable, null, "inputdata=" + xmlstr);
}

function refreshtable(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
        showErrorDialog(data);
        return;
    }
    refreshTableState(st, window.tableconf[0], data);
    timeoutid = setTimeout(query, 1000);
}

function createSetXML(op)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        var neidvalue = getNeProperty(top)["neid"];
        param.setAttribute("name", "neid");
        param.setAttribute("value", neidvalue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "op");
        param.setAttribute("value", op);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "clockslotno");
        param.setAttribute("value", clockslotno);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "clock2mindex");
        param.setAttribute("value", clock2mindex);
        row.appendChild(param);
        
        param = new tagElement("param");
        var clockid = st.getCellCurrentValue(i, "clockid", "clockid");
        if (i > 0 && clockid == 15794177) 
        {
            continue;
        }
        
        param.setAttribute("name", "clockid");
        param.setAttribute("value", clockid);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    if (bussiness.childNodes.length <= 0) 
    {
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        var neidvalue = getNeProperty(top)["neid"];
        param.setAttribute("name", "neid");
        param.setAttribute("value", neidvalue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "clockslotno");
        param.setAttribute("value", clockslotno);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "clock2mindex");
        param.setAttribute("value", clock2mindex);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "clockid");
        param.setAttribute("value", 15794177);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "op");
        param.setAttribute("value", op);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function showErrorDialog(data)
{
    for (var i = 0; i < data.getBErrLength(); i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["clocksourcepriority"];
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../page/", data.getError(), errArr);
}

function newClock()
{
    hideMenu();
    xshowModalDialog("newclockdiglog.html", RESOURCE["addclock"], 340, 400, "../../../../images/","yes","no");
}

/*
 *      
 */
function upchangerow()
{
    var rowsize = st.getDataRowLength();
    
    if (rowsize == 1) 
    {
        return;
    }
    
    for (var i = 0; i < rowsize; i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            if (i == 0 || st.getCellStoreValue(i, "clockid", "clockid") == "15794177") 
            {
                return;
            }
            else 
            {
                $("applybtn").disabled = !btnRightArr.applybtn.right;
                swapTableRow(i, i - 1);
                break;
            }
        }
    }
}

/*
 *      
 */
function downchangerow()
{
    var rowsize = st.getDataRowLength();
    
    if (rowsize == 1) 
    {
        return;
    }
    for (var i = 0; i < rowsize; i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            if (i == (rowsize - 1) || st.getCellStoreValue(i + 1, "clockid", "clockid") == "15794177") 
            {
                return;
            }
            else 
            {
                $("applybtn").disabled = !btnRightArr.applybtn.right;
                swapTableRow(i + 1, i);
                i = i + rowsize;
            }
        }
    }
}

/**
 *      
 */
function swapTableRow(src, des)
{
    var srcrow = st.getRow(src);
    var drow = st.getRow(des);
    var srcNum = srcrow.element.cols["number"].element.innerText;
    var desNum = drow.element.cols["number"].element.innerText;
    
    st.setAtomValue(srcrow.element.cols["number"].element.showElement, desNum);
    st.setAtomValue(drow.element.cols["number"].element.showElement, srcNum);
    st.element.datarows[des] = srcrow;
    st.element.datarows[src] = drow;
    
    srcrow.element.swapNode(drow.element);
}

/**
 *      
 */
function delclock()
{
    if (timeoutid != null) 
    {
        clearTimeout(timeoutid);
    }
    var rowsize = st.getDataRowLength();
    for (var j = 0; j < st.getDataRowLength(); j++) 
    {
        if (st.getRowSelFlag(j)) 
        {
            var clockid = st.getCellCurrentValue(j, "clockid", "clockid");
            if (clockid == "15794177") 
            {
                continue;
            }
            
            st.deleteRow(j);
        }
    }
    
    st.adjustDataRows();
    $("delbtn").disabled = true;
    setClockPriority("del");
    var size = st.getDataRowLength();
    if (size == 0) 
    {
        $("newbtn").disabled = true;
        setTimeout(query, 5000);
    }
}

/**
 *          
 */
function addclock(data)
{
    var index = st.getDataRowLength();
    insertTableRowAt(st, window.tableconf[0], data, RESOURCE, index);
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}
