
var winurlobj = getNeProperty(self);
var nmUser = winurlobj.nmUser;
var neid = winurlobj.neid;
var slotid = winurlobj.slotid;
/**
 * 
 * TRANSU2000V1R7C00-4207 
 * OP201205160001:TD V1R5 DCR_RTN  SL91CQ1                WEBLCT
 * 
 */
var warningflag = false;
var btnRightArr = new Object();

var CLOCKMODE_SYS = 0;		//           
var CLOCKMODE_LINE = 2;		//           

var VALID_VALUE = 65535;
var INVALID_SUBSLOTID = 255;

var mtable;	//ctable  

/**
 *      
 * @return
 */
function init()
{
	initWarningFlag();
	initTable();
	getPorts();
	queryClockTransInfor();
}

function initWarningFlag()
{
	warningflag = false;
}

function initTable()
{
	$("clockmode").innerText = RESOURCE["clockretimemode"];
	$("clockmodespan_sys").innerText = RESOURCE["clockmoderadio_sys"];
	$("clockmodespan_line").innerText = RESOURCE["clockmoderadio_line"];
	$("clockport").innerText = RESOURCE["lineclockport"];

	mtable = new MTable();
	mtable.addHead(RESOURCE["clocksource"], RESOURCE["port"], RESOURCE["timeslot"]);
	

	var atom5_Port = new Atom("select");
	for( i = 0; i < 4; i++ )
	{
		var index = i+1;
		atom5_Port.element.options[atom5_Port.element.options.length] = new Option(index+"(Port-"+index+")", index);
	}
	atom5_Port.element.options[atom5_Port.element.options.length] = new Option("-", VALID_VALUE);

	var atom5_VC12 = new Atom("select");
	for( var i = 1; i < 64; i++ )
	{
		atom5_VC12.addOption("VC12-"+i, i);
	}
	atom5_VC12.element.options[atom5_VC12.element.options.length] = new Option("-", INVALID_SUBSLOTID);
	
	mtable.addAttrRow("clocksource5", RESOURCE["clocksource5"], atom5_Port, atom5_VC12);
	
	
	
	var atom6_Port = new Atom("select");
	for( i = 0; i < 4; i++ )
	{
		var index = i+1;
		atom6_Port.element.options[atom6_Port.element.options.length] = new Option(index+"(Port-"+index+")", index);
	}
	atom6_Port.element.options[atom6_Port.element.options.length] = new Option("-", VALID_VALUE);

	var atom6_VC12 = new Atom("select");
	for( var i = 1; i < 64; i++ )
	{
		atom6_VC12.addOption("VC12-"+i, i);
	}
	atom6_VC12.element.options[atom6_VC12.element.options.length] = new Option("-", INVALID_SUBSLOTID);
	
	mtable.addAttrRow("clocksource6", RESOURCE["clocksource6"], atom6_Port, atom6_VC12);


	$("tablecontainer3").appendChild(mtable.getTable());

	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_ETH_GET_CLOCKTRANSINFOR);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_ETH_SET_CLOCKTRANSINFOR);
    getRightInfo(winurlobj, btnRightArr);
	
	addListeners();
}


function queryClockTransInfor()
{
	LoadingProcess.removeWaitStatus();
	LoadingProcess.showWaitStatus("../../../../images/",RESOURCE["loadingtitle"]);
	
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_ETH_GET_CLOCKTRANSINFOR + "&nmUser="+ nmUser;

	var xmlstr = createQueryClockTransInforXML();
	initWarningFlag();
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;	
	loadXMLdoc(urlreq, "POST", true, queryClockTransInforCallback, null, "inputdata=" + xmlstr);	
}


function createQueryClockTransInforXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null; 

    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    addParam(row, "clocksource", "5" );
    bussiness.appendChild(row);

    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    addParam(row, "clocksource", "6" );
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);

    return di.toString();
}



function queryClockTransInforCallback(doc)
{
	LoadingProcess.removeWaitStatus();
	
	var data = EncapsulateData(doc);
	
	$("querybtn").disabled = false;
	
    if( data.getSErrorCode() != OPERATION_SUCCESS )
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", data.getError(), errArr);
    }
    
	$("applybtn").disabled = true;
    
    if( data.getSErrorCode() != OPERATION_SUCCESS && data.getSErrorCode() != OPERATION_PART_SUCCESS )
    {
    	return;
    }

    for( var i = 0; i < data.getDataRowLength(); i++ )
    {
    	if( i == 0 )
    	{
        	var t_slotid = data.getDataRowParam(i, "slotid");
        	var t_clockmode = data.getDataRowParam(i, "clockmode");
        	var t_port = data.getDataRowParam(i, "port");
        	
        	if( t_clockmode == CLOCKMODE_SYS )
        	{
        		$("clockmoderadio_sys").checked = true;
        		$("clockportselect").value = "1";
        		$("clockportselect").disabled = true;
        	}
        	else if( t_clockmode == CLOCKMODE_LINE )
        	{
        		$("clockmoderadio_line").checked = true;
            	$("clockportselect").value = t_port;
            	$("clockportselect").disabled = false;
        	}
    	}

    	var t_clocksource = data.getDataRowParam(i, "clocksource");
    	var t_sdhport = data.getDataRowParam(i, "sdhport");
    	var t_lowpath = data.getDataRowParam(i, "lowpath");
    	

    	if( t_clocksource == "5" )
    	{
    		mtable.getAtom("clocksource5", 0).setValue(t_sdhport);
    		mtable.getAtom("clocksource5", 1).setValue(t_lowpath);
    	}
    	if( t_clocksource == "6" )
    	{
    		mtable.getAtom("clocksource6", 0).setValue(t_sdhport);
    		mtable.getAtom("clocksource6", 1).setValue(t_lowpath);
    	}
    }
}



function applyClockTransInfor()
{
	if(warningflag == true)
	{
		if (!confirm(RESOURCE["confmsg"])) 
	    {
	        return;
	    }
	}
	
	LoadingProcess.removeWaitStatus();
	LoadingProcess.showWaitStatus("../../../../images/",RESOURCE["loadingtitle"]);
	
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_ETH_SET_CLOCKTRANSINFOR + "&nmUser="+ nmUser;

	var xmlstr = createApplyClockTransInforXML();
	
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	
	loadXMLdoc(urlreq, "POST", true, applyClockTransInforCallback, null, "inputdata=" + xmlstr);	
}

/**
 *        XML
 * @return
 */
function createApplyClockTransInforXML()
{	
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null; 

    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    var t_clockmodeValue = $("clockmoderadio_sys").checked == true ? CLOCKMODE_SYS : CLOCKMODE_LINE;
    var t_portValue = $("clockmoderadio_sys").checked == true ? VALID_VALUE : $("clockportselect").value;
    addParam(row, "clockmode", t_clockmodeValue );
    addParam(row, "port", t_portValue );
    addParam(row, "clocksource", "5" );
    addParam(row, "sdhport", mtable.getAtom("clocksource5", 0).getValue() );
    addParam(row, "highpath",  mtable.getAtom("clocksource5", 0).getValue() == VALID_VALUE ? VALID_VALUE : "1" );
    addParam(row, "lowpath", mtable.getAtom("clocksource5", 1).getValue() );
    bussiness.appendChild(row);
    
    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    addParam(row, "clocksource", "6" );
    addParam(row, "sdhport", mtable.getAtom("clocksource6", 0).getValue() );
    addParam(row, "highpath", mtable.getAtom("clocksource6", 0).getValue() == VALID_VALUE ? VALID_VALUE : "1"  );
    addParam(row, "lowpath", mtable.getAtom("clocksource6", 1).getValue() );
    bussiness.appendChild(row);

    di.getRoot().appendChild(bussiness);
    return di.toString();
}



function applyClockTransInforCallback(doc)
{
	LoadingProcess.removeWaitStatus();

	var data = EncapsulateData(doc);
	
	$("querybtn").disabled = false;

    if( data.getSErrorCode() != OPERATION_SUCCESS )
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", data.getError(), errArr);
    }
    else
    {
    	initWarningFlag();
    }
    
	$("applybtn").disabled = true;
}

function addParam(row, attriName, attriVal)
{
    var param = new tagElement("param");
    param.setAttribute("name", attriName);
    param.setAttribute("value", attriVal );
    row.appendChild(param);
}

/**
 *     
 * @return
 */
var lastIndex = 0;
function addListeners()
{
	$("clockmoderadio_sys").onclick = function()
	{
		$("clockportselect").disabled = true;
		lastIndex = $("clockportselect").selectedIndex;
		$("clockportselect").selectedIndex = 0;
		if (btnRightArr.applybtn.right)
		{
			warningflag = true;
			$("applybtn").disabled = false;
		}
	}
	$("clockmoderadio_line").onclick = function()
	{
		$("clockportselect").disabled = false;
		$("clockportselect").selectedIndex = lastIndex;
		if (btnRightArr.applybtn.right)
		{
			warningflag = true;
			$("applybtn").disabled = false;
		}
	}

	$("clockportselect").onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			warningflag = true;
			$("applybtn").disabled = false;
		}
	}
	
	mtable.getAtom("clocksource5",0).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource5", 0).getValue() == VALID_VALUE )
		{
			mtable.getAtom("clocksource5", 1).setValue(INVALID_SUBSLOTID);
		}
		else
		{
			if( mtable.getAtom("clocksource5", 1).getValue() == INVALID_SUBSLOTID )
			{
				mtable.getAtom("clocksource5", 1).setValue("1");	
			}
		}
	}
	
	mtable.getAtom("clocksource5",1).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource5", 1).getValue() == INVALID_SUBSLOTID )
		{
			mtable.getAtom("clocksource5", 0).setValue(VALID_VALUE);
		}
		else
		{
			if( mtable.getAtom("clocksource5", 0).getValue() == VALID_VALUE )
			{
				mtable.getAtom("clocksource5", 0).setValue("1");	
			}
		}
	}
	
	mtable.getAtom("clocksource6",0).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource6", 0).getValue() == VALID_VALUE )
		{
			mtable.getAtom("clocksource6", 1).setValue(INVALID_SUBSLOTID);
		}
		else
		{
			if( mtable.getAtom("clocksource6", 1).getValue() == INVALID_SUBSLOTID )
			{
				mtable.getAtom("clocksource6", 1).setValue("1");	
			}
		}
	}
	
	mtable.getAtom("clocksource6",1).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource6", 1).getValue() == INVALID_SUBSLOTID )
		{
			mtable.getAtom("clocksource6", 0).setValue(VALID_VALUE);
		}
		else
		{
			if( mtable.getAtom("clocksource6", 0).getValue() == VALID_VALUE )
			{
				mtable.getAtom("clocksource6", 0).setValue("1");	
			}
		}
	}
}


function getPorts()
{
    var xmlstr = createGetPortsXML();
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_ETHBOARDPORTS+"&nmUser="+winurlobj["nmUser"];

    loadXMLdoc(urlreq, "POST", false, getPortsCallback, null, "inputdata="+xmlstr);
}

function createGetPortsXML()
{    
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","subslotid");
    param.setAttribute("value",INVALID_SUBSLOTID);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function getPortsCallback(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObj";
    openErrPage("../../../../page/", data.getError(), errArr);
    
    if (OPERATION_SUCCESS == data.getSErrorCode()) 
    {
    	$("clockportselect").options.length = 0;
        var t_slotid;
        var t_portid;
        var t_portName;
        for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
		{
        	t_slotid = data.getDataRowParam(i ,"slotid" );
		    if( t_slotid != slotid )
		    {
		        continue;
		    }
		    t_portid = data.getDataRowParam(i , "portid");
		    t_portName = data.getDataRowParam(i , "portName");
		    $("clockportselect").options[$("clockportselect").options.length] = new Option(t_portName, t_portid);
		}
        
        if( $("clockportselect").options.length == 0 )
        {
        	for( i = 0; i < 4; i++ )
        	{
        		var index = i+1;
        		$("clockportselect").options[$("clockportselect").options.length] = new Option(index+"(Port-"+index+")", index);
        	}
        }
    }
}
