var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var btnRightArr = new Object();
var st0, st1;
var OPRSUCC = 0;
var PARTSUCC = 1;

var portworkmode = new Object();
portworkmode["2"] = "BC";
portworkmode["3"] = "TC";
portworkmode["-1"] = "/";

var portstatus = new Object();
portstatus["-1"] = "INVALID";
portstatus["0"] = "MASTERSLAVE";
portstatus["1"] = "MASTER";
portstatus["2"] = "SLAVE";
portstatus["3"] = "PASSIVE";

var portrealstatus = new Object();
portrealstatus["1"] = "INITIALIZING";
portrealstatus["2"] = "FAULTY";
portrealstatus["3"] = "DISABLED";
portrealstatus["4"] = "LISTENING";
portrealstatus["5"] = "PRE_MASTER";
portrealstatus["6"] = "MASTER";
portrealstatus["7"] = "PASSIVE";
portrealstatus["8"] = "UNCALIBRATED";
portrealstatus["9"] = "SLAVE";
portrealstatus["-1"] = "INVALID";
portrealstatus["255"] = "INVALID";

var msgformat = new Object();
msgformat["1"] = "PTPETH";
msgformat["2"] = "PTPIP";

var enable = new Object();
enable["0"] = "disabled";
enable["1"] = "enabled";

var encapsulationFormat = new Object();
encapsulationFormat["1"] = "ETH1588";
encapsulationFormat["2"] = "IP1588";

var protocolType = new Object();
protocolType["1"] = "DCLS";
protocolType["2"] = "PPSRS232";
protocolType["3"] = "J.211";

var sdMode = new Object();
sdMode['1'] = RESOURCE['singleMode'];
sdMode['2'] = RESOURCE['doubleMode'];

var selectedRowID = 0;

var workmode;
var TC = "3";
var TCOC = "4";
var TCBC = "5";

var INVALID_VLAN = "65535";

var portData;
var ISFROMNE = "0";
var isModifySlaveOnly = false;
var MIN_VLAN1588 = "1";
var MAX_VLAN1588 = "4094";


function init()
{	
    st0 = new SortTable();
    st0.head.setAttribute("id", "htmlTablePtpPortParamTHead");
    st0.body.setAttribute("id", "htmlTablePtpPortParamTBody");
    st0.setImage("../../../../images/");
    tc = window.tableconf[0];
    createTableHead(st0, tc);
    st0.setOnRowSelectHandler(rowSelected);
    st0.setOnCellEditHandler(cellEditHandler);
    st0.setBodyHeight("130px");
	$("tablecomponent").popupMenuExcludeCells = ['defaultvlanid'];
    $("tablecomponent").appendChild(st0.getTable());
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("createbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_PTP_PORTSTATUS);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_SET_PTP_PORTSTATUS);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_SET_PTP_PORTSTATUS);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_PTP_PORTSTATUS);
    
    getRightInfo(winurlobj.winurlobj, btnRightArr);
    
    if(btnRightArr.querybtn.right)
    {
    	winurlobj.query();
        query(winurlobj.neStatus, "0");
    }
}



function cellEditHandler(param)
{
	if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

function tabSelectHandler()
{
    if (-1 != winurlobj.selectedRowID_last && selectedRowID != winurlobj.selectedRowID_last && btnRightArr.querybtn.right) 
    {
        selectedRowID = winurlobj.selectedRowID_last;
        sendQueryInfo(selectedRowID);
    }
}

function query(workMode, isFromNE, isFromApply)
{
    workmode = workMode;
    ISFROMNE = isFromNE;
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createQueryXML(workMode);
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_PORTSTATUS + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackQuery, isFromApply, "inputdata=" + xmlstr);
    
}

function createQueryXML(workMode)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "isFromNE");
    param.setAttribute("value", ISFROMNE);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "workmode");
    param.setAttribute("value", workMode);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc, isFromApply)
{
    $("querybtn").disabled = false;
    var data = EncapsulateData(doc);
    if ("0" == ISFROMNE) 
    {
        portData = data;
    }
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["queryPortStatus"];
    }
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
        if ("1" == ISFROMNE) 
        {
            for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
            {
                var row = data.rows[i];
                var slotid = row["slotid"].value;
                var port = row["port"].value;
                
                for (var j = 0, lenPortData = portData.getDataRowLength(); j < lenPortData; j++) 
                {
                    var rowPortData = portData.rows[j];
                    if (slotid == rowPortData["slotid"].value && port == rowPortData["port"].value) 
                    {
                        data.rows[i] = rowPortData;
                        break;
                    }
                }
            }
        }
        else 
        {
            for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
            {
                var diobj = data.rows[i];
                var ptag = null;
                
                ptag = new ParamTag();
                var clockidhigh = data.getDataRowParam(i, "clockidhigh");
                var clockidlow = data.getDataRowParam(i, "clockidlow");
                var interfaceid = data.getDataRowParam(i, "interfaceid");
                
                ptag.value = getCompanyCodeForRTNNew(clockidhigh, clockidlow, interfaceid);
                
                diobj["sourceID"] = ptag;
                
                if (diobj["defaultvlanid"].value == INVALID_VLAN) 
                {
                    diobj["defaultvlanid"].value = "/";
                }
            }
        }

    	var bmcValue = parent.st.getCellStoreValue(0, "staticBMC","staticBMC");
        
        st0.clearTableData();
        createTableBody(st0, window.tableconf[0], data, RESOURCE);

        for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
        {
        	  if(st0.getCell(i, "acrEnable") != null && st0.getCellStoreValue(i, "acrEnable", "acrEnable") == null)
        	  {
        	  	var acrEnalbe = st0.getCell(i, "acrEnable").element;
               acrEnalbe.showElement.setValue("-");
    					acrEnalbe.ondblclick = null;
    					acrEnalbe.style.backgroundColor = "#C8C8C8";
    					acrEnalbe.style.cursor = "point"
    					acrEnalbe.isEdit = "0";
        	  }
        	  if ("" == st0.getCellStoreValue(i, "portrealstatus", "portrealstatus")
        	   || undefined == st0.getCellStoreValue(i, "portrealstatus", "portrealstatus"))
        	  {
        	  	  var portrealstatus = st0.getCell(i, "portrealstatus").element;
                portrealstatus.showElement.setValue("/");
        	  }
        	  
        	  if( st0.getCell(i, "portworkmode") != null && 
        	      st0.getCellStoreValue(i, "portworkmode", "portworkmode") == null )
        	  {
        	  	  var cellShow = st0.getCellShow(i, "portworkmode");
        	  	  cellShow.setValue("/");
     	  				st0.setCellIsEdit(st0.getCell(i, "portworkmode"), false);
        	  }
        	  
        	  if( st0.getCell(i, "mode") != null && 
        	      st0.getCellStoreValue(i, "mode", "mode") == null )
        	  {
        	  	  var cellShow = st0.getCellShow(i, "mode");
        	  	  cellShow.setValue("/");
     	  				st0.setCellIsEdit(st0.getCell(i, "mode"), false);
        	  }
        	  
        	  if( (st0.getCell(i, "portmanstatus") != null && 
        	      st0.getCellStoreValue(i, "portmanstatus", "portmanstatus") == null) ||
        	      bmcValue != "1" )
        	  {
        	  	  var cellShow = st0.getCellShow(i, "portmanstatus");
        	  	  cellShow.setValue("/");
     	  				st0.setCellIsEdit(st0.getCell(i, "portmanstatus"), false);
        	  }
        	  if( st0.getCell(i, "W32PORT_ATTR_1588GAPENABLED") != null && 
        	      st0.getCellStoreValue(i, "W32PORT_ATTR_1588GAPENABLED", "W32PORT_ATTR_1588GAPENABLED") == null )
        	  {
        	  	  var cellShow = st0.getCellShow(i, "W32PORT_ATTR_1588GAPENABLED");
        	  	  cellShow.setValue("/");
     	  				st0.setCellIsEdit(st0.getCell(i, "W32PORT_ATTR_1588GAPENABLED"), false);
        	  }
        }
        
        if (workmode == TC || workmode == TCOC) 
        {
            for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
            {
                var defaultvlanid = st0.getCell(i, "defaultvlanid").element;
                setCellUnedit(defaultvlanid);
                
                var portstatus = st0.getCell(i, "portstatus").element;
                setCellUnedit(portstatus);
                
                var portrealstatus = st0.getCell(i, "portrealstatus").element;
                setCellUnedit(portrealstatus);
                
                var sourceID = st0.getCell(i, "sourceID").element;
                setCellUnedit(sourceID);
                
                if(st0.getCell(i, "acrEnable") != null)
                {
                    var acrEnable = st0.getCell(i, "acrEnable").element;
                    setCellUnedit(acrEnable);
                }
            }
        }
        else if (workmode == TCBC)
        {
        	for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
            {
                var workmodevar = st0.getCellStoreValue(i,"portworkmode","portworkmode");
                if (TC != workmodevar)
                {
                	continue;
                }
				/**
				 *     DTS2012122603858 
				 *      TC  +BMC             
				 *     SE      zhongqixiang 00177720, tangxiaoyu 00135073     TC           
				 */
				
                if(bmcValue = "1"&&TC == workmodevar)
				{
					var portmanstatus = st0.getCell(i, "portmanstatus").element;
				    portmanstatus.ondblclick = null;
				    portmanstatus.style.backgroundColor = "#C8C8C8";
				    portmanstatus.style.cursor = "point"
				    portmanstatus.isEdit = "0";
				}
                var portstatus = st0.getCell(i, "portstatus").element;
                setCellUnedit(portstatus);
                
                var sourceID = st0.getCell(i, "sourceID").element;
                setCellUnedit(sourceID);
                
                var acrCell = st0.getCell(i, "acrEnable");
                
                if(acrCell != null && st0.getCellIsEdit(acrCell) == "1")
                {
                    var acrEnable = st0.getCell(i, "acrEnable").element;
                    setCellUnedit(acrEnable);
                }
            }
        }
        
        addListerner(st0, "sourceID");
        addCellEvent();
    }
    
    {
        $("createbtn").disabled = !btnRightArr.createbtn.right;
    }
          
    if (winurlobj.st.getModify(0)) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    
    if (typeof(isFromApply) == 'undefined' || !isFromApply)
    {
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../page/", data.getError(), errArr);
    }
}

function createTable()
{
    st0.clearTableData();
    createTableBody(st0, window.tableconf[0], portData, RESOURCE);
    
    if (workmode == TC || workmode == TCOC) 
    {
        for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
        {
            var defaultvlanid = st0.getCell(i, "defaultvlanid").element;
            setCellUnedit(defaultvlanid);
            
            var portstatus = st0.getCell(i, "portstatus").element;
            setCellUnedit(portstatus);
            
            var portrealstatus = st0.getCell(i, "portrealstatus").element;
            setCellUnedit(portrealstatus);
            
            var sourceID = st0.getCell(i, "sourceID").element;
            setCellUnedit(sourceID);
            
            if(st0.getCell(i, "acrEnable") != null)
            {
                var acrEnable = st0.getCell(i, "acrEnable").element;
                setCellUnedit(acrEnable);
            }
        }
    }
    
    addListerner(st0, "sourceID");
    addCellEvent();
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
    {
        cell = st0.getCell(i, "defaultvlanid");
        if (cell.element.isEdit == "0") 
        {
            continue;
        }
        
        cell.element["ondblclick"] = function()
        {
            this.modify = true;
            this.parentNode.modify = true;
            
            showMgrDialogVlan(st0, this, "defaultvlanid");
        }
        
        cell.element.oncontextmenu = function()
        {
            this.modify = true;
            this.parentNode.modify = true;
            
            showMgrDialogVlan(st0, this, "defaultvlanid");
        };
        
        cell = st0.getCellElement(i,"defaultvlanid");
        textCheck(cell.editElement.element,MIN_VLAN1588,MAX_VLAN1588,0,["/"]);
        
        cell = st0.getCellElement(i,"sourceID");
        cell.editElement.element.maxLength = 20;
        cell.editElement.element["onkeypress"] = function()
        {
            if(!restrict(this, event, "0123456789abcdefABCDEF"))
            {
                return false;
            }
            return true;
        }	 
    }
}

function showMgrDialogVlan(st, cellElement, key)
{
    var i;
    var evt = EventUtil.getEvent();
    var elem = evt.target;
    if (elem.parent || elem.parentNode.parent) 
    {
        var rowid;
        var rows;
        if (elem.parent) 
        {
            rowid = elem.parentNode.rowIndex;
            rows = elem.parent.getSelectedRows();
        }
        else 
        {
            rowid = elem.parentNode.parentNode.rowIndex;
            rows = elem.parentNode.parent.getSelectedRows();
        }
        
        if (!rows.contains(rowid)) 
        {
            return;
        }
        
        if (rows.length == 1) 
        {
            i = rows[0];
        }
        else 
        {
            i = rowid;
        }
    }
    
    if (null == i) 
    {
        return;
    }
    
    var value = st.getCellStoreValue(i, key, key);
    
    xshowModalDialog("../clock_ptp/maxvlannum.html?value=" + value + "&key=" + key + "&index=" + i, RESOURCE["VLANID"], 320, 170, "../../../../images/");
}

function setCellUnedit(cell)
{
    cell.showElement.setValue("/");
    cell.ondblclick = null;
    cell.style.backgroundColor = "#C8C8C8";
    cell.style.cursor = "point"
    cell.isEdit = "0";
}

function create()
{
	if (isIE) 
	{
		xshowModalDialog("../clock_ptp/createport.html", RESOURCE["createClockPort"], 610, 400, "../../../../images/");
	}
	else 
	{
		xshowModalDialog("../clock_ptp/createport.html", RESOURCE["createClockPort"], 650, 450, "../../../../images/");
	}
}

function rowSelected(rows)
{
    var len = rows.length;
    
    if (0 == len /*|| workmode == TC || workmode == TCOC*/) 
    {
        $("deletebtn").disabled = true;
    }
    else 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
}

function deletePort()
{
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createDeleteXML();
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_CONFIG_PTP_CLOCKPORT + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackDelete, null, "inputdata=" + xmlstr);
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    for (var rowindex = 0, length = st0.getDataRowLength(); rowindex < length; rowindex++) 
    {
        if (!st0.getRowSelFlag(rowindex)) 
        {
            continue;
        }
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "portName", "slotid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        var subslotid = st0.getCellStoreValue(rowindex, "portName", "subslotid");
        if (null == subslotid) 
        {
            subslotid = "255";
        }
        param.setAttribute("value", subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "port", "port"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ptpEnable");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackDelete(doc)
{
    $("querybtn").disabled = false;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
    var data = EncapsulateData(doc);
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["deletePort"];
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
        {
            if (st0.getRowSelFlag(i)) 
            {
                st0.deleteRow(i);
            }
        }
        st0.adjustDataRows();
    }
    else 
    {
        $("deletebtn").disabled = false;
    }
          
    if (winurlobj.st.getModify(0)) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function apply()
{
    var xmlstr = createApplyXML();
    if (null == xmlstr) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTP_PORTSTATUS + "" + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackApply, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    st1 = winurlobj.st;
    if (winurlobj.timeChange) 
    {
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        var minTime = new Date(2000, 0, 1, 0, 0, 0).getTime();
        var maxTime = new Date(2099, 11, 31, 23, 59, 59).getTime();
        var sysDateTimeStr = getTimeFromString(winurlobj.$("ptpSysTimeTxt").value,STANDARD_FORMAT);
        var systemTime = getTimeFromString(winurlobj.$("ptpSysTimeTxt").value);
        if (systemTime < minTime || systemTime > maxTime) 
        {
            alert(RESOURCE["timeRange"]);
            return null;
        }
        
        var sysDateTime = sysDateTimeStr.split(" ");
        var sysDate = sysDateTime[0].split("-");
        var sysTime = sysDateTime[1].split(":");
        
        var param = new tagElement("param");
        param.setAttribute("name", "year");
        param.setAttribute("value", sysDate[0]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "month");
        param.setAttribute("value", sysDate[1]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "day");
        param.setAttribute("value", sysDate[2]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "hour");
        param.setAttribute("value", sysTime[0]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "minute");
        param.setAttribute("value", sysTime[1]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "second");
        param.setAttribute("value", sysTime[2]);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    for (var rowindex = 0, rowlen = st1.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st1.getModify(rowindex)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        if (st1.getCellModify(rowindex, "workmode")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "workmode");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "workmode", "workmode"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "staticBMC")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "staticBMC");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "staticBMC", "staticBMC"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "slaveonlymode")) 
        {
        	isModifySlaveOnly = true;
            param = new tagElement("param");
            param.setAttribute("name", "slaveonlymode");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "slaveonlymode", "slaveonlymode"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "multicastmode")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "multicastmode");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "multicastmode", "multicastmode"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "timeadjust")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "timeadjust");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "timeadjust", "timeadjust"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "protocolFormat")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "protocolFormat");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "protocolFormat", "protocolFormat"));
            row.appendChild(param);
        }
        
        bussiness.appendChild(row);
    }
    
    for (var rowindex = 0, length = st0.getDataRowLength(); rowindex < length; rowindex++) 
    {
        if (!st0.getModify(rowindex)) 
        {
            continue;
        }
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "portName", "slotid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        var subslotid = st0.getCellStoreValue(rowindex, "portName", "subslotid");
        if (null == subslotid) 
        {
            subslotid = "255";
        }
        param.setAttribute("value", subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "port", "port"));
        row.appendChild(param);

        if (st0.getCellModify(rowindex, "portworkmode")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "portworkmode");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "portworkmode", "portworkmode"));
            row.appendChild(param);
        }
        
        if (st0.getCellModify(rowindex, "portmanstatus") /*&& st1.getCellStoreValue(0,"staticBMC","staticBMC")=="1" */) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "portmanstatus");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "portmanstatus", "portmanstatus"));
            row.appendChild(param);
        }

        if (st0.getCellModify(rowindex, "defaultvlanid")) 
        {
            defaultvlanid = st0.getCellStoreValue(rowindex, "defaultvlanid", "defaultvlanid");
            if ("/" == defaultvlanid) 
            {
                defaultvlanid = INVALID_VLAN;
            }
            param = new tagElement("param");
            param.setAttribute("name", "defaultvlanid");
            param.setAttribute("value", defaultvlanid);
            row.appendChild(param);
        }
        
        if (st0.getCell(rowindex, "vlanpriority") && st0.getCellModify(rowindex, "vlanpriority")) 
        {
        	var vlanpriority = st0.getCellStoreValue(rowindex, "vlanpriority", "vlanpriority");
            param = new tagElement("param");
            param.setAttribute("name", "vlanpriority");
            param.setAttribute("value", vlanpriority);
            row.appendChild(param);
        }
        
        if (st0.getCellModify(rowindex, "msgformat")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "msgformat");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "msgformat", "msgformat"));
            row.appendChild(param);
        }
        
        if (st0.getCellModify(rowindex, "portstatus")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "portstatus");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "portstatus", "portstatus"));
            row.appendChild(param);
        }
        if (st0.getCellModify(rowindex, "sourceID")) 
        {
            var sourceID = st0.getCellStoreValue(rowindex, "sourceID", "sourceID");
            
            param = new tagElement("param");
            param.setAttribute("name", "clockidhigh");
            param.setAttribute("value", getSourceIDHigh(sourceID));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "clockidlow");
            param.setAttribute("value", getSourceIDLow(sourceID));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "interfaceid");
            param.setAttribute("value", getInterfaceID(sourceID));
            row.appendChild(param);
        }

		if (null != st0.getCell(rowindex, "W32PORT_ATTR_1588GAPENABLED") && st0.getCellModify(rowindex, "W32PORT_ATTR_1588GAPENABLED")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "W32PORT_ATTR_1588GAPENABLED");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "W32PORT_ATTR_1588GAPENABLED", "W32PORT_ATTR_1588GAPENABLED"));
            row.appendChild(param);
        }
		
		if (null != st0.getCell(rowindex, "acrEnable") && st0.getCellModify(rowindex, "acrEnable")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "acrEnable");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "acrEnable", "acrEnable"));
            row.appendChild(param);
        }
        
        	
	if (st0.getCell(rowindex, "mode") && st0.getCellModify(rowindex, "mode")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "mode");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "mode", "mode"));
            row.appendChild(param);
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApply(doc)
{
    $("querybtn").disabled = false;
    $("createbtn").disabled = true;

    var data = EncapsulateData(doc);
    
    if (OPRSUCC != data.getError().getGlobleECode()) 
    {        
    	  for (var i = 0, size = data.getBErrLength(); i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            if (undefined == tempObj["slotid"])
            {
            	  tempObj["slotid"] = tempObj["nename"];
            	  tempObj["boardname"] = "";
            	  tempObj["portname"] = "";
            }
        }

        var errArr = [];
        errArr[0] = "slotid";
        errArr[1] = "boardname";
        errArr[2] = "portname";
        openErrPage("../../../../page/", data.getError(), errArr);
        
        $("applybtn").disabled = false;
    }
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        refreshTableState(winurlobj.st, winurlobj.window.tableconf[0], data);
        refreshTableState(st0, tc, data);
        
        if (!(winurlobj.st.getCellModify(0, "workmode"))) 
        {
            winurlobj.neStatus = winurlobj.st.getCellStoreValue(0, "workmode", "workmode");
        }
        
        
        if (winurlobj.neStatus != TC && winurlobj.neStatus != TCOC) 
        {
            $("createbtn").disabled = !btnRightArr.createbtn.right;
        }

        /**
         *      DTS2012051502124 
         *                   
         */
        query(winurlobj.neStatus, "0", true);
		/**
		 *      DTS2012101509497 
		 *         TC       BMC
		 */
		winurlobj.query(true);
    }
}

function disablePtpPortStatus(val)
{
	if (st0.getDataRowLength() > 0) 
	{
		var cell = st0.getCell(0, "portmanstatus");
		var cellShow = st0.getCellShow(0, "portmanstatus");
		var portstatus = st0.getCellStoreValue(0, "portworkmode", "portworkmode");
		/**
		 *     DTS2012122603858 
		 *          SE      zhongqixiang 00177720, tangxiaoyu 00135073     TC           
		 */	
		if (val == "1") 
		{
			if(portstatus!=TC)
			{
				st0.setCellIsEdit(cell, true);
			}
			else
			{
				st0.setCellIsEdit(cell, false);
			}
		}
		else 
		{
			st0.setCellIsEdit(cell, false);
			cellShow.setValue("/");
		}
	}
}
