/**
 * File:         clocksynstatu.js
 * Copyright:    Copyright 2008 Huawei Tech. Co., Ltd. All Rights Reserved.
 * Product:      iManager T2000 V200R007C02 PTN     
 * Description:        JavaScript  
 * Created:      zhaoliang 69741 2008-08-16
 * Modified:      
 * Modification:  
 */
var winurlobj = getNeProperty(self);

var btnRightArr = new Object();

var st;

var OPRSUCC = 0;
var PARTSUCC = 1;

var staticbmc = new Object();
staticbmc["1"] = "enabled";
staticbmc["0"] = "disabled";
staticbmc["-1"] = "/";

var workmode = new Object();
workmode["1"] = "OC";
workmode["2"] = "BC";
workmode["3"] = "TC";
workmode["4"] = "TCOC";
workmode["5"] = "TCBC";

var slaveonlymode = new Object();
slaveonlymode["1"] = "SLAVE_ONLY";
slaveonlymode["2"] = "NON_SLAVE_ONLY";

var timeadjust = new Object();
timeadjust["0"] = "disabled";
timeadjust["1"] = "enabled";

var clockSourceType = new Object();
clockSourceType["1"] = "ATOMIC_CLOCK";
clockSourceType["2"] = "GPS";
clockSourceType["3"] = "TERRESTRIAL_RADIO";
clockSourceType["4"] = "PTP";
clockSourceType["5"] = "NTP";
clockSourceType["6"] = "HAND_SET";
clockSourceType["7"] = "OTHER";
clockSourceType["8"] = "INTERNAL_OSCILLATOR";

var multicastmode = new Object();
multicastmode["1"] = "allmulticast";
multicastmode["2"] = "partmulticast";

var protocolFormat = new Object();
protocolFormat["0"] = "NMEA";
protocolFormat["1"] = "UBX";

var portTab;

var selectedRowID_last = -1;

var neStatus;
var forwardStatus;

var OC = "1";
var BC = "2";
var TC = "3";
var TCOC = "4";
var TCBC = "5";

var flagQuery = false;
var timeChange = false;

var INVALID_SLOT = "65535";

/**
 * Description:        
 * @author zhaoliang 69741 2008-08-16
 */
function init()
{
    initTable();
    
    initTabPanel();
    
    initTimeComponents();
    initCalendar();    
}

/**
 * Description:        
 * @author zhaoliang 69741 2008-08-16
 */
function initTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTablePtpClockSynStatusTHead");
    st.body.setAttribute("id", "htmlTablePtpClockSynStatusTBody");
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(cellEditHandler);
    st.setBodyHeight("170px");
    $("tablecomponent").appendChild(st.getTable());
    $("tablecomponent").oncontextmenu = popupMenuHandler;
}

/**
 * Description:    Tab   
 * @author zhaoliang 69741 2008-08-16
 */
function initTabPanel()
{
    portTab = new Tabs();
    portTab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    portTab.addTab("portparam", RESOURCE["portparam"], "portparam.html");
    portTab.addTab("portmessage", RESOURCE["portmessage"], "../clock_ptp/portmessage.html");
    portTab.addTab("transwarp", RESOURCE["transwarp"], "../clock_ptp/transwarp.html");
    setTabsHeight(portTab, "420px");
    
    $("porttab").appendChild(portTab.getTabs());
    portTab.selectTab("portparam");
}

/**
 * Description:   Tab     
 * @author zhaoliang 69741 2008-08-16
 */
function setTabsHeight(tab, tabodyheight)
{
    for (var key in tab.tabNodes) 
    {
        tab.tabNodes[key].body.style.height = tabodyheight;
    }
}

/**
 * Description:               
 * @author zhaoliang 69741 2008-08-16
 */
function cellEditHandler(param)
{
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
	{
		portTab.getTabWindow("portparam").$("applybtn").disabled = !portTab.getTabWindow("portparam").btnRightArr.applybtn.right;    
	}
    
    if (param.stage == TABLE_CONSTANT.BEFOREEDIT) 
	{
		var workmode = st.getCellEdit(param.rowindex,"workmode");	 
		workmode.clearOptions();
		if(SpecialAttrMgr.isNESupport(winurlobj["neid"], "TE_FUNC_RTN_PTP_CLOCK", "PTP_CLOCK_ONLY_SUPPORT_TC"))
		{
			workmode.addOption("TC",3);
			workmode.addOption("TC+BC",5);
		}else{
			workmode.addOption("OC",1);
			workmode.addOption("BC",2);
			workmode.addOption("TC",3);
			workmode.addOption("TC+BC",5);
		}	    
	}
}

/**
 * Description:     
 * @author zhaoliang 69741 2008-08-16
 */
function query(isFromApply)
{
    var xmlstr = createQueryXML();
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_SYNCPARA + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackQuery, isFromApply, "inputdata=" + xmlstr);
}

/**
 * Description:     XML
 * @author zhaoliang 69741 2008-08-16
 */
function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * Description:       
 * @author zhaoliang 69741 2008-08-16
 */
function handleBackQuery(doc, isFromApply)
{
    
    var data = EncapsulateData(doc);
    
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["querySyncPara"];
    }
    if (typeof(isFromApply) == 'undefined' || !isFromApply)
    {
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../page/", data.getError(), errArr);
    }
    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            var diobj = data.rows[i];
            var ptag = null;
            
            ptag = new ParamTag();
            var srcidhigh = data.getDataRowParam(i, "srcidhigh");
            var srcidlow = data.getDataRowParam(i, "srcidlow");
            if( srcidhigh == "00259E21" )
            {
            	ptag.value = getCompanyCodeNoIfForRTNNew(srcidhigh, srcidlow);
            }
            else
            {
            	ptag.value = getCompanyCodeNoIf_ExternalTimeInterface(srcidhigh, srcidlow);
            }
            diobj["clockSourceNo"] = ptag;
            
            ptag = new ParamTag();
            var gid1 = data.getDataRowParam(i, "gid1");
            var gid2 = data.getDataRowParam(i, "gid2");
            if( gid1 == "00259E21" )
            {
            	ptag.value = getCompanyCodeNoIfForRTNNew(gid1, gid2);
            }
            else
            {
            	ptag.value = getCompanyCodeNoIf_ExternalTimeInterface(gid1, gid2);
            }
            diobj["currentClock"] = ptag;
            
            var datetime = new Date(diobj["year"].value,parseInt(diobj["month"].value) - 1,diobj["day"].value,diobj["hour"].value,diobj["minute"].value,diobj["second"].value);
            var sysTime =createTime(datetime);
            
            $("ptpSysTimeTxt").value = sysTime;
            
            if (INVALID_SLOT == diobj["slotid"].value || "-1" == diobj["slotid"].value) 
            {
                diobj["slotid"].value = "/";
                diobj["boardname"].value = "";
                diobj["portname"].value = "";
            }
            
        }
        
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        neStatus = st.getCellStoreValue(0, "workmode", "workmode");
        var slaveonlycell = st.getCell(0, "slaveonlymode").element;
		var staticbmc = st.getCellStoreValue(0, "staticBMC", "staticBMC");
        if (OC != neStatus) 
        {
            slaveonlycell.showElement.setValue("/");
            slaveonlycell.ondblclick = null;
            slaveonlycell.style.backgroundColor = "#C8C8C8";
            slaveonlycell.style.cursor = "point"
            slaveonlycell.isEdit = "0";
        }
        else
		{
				/**
				 *     DTS2012122603839 
				 *          SE      zhongqixiang 00177720, tangxiaoyu 00135073    
				 *     1      BMC                  PTP         initializing  
				 *  2      BMC                                "/"  
				 */				
			var staticbmc = st.getCellStoreValue(0, "staticBMC", "staticBMC");
			if(staticbmc == "1")
			{
				 slaveonlycell.showElement.setValue("/");
	            slaveonlycell.ondblclick = null;
	            slaveonlycell.style.backgroundColor = "#C8C8C8";
	            slaveonlycell.style.cursor = "point"
	            slaveonlycell.isEdit = "0";
			}
		}
        var multicastmode = st.getCell(0, "multicastmode").element;
        var timeadjust = st.getCell(0, "timeadjust").element;
        if (OC != neStatus && BC != neStatus && TCBC != neStatus)
        {
            multicastmode.showElement.setValue("/");
            multicastmode.ondblclick = null;
            multicastmode.style.backgroundColor = "#C8C8C8";
            multicastmode.style.cursor = "point"
            multicastmode.isEdit = "0";
            
            timeadjust.showElement.setValue("/");
            timeadjust.ondblclick = null;
            timeadjust.style.backgroundColor = "#C8C8C8";
            timeadjust.style.cursor = "point"
            timeadjust.isEdit = "0";
            
            if (TC == neStatus) 
            {
                var currentClock = st.getCell(0, "currentClock").element;
                var currentClockEntry = st.getCell(0, "currentClockEntry").element;
                
                currentClock.showElement.setValue("/");
                currentClockEntry.showElement.setValue("/");
            }
        }
        
    	  if( st.getCell(0, "staticBMC") != null && 
    	      st.getCellStoreValue(0, "staticBMC", "staticBMC") == null )
    	  {
    	  	  var cellShow = st.getCellShow(0, "staticBMC");
    	  	  cellShow.setValue("/");
 	  				st.setCellIsEdit(st.getCell(0, "staticBMC"), false);
    	  }        
        
        forwardStatus = neStatus;
                
        addCellEvent();
        
        if (flagQuery) 
        {
            portTab.getTabWindow("portparam").query(neStatus, "0", isFromApply);
        }
    }
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCellElement(i, "workmode");
        cell.editElement.element.onchange = function()
        {
            var currentStatus = this.value;
            
            var slaveonlycell = st.getCell(0, "slaveonlymode").element;
            var multicastmode = st.getCell(0, "multicastmode").element;
            var timeadjust = st.getCell(0, "timeadjust").element;
            if (OC == currentStatus) 
            {
                slaveonlycell.ondblclick = cellondbclick;
                slaveonlycell.style.backgroundColor = "#ffffff";
                slaveonlycell.style.cursor = "hand";
                slaveonlycell.isEdit = "1";
                slaveonlycell.modify = true;
                slaveonlycell.showElement.setValue(RESOURCE[slaveonlymode["2"]]);
                st.setCellValue(st.getCell(0, "slaveonlymode"),"slaveonlymode","2");
            }
            else 
            {
                slaveonlycell.showElement.setValue("/");
                slaveonlycell.ondblclick = null;
                slaveonlycell.style.backgroundColor = "#C8C8C8";
                slaveonlycell.style.cursor = "point"
                slaveonlycell.isEdit = "0";
                slaveonlycell.modify = false;
            }

            if (OC == currentStatus || BC == currentStatus || TCBC == currentStatus ) 
            {
                multicastmode.ondblclick = cellondbclick;
                multicastmode.style.backgroundColor = "#ffffff";
                multicastmode.style.cursor = "hand";
                multicastmode.isEdit = "1";
                multicastmode.modify = true;
                multicastmode.showElement.setValue(RESOURCE["allmulticast"]);
                st.setCellValue(st.getCell(0, "multicastmode"),"multicastmode","1");
                
                timeadjust.ondblclick = cellondbclick;
                timeadjust.style.backgroundColor = "#ffffff";
                timeadjust.style.cursor = "hand";
                timeadjust.isEdit = "1";
                timeadjust.modify = true;
                timeadjust.showElement.setValue(RESOURCE["enabled"]);
                st.setCellValue(st.getCell(0, "timeadjust"),"timeadjust","1");
                
                if (neStatus == currentStatus) 
                {
                    portTab.getTabWindow("portparam").query(currentStatus, "0");
                }
                else 
                {
                    portTab.getTabWindow("portparam").st0.clearTableData();
                }

                portTab.getTabWindow("portparam").$("createbtn").disabled = !portTab.getTabWindow("portparam").btnRightArr.createbtn.right;
            }
            else 
            {
                multicastmode.showElement.setValue("/");
                multicastmode.ondblclick = null;
                multicastmode.style.backgroundColor = "#C8C8C8";
                multicastmode.style.cursor = "point"
                multicastmode.isEdit = "0";
                multicastmode.modify = false;
                
                timeadjust.showElement.setValue("/");
                timeadjust.ondblclick = null;
                timeadjust.style.backgroundColor = "#C8C8C8";
                timeadjust.style.cursor = "point"
                timeadjust.isEdit = "0";
                timeadjust.modify = false;
/*
                if (TC == neStatus || TCOC == neStatus) 
                {
                    portTab.getTabWindow("portparam").createTable();
                }
                else if (TC != forwardStatus && TCOC != forwardStatus) 
                {
                    portTab.getTabWindow("portparam").query(currentStatus, "1");
                }
*/
                if (neStatus == currentStatus) 
                {
                    portTab.getTabWindow("portparam").query(currentStatus, "0");
                }
                else 
                {
                    portTab.getTabWindow("portparam").st0.clearTableData();
                }
                
                portTab.getTabWindow("portparam").$("createbtn").disabled = true;
            }
            
            forwardStatus = currentStatus;
            portTab.getTabWindow("portparam").$("applybtn").disabled = !portTab.getTabWindow("portparam").btnRightArr.applybtn.right;
        	
			disableStaticBMSOnTC(currentStatus);
		}
        
        cell = st.getCellElement(i, "staticBMC");
        cell.editElement.element.onchange = function()
        {
			var workmode =st.getCellStoreValue(0, "workmode", "workmode");
			if (workmode == OC) 
			{
				var slaveonlycell = st.getCell(0, "slaveonlymode").element;
				/**
				 *     DTS2012122603839 
				 *          SE      zhongqixiang 00177720, tangxiaoyu 00135073    
				 *     1      BMC                  PTP         initializing  
				 *  2      BMC                                "/"  
				 */	
				if (this.value == "1") 
				{
					slaveonlycell.showElement.setValue("/");
					slaveonlycell.ondblclick = null;
					slaveonlycell.style.backgroundColor = "#C8C8C8";
					slaveonlycell.style.cursor = "point"
					slaveonlycell.isEdit = "0";
					slaveonlycell.modify = false;
				}
				else 
				{
					slaveonlycell.ondblclick = cellondbclick;
					slaveonlycell.style.backgroundColor = "#ffffff";
					slaveonlycell.style.cursor = "hand";
					slaveonlycell.isEdit = "1";
					slaveonlycell.modify = true;
					slaveonlycell.showElement.setValue("NO");
					st.setCellValue(st.getCell(0, "slaveonlymode"), "slaveonlymode", "2");
				}
			}
			else
			{
				slaveonlycell.showElement.setValue("/");
				slaveonlycell.ondblclick = null;
				slaveonlycell.style.backgroundColor = "#C8C8C8";
				slaveonlycell.style.cursor = "point"
				slaveonlycell.isEdit = "0";
				slaveonlycell.modify = false;
			}
        	if( portTab.getTabWindow("portparam").disablePtpPortStatus )
        	{
        		portTab.getTabWindow("portparam").disablePtpPortStatus(this.value);
        	}
        }
    }
}
/**
 *      DTS2012101509497 
 *         TC       BMC
 * @param {Object} currentStatus
 */
function disableStaticBMSOnTC(currentStatus)
{
	   var staticBMCcell = st.getCell(0, "staticBMC").element;
       if (TC == currentStatus) 
       {
                staticBMCcell.showElement.setValue("/");
                staticBMCcell.modify = false;
                st.setCellIsEdit(staticBMCcell,0);
       }
	   else 
	   {
                st.setCellIsEdit(staticBMCcell,1);
                staticBMCcell.modify = true;
                staticBMCcell.showElement.setValue(RESOURCE["disabled"]);
                st.setCellValue(st.getCell(0, "staticBMC"),"staticBMC","0");
	   }
}
/**
 * Description:        
 * @author zhaoliang 69741 2008-08-16
 */
function initTimeComponents()
{
    var script = document.createElement("script");
    script.src = "../../../../script/thirdparty/calendar-" + SYSTEMCONF.getLanguage() + ".js"
    document.body.appendChild(script);
    var time = new Date();
    $("ptpSysTimeTxt").value = createTime(time);
}

/**
 * Description:        
 * @author zhaoliang 69741 2008-08-16
 */
function initCalendar()
{
    Calendar.setup(
    {
        inputField: "ptpSysTimeTxt",
        showsTime: true,
        timeFormat: "24",
        button: "ptpSysTimeBtn",
        singleClick: true
    });
}

Calendar.prototype.showAt = function(x, y)
{
    var s = this.element.style;
    s.left = x + "px";
    s.top = y + "px";
    this.show();
    timeChange = true;
    portTab.getTabWindow("portparam").$("applybtn").disabled = !portTab.getTabWindow("portparam").btnRightArr.applybtn.right;
};
