
var seg1 = ":";
var seg2 = ";";

var hwCompanyCode = new Array();
hwCompanyCode[0] = "001882";
hwCompanyCode[1] = "001E10";
hwCompanyCode[2] = "00E0FC";
hwCompanyCode[3] = "00259E";

function addListerner(st, key)
{
	var cell = null;

	for(var i = 0,len = st.getDataRowLength();i<len;i++)
	{
		cell = st.getCell(i, key);
		if (cell.element.isEdit == "0")
    {
    	   continue;
    }
		
		if(null != cell)
		{
			cell.element["ondblclick"] = function()
			{	
				this.modify = true;  
                this.parentNode.modify = true;

				showMgrDialog(st, this, key);	
			}
			
			cell.element.oncontextmenu = function()
			{
				this.modify = true;  
                this.parentNode.modify = true;
				
				showMgrDialog(st, this, key);
			}
		}
		
	}	
}

function showMgrDialog(st, cellElement, key)
{
	var i;
	var evt = EventUtil.getEvent();
    var elem = evt.target;
    if(elem.parent||elem.parentNode.parent)
    {
       var rowid;
       var rows;
       if(elem.parent)
       {
       	   rowid = elem.parentNode.rowIndex;
       	   rows = elem.parent.getSelectedRows();
       }
       else
       {
       	   rowid = elem.parentNode.parentNode.rowIndex;
       	   rows = elem.parentNode.parent.getSelectedRows();
       }

       if(!rows.contains(rowid))
       {
          return;
       }
       
        if(rows.length == 1)
	    {
	    	i = rows[0];
	    }
	    else
	    {
	    	i = rowid;
	    }
    }

	if(null == i)
	{
		return;
	}

    var value = st.getCellStoreValue(i, key, key);
		
	xshowModalDialog("../../page/clock_ptp/clocksourceedit.html?value="+value+"&key="+key+"&index="+i,RESOURCE["clocksourcetitle"],400,270,"../../../../images/");
}


function getSourceIDHigh(str)
{
	if(isHwDevString(str))
	{
	    var temp = str.split(seg2);
	
	    var temp0 = temp[0].split(seg1);
	    var temp1 = temp[1].split(seg1);
	    
	    var companycode = temp0[1];
	    var supplyingcode = temp1[1];
	    
	    for(var i = supplyingcode.length ;i<2;i++)
	    {
	        supplyingcode = "0" + supplyingcode;
	    }
	
	    var ret = companycode + supplyingcode;
	
	    return ret;
	}
	else
	{
		  if(str.length >= 8)
		  {
		      return str.substring(0,8);
		  }
		  else
		  {
		      return str;
		  }
	}
}

function getSourceIDLow(str)
{
	if(isHwDevString(str))
	{
	    var temp = str.split(seg2);
	
	    var temp2 = temp[2].split(seg1);
	
	    var temp3 = temp2[1].split(".");
	    var neidStr = temp3[0];

	    var neidArr = neidStr.split("-");
	    var extendNeid = neidArr[0];
	    var neid = neidArr[1];
	    
	    var tenneid = parseInt(extendNeid*65536,10) + parseInt(neid,10);
	    var ret = tenToHex(tenneid);
	    for (var i = ret.length; i < 8; i++)
	    {
	        ret = "0" + ret;
	    }
	
	    return ret;
	}
	else
	{
		  if(str.length >= 16)
		  {
		      return str.substring(8,16);
		  }
		  else
		  {
		      return str;
		  }
	}
}

function getInterfaceID(str)
{
	if(isHwDevString(str))
	{
	    var temp = str.split(seg2);
	
	    var temp3 = temp[3].split(seg1);
	
	    var ret = parseInt(temp3[1]).toString(16);
	    
	    while(ret.length < 4)
	    {
	        ret = "0" + ret;
	    }
	
	    return ret;
	}
	else
	{
		  if(str.length >= 20)
		  {
		      return str.substring(16,20);
		  }
		  else
		  {
		      return str;
		  }
	}
}

function getHexCode(str)
{
	if (18 == str.length)
	{
		return str;
	}
	
	if(isHwDevString(str))
	{
	    var temp = str.split(seg2);
	
	    var temp0 = temp[0].split(seg1);
	    var temp1 = temp[1].split(seg1);
	    var temp2 = temp[2].split(seg1);
	    var temp3 = temp[3].split(seg1);
	
	    var ret = temp0[1] + temp1[1] + temp2[1] + temp3[1];
	
	    return ret;
	}
	else
	{
		return str;
	}
}

function getHexCodeNoIf(str)
{
	if (16 == str.length)
	{
		return str;
	}
	
	if(isHwDevString(str))
	{
	    var temp = str.split(seg2);
	
	    var temp0 = temp[0].split(seg1);
	    var temp1 = temp[1].split(seg1);
	    var temp2 = temp[2].split(seg1);
	
	    var ret = temp0[1] + temp1[1] + temp2[1];
	
	    return ret;
	}
	else
	{
		return str;
	}
}

function isHwDevString(str)
{
	var isHwDev = false;
	
	for (var i=0; i<hwCompanyCode.length; i++)
	{
		isHwDev = findCodeValue(str, hwCompanyCode[i])
		
		if (isHwDev)
		{ 
		   return isHwDev;
		}
	}
	
	return isHwDev;
}

function findCodeValue(str, code)
{
	var i = str.indexOf(seg1 + code + seg2);
	
	var ret = false;
	
	if (-1 < i)
	{
		ret = true; 
	}
	
	return ret;
}

function getCompanyCode(sourceidHigh, sourceidLow, interfaceID)
{
	var str;
	
	if (isHwDevID(sourceidHigh.substring(0,6)))
	{
	    
    var neip = parseInt("0x" + sourceidHigh.substring(6,8)) + "."
             + parseInt("0x" + sourceidLow.substring(0,2)) + "."
             + parseInt("0x" + sourceidLow.substring(2,4)) + "."
             + parseInt("0x" + sourceidLow.substring(4,6));
	    
		str = RESOURCE["companyCode"] + seg1 + sourceidHigh.substring(0,6);
		str += seg2 + RESOURCE["addCode"] + seg1 + sourceidLow.substring(6,8);
		str += seg2 + RESOURCE["NEID"] + seg1 + neip;
		str += seg2 + RESOURCE["interfaceID"] + seg1 + parseInt(interfaceID,16);
	}
	else
	{
		str = sourceidHigh + sourceidLow + interfaceID;
	}
	
	return str;
}

function getCompanyCodeForRTNNew(sourceidHigh, sourceidLow, interfaceID)
{
	var str;
	
	if (isHwDevID(sourceidHigh.substring(0,6)))
	{
	    
	    
		str = RESOURCE["companyCode"] + seg1 + sourceidHigh.substring(0,6);
		str += seg2 + RESOURCE["addCode"] + seg1 + sourceidHigh.substring(6,8);
		str += seg2 + RESOURCE["NEID"] + seg1 + formatNEID(sourceidLow);
		str += seg2 + RESOURCE["interfaceID"] + seg1 + parseInt(interfaceID,16);
	}
	else
	{
		str = sourceidHigh + sourceidLow + interfaceID;
	}
	
	return str;
}

function getCompanyCodeNoIf(sourceidHigh, sourceidLow)
{
	var str;
	
	if (isHwDevID(sourceidHigh.substring(0,6)))
	{
    var neip = parseInt("0x" + sourceidHigh.substring(6,8)) + "."
             + parseInt("0x" + sourceidLow.substring(0,2)) + "."
             + parseInt("0x" + sourceidLow.substring(2,4)) + "."
             + parseInt("0x" + sourceidLow.substring(4,6));

		str = RESOURCE["companyCode"] + seg1 + sourceidHigh.substring(0,6);
		str += seg2 + RESOURCE["addCode"] + seg1 + sourceidLow.substring(6,8);
		str += seg2 + RESOURCE["NEID"] + seg1 + neip;
	}
	else
	{
		str = sourceidHigh + sourceidLow;
	}
	
	return str;
}

/**
 *                            
 * @param sourceidHigh
 * @param sourceidLow
 * @return
 */
function getCompanyCodeNoIfForRTNNew(sourceidHigh, sourceidLow)
{
	var str;
	
	if (isHwDevID(sourceidHigh.substring(0,6)))
	{
		str = RESOURCE["companyCode"] + seg1 + sourceidHigh.substring(0,6);
		str += seg2 + RESOURCE["addCode"] + seg1 + sourceidHigh.substring(6,8);
		str += seg2 + RESOURCE["NEID"] + seg1 + formatNEID(sourceidLow);
	}
	else
	{
		str = sourceidHigh + sourceidLow;
	}
	
	return str;
}

/**
 *                      
 * @param sourceidHigh
 * @param sourceidLow
 * @return
 */
function getCompanyCodeNoIf_ExternalTimeInterface(sourceidHigh, sourceidLow)
{
	var str;
	
	if (isHwDevID(sourceidHigh.substring(0,6)))
	{
		str = RESOURCE["companyCode"] + seg1 + sourceidHigh.substring(0,6);
		var tmpNeID = sourceidHigh.substring(6,8) + sourceidLow.substring(0,6);
		str += seg2 + RESOURCE["NEID"] + seg1 + formatNEID(tmpNeID);
		str += seg2 + RESOURCE["externalTimePortID"] + seg1 + sourceidLow.substring(7,8);
	}
	else
	{
		str = sourceidHigh + sourceidLow;
	}
	
	return str;
}

function getCompanyCode_ExternalTimeInterface(sourceidHigh, sourceidLow, interfaceID)
{
	var str;
	
	if (isHwDevID(sourceidHigh.substring(0,6)))
	{
		str = RESOURCE["companyCode"] + seg1 + sourceidHigh.substring(0,6);
		var tmpNeID = sourceidHigh.substring(6,8) + sourceidLow.substring(0,6);
		str += seg2 + RESOURCE["NEID"] + seg1 + formatNEID(tmpNeID);
		str += seg2 + RESOURCE["externalTimePortID"] + seg1 + sourceidLow.substring(7,8);
		str += seg2 + RESOURCE["interfaceID"] + seg1 + parseInt(interfaceID,16);
	}
	else
	{
		str = sourceidHigh + sourceidLow + interfaceID;
	}
	
	return str;
}


function getCompanyCodeNoIf_RTNR3(sourceidHigh, sourceidLow)
{
	var str;
	
	if (isHwDevID(sourceidHigh.substring(0,6)))
	{
		str = RESOURCE["companyCode"] + seg1 + sourceidHigh.substring(0,6);
		str += seg2 + RESOURCE["addCode"] + seg1 + sourceidHigh.substring(6,8);
		var tmpNeID = sourceidHigh.substring(6,8) + sourceidLow.substring(0,6);
		str += seg2 + RESOURCE["NEID"] + seg1 + "(" + sourceidHigh + " " + sourceidLow + ")";
	}
	else
	{
		str = sourceidHigh + sourceidLow;
	}
	
	return str;
}

function formatNEID(longneid)
{
	var tenneid = parseInt(longneid,16);
	return parseInt((tenneid/65536),10)+ "-" + (tenneid % 65536);
}

function isHwDevID(id)
{
	var temp = id;
	
	var isHwDev = false;
	
	for (var i=0; i<hwCompanyCode.length; i++)
	{
		if (hwCompanyCode[i] == temp)
		{
			isHwDev = true;
		}
	}
	
	return isHwDev;
}

