 //var winurlobj = getNeProperty(self);
var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var btnRightArr = new Object();
var st0, st1;
var OPRSUCC = 0;
var PARTSUCC = 1;

var portstatus = new Object();
portstatus["0"] = "MASTERSLAVE";
portstatus["1"] = "MASTER";
portstatus["2"] = "SLAVE";
portstatus["3"] = "PASSIVE";

var portrealstatus = new Object();
portrealstatus["1"] = "INITIALIZING";
portrealstatus["2"] = "FAULTY";
portrealstatus["3"] = "DISABLED";
portrealstatus["4"] = "LISTENING";
portrealstatus["5"] = "PRE_MASTER";
portrealstatus["6"] = "MASTER";
portrealstatus["7"] = "PASSIVE";
portrealstatus["8"] = "UNCALIBRATED";
portrealstatus["9"] = "SLAVE";
portrealstatus["-1"] = "INVALID";
portrealstatus["255"] = "INVALID";

var msgformat = new Object();
msgformat["1"] = "PTPETH";
msgformat["2"] = "PTPIP";

var enable = new Object();
enable["0"] = "disabled";
enable["1"] = "enabled";

var encapsulationFormat = new Object();
encapsulationFormat["1"] = "ETH1588";
encapsulationFormat["2"] = "IP1588";

var protocolType = new Object();
protocolType["1"] = "DCLS";
protocolType["2"] = "PPSRS232";
protocolType["3"] = "J.211";

var sdMode = new Object();
sdMode['1'] = RESOURCE['singleMode'];
sdMode['2'] = RESOURCE['doubleMode'];

var selectedRowID = 0;

var workmode;
var TC = "3";
var TCOC = "4";

var INVALID_VLAN = "65535";

var portData;
var ISFROMNE = "0";
var isModifySlaveOnly = false;
var MIN_VLAN1588 = "1";
var MAX_VLAN1588 = "4094";


function init()
{	
    st0 = new SortTable();
    st0.head.setAttribute("id", "htmlTablePtpPortParamTHead");
    st0.body.setAttribute("id", "htmlTablePtpPortParamTBody");
    st0.setImage("../../../../images/");
    tc = window.tableconf[0];
    createTableHead(st0, tc);
    st0.setOnRowSelectHandler(rowSelected);
    st0.setOnCellEditHandler(cellEditHandler);
    st0.setBodyHeight("130px");
	$("tablecomponent").popupMenuExcludeCells = ['defaultvlanid'];
    $("tablecomponent").appendChild(st0.getTable());
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("createbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_PTP_PORTSTATUS);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_SET_PTP_PORTSTATUS);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_SET_PTP_PORTSTATUS);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_PTP_PORTSTATUS);
    
    getRightInfo(winurlobj.winurlobj, btnRightArr);
    
    if(btnRightArr.querybtn.right)
    {
    	winurlobj.query();
        query(winurlobj.neStatus, "0");
    }
}



function cellEditHandler(param)
{
	if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

function tabSelectHandler()
{
    if (-1 != winurlobj.selectedRowID_last && selectedRowID != winurlobj.selectedRowID_last && btnRightArr.querybtn.right) 
    {
        selectedRowID = winurlobj.selectedRowID_last;
        sendQueryInfo(selectedRowID);
    }
}

function query(workMode, isFromNE, isFromApply)
{
    workmode = workMode;
    ISFROMNE = isFromNE;
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createQueryXML(workMode);
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_PORTSTATUS + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackQuery, isFromApply, "inputdata=" + xmlstr);
    
}

function createQueryXML(workMode)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "isFromNE");
    param.setAttribute("value", ISFROMNE);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "workmode");
    param.setAttribute("value", workMode);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc, isFromApply)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if ("0" == ISFROMNE) 
    {
        portData = data;
    }
    
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["queryPortStatus"];
    }
    
    
    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
        if ("1" == ISFROMNE) 
        {
            for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
            {
                var row = data.rows[i];
                var slotid = row["slotid"].value;
                var port = row["port"].value;
                
                for (var j = 0, lenPortData = portData.getDataRowLength(); j < lenPortData; j++) 
                {
                    var rowPortData = portData.rows[j];
                    if (slotid == rowPortData["slotid"].value && port == rowPortData["port"].value) 
                    {
                        data.rows[i] = rowPortData;
                        break;
                    }
                }
            }
        }
        else 
        {
            for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
            {
                var diobj = data.rows[i];
                var ptag = null;
                
                ptag = new ParamTag();
                var clockidhigh = data.getDataRowParam(i, "clockidhigh");
                var clockidlow = data.getDataRowParam(i, "clockidlow");
                var interfaceid = data.getDataRowParam(i, "interfaceid");
                
                ptag.value = getCompanyCode(clockidhigh, clockidlow, interfaceid);
                
                diobj["sourceID"] = ptag;
                
                if (diobj["defaultvlanid"].value == INVALID_VLAN) 
                {
                    diobj["defaultvlanid"].value = "/";
                }
                
            }
        }
        
        st0.clearTableData();
        createTableBody(st0, window.tableconf[0], data, RESOURCE);

        for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
        {
        	  if(st0.getCell(i, "acrEnable") != null && st0.getCellStoreValue(i, "acrEnable", "acrEnable") == null)
        	  {
        	  	var acrEnalbe = st0.getCell(i, "acrEnable").element;
               acrEnalbe.showElement.setValue("-");
    					acrEnalbe.ondblclick = null;
    					acrEnalbe.style.backgroundColor = "#C8C8C8";
    					acrEnalbe.style.cursor = "point"
    					acrEnalbe.isEdit = "0";
        	  }
        	  if ("" == st0.getCellStoreValue(i, "portrealstatus", "portrealstatus")
        	   || undefined == st0.getCellStoreValue(i, "portrealstatus", "portrealstatus"))
        	  {
        	  	  var portrealstatus = st0.getCell(i, "portrealstatus").element;
                portrealstatus.showElement.setValue("/");
        	  }            
        }
        
        if (workmode == TC || workmode == TCOC) 
        {
            for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
            {
                var defaultvlanid = st0.getCell(i, "defaultvlanid").element;
                setCellUnedit(defaultvlanid);
                
                var portstatus = st0.getCell(i, "portstatus").element;
                setCellUnedit(portstatus);
                
                var portrealstatus = st0.getCell(i, "portrealstatus").element;
                setCellUnedit(portrealstatus);
                
                var sourceID = st0.getCell(i, "sourceID").element;
                setCellUnedit(sourceID);
                
                if(st0.getCell(i, "acrEnable") != null)
                {
                    var acrEnable = st0.getCell(i, "acrEnable").element;
                    setCellUnedit(acrEnable);
                }
            }
        }
        
        addListerner(st0, "sourceID");
        addCellEvent();
    }
    
    if (workmode != TC && workmode != TCOC) 
    {
        $("createbtn").disabled = !btnRightArr.createbtn.right;
    }
          
    if (winurlobj.st.getModify(0)) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }

    if (typeof(isFromApply) == 'undefined' || !isFromApply)
    {
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../page/", data.getError(), errArr);
    }
}

function createTable()
{
    st0.clearTableData();
    createTableBody(st0, window.tableconf[0], portData, RESOURCE);
    
    if (workmode == TC || workmode == TCOC) 
    {
        for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
        {
            var defaultvlanid = st0.getCell(i, "defaultvlanid").element;
            setCellUnedit(defaultvlanid);
            
            var portstatus = st0.getCell(i, "portstatus").element;
            setCellUnedit(portstatus);
            
            var portrealstatus = st0.getCell(i, "portrealstatus").element;
            setCellUnedit(portrealstatus);
            
            var sourceID = st0.getCell(i, "sourceID").element;
            setCellUnedit(sourceID);
            
            if(st0.getCell(i, "acrEnable") != null)
            {
                var acrEnable = st0.getCell(i, "acrEnable").element;
                setCellUnedit(acrEnable);
            }
        }
    }
    
    addListerner(st0, "sourceID");
    addCellEvent();
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
    {
        cell = st0.getCell(i, "defaultvlanid");
        if (cell.element.isEdit == "0") 
        {
            continue;
        }
        
        cell.element["ondblclick"] = function()
        {
            this.modify = true;
            this.parentNode.modify = true;
            
            showMgrDialogVlan(st0, this, "defaultvlanid");
        }
        
        cell.element.oncontextmenu = function()
        {
            this.modify = true;
            this.parentNode.modify = true;
            
            showMgrDialogVlan(st0, this, "defaultvlanid");
        };
        
        cell = st0.getCellElement(i,"defaultvlanid");
        textCheck(cell.editElement.element,MIN_VLAN1588,MAX_VLAN1588);
        
        cell = st0.getCellElement(i,"sourceID");
        cell.editElement.element.maxLength = 20;
        cell.editElement.element["onkeypress"] = function()
        {
            if(!restrict(this, event, "0123456789abcdefABCDEF"))
            {
                return false;
            }
            return true;
        }	 
    }
}

function showMgrDialogVlan(st, cellElement, key)
{
    var i;
    var evt = EventUtil.getEvent();
    var elem = evt.target;
    if (elem.parent || elem.parentNode.parent) 
    {
        var rowid;
        var rows;
        if (elem.parent) 
        {
            rowid = elem.parentNode.rowIndex;
            rows = elem.parent.getSelectedRows();
        }
        else 
        {
            rowid = elem.parentNode.parentNode.rowIndex;
            rows = elem.parentNode.parent.getSelectedRows();
        }
        
        if (!rows.contains(rowid)) 
        {
            return;
        }
        
        if (rows.length == 1) 
        {
            i = rows[0];
        }
        else 
        {
            i = rowid;
        }
    }
    
    if (null == i) 
    {
        return;
    }
    
    var value = st.getCellStoreValue(i, key, key);
    
    xshowModalDialog("maxvlannum.html?value=" + value + "&key=" + key + "&index=" + i, RESOURCE["VLANID"], 320, 170, "../../../../images/");
}

function setCellUnedit(cell)
{
    cell.showElement.setValue("/");
    cell.ondblclick = null;
    cell.style.backgroundColor = "#C8C8C8";
    cell.style.cursor = "point"
    cell.isEdit = "0";
}

function create()
{
	if (isIE) 
	{
		xshowModalDialog("createport.html", RESOURCE["createClockPort"], 610, 400, "../../../../images/");
	}
	else 
	{
		xshowModalDialog("createport.html", RESOURCE["createClockPort"], 650, 450, "../../../../images/");
	}
}

function rowSelected(rows)
{
    var len = rows.length;
    
    if (0 == len || workmode == TC || workmode == TCOC) 
    {
        $("deletebtn").disabled = true;
    }
    else 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
}

function deletePort()
{
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createDeleteXML();
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_CONFIG_PTP_CLOCKPORT + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackDelete, null, "inputdata=" + xmlstr);
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    for (var rowindex = 0, length = st0.getDataRowLength(); rowindex < length; rowindex++) 
    {
        if (!st0.getRowSelFlag(rowindex)) 
        {
            continue;
        }
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "portName", "slotid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        var subslotid = st0.getCellStoreValue(rowindex, "portName", "subslotid");
        if (null == subslotid) 
        {
            subslotid = "255";
        }
        param.setAttribute("value", subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "port", "port"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ptpEnable");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackDelete(doc)
{
    $("querybtn").disabled = false;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
    var data = EncapsulateData(doc);
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["deletePort"];
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
        {
            if (st0.getRowSelFlag(i)) 
            {
                st0.deleteRow(i);
            }
        }
        st0.adjustDataRows();
    }
    else 
    {
        $("deletebtn").disabled = false;
    }
          
    if (winurlobj.st.getModify(0)) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function apply()
{
    var xmlstr = createApplyXML();
    if (null == xmlstr) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTP_PORTSTATUS + "" + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackApply, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    st1 = winurlobj.st;
    if (winurlobj.timeChange) 
    {
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        var minTime = new Date(2000, 0, 1, 0, 0, 0).getTime();
        var maxTime = new Date(2099, 11, 31, 23, 59, 59).getTime();
        var sysDateTimeStr = getTimeFromString(winurlobj.$("ptpSysTimeTxt").value,STANDARD_FORMAT);
        var systemTime = getTimeFromString(winurlobj.$("ptpSysTimeTxt").value);
        if (systemTime < minTime || systemTime > maxTime) 
        {
            alert(RESOURCE["timeRange"]);
            return null;
        }
        
        var sysDateTime = sysDateTimeStr.split(" ");
        var sysDate = sysDateTime[0].split("-");
        var sysTime = sysDateTime[1].split(":");
        
        var param = new tagElement("param");
        param.setAttribute("name", "year");
        param.setAttribute("value", sysDate[0]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "month");
        param.setAttribute("value", sysDate[1]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "day");
        param.setAttribute("value", sysDate[2]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "hour");
        param.setAttribute("value", sysTime[0]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "minute");
        param.setAttribute("value", sysTime[1]);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "second");
        param.setAttribute("value", sysTime[2]);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    for (var rowindex = 0, rowlen = st1.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st1.getModify(rowindex)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        if (st1.getCellModify(rowindex, "workmode")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "workmode");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "workmode", "workmode"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "slaveonlymode")) 
        {
        	isModifySlaveOnly = true;
            param = new tagElement("param");
            param.setAttribute("name", "slaveonlymode");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "slaveonlymode", "slaveonlymode"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "multicastmode")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "multicastmode");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "multicastmode", "multicastmode"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "timeadjust")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "timeadjust");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "timeadjust", "timeadjust"));
            row.appendChild(param);
        }
        
        if (st1.getCellModify(rowindex, "protocolFormat")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "protocolFormat");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "protocolFormat", "protocolFormat"));
            row.appendChild(param);
        }
        
        bussiness.appendChild(row);
    }
    
    for (var rowindex = 0, length = st0.getDataRowLength(); rowindex < length; rowindex++) 
    {
        if (!st0.getModify(rowindex)) 
        {
            continue;
        }
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "portName", "slotid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        var subslotid = st0.getCellStoreValue(rowindex, "portName", "subslotid");
        if (null == subslotid) 
        {
            subslotid = "255";
        }
        param.setAttribute("value", subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", st0.getCellStoreValue(rowindex, "port", "port"));
        row.appendChild(param);
        
        if (st0.getCellModify(rowindex, "defaultvlanid")) 
        {
            defaultvlanid = st0.getCellStoreValue(rowindex, "defaultvlanid", "defaultvlanid");
            if ("/" == defaultvlanid) 
            {
                defaultvlanid = INVALID_VLAN;
            }
            param = new tagElement("param");
            param.setAttribute("name", "defaultvlanid");
            param.setAttribute("value", defaultvlanid);
            row.appendChild(param);
        }
        
        if (st0.getCellModify(rowindex, "msgformat")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "msgformat");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "msgformat", "msgformat"));
            row.appendChild(param);
        }
        
        if (st0.getCellModify(rowindex, "portstatus")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "portstatus");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "portstatus", "portstatus"));
            row.appendChild(param);
        }
        if (st0.getCellModify(rowindex, "sourceID")) 
        {
            var sourceID = st0.getCellStoreValue(rowindex, "sourceID", "sourceID");
            
            param = new tagElement("param");
            param.setAttribute("name", "clockidhigh");
            param.setAttribute("value", getSourceIDHigh(sourceID));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "clockidlow");
            param.setAttribute("value", getSourceIDLow(sourceID));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "interfaceid");
            param.setAttribute("value", getInterfaceID(sourceID));
            row.appendChild(param);
        }
		
		if (null != st0.getCell(rowindex, "acrEnable") && st0.getCellModify(rowindex, "acrEnable")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "acrEnable");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "acrEnable", "acrEnable"));
            row.appendChild(param);
        }
        
        	
	if (st0.getCell(rowindex, "mode") && st0.getCellModify(rowindex, "mode")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "mode");
            param.setAttribute("value", st0.getCellStoreValue(rowindex, "mode", "mode"));
            row.appendChild(param);
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApply(doc)
{
    $("querybtn").disabled = false;
    $("createbtn").disabled = true;
    
    var data = EncapsulateData(doc);
    
    if (OPRSUCC != data.getError().getGlobleECode()) 
    {        
    	  for (var i = 0, size = data.getBErrLength(); i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            if (undefined == tempObj["slotid"])
            {
            	  tempObj["slotid"] = tempObj["nename"];
            	  tempObj["boardname"] = "";
            	  tempObj["portname"] = "";
            }
        }

        var errArr = [];
        errArr[0] = "slotid";
        errArr[1] = "boardname";
        errArr[2] = "portname";
        openErrPage("../../../../page/", data.getError(), errArr);
        
        $("applybtn").disabled = false;
    }
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        refreshTableState(winurlobj.st, winurlobj.window.tableconf[0], data);
        refreshTableState(st0, tc, data);
        
        if (!(winurlobj.st.getCellModify(0, "workmode"))) 
        {
            winurlobj.neStatus = winurlobj.st.getCellStoreValue(0, "workmode", "workmode");
        }
        
        if(isModifySlaveOnly && !(winurlobj.st.getCellModify(0, "slaveonlymode")))
        {
        	isModifySlaveOnly = false;
        	query(winurlobj.neStatus, "0", true);
        }
        
        if (winurlobj.neStatus != TC && winurlobj.neStatus != TCOC) 
        {
            $("createbtn").disabled = !btnRightArr.createbtn.right;
        }
    }
}
