var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var btnRightArr = new Object();
var st, st1;
var OPRSUCC = 0;
var PARTSUCC = 1;

var pemode = new Object();
pemode["1"] = "P2P";
pemode["2"] = "E2E";

var P2P = "1";
var E2E = "2";

var cycle = new Object();
cycle["0"] = "cycle0";
cycle["1"] = "cycle1";
cycle["2"] = "cycle2";
cycle["3"] = "cycle3";
cycle["4"] = "cycle4";
cycle["5"] = "cycle5";
cycle["6"] = "cycle6";
cycle["7"] = "cycle7";
cycle["8"] = "cycle8";
cycle["9"] = "cycle9";
cycle["10"] = "cycle10";
cycle["11"] = "cycle11";
cycle["12"] = "cycle12";
cycle["13"] = "cycle13";
cycle["14"] = "cycle14";
cycle["15"] = "cycle15";
cycle["16"] = "cycle16";
cycle["17"] = "cycle17";
cycle["18"] = "cycle18";
cycle["19"] = "cycle19";
cycle["20"] = "cycle20";

var MIN_VLAN1588 = "1";
var MAX_VLAN1588 = "4094";

var MIN_TIMEOUTMULT = "2";
var MAX_TIMEOUTMULT = "10";

var OC = "1";
var BC = "2";
var TC = "3";
var TCOC = "4";
var TCBC = "5";

window.onresize = function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
}

function init()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTablePtpPortMessageTHead");
    st.body.setAttribute("id", "htmlTablePtpPortMessageTBody");
    st.setImage("../../../../images/");
    tc = window.tableconf[0];
    createTableHead(st, tc);
    st.setOnCellEditHandler(cellEditHandler);
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
    $("tablecomponent").appendChild(st.getTable());
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_PTP_PORTMSG);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_PTP_PORTMSG);
    
    getRightInfo(winurlobj.winurlobj, btnRightArr);
}

function cellEditHandler(param)
{
	if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

function tabSelectHandler()
{
    query();
}

function query()
{
    if (!btnRightArr.querybtn.right) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createQueryXML();
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_PORTMSG + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackQuery, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "workmode");
    param.setAttribute("value", winurlobj.neStatus);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["queryPortMsg"];
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        var curslotid = null;
        var curportid = null;
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            var pemode = st.getCellStoreValue(i, "pemode", "pemode");
            if (P2P == pemode) 
            {
                var delaycycle = st.getCell(i, "delaycycle").element;
                
                delaycycle.showElement.setValue("/");
                delaycycle.ondblclick = null;
                delaycycle.style.backgroundColor = "#C8C8C8";
                delaycycle.style.cursor = "point"
                delaycycle.isEdit = "0";
            }
            else 
            {
                var pdelaycycle = st.getCell(i, "pdelaycycle").element;
                
                pdelaycycle.showElement.setValue("/");
                pdelaycycle.ondblclick = null;
                pdelaycycle.style.backgroundColor = "#C8C8C8";
                pdelaycycle.style.cursor = "point"
                pdelaycycle.isEdit = "0";
            }
            
            curslotid = st.getCellStoreValue(i, "portName", "slotid");
            curportid = st.getCellStoreValue(i, "port", "port");
            var tmpPortWorkMode = getPortWorkMode(curslotid, curportid);
            /**
             * sync    
             1    BC/OC      sync        PTP  
             
             DELAY    
             
             1    PE   E2E   
             
             2        BC  OC 
             
             3   PTP       
             
             PDELAY    
             
             1    PE   P2P   
             
             2     BC OC   PTP          
             
             3     TC TC+OC       PTP       
             
             
             announce    
             
             1.      BC/OC      announce        PTP   
             
             
             timeout  
             
             1    BC/OC       timeout      PTP  
             */
            setAllPeriodUnedit(i);
            if (typeof(tmpPortWorkMode) == "undefined")
            {
            	if (winurlobj.neStatus == BC || winurlobj.neStatus == OC ||(winurlobj.neStatus == TCBC && tmpPortWorkMode != TC)) 
            	{
            		setCellEdit(i, "anncycle");
					setCellEdit(i, "anntimeout");
            	}
            }
            else
            {
	            if (winurlobj.neStatus == BC || winurlobj.neStatus == OC ||(winurlobj.neStatus == TCBC && tmpPortWorkMode == BC)) 
	            {
	            	setCellEdit(i, "syncycle");
					setCellEdit(i, "anncycle");
					setCellEdit(i, "anntimeout");
	            }
            }
			if(pemode == P2P)
			{
				setCellEdit(i, "pdelaycycle");
			}
			if (pemode == E2E&&(winurlobj.neStatus == BC || winurlobj.neStatus == OC||(winurlobj.neStatus == TCBC && tmpPortWorkMode == BC))) 
			{
				setCellEdit(i, "delaycycle");
			}	
        }
        
        addCellEvent();
    }
}

function setCellEdit(row, name)
{
	var cell = st.getCell(row, name).element;
    cell.ondblclick = cellondbclick;
    cell.style.backgroundColor = "#ffffff";
    cell.style.cursor = "hand";
    cell.isEdit = "1";
}

function setAllPeriodUnedit(row)
{
    var syncycle = st.getCell(row, "syncycle").element;
    setCellUnEditable(syncycle);
    
    var delaycycle = st.getCell(row, "delaycycle").element;
    setCellUnEditable(delaycycle);
	
    var pdelaycycle = st.getCell(row, "pdelaycycle").element;
    setCellUnEditable(pdelaycycle);  
	  
    var anncycle = st.getCell(row, "anncycle").element;
    setCellUnEditable(anncycle);
    
    var anntimeout = st.getCell(row, "anntimeout").element;
    setCellUnEditable(anntimeout);
}
function setCellUnEditable(cell)
{
    cell.ondblclick = null;
    cell.style.backgroundColor = "#C8C8C8";
    cell.style.cursor = "point"
    cell.isEdit = "0";	
}

/**
 * DTS2012053006476
 */
function getPortWorkMode(tmpslotid, tmpportid)
{
    var tmpstdata = winurlobj.portTab.getTabWindow("portparam").st0;
    var portParamSlotid = null;
    var portParamPortid = null;
    
    var portWorkModevar = "";
    for (var i = 0, len = tmpstdata.getDataRowLength(); i < len; i++) 
    {
        portParamSlotid = tmpstdata.getCellStoreValue(i, "portName", "slotid");
        portParamPortid = tmpstdata.getCellStoreValue(i, "port", "port");
        
        if (tmpslotid == portParamSlotid && tmpportid == portParamPortid) 
        {
            portWorkModevar = tmpstdata.getCellStoreValue(i, "portworkmode", "portworkmode");
            return portWorkModevar;
        }
    }
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCellElement(i, "anntimeout");
        textCheck(cell.editElement.element, MIN_TIMEOUTMULT, MAX_TIMEOUTMULT);
        
        cell = st.getCellElement(i, "pemode");
        cell.editElement.element.onchange = function()
        {
            var pemode = this.value;
            var rowindex = this.parentNode.parentNode.rowIndex;
            var delaycycle = st.getCell(rowindex, "delaycycle").element;
            var pdelaycycle = st.getCell(rowindex, "pdelaycycle").element;
			
            var curslotid = st.getCellStoreValue(rowindex, "portName", "slotid");
            var curportid = st.getCellStoreValue(rowindex, "port", "port");
            var tmpPortWorkMode = getPortWorkMode(curslotid, curportid);       
			   
            if (P2P == pemode) 
            {
                delaycycle.showElement.setValue("/");
                delaycycle.ondblclick = null;
                delaycycle.style.backgroundColor = "#C8C8C8";
                delaycycle.style.cursor = "point"
                delaycycle.isEdit = "0";
                
                pdelaycycle.ondblclick = cellondbclick;
                pdelaycycle.style.backgroundColor = "#ffffff";
                pdelaycycle.style.cursor = "hand";
                pdelaycycle.isEdit = "1";
                pdelaycycle.showElement.setValue("128/1024");
            }
            else 
            {
                if (winurlobj.neStatus == BC || winurlobj.neStatus == OC||(winurlobj.neStatus == TCBC && tmpPortWorkMode == BC)) 
                {
                    delaycycle.ondblclick = cellondbclick;
                    delaycycle.style.backgroundColor = "#ffffff";
                    delaycycle.style.cursor = "hand";
                    delaycycle.isEdit = "1";
                    delaycycle.showElement.setValue("128/1024");
                }
                
                pdelaycycle.showElement.setValue("/");
                pdelaycycle.ondblclick = null;
                pdelaycycle.style.backgroundColor = "#C8C8C8";
                pdelaycycle.style.cursor = "point"
                pdelaycycle.isEdit = "0";
            }
            
        }
    }
}

function apply()
{
    var xmlstr = createApplyXML();
    if (null == xmlstr) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTP_PORTMSG + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackApply, null, "inputdata=" + xmlstr);
    
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var length = st.getDataRowLength();
    if (0 < length) 
    {
        for (var rowindex = 0; rowindex < length; rowindex++) 
        {
            if (!st.getModify(rowindex)) 
            {
                continue;
            }
            
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", neid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "slotid");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "portName", "slotid"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "subslotid");
            var subslotid = st.getCellStoreValue(rowindex, "portName", "subslotid");
            if (null == subslotid) 
            {
                subslotid = "255";
            }
            param.setAttribute("value", subslotid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "port");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "port", "port"));
            row.appendChild(param);
            
            if (st.getCellModify(rowindex, "pemode")) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "pemode");
                param.setAttribute("value", st.getCellStoreValue(rowindex, "pemode", "pemode"));
                row.appendChild(param);
            }
            
            if (st.getCellModify(rowindex, "delaycycle")) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "delaycycle");
                param.setAttribute("value", st.getCellStoreValue(rowindex, "delaycycle", "delaycycle"));
                row.appendChild(param);
            }
            
            if (st.getCellModify(rowindex, "pdelaycycle")) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "pdelaycycle");
                param.setAttribute("value", st.getCellStoreValue(rowindex, "pdelaycycle", "pdelaycycle"));
                row.appendChild(param);
            }
            
            if (st.getCellModify(rowindex, "anncycle")) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "anncycle");
                param.setAttribute("value", st.getCellStoreValue(rowindex, "anncycle", "anncycle"));
                row.appendChild(param);
            }
            
            if (st.getCellModify(rowindex, "syncycle")) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "syncycle");
                param.setAttribute("value", st.getCellStoreValue(rowindex, "syncycle", "syncycle"));
                row.appendChild(param);
            }
            
            if (st.getCellModify(rowindex, "anntimeout")) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "anntimeout");
                param.setAttribute("value", st.getCellStoreValue(rowindex, "anntimeout", "anntimeout"));
                row.appendChild(param);
            }
            
            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApply(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    
    if (OPRSUCC != data.getError().getGlobleECode()) 
    {
        var errArr = [];
        errArr[0] = "slotid";
        errArr[1] = "boardname";
        errArr[2] = "portname";
        openErrPage("../../../../page/", data.getError(), errArr);
        
        $("applybtn").disabled = false;
    }
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        refreshTableState(st, tc, data);
    }
}

function setCellUnedit(cell)
{
    cell.showElement.setValue("/");
    cell.ondblclick = null;
    cell.style.backgroundColor = "#C8C8C8";
    cell.style.cursor = "point"
    cell.isEdit = "0";
}
