var winurlobj = getNeProperty(parent);
var btnRightArr = new Object();
var st;
var OPRSUCC = 0;
var PARTSUCC = 1;
var neid = winurlobj["neid"];

var extinterfacemode = new Object();
extinterfacemode["1"] = "outerClock";
extinterfacemode["2"] = "outerTime";

var interfacedirection = new Object();
interfacedirection["1"] = "ingress";
interfacedirection["2"] = "egress";

var protocoltype = new Object();
protocoltype["1"] = "DCLS";
protocoltype["2"] = "PPS";

var interfaceletricity = new Object();
interfaceletricity["1"] = "TTL";
interfaceletricity["2"] = "RS232";
interfaceletricity["3"] = "RS422";

var boardPSMap = new Object();
boardPSMap["1410"] = 20;
boardPSMap["1411"] = 20;
boardPSMap["1607"] = 22;
boardPSMap["1608"] = 22;
boardPSMap["1609"] = 6;

var timelevelmode = new Object();
timelevelmode['1'] = RESOURCE['manualconfiguration'];
timelevelmode['2'] = RESOURCE['automaticswitch'];

function tabSelectHandler()
{
    if (st == null)
    {
        init();
    }
    
    if(btnRightArr.querybtn.right)
	  {
		  query();
	  }   
}

window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");
}	    

function init()
{
	  st = new SortTable();	
    st.head.setAttribute("id", "htmlTableBasicAttriTHead");
    st.body.setAttribute("id", "htmlTableBasicAttriTBody");
    st.setImage("../../../../images/");    
    tc = window.tableconf[0];   
    createTableHead(st, tc); 
    st.setOnCellEditHandler(cellEditHandler);  
	  st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");
    $("tablecomponent").appendChild(st.getTable());
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    
    $("querybtn").value=RESOURCE["querybutton"];
    $("applybtn").value=RESOURCE["applybutton"];
    $("querybtn").disabled = true;
    $("applybtn").disabled = true; 	
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_QUERY_PTP_BASICATTRIBUTE);
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_PTP_BASICATTRIBUTE);   
    
    getRightInfo(winurlobj,btnRightArr);
    
    if(btnRightArr.querybtn.right)
	  {
		  query();
	  }    
}

function cellEditHandler(param)
{
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
	  $("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

function query()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xmlstr = createQueryXML();  
	var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_PTP_BASICATTRIBUTE+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");    
	var row = new tagElement("row-params");
	
	var param = new tagElement("param");    
	param.setAttribute("name","neid");
	param.setAttribute("value",winurlobj["neid"]);
	row.appendChild(param);			
	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackQuery(doc)
{
	  $("querybtn").disabled = false;
	  var data = EncapsulateData(doc); 
	  
	  for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
	  	  tempObj["operateObj"] = RESOURCE["queryBaseAttr"];
	  }
	  
	  var errArr = [];
	  errArr[0] = "operateObj";
	  openErrPage("../../../../page/", data.getError(), errArr);
	  
	  if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
	  {       
		  for(var i = 0,len = data.getDataRowLength();i<len;i++)
		  {
			  var row = data.rows[i];
			  var boardPS = boardPSMap[row["boardtype"].value];
			  if(isNaN(boardPS))
			  {
				  boardPS = 0;
			  }
			  row["portname"].value = RESOURCE["outerTime"] + (row["port"].value - boardPS);
		  }
		  
		  st.clearTableData();
		  createTableBody(st, window.tableconf[0], data, RESOURCE);
	      
	      for(var i = 0,len = st.getDataRowLength();i<len;i++)
	      {
	    	  var value = st.getCellStoreValue(i,"portid","port");
	    	  var cpcell = st.getCellElement(i,"interfacedirection");
	    	  if("1" == st.getCellStoreValue(i,"extinterfacemode","extinterfacemode"))
        	  {
		    	  cpcell.ondblclick = null;
		    	  cpcell.style.backgroundColor = "#C8C8C8";
		    	  cpcell.style.cursor = "point";
		    	  cpcell.isEdit = "0";
		    	  cpcell.modify = false;
		    	  st.setAtomValue(cpcell.showElement,"/");
        	  }
	    	  
	    	  var cpcel2 = st.getCellElement(i,"protocoltype");
	    	  if("1" == st.getCellStoreValue(i,"extinterfacemode","extinterfacemode"))
        	  {
        	      cpcel2.ondblclick = null;
        	      cpcel2.style.backgroundColor = "#C8C8C8";
        	      cpcel2.style.cursor = "point";
        	      cpcel2.isEdit = "0";
        	      cpcel2.modify = false;
        	      st.setAtomValue(cpcel2.showElement,"/");
        	  }
	    	  
	    	  var cpcel3 = st.getCellElement(i,"interfaceletricity");
	    	  if("1" == st.getCellStoreValue(i,"extinterfacemode","extinterfacemode"))
        	  {
        	      cpcel3.ondblclick = null;
        	      cpcel3.style.backgroundColor = "#C8C8C8";
        	      cpcel3.style.cursor = "point";
        	      cpcel3.isEdit = "0";
        	      cpcel3.modify = false;
        	      st.setAtomValue(cpcel3.showElement,"/");
        	  }
	    	  
	    	  var cpcel4 = st.getCellElement(i,"timelevelmode");
	    	  if( "1" == st.getCellStoreValue(i,"extinterfacemode","extinterfacemode"))
        	  {
	    		  cpcel4.ondblclick = null;
	    		  cpcel4.style.backgroundColor = "#C8C8C8";
	    		  cpcel4.style.cursor = "point";
	    		  cpcel4.isEdit = "0";
	    		  cpcel4.modify = false;
        	      st.setAtomValue(cpcel4.showElement,"/");
        	  }
			  if( "1" == st.getCellStoreValue(i,"protocoltype","protocoltype"))
        	  {
	    		  cpcel4.ondblclick = null;
	    		  cpcel4.style.backgroundColor = "#C8C8C8";
	    		  cpcel4.style.cursor = "point";
	    		  cpcel4.isEdit = "0";
	    		  cpcel4.modify = false;
        	      st.setAtomValue(cpcel4.showElement,"-");
        	  }
	      }
			
	      if (st.getDataRowLength() > 0) 
	      {
	    	  st.setRowSelect(0);
	      }
	      addCellEvent();
    }
}


function addCellEvent()
{
	  var cell = null;
	  for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	  {
		    cell = st.getCell(i,"extinterfacemode");
			
		    cell.element.editElement.element["onchange"] = function()
	        {	 	
		        var rowindex = this.parentNode.parentNode.rowIndex;            
	            var cpcell = st.getCell(rowindex,"interfacedirection");
    		    if(this.value == "2")
        	    {
    			    cpcell.element.showElement.setValue(RESOURCE["egress"]);
	        	    st.setCellValue(cpcell,"interfacedirection","2");
					st.setCellIsEdit(cpcell,1);
					st.setCellModify(rowindex,"interfacedirection",true);
        	    }
        	    else
        	    {
					st.setCellIsEdit(cpcell,0);
    	    	    cpcell.element.showElement.setValue("/");
					st.setCellModify(rowindex,"interfacedirection",false);   		        
        	    }
					
			    var cpcel2 = st.getCell(rowindex,"protocoltype");
				var cpcel4 = st.getCell(rowindex,"timelevelmode");
    		    if(this.value == "2")
        	    {
					st.setCellIsEdit(cpcel2,1);
    		    	cpcel2.element.showElement.setValue(RESOURCE["DCLS"]);
					st.setCellModify(rowindex,"protocoltype",true);
    		    	st.setCellValue(cpcel2,"protocoltype","1");
					st.setCellIsEdit(cpcel4,0);
					cpcel4.element.showElement.setValue("-");
					st.setCellValue(cpcel4,"timelevelmode","-");
        	    }
        	    else
        	    {
					st.setCellIsEdit(cpcel2,0);
					st.setCellModify(rowindex,"protocoltype",false);
    	    	    cpcel2.element.showElement.setValue("/");    
					st.setCellIsEdit(cpcel4,0);
        	    	cpcel4.element.showElement.setValue("/");     		        
        	    }
    		    
			    var cpcel3 = st.getCell(rowindex,"interfaceletricity");
    		    if(this.value == "2")
        	    {
					st.setCellIsEdit(cpcel3,1);
					st.setCellModify(rowindex,"interfaceletricity",true);
    		    	cpcel3.element.showElement.setValue(RESOURCE["RS422"]);
    		    	st.setCellValue(cpcel3,"interfaceletricity","3");
        	    }
        	    else
        	    {
					st.setCellIsEdit(cpcel3,0);
					st.setCellModify(rowindex,"interfaceletricity",false);
    	    	    cpcel3.element.showElement.setValue("/");         		        
	            }

	  	  }	  
		  
	  	  cell = st.getCell(i,"protocoltype");
	  	  cell.element.editElement.element["onchange"] = function()
		  {
		        var rowindex = this.parentNode.parentNode.rowIndex;   
		        var cpcel = st.getCell(rowindex,"timelevelmode"); 
		        if (this.value == "1")
		        {
					st.setCellIsEdit(cpcel,0);
					st.setCellModify(rowindex,"timelevelmode",false);
		            cpcel.element.showElement.setValue("-");
		            st.setCellValue(cpcel,"timelevelmode","-");
		        }
		        else if (this.value == "2")
		        {
					st.setCellIsEdit(cpcel,1);
					st.setCellModify(rowindex,"timelevelmode",true);
		            cpcel.element.showElement.setValue(RESOURCE['manualconfiguration']);
		            st.setCellValue(cpcel,"timelevelmode","1");
		        }
		  }
	  }
}

function apply()
{	
    var xmlstr = createApplyXML();
    if (null == xmlstr)
    {
    	  return;
    }
    
    $("querybtn").disabled = true;
	  $("applybtn").disabled = true;
	  
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_PTP_BASICATTRIBUTE+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",true,handleBackApply,null,"inputdata="+xmlstr);
}

function createApplyXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
     	  
    for(var rowindex = 0, length = st.getDataRowLength(); rowindex < length; rowindex++)
    {
        if(!st.getModify(rowindex))
    	  {
    	  	  continue;
    	  }
        
    	  var row = new tagElement("row-params");
    
	      var param = new tagElement("param");    
        param.setAttribute("name","neid");
        param.setAttribute("value",neid);
        row.appendChild(param);
    	  
    	  param = new tagElement("param");    
      	param.setAttribute("name","slotid");
      	param.setAttribute("value",st.getCellStoreValue(rowindex,"portid","slotid"));
      	row.appendChild(param);
    	  
    	  param = new tagElement("param");    
      	param.setAttribute("name","subslotid");
      	var subslotid = st.getCellStoreValue(rowindex,"portid","subslotid");
      	if (null == subslotid)
      	{
      		  subslotid = "255";
      	}
      	param.setAttribute("value",subslotid);
      	row.appendChild(param);
    	  
    	  param = new tagElement("param");    
      	param.setAttribute("name","port");
      	param.setAttribute("value",st.getCellStoreValue(rowindex,"portid","port"));
      	row.appendChild(param);
    	
        if (st.getCellModify(rowindex, "extinterfacemode"))
        {
        	  param = new tagElement("param");    
      	    param.setAttribute("name","extinterfacemode");
      	    param.setAttribute("value",st.getCellStoreValue(rowindex,"extinterfacemode","extinterfacemode"));
      	    row.appendChild(param);
      	}
    	
        if (st.getCellModify(rowindex, "interfacedirection") || st.getCellModify(rowindex, "protocoltype")
		    || st.getCellModify(rowindex, "interfaceletricity")
			|| ( 2 == st.getCellStoreValue(rowindex,"extinterfacemode","extinterfacemode"))) // add this condition for AU9D49663
        {
        	  param = new tagElement("param");    
      	    param.setAttribute("name","interfacedirection");
      	    param.setAttribute("value",st.getCellStoreValue(rowindex,"interfacedirection","interfacedirection"));
      	    row.appendChild(param);
      	
        	  param = new tagElement("param");    
      	    param.setAttribute("name","protocoltype");
      	    param.setAttribute("value",st.getCellStoreValue(rowindex,"protocoltype","protocoltype"));
      	    row.appendChild(param);
      	
        	  param = new tagElement("param");    
      	    param.setAttribute("name","interfaceletricity");
      	    param.setAttribute("value",st.getCellStoreValue(rowindex,"interfaceletricity","interfaceletricity"));
      	    row.appendChild(param);
      	}
        
        if ( st.getCellStoreValue(rowindex,"extinterfacemode","extinterfacemode") == "2" && st.getCell(rowindex, "timelevelmode") != null && st.getCellModify(rowindex, "timelevelmode") )
        {
	  	    param = new tagElement("param");    
		    param.setAttribute("name","timelevelmode");
		    param.setAttribute("value",st.getCellStoreValue(rowindex,"timelevelmode","timelevelmode"));
		    row.appendChild(param);
        }
		
    	bussiness.appendChild(row);      	  
    }
	if (0 == bussiness.childNodes.length)
	{
		alert(RESOURCE["nochange"]);
		return null;
	}
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApply(doc)
{     
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
	  var data = EncapsulateData(doc); 
    
    if (OPRSUCC != data.getError().getGlobleECode())
    {
    	  for(var i = 0, size = data.getBErrLength();i < size;i++)
	      {
		        var tempObj = data.getError().rowErrors[i].errorObj;
  	    		tempObj["operateObj"] = RESOURCE["setBaseAttr"];
		    }	
	      var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../page/", data.getError(), errArr);
        
        $("applybtn").disabled = false;
    }

    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
	      refreshTableState(st,tc,data);
    }     
}
