var st;
var clockslotno = 3;
var clockstate = new Object();
clockstate[0] = "noability";
clockstate[1] = "ability";

var lockstate = new Object();
lockstate[0] = "lock";
lockstate[1] = "nolock";

var statedoc;
var btnRightArr = new Object();
var neobject = getNeProperty(self);


function tabSelectHandler()
{
}

function init()
{
    document.getElementById("querybtn").value = RESOURCE["query"];
    
    document.getElementById("srctext").innerHTML = RESOURCE["switchsrc"];
    document.getElementById("statetext").innerHTML = RESOURCE["switchstate"];
    
    st = new SortTable();
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    
    document.getElementById("autoacross").appendChild(st.getTable());
    st.setBodyHeight(370);
    
    st.setBodyHeight(getTableHeight($("autoacross"), st) + "px");
    
    var xmlstr = createQuerySlotXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERYOUTMETHODFORKEEPMODE + "&timeStamp=" + new Date().getTime();
    loadXMLdoc(urlreq, "POST", false, initSlot, null, "inputdata=" + xmlstr);
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_CLOCKIDENABLE);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SETCLKLOCKSTATE);
    
    getRightInfo(neobject, btnRightArr);
    
    if (btnRightArr.applybtn.right) 
    {
        $("autoacross").oncontextmenu = rightlist;//popupMenuHandler1; 
    }
    
    if (btnRightArr.querybtn.right) 
    {
        query();
    }
}

function createQuerySlotXML()
{
    di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    row = new tagElement("row-params");
    param = new tagElement("param");
    var neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function initSlot(doc)
{
    var data = new Object();
    data = EncapsulateData(doc);
    
    clockslotno = data.rows[0]["clockslotno"].value;
}

function query()
{
    document.getElementById("querybtn").disabled = true;
    
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_VIEWCLKSWITCHATTR + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, updatePG, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clockslotno");
    param.setAttribute("value", clockslotno);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function updatePG(doc)
{
    statedoc = doc;
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        document.getElementById("querybtn").disabled = false;
        showErrorDialog(data);
        return;
    }
        
    updataTable(statedoc);
    querySwitch();
}

function querySwitch()
{
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GETCLKSWITCHATTR + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, refreshWorkBoard, null, "inputdata=" + xmlstr);
}

function updataTable(doc)
{
    var data = EncapsulateData(doc);
    
      for(var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
        var clockname = data.getDataRowParam(i, "clockname");
        if(clockname != null && (clockname.indexOf("SP3S-2")>0 || clockname.indexOf("SP3D-2")>0) && neobject.neType != "95")
        {
        	   var args = clockname.split("-");
        	  var s = args[2].split("(");
        	  data.rows[i]["clockname"].value = args[0]+"-"+args[1]+"-"+"5("+s[1]+"-5)";
        }
        
     }
   
    if (0 != data.getSErrorCode()) 
    {
        document.getElementById("querybtn").disabled = false;
        showErrorDialog(data);
        return;
    }
    
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();
    
    createTableBody(st, window.tableconf[0], data, RESOURCE);
}

function refreshWorkBoard(doc)
{
    document.getElementById("querybtn").disabled = false;
    
    refreshSwitchInfo(doc);
}

function refreshSwitchInfo(doc)
{
    var newdata = new Object();
    newdata = EncapsulateData(doc);
    if (0 != newdata.getSErrorCode()) 
    {
        showErrorDialog(newdata);
        return;
    }
    
    var switchsrc = newdata.rows[0]["switchsrc"].value;

    if( (switchsrc.indexOf("SP3S-2")>0 || switchsrc.indexOf("SP3D-2")>0) && neobject.neType != "95")
    {
        	 var args = switchsrc.split("-");
        	 var s = args[2].split("(");
        	 switchsrc = args[0]+"-"+args[1]+"-"+"5("+s[1]+"-5)";
    }
    
    document.getElementById("switchsrc").value = switchsrc;
    
    var switchstate = newdata.rows[0]["switchstate"].value;
    
    document.getElementById("switchstate").value = switchstate;
}

function lock(lockstate)
{
    var xmlstr = createLockXML(lockstate);
    if (xmlstr == null) 
    {
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SETCLKLOCKSTATE + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshTable, null, "inputdata=" + xmlstr);
}

function refreshTable(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return;
    }
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_VIEWCLKSWITCHATTR + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, updataTable, null, "inputdata=" + xmlstr);
    querySwitch();
}

/**
 * 0       1     
 */
function createLockXML(lockstate)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            var row = new tagElement("row-params");
            var param = new tagElement("param");
            var neidvalue = neobject.neid;
            param.setAttribute("name", "neid");
            param.setAttribute("value", neidvalue);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "clockslotno");
            param.setAttribute("value", clockslotno);
            row.appendChild(param);
            
            param = new tagElement("param");
            var clockid = st.getCellCurrentValue(i, "clockid", "clockid");
            param.setAttribute("name", "clockid");
            param.setAttribute("value", clockid);
            row.appendChild(param);
            
            param = new tagElement("param");
            var clockname = st.getCellCurrentValue(i, "clockname", "clockname");
            param.setAttribute("name", "clockname");
            param.setAttribute("value", clockname);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "lockstate");
            param.setAttribute("value", lockstate);
            row.appendChild(param);
            
            bussiness.appendChild(row);
        }
    }
    
    if (bussiness.childNodes.length <= 0) 
    {
        return null;
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createSwitchXML(switchstate)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var selectnum = st.getSelectedRowCount();
    var sel = st.getSelectedRows();
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clockslotno");
    param.setAttribute("value", clockslotno);
    row.appendChild(param);
    
    var clockid;
    var clockname = "";
    if (selectnum >= 1) 
    {
        clockid = st.getCellCurrentValue(sel[0], "clockid", "clockid");
        clockname = st.getCellCurrentValue(sel[0], "clockname", "clockname");
    }
    else 
    {
        clockid = 61442; //          
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "clockname");
    param.setAttribute("value", clockname);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clockid");
    param.setAttribute("value", clockid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "switchstate");
    param.setAttribute("value", switchstate);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function switchclock(switchstate)
{
    /*
     * AU9D48599 [R6C01 CP0016_       ]
     *       RTN                        
     */
    var alertKey = "";
    
    if (switchstate == 0) 
    {
        alertKey = "CLEAR_SWITCH_PROMOT";
    }
    else if (switchstate == 1) 
    {
        alertKey = "MANUAL_SWITCH_PROMOT";
    }
    else if (switchstate == 2) 
    {
        alertKey = "FORCE_SWITCH_PROMOT";
    }
    
    /*        
     */
    removejsDOMmenu();
    
    if (confirm(RESOURCE[alertKey])) 
    {
        var xmlstr = createSwitchXML(switchstate);
        
        var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SETCLKSWITCHSTATE + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
        loadXMLdoc(urlreq, "POST", true, refreshSwitch, null, "inputdata=" + xmlstr);
    }
}

function refreshSwitch(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return;
    }
    
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GETCLKSWITCHATTR + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", false, refreshSwitchInfo, null, "inputdata=" + xmlstr);
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
}

function rightlist()
{
    removejsDOMmenu();
    var count = st.getSelectedRowCount();
    var length = st.getDataRowLength();

    var cursorMenu1 = new jsDOMenu(100);
    if (SYSTEMCONF.getLanguage() == "en")
    {
    	cursorMenu1 = new jsDOMenu(150);
    }
	    
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearswitch"], "", switchclock, "0"));
    cursorMenu1.addMenuItem(new menuItem('-'));
    var menulength = 0;
    if (st.getRowSelFlag(length - 1) || count == 0) 
    {
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["lock"], "", lock, "0", false));
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearlock"], "", lock, "1", false));
    }
    else if (count >= 1) 
    {
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["lock"], "", lock, "0"));
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearlock"], "", lock, "1"));
        menulength = menulength + 2;
    }
    
    cursorMenu1.addMenuItem(new menuItem('-'));
    
    if (count == 1) 
    {
        var sel = st.getSelectedRows();
        
        var state = st.getCellCurrentValue(sel[0], "lockstate", "lockstate");
        if (state == 1) 
        {
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2"));
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1"));
            
            menulength = menulength + 3;
        }
        else 
        {
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2", false));
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1", false));
            
            menulength = menulength + 3;
        }
    }
    else 
    {
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2", false));
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1", false));
        
        menulength = menulength + 3;
    }

    cursorMenu1.addMenuItem(new menuItem('-'));
    
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["query"], "", query, "0"));
    
    setPopUpMenu(cursorMenu1);
    rightClickHandler();
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("autoacross"), st) + "px");
}

