var st;

var clockslotno = 1;

var outclockmode = new Object();
outclockmode[0] = "outclockmode0";
outclockmode[1] = "outclockmode1";
outclockmode[2] = "empty";

var s1slot = new Object();
s1slot[0] = "s1ALL";
s1slot[1] = "s1byte0";
s1slot[2] = "s1byte1";
s1slot[3] = "s1byte2";
s1slot[4] = "s1byte3";
s1slot[5] = "s1byte4";

var s1quality = new Object();
s1quality[0] = "s1limit0";
s1quality[1] = "s1limit1";
s1quality[2] = "s1limit2";
s1quality[3] = "s1limit3";
s1quality[4] = "s1limit4";

var lapseflag = new Object();
lapseflag[0] = "lapseflag0";
lapseflag[1] = "lapseflag1";
lapseflag[2] = "lapseflag2";
lapseflag[3] = "lapseflag3";

var losaction = new Object();
losaction[0] = "losaction0";
losaction[1] = "losaction1";
losaction[2] = "losaction2";

var outclockname = new Object();
outclockname[1] = "outclockname1";
outclockname[2] = "outclockname2";

var btnRightArr = new Object();

var neobject = getNeProperty(self);

var NETYPE_RTN905 = "95";//RTN905
var EXTERNAL_CLOCKID1 = "15728641";
var EXTERNAL_CLOCKID2 = "15728642";
var netype = neobject.neType;

function init()
{
    document.getElementById("querybtn").value = RESOURCE["query"];
    document.getElementById("applybtn").value = RESOURCE["apply"];
    
    st = new SortTable();
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(cellEditHandler);
    
    document.getElementById("autoacross").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight($("autoacross"), st) + "px");
    $("autoacross").oncontextmenu = popupMenuHandler;
    
    var xmlstr = createQuerySlotXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERYOUTMETHODFORKEEPMODE + "&timeStamp=" + new Date().getTime();
    loadXMLdoc(urlreq, "POST", false, initSlot, null, "inputdata=" + xmlstr);
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_2MEXTCLK_ATTR);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_2MEXTCLK_ATTR);
    
    getRightInfo(neobject, btnRightArr);
    
    initrightbtn(btnRightArr);
    
    $("applybtn").disabled = true;
    
    if (btnRightArr.querybtn.right) 
    {
        query();
    }
}

function cellEditHandler(param)
{
    if (btnRightArr.applybtn.right && param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        $("applybtn").disabled = false;
    }
    
    var colid = param.colid;
    var st = param.st;
    var rowindex = param.rowindex;
    /**
     *     :DTS2012041704720
     *        
     *     :      RTN905           HZ BIT                   HZ,         BIT 
     * DCR   OP201204260002--         1        1       
     *   2       1   hz            2   16  E1  bit   
     */
    if(SpecialAttrMgr.isNESupport(neobject.neid,"TE_FUNC_CFG_NE_ATTRIB","NE_ATTR_SUPPORT_CLOCK_FILTEBITMODE") 
		&& colid == "outclockmode" )
    {
    	var clockid = st.getCellStoreValue(rowindex, "clockid", "clockid");
    	if(!clockid)
    	{
    		return;
    	}
    	var cell = st.getCell(rowindex, 'outclockmode', 'outclockmode');
    	/**
    	 * 2Mbit/s = "0"
    	 * 2MHz = "1"
    	 */
    	var options = cell.element.editElement.element.options;
    	switch(clockid)
    	{
        	case EXTERNAL_CLOCKID1:
        		options.length = 0;
        		options[options.length] = new Option(RESOURCE["outclockmode1"],1);   
        		break;
        	case EXTERNAL_CLOCKID2:
        		options.length = 0;
        		options[options.length] = new Option(RESOURCE["outclockmode0"],0);   
        		break;
        	default:
        		break;
    	}
    }
}


function initSlot(doc)
{
    var data = new Object();
    data = EncapsulateData(doc);
    
    clockslotno = data.rows[0]["clockslotno"].value;
}

function createQuerySlotXML()
{
    di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    row = new tagElement("row-params");
    param = new tagElement("param");
    neidvalue = getNeProperty(top).neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function query()
{
    document.getElementById("querybtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_2MEXTCLK_ATTR + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, updatePG, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue = getNeProperty(top).neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clockslotno");
    param.setAttribute("value", clockslotno);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function updatePG(doc)
{
    document.getElementById("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if (0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return;
    }
    
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();
    
    createTableBody(st, window.tableconf[0], data, RESOURCE);
    /**
     *                    
     *                 
     *      
     *          SDH RTN600                    
     *                           
     */
    for (var j = 0; j < st.getDataRowLength(); j++) 
	{
		if (st.getDataRowLength() > 1) 
		{
			var outclockno = st.getCellCurrentValue(j, "outclockno", "outclockno");
			if (parseInt(outclockno) == 255) 
			{
				var celllink = st.getCell(j, "s1quality");
				celldatalink(celllink, j);
				celllink = st.getCell(j, "losaction");
				celldatalink(celllink, j);
			}
		}
		
		var mode = st.getCellStoreValue(j, "outclockmode", "outclockmode");
		
		var cell = st.getCell(j, "outclockmode");
        
        tagCellEvent(cell, j);
        if (mode == 1 || typeof(st.getCellStoreValue(j,"s1slot","s1slot")) == "undefined") 
        {
            st.setAtomValue(st.getCell(j, "s1slot").element.showElement, "-");
            st.getCell(j, "s1slot").element.ondblclick = null;
            st.setCellIsEdit(st.getCell(j, "s1slot"), 0);
        }
    }
}

function celldatalink(cell)
{
    var atom = cell.element.editElement;
    
    var colid = cell.colid;
    
    atom.element["onchange"] = function()
    {
        var v = this.value;
        var rowindex = this.parentNode.parentNode.rowIndex;
        var setvalue;
        if (colid == "s1quality") 
        {
            setvalue = s1quality[v];
        }
        else 
        {
            setvalue = losaction[v];
        }
        if (rowindex == 0) 
        {
            st.setAtomValue(st.getCell(1, colid).element.showElement, RESOURCE[setvalue]);
            st.setCellValue(st.getCell(1, colid), colid, v);
        }
        else 
        {
            st.setAtomValue(st.getCell(0, colid).element.showElement, RESOURCE[setvalue]);
            st.setCellValue(st.getCell(0, colid), colid, v);
        }
    }
    
}

function tagCellEvent(cell,index)
{
    var atom = cell.element.editElement;
    atom.element["onchange"] = function()
    {
        var v = this.value;
        var rowindex = this.parentNode.parentNode.rowIndex;
		if(typeof(st.getCellStoreValue(rowindex,"s1slot","s1slot")) == "undefined")
		{
			return;
		}
        if (v == 1) 
        {
            st.setAtomValue(st.getCell(rowindex, "s1slot").element.showElement, "-");
            st.getCell(rowindex, "s1slot").element.ondblclick = null;
            st.setCellIsEdit(st.getCell(rowindex, "s1slot"), 0);
        }
        else 
        {
            st.setAtomValue(st.getCell(rowindex, "s1slot").element.showElement, RESOURCE["s1byte0"]);
            st.getCell(rowindex, "s1slot").element.ondblclick = cellondbclick;
            st.setCellValue(st.getCell(rowindex, "s1slot"), "s1slot", "1");
            st.setCellIsEdit(st.getCell(rowindex, "s1slot"), 1);
        }
    }
}

function apply()
{
    document.getElementById("applybtn").disabled = true;
    var xmlstr = createApplyXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_2MEXTCLK_ATTR + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshWorkBoard, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
    	/**
    	 *      DTS2012042007561
    	 * RTN905                                    2Mbit/s  
    	 *                                     
    	 */
        
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        var neidvalue = getNeProperty(top)["neid"];
        param.setAttribute("name", "neid");
        param.setAttribute("value", neidvalue);
        row.appendChild(param);        
        
        param = new tagElement("param");
        param.setAttribute("name", "clockslotno");
        param.setAttribute("value", clockslotno);
        row.appendChild(param);        
        
        param = new tagElement("param");
        var clockid = st.getCellCurrentValue(i, "clockid", "clockid");
        param.setAttribute("name", "clockid");
        param.setAttribute("value", clockid);
        row.appendChild(param);
		
		param = new tagElement("param");
        var clockname = st.getCellShow(i, "outclockname").element.innerHTML;
        param.setAttribute("name", "clockname");
        param.setAttribute("value", clockname);
        row.appendChild(param);
        
        param = new tagElement("param");
        var outclockmode = st.getCellCurrentValue(i, "outclockmode", "outclockmode");
        param.setAttribute("name", "outclockmode");
        param.setAttribute("value", outclockmode);
        row.appendChild(param);
        
		var s1slot = st.getCellCurrentValue(i, "s1slot", "s1slot");
		if (typeof(s1slot) != "undefined") 
		{
			param = new tagElement("param");
			param.setAttribute("name", "s1slot");
			param.setAttribute("value", s1slot);
			row.appendChild(param);
		}
        param = new tagElement("param");
        var s1quality = st.getCellCurrentValue(i, "s1quality", "s1quality");
        param.setAttribute("name", "s1quality");
        param.setAttribute("value", s1quality);
        row.appendChild(param);
        
        param = new tagElement("param");
        var lapseflag = st.getCellCurrentValue(i, "lapseflag", "lapseflag");
        param.setAttribute("name", "lapseflag");
        param.setAttribute("value", lapseflag);
        row.appendChild(param);
        
        param = new tagElement("param");
        var losaction = st.getCellCurrentValue(i, "losaction", "losaction");
        param.setAttribute("name", "losaction");
        param.setAttribute("value", losaction);
        row.appendChild(param);		
        /**
         *     q00119080
         *      AU9D87949
         *                     
         */
        param = new tagElement("param"); 
        param.setAttribute("name", "outclockno");
        param.setAttribute("value", i+1);
		
        row.appendChild(param);
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshWorkBoard(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 != data.getSErrorCode()) 
    {
        document.getElementById("applybtn").disabled = false;
        showErrorDialog(data);
        return;
    }
    
    refreshTableState(st, window.tableconf[0], data);
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
}


/*
Add table popupmenu handler
*/
function popupMenuHandler(evt)
{	
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent
			|| elem.editElement == null)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	var isColNotShowMenu = ((null != this.popupMenuExcludeCells) && (this.popupMenuExcludeCells.contains(colid)));
	
	if( NETYPE_RTN905 == netype && rows.length >= 2 && colid == "outclockmode" )
	{
		return;
	}

	if ( rows.contains(rowid))
	{
		if (null != elem.editElement && 
			 	elem.isEdit == 1 && !isColNotShowMenu)
		{
			if( SpecialAttrMgr.isNESupport(neobject.neid,"TE_FUNC_CFG_NE_ATTRIB","NE_ATTR_SUPPORT_CLOCK_FILTEBITMODE") 
				&& colid == "outclockmode" )
			{
				var clockid = st.getCellStoreValue(rowid, "clockid", "clockid");
				
				elem.editElement.removeAllOptions();
				
				if( EXTERNAL_CLOCKID1 == clockid )
				{
					elem.editElement.addOption(RESOURCE["outclockmode1"],1);
				}
				if( EXTERNAL_CLOCKID2 == clockid )
				{
					elem.editElement.addOption(RESOURCE["outclockmode0"],0);
				}
			}
			
			createTablePopupMenu(elem, evt);
			return;
		}

		for ( var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i], colid);
			if (null != tmpElem.editElement && tmpElem.isEdit == 1 && !isColNotShowMenu)
			{
				createTablePopupMenu(tmpElem, evt);
				return;
			}
		}
	}
}
