var boardType = 0; 
var portType = 0;
var portSpeed = 255;
var portName = "";
var canModifyPortBds = [2469];

function MenuItem(){
    this.name = null;
    this.type = null;
    this.supportfunblocklist = null;
    this.unsupportfunblocklist = null;
    this.toString = function(){
        var str = '';
        str += 'name=' + this.name + '\n';
        str += 'type=' + this.type + '\n';
        str += 'supportfunblocklist=' + this.supportfunblocklist + '\n';
        str += 'unsupportfunblocklist=' + this.unsupportfunblocklist + '\n';
        return str;
    }
}

/*
          
 */
function loadFunblockMenuData(){
    loadXMLdoc("../../conf/channel/funblockmenu.xml", "GET", false, funblockmenuCallback);
    function funblockmenuCallback(doc){
        var data = EncapsulateData(doc);
        if (data.getSErrorCode() != 0) {
            return;
        }
        
        for (var i = 0; i < data.getDataRowLength(); i++) {
            var type = data.getDataRowParam(i, "type");
            var name = data.getDataRowParam(i, "name");
            var supportlist = data.getDataRowParam(i, "supportfunblocklist");
            var unsupportlist = data.getDataRowParam(i, "unsupportfunblocklist");
            
            var menuitem = new MenuItem();
            menuitem.type = type;
            menuitem.name = name;
            menuitem.supportfunblocklist = supportlist.split(",");
            menuitem.unsupportfunblocklist = unsupportlist.split(",");
            funblockmenu[type] = menuitem;
            
        }
    }
    
}

/*
                
 */
function getConextMenuID(funblock){

    var menuid = [];
    
    if (!funblock) {
    
        return menuid;
    }
    
    var functionType = funblock.functionType;
    
    if (!functionType) {
        return menuid;
    }
    
    var menuitem = null;
    
    for (var key in funblockmenu) {
        menuitem = funblockmenu[key];
        if ((menuitem.unsupportfunblocklist.length > 1) &&
        (!menuitem.unsupportfunblocklist.contains(functionType))) {
            menuid.push(menuitem.type);
            break;
        }
        
        if (menuitem.supportfunblocklist.contains(functionType)) {
            menuid.push(menuitem.type);
        }
    }
    return menuid;
}


/*
        
 */
 
function createjsDOMenu(){
    createMenu(arguments[0]);
}

/*
       
 */
function createMenu(funblock){
 
    
    removejsDOMmenu();
    
    
    cursorMenu1 = new jsDOMenu(125);
    
	if(isSupportModify(funblock))
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["modifydynport"],"modifydynport",modifyPort));
	}
    
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["deletPort"], "deletPort", deletPort));
    setPopUpMenu(cursorMenu1);
}


 /*
                
  */
  function isSupportModify(funblock)
  {
  	if((getBoardName().indexOf("SL4D") != -1) || (getBoardName().indexOf("SL1D") != -1)
  		|| (getBoardName().indexOf("EG4") != -1) || (getBoardName().indexOf("EG4P") != -1)
  		|| (getBoardName().indexOf("EG2D") != -1)
  		|| (canModifyPortBds.contains(boardType))
  		|| SpecialAttrMgr.isCPSupport(neId, slotId,"TE_FUNC_SDH_PATH_CONFIG","SDH_CES_PORT_REPLACE"))
  	{
  		return true;
  	}
  	return false;
  }
  
  function getBoardName()
{
	return window.tree[0].text;
}

/*
         
 @param loopbacktype       ID
 @param rootmenu     
 @param func         
 @param funblock      
 */
function createLoopbackMenu(loopbacktype, rootmenu, func, funblock){

    rootmenu.addMenuItem(new menuItem(RESOURCE[loopbacktype], "loopback", ""));
    cursorMenu1_1 = new jsDOMenu(100);
    with (cursorMenu1_1) {
        addMenuItem(new menuItem(RESOURCE["noloopback"], "", func, "0"));
        addMenuItem(new menuItem(RESOURCE["inloopback"], "", func, "1"));
        if (funblock.functionType != 6) {
            addMenuItem(new menuItem(RESOURCE["outloopback"], "", func, "2"));
        }
    }
    rootmenu.items[rootmenu.items.length - 1].setSubMenu(cursorMenu1_1);
}

/*
       ,             
 bug,        
 */
function setTuLoopback(argus){
}

function setOpticalLoopback(argus){
}

function setDdnLoopback(argus){
}

/*
      
 */

function modifyPortName(argus){

    showModalDialog("modifyport.html", window, "dialogHeight:150px;dialogWidth:250px;center:yes;help:no;resizable:Yes;status:No;")
    
}

/*
                  
 */
function setPortName(name){
    var treenode = window.tree[window.tree.selectID];
    if (treenode && treenode.userObject) {
        var funblock = treenode.userObject;
        funblock.name = name;
        var span = $("span_" + window.tree.selectID);
        if (span) {
            var render = new treeCellRender(funblock);
            span.replaceChild(render.getDomElement(), span.firstChild);
        }
    }
    
}

/*
   vc3    
 */
function setVC3Loopback(loopbackstatus){

}

/*
   vc4    
 */
function setVC4Loopback(loopbackstatus){
    var treenode = window.tree[window.tree.selectID];
    if (treenode && treenode.userObject) {
        var funblock = treenode.userObject;
        funblock.loopback = loopbackstatus;
        var span = $("span_" + window.tree.selectID);
        if (span) {
            var render = new treeCellRender(funblock);
            span.replaceChild(render.getDomElement(), span.firstChild);
        }
    }
}

/*
       
 */
function browseCurrentAlarm(type){
    window.status = "browser current Alaram";
}

/*
         
 */
function createLegendTable(){
    $("legendtitle").innerHTML = RESOURCE["Legend"];
    $("legenddesc").innerHTML = RESOURCE["Description"];
    $("unknowAlarmColer").style.backgroundColor = ALARM_COLOR[-1];
    $("unknowAlarm").innerHTML = RESOURCE["unknowAlarm"];
    $("noAlarmColer").style.backgroundColor = ALARM_COLOR[0];
    $("noAlarm").innerHTML = RESOURCE["noAlarm"];
    $("criticalAlarmColor").style.backgroundColor = ALARM_COLOR[1];
    $("criticalAlarm").innerHTML = RESOURCE["criticalAlarm"];
    $("majorAlarmColor").style.backgroundColor = ALARM_COLOR[2];
    $("majorAlarm").innerHTML = RESOURCE["majorAlarm"];
    $("juniorAlarmColor").style.backgroundColor = ALARM_COLOR[3];
    $("juniorAlarm").innerHTML = RESOURCE["juniorAlarm"];
    $("wariningAlarmColer").style.backgroundColor = ALARM_COLOR[4];
    $("wariningAlarm").innerHTML = RESOURCE["wariningAlarm"];
}


/*
          
   0        
   1      
 */
function createQueryXmlData(){
    var requesType = arguments[0];
    
    var URLParam = parseURLStr(window);
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neid");
    param.setAttribute("value", URLParam.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", URLParam.slotID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "requesType");
    param.setAttribute("value", requesType);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    if (neId == 0 || slotId == 0) {
        slotId = URLParam.slotID
        neId = URLParam.neid;
    }
    
    return di.toString();
}


/*
 create channel path tree
 */
function createTree(){

    window.status = RESOURCE["loadingdata"];
    window.tree.treeCellRender = treeCellRender;
    setImagePath("../../../../images/tree/");
    
    var xmlData = createQueryXmlData(0);
    
    loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_CPOBJINFO, "POST", true, queryChannelDataCallBack, "", "inputdata=" + xmlData);
    
}

/*
 treenode  click hanlder
 */
function treeNodeClickHandler(){
    if (this.userObject) {
    }
    
}


/*
 query tree node data call back handler
 */
function queryChannelDataCallBack(doc)
{
	var data= EncapsulateData(doc);
	if(data.getSErrorCode()!= 0)
	{		  	
	    showErrorDialog(data);
		return;
    } 
		  
	if(data.getDataRowLength() ==0)
	{
	    return;	
	}
	
	
	for(var i=0,iLength = data.getDataRowLength(); i<iLength; i++)
	{ 
	    var id=data.getDataRowParam(i,"id");
		var pid=data.getDataRowParam(i,"pid");
		var name= data.getDataRowParam(i,"name");
		var pathid = data.getDataRowParam(i,"pathID");
		var TopAlarmLevel = data.getDataRowParam(i,"topAlarmLevel");
		var logicPortInPosition = data.getDataRowParam(i,"logicPortInPosition");
		boardType = data.getDataRowParam(i,"boardType");
		if(logicPortInPosition==0)
		{
		    canAdd = true;
		    continue;
        }
		if(name =="")
		{
		    name=data.getDataRowParam(i,"portName");
        }
           
        
		if(pid == -1)
		{
		    
		    root= new TreeNode(id , null, name,treeNodeClickHandler);   
		    document.title=name;	
        }
		else
		{
		    
		    var pnode= window.tree[pid];
		      	
		    var treenode =new  TreeNode(id, pnode,name,treeNodeClickHandler);
		    
		    setParentNodeAlarmLevel(pid,TopAlarmLevel);
		        
		    
		    var funblock=ConvertRowtoFunBlock(data,i);
		        
            		        
		    treenode.userObject=funblock;
		      		      	 
        }
    }  
    $("graph").appendChild(root.drawTree());
	$("graph").oncontextmenu = ContextMenuHandler;	     
	root.expand();
	window.status=''; 
}


/**
 *          ,       ,           
 *@param pid    ID
 *@param alarmLevle     
 */
function setParentNodeAlarmLevel(pid, alarmLevel){
    var pnode = window.tree[pid];
    if (typeof(pnode) == "undefined" || pnode == null) {
        return;
    }
    if (pnode != root && (pnode.userObject.TopAlarmLevel == 0 || pnode.userObject.TopAlarmLevel == -1)) {
        if (pnode.userObject.TopAlarmLevel < 1 && alarmLevel > pnode.userObject.TopAlarmLevel) {
            pnode.userObject.TopAlarmLevel = alarmLevel;
        }
        else {
            if (alarmLevel < pnode.userObject.TopAlarmLevel) {
                pnode.userObject.TopAlarmLevel = alarmLevel;
            }
        }
    }
    if (typeof(pnode.userObject) != "undefined" &&
    typeof(pnode.userObject.pid) != "undefined" &&
    pnode.userObject.pid != "-1" &&
    pnode.userObject.pid != "0") {
        setParentNodeAlarmLevel(pnode.userObject.pid, pnode.userObject.TopAlarmLevel);
    }
}

/*
          
 */
function ContextMenuHandler(event){

    if (!event) {
        event = window.event;
    }
    var nodeid = GetTreeNodeIDFromEvent(event);
    if (nodeid != null) {
        var treeNode = window.tree[nodeid];
        treeNode.isSelect();
        if (treeNode.userObject) {
            if (treeNode.userObject.canDelPort == 1) {
                portId = treeNode.userObject.portid;
                portType = treeNode.userObject.portType;
                portSpeed = treeNode.userObject.portSpeed;
    		        portName = treeNode.userObject.portName;
                createjsDOMenu(treeNode.userObject);
                rightClickHandler();
            }
        }
    }
    else {
        if (isDynBoard.indexOf("true") >= 0) {
            createAddPortMenu();
            rightClickHandler();
        }
        
    }
    return false;
}


function createAddPortMenu(){
    removejsDOMmenu();
    
    addPortMenu = new jsDOMenu(125);
    
    if (canAdd == true) {
        addPortMenu.addMenuItem(new menuItem(RESOURCE["addPort"], "addPort", addPort));
    }
    addPortMenu.addMenuItem(new menuItem(RESOURCE["QueryPortState"], "QueryPortState", rebuildTree));
    setPopUpMenu(addPortMenu);
}

function rebuildTree(){
    canAdd = false;
    clearInterval(timer);
    var xmlData = createQueryXmlData(0);
    
    loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_CPOBJINFO, "POST", false, rebuildTreeCallBack, "", "inputdata=" + xmlData);
}

function rebuildTreeCallBack(doc){
    
    Tree.clearNodes(window.tree);
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getDataRowLength(); i++) {
        var id = data.getDataRowParam(i, "id");
        var pid = data.getDataRowParam(i, "pid");
        var name = data.getDataRowParam(i, "name");
        var pathid = data.getDataRowParam(i, "pathID");
        var TopAlarmLevel = data.getDataRowParam(i, "topAlarmLevel");
        var logicPortInPosition = data.getDataRowParam(i, "logicPortInPosition");
        if (logicPortInPosition == 0) {
            canAdd = true;
            continue;
        }
        if (name == "") {
            name = data.getDataRowParam(i, "portName");
        }
        
        
        if (pid == -1) {
            
            root = new TreeNode(id, null, name, treeNodeClickHandler);
            document.title = name;
        }
        else {
            
            var pnode = window.tree[pid];
            
            if(pnode == null)
            {
            	continue;
            }
            
            var treenode = new TreeNode(id, pnode, name, treeNodeClickHandler);
            if (pnode != root && (pnode.userObject.TopAlarmLevel == 0 || pnode.userObject.TopAlarmLevel == -1)) {
                if (pnode.userObject.TopAlarmLevel < 1 && TopAlarmLevel > pnode.userObject.TopAlarmLevel) {
                    pnode.userObject.TopAlarmLevel = TopAlarmLevel;
                }
                else {
                    if (TopAlarmLevel < pnode.userObject.TopAlarmLevel) {
                        pnode.userObject.TopAlarmLevel = TopAlarmLevel;
                    }
                }
            }
            
            
            var funblock = ConvertRowtoFunBlock(data, i);
            
            		        
            treenode.userObject = funblock;
            
        }
    }
    
    $("graph").replaceChild(root.drawTree(), $("graph").firstChild);
    root.expand();
    
    $("graph").oncontextmenu = ContextMenuHandler;
    
    window.status = '';
}

/*
     
 */
function addPort(){
    hideMenu();
    showModalDialog("addPort.html", window, "dialogHeight:180px;dialogWidth:220px;center:yes;help:no;resizable:No;status:No;")
}


/*
     
 */
function deletPort(){

    var requestXml = creatDeletPortXml();
    loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_DEL_PORT, "POST", false, deletPortCallback, null, "inputdata=" + requestXml);
    
    rebuildTree();
}

/*
       
*/
function modifyPort()
{
        hideMenu();
        showModalDialog("modifyPort.html?isModify=true&portID="+portId+"&boardName=" + getBoardName() + "&portType=" + portType + "&portSpeed=" + portSpeed + "&portName=" + portName, window, "dialogHeight:190px;dialogWidth:320px;center:yes;help:no;resizable:yes;status:No;")
 }

function creatDeletPortXml(){
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", neId);
    row.appendChild(param);
    
    
    var param = new tagElement("param");
    param.setAttribute("name", "slotId");
    param.setAttribute("value", slotId);
    row.appendChild(param);
    
    
    
    var param = new tagElement("param");
    param.setAttribute("name", "portId");
    param.setAttribute("value", portId);
    row.appendChild(param);
    bussiness.appendChild(row);
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function deletPortCallback(doc){

    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotID";
    errArr[2] = "boardname";
    errArr[3] = "portID";
    openErrPage("../../../../page/", data.getError(), errArr);
}

/*
               ID
 */
function GetTreeNodeIDFromEvent(evt){
    var ele = evt.srcElement;
    while (ele != null) {
        if (ele.tagName == 'SPAN' && ele.id) {
            var pos = ele.id.indexOf("_");
            if (pos != -1) {
                return ele.id.substring(pos + 1);
            }
        }
        ele = ele.parentNode;
    }
    return null;
}

/*
 ConvertRowDatatoFunBlock
 */
function ConvertRowtoFunBlock(data, index){

    var funblock = new FunBlock();
    funblock.id = data.getDataRowParam(index, "id");
    funblock.pid = data.getDataRowParam(index, "pid");
    funblock.portid = data.getDataRowParam(index, "portID");
    funblock.pathid = data.getDataRowParam(index, "pathID");
    funblock.name = data.getDataRowParam(index, "name");
    funblock.canDelPort = data.getDataRowParam(index, "canDelPort");
    funblock.functionType = data.getDataRowParam(index, "functionType");
    funblock.loopback = data.getDataRowParam(index, "loopback");
    funblock.payload = data.getDataRowParam(index, "payload");
    funblock.portName = data.getDataRowParam(index, "portName");
    funblock.portStatus = data.getDataRowParam(index, "portStatus");
    funblock.usageState = data.getDataRowParam(index, "usageState");
    funblock.TopAlarmLevel = data.getDataRowParam(index, "topAlarmLevel")
    funblock.portSpeed = data.getDataRowParam(index,"portSpeed");
    funblock.portType = data.getDataRowParam(index,"portType");
    if (isDynBoard == null) {
        isDynBoard = data.getDataRowParam(index, "IsDynBoard");
    }
    return funblock;
}

/*
 Function block data constructor
 */
function FunBlock(){
    this.id = null;
    this.pid = null;
    this.name = null;
    this.portid = null;
    this.pathid = null;
    this.canDelPort = null;
    this.functionType = null;
    this.loopback = null;
    this.payload = null;
    this.portName = null;
    this.portStatus = null;
    this.usageState = null;
    this.TopAlarmLevel = null;
    this.portType = null;
}

/*
 Function block toString method,for debug
 */
FunBlock.prototype.toString = function(){
    var str = 'FunctionBlock Info:\n';
    str = str + "id=" + this.id + "\n";
    str = str + "pid=" + this.pid + "\n";
    str = str + "name=" + this.name + "\n";
    str = str + "Portid" + this.portid + "\n";
    str = str + "Pathid" + this.pathid + "\n";
    str = str + "canDelPort=" + this.canDelPort + "\n";
    str = str + "functionType=" + this.functionType + "\n";
    str = str + "loopback=" + this.loopback + "\n";
    str = str + "payload=" + this.payload + "\n";
    str = str + "portName=" + this.portName + "\n";
    str = str + "portStatus=" + this.portStatus + "\n";
    str = str + "usageState=" + this.usageState + "\n";
    str = str + "TopAlarmLevel" + this.TopAlarmLevel + "\n";
    return str;
}

/*
                  
 */
function treeCellRender(userobject){
    this.alarmStateLabel = null;
    this.pathNameLabel = null;
    this.payloadLabel = null;
    this.loopbackLabel = null;
    this.userObject = userobject;
}

/*
      treerender dom  
 */
treeCellRender.prototype.getDomElement = function(){
    var funblock = this.userObject;
    
    
    var div = document.createElement("div");
    div.style.display = "inline";
    div.style.paddingRight = "1px";
    
    
    
    var alarmdiv = document.createElement("div");
    alarmdiv.setAttribute("id", "alarmdiv_" + funblock.id);
    alarmdiv.style.display = "inline";
    alarmdiv.style.width = "14px";
    alarmdiv.style.height = "14px";
    alarmdiv.style.border = "1px solid black";
    alarmdiv.style.backgroundColor = ALARM_COLOR[funblock.TopAlarmLevel];
    
    div.appendChild(alarmdiv);
    
    
    
    var name = funblock.name;
    var portName = funblock.portName;
    if (name == "") {
        name = portName;
    }
    if (portName != "" && portName != name) {
        name = portName + "(" + name + ")";
    }
    
    var span = document.createElement("span");
    span.style.display = "inline";
    span.appendChild(document.createTextNode(name));
    div.appendChild(span);
    
    
    return div;
}

/*
     
 */
function showErrorDialog(data){
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
}

/*
    plus and minus         
 */
function initIconHandler(){

    $("plusicon").onclick = expandTree;
    $("minusicon").onclick = collapseTree;
}

/*
        
 */
function expandTree(){
    root.expandAll();
}

/*
          
 */
function collapseTree(){
    for (var i = 0; i < root.childNodes.length; i++) {
        root.childNodes[i].collapseAll();
    }
}


/*
            
 */
window.onload = function(){
    var startTime = new Date().getTime();
    
    createLegendTable();
    
    
    
    createTree();
    
    initIconHandler();
    
    loadFunblockMenuData();
}
function refreshTree(){
    var xmlData = createQueryXmlData(1);
    
    loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_CPOBJINFO, "POST", true, refreshCallBack, "", "inputdata=" + xmlData);
}


function refreshCallBack(doc){
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() != 0) {
        showErrorDialog(data);
        return;
    }
    
    
    if (data.getDataRowLength() == 0) {
        return;
    }
    
    
    var len = data.getDataRowLength();
    
    for (var i = 0; i < len; i++) {
        var id = data.getDataRowParam(i, "id");
        var pid = data.getDataRowParam(i, "pid");
        var TopAlarmLevel = data.getDataRowParam(i, "topAlarmLevel");
        if (pid != -1) {
            var pnode = window.tree[pid];
            
            if (window.tree[id]) {
                var node = window.tree[id];
                node.userObject.TopAlarmLevel = TopAlarmLevel;
                if (pnode != root) {
                    if (pnode != root && (pnode.userObject.TopAlarmLevel == 0 || pnode.userObject.TopAlarmLevel == -1)) {
                        if (pnode.userObject.TopAlarmLevel < 1 && TopAlarmLevel > pnode.userObject.TopAlarmLevel) {
                            pnode.userObject.TopAlarmLevel = TopAlarmLevel;
                        }
                        else {
                            if (TopAlarmLevel < pnode.userObject.TopAlarmLevel) {
                                pnode.userObject.TopAlarmLevel = TopAlarmLevel;
                            }
                        }
                    }
                }
            }
            else {
                continue;
            }
        }
        
        
    }
    
    for (var j = 0; j < len; j++) {
        var id = data.getDataRowParam(j, "id");
        var pid = data.getDataRowParam(j, "pid");
        if (pid != -1) {
            if (window.tree[id]) {
                var funblock = window.tree[id].userObject;
                document.getElementById("alarmdiv_" + id).style.backgroundColor = ALARM_COLOR[funblock.TopAlarmLevel];
            }
            else {
                continue;
            }
            
        }
    }
    
    if (null != window.tree.selectID) {
        var selectNode = window.tree[window.tree.selectID];
        if (selectNode) {
            selectNode.isSelect();
        }
        else {
            root.onClick();
            root.isSelect();
        }
    }
    
}

 function createjsDOMenu()
  {
  	 createMenu(arguments[0]);
  }
  
