loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../res/bittest/bittestres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
loadXMLdoc("../../conf/bittest_u2kv1r7c00/testreporttable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
loadXMLdoc("../../conf/bittest_u2kv1r7c00/bittesttable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);

var nepara = getNeProperty(self);
var neid = nepara["neid"];
var slotid = nepara["slotid"];
var boardType = nepara["boardType"];
var st;
var testResultCT;
var testReportST;
var printResultST;
var intervalID = -1;
var currentPort = -1;


var DISPLAY_GRAP = 1; //       
var DISPLAY_REPORT = 2; //       
var displayMode = 1; //        or         


var btnRightArr = new Object();

var directionConvert = new Object();
directionConvert[0] = "UNI";
directionConvert[1] = "NNI";
directionConvert[2] = "tributary";
directionConvert[3] = "cross";
directionConvert[4] = "radio";
directionConvert[5] = "XC";
directionConvert[6] = "LIU";

var framesetConvert = new Object();
framesetConvert["0"] = "unframeset";
framesetConvert["1"] = "frameset";
framesetConvert["-"] = "-";

var reportcycleConvert = new Object();
reportcycleConvert[1] = "shorttest";
reportcycleConvert[2] = "normaltest";
reportcycleConvert[3] = "longtest";

var reportConvert = new Object();
reportConvert["nenameres"] = "nenameres";
reportConvert["slotidres"] = "slotidres";
reportConvert["portidres"] = "portidres";
reportConvert["boardnameres"] = "boardnameres";
reportConvert["testresultnores"] = "testresultnores";
reportConvert["starttimeres"] = "starttimeres";
reportConvert["testperiodres"] = "testperiodres";
reportConvert["testtimeres"] = "testtimeres";
reportConvert["endtesttimeres"] = "endtesttimeres";
reportConvert["biterrnumres"] = "biterrnumres";
reportConvert["biterrrateres"] = "biterrrateres";
reportConvert["bgErrBitres"] = "bgErrBit";
reportConvert["errBitSecondres"] = "errBitSecond";
reportConvert["severityErrBitSecondres"] = "severityErrBitSecond";
reportConvert["unUsableSecondres"] = "unUsableSecond";
reportConvert["e1_bitNum"] = "e1_bitNum";
reportConvert["e1_bitNumRate"] = "e1_bitNumRate";
reportConvert["e1_bgErrBit"] = "e1_bgErrBit";
reportConvert["e1_errBitSecond"] = "e1_errBitSecond";
reportConvert["e1_severityErrBitSecond"] = "e1_severityErrBitSecond";
reportConvert["e1_unUsableSecond"] = "e1_unUsableSecond";
reportConvert["pathres"] = "pathres";


var PORTMODE_PDH = "0";
var PORTMODE_CES = "1";
var PORTMODE_IF = "2";
var IF_RADIO_OPTION = "4";
var IF_NOT_RADIO_OPTION = "5or6"
var HAVE_NO_E1 = false;

var isStopFlag = false;

var isSupportE1PRBS = getSupportE1PRBSFlag();

var E1_PRBS_TEST_VALUE = "1";

var isOnlySupportLIU;

var testResultCT_print_E1_PRBS

var isSupportPRBSReportNewAttr = getSupportPRBSReportNewAttr();

function getOnlySupportLIU(shelfType)
{
	if(!isSupportE1PRBS)
	{
		return false;
	}
	if(!SpecialAttrMgr.isNESupport(neid, "TE_FUNC_RTN_PRBS", "TE_ATTR_RTN_SUPPORT_E1_PRBS_ONLE_LIU"))
	{
		return false;
	}
	var supportShelfList = SpecialAttrMgr.getNEAttrListValue(neid, "TE_FUNC_RTN_PRBS", "TE_ATTR_RTN_SUPPORT_E1_PRBS_ONLE_LIU");
	
	if(supportShelfList == null || supportShelfList.length == 0)
	{
		return false;
	}
	for (var i = 0; i < supportShelfList.length; i++)
	{
		if(supportShelfList[i] == shelfType)
		{
			return true;
		}
	}
	return false;
	
}

function getSupportE1PRBSFlag()
{
	return SpecialAttrMgr.isCPSupport(neid, slotid, "TE_FUNC_RTN_PRBS", "TE_ATTR_RTN_SUPPORT_E1_PRBS");
}

function getSupportPRBSReportNewAttr()
{
	
	return SpecialAttrMgr.isNESupport(neid, "TE_FUNC_RTN_PRBS", "TE_ATTR_RTN_SUPPORT_PRBS_NEW_ATTR");
}

function bittestValueConvert(str)
{
	if(str=="4294967295"||str=="4294967295E-10")
	{
		return RESOURCE["invalid"];
	}
	return str;
}
function progressConvert(str)
{
	var tmpvar = parseInt(str, 10);
	if (tmpvar >= 0 && tmpvar < 100)
	{
		return tmpvar + "%"
	}
	else if (tmpvar == -1)
	{
		return RESOURCE["progress_not_start"];
	}
	else if (tmpvar == 100)
	{
		return RESOURCE["progress_end"];
	}
	
}

function compareStarttime(str1,str2)
{
	if (str1 == "-" && str2 == "-")
	{
		return 0;
	}
	else if (str1 == "-" && str2 !="-")
	{
		return -1;
	}
	else if (str1 != "-" && str2 == "-")
	{
		return 1;
	}
	else if (str1 != "-" && str2 != "-")
	{
		return compareDate(str1,str2);
	}
}

function compareprogress(str1,str2)
{
	str1 = str1.substring(0,str1.length);
	str2 = str2.substring(0,str2.length);
	return compareNum(str1,str2);
}

window.onload = function()
{
    initTable();
    initTabs();
    initButton();
    var portid = 0;
    var nepara = getNeProperty(self);
    var neid = nepara["neid"];
    var slotid = nepara["slotid"];
	
	var urlreq ="../../../../specialAppServlet?sfid="+TECMDCODE_REPORTBITTESTRESULT+"&neid="+neid+"&slotid="+slotid
                +"&portid="+portid+"&timeStamp="+new Date().getTime();
    
    var contain1 = $("imagecontainer");
    contain1.src = urlreq;
		
    /**
     *              
     */
    queryTable();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../images/");  
	var tc = window.tableconf[1];
    createTableHead(st, tc);
    $("autoAcross").appendChild(st.getTable());
    st.setBodyHeight(180);
    st.setSingleChoiceFlg(true);
    st.setOnCellEditHandler(cellEditHandler);
    $("autoAcross").oncontextmenu = popupMenuHandler; 
    st.setOnRowSelectHandler(rowSelectHandler);
	
	if(!isSupportE1PRBS)
	{
		for (var i = 0 ; i < tc.getColsLength() ; i++)
		{
			if(tc.getColId(i) == "pathid")
			{
				tc.colArray[i].width="0%";
				break;
			}
		}
	}
	
    createTestResultCT();
    var hc=st.getHeadCell("portname");
    st.setHCAttribute(hc,1,0,compareNum);
    
    var hc=st.getHeadCell("testtime");
    st.setHCAttribute(hc,1,1,compareNum);
    
    var hc=st.getHeadCell("starttime");
    st.setHCAttribute(hc,1,1,compareStarttime);
    
    var hc=st.getHeadCell("progress");
    st.setHCAttribute(hc,1,1,compareprogress);
    
    
    testReportST = new SortTable();
    testReportST.setImage("../../../../images/");  
    createTableHead(testReportST, window.tableconf[0]);
    testReportST.setBodyHeight(240);
    $("testReportTbl").appendChild(testReportST.getTable());
    
    disablebuttton();
    
    btnRightArr.startTestBtn = new BtnRightObj("startTestBtn",TECMDCODE_SET_CES_BITTEST);    
    btnRightArr.stopTestBtn = new BtnRightObj("stopTestBtn",TECMDCODE_STOP_CES_BITTEST);
    
    btnRightArr.queryResultBtn = new BtnRightObj("queryResultBtn",TECMDCODE_QUERY_CES_SELECTED_PORTRESULT);
    btnRightArr.printResultBtn = new BtnRightObj("printResultBtn",TECMDCODE_QUERY_CES_SELECTED_PORTRESULT);
    btnRightArr.saveasResultBtn = new BtnRightObj("saveasResultBtn",TECMDCODE_QUERY_CES_SELECTED_PORTRESULT);
    
    btnRightArr.queryReportBtn = new BtnRightObj("queryReportBtn",TECMDCODE_QUERY_CES_BITTESTREPORT);
    btnRightArr.printReportBtn = new BtnRightObj("printReportBtn",TECMDCODE_QUERY_CES_BITTESTREPORT);
    btnRightArr.saveasReportBtn = new BtnRightObj("saveasReportBtn",TECMDCODE_QUERY_CES_BITTESTREPORT);
    
    getRightInfo(nepara,btnRightArr);
    
    changebutton();
    refreshPic();//added by t00221658
}

function cellEditHandler(param)
{
	var colid = param.colid;
	var rowIndex = param.rowindex;
	
	/**
	 * CES   PDH             
	 */
	if (colid == "direction" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var tmpPortMode = st.getCellStoreValue(rowIndex, "portmode", "portmode");
		var directionEdit = st.getCellEdit(rowIndex, colid);
		if (tmpPortMode == PORTMODE_PDH)
		{
			directionEdit.clearOptions();
			directionEdit.addOption(RESOURCE["cross"], "3");
			directionEdit.addOption(RESOURCE["tributary"], "2");
		}
		else if (tmpPortMode == PORTMODE_IF && isSupportE1PRBS)
		{
			directionEdit.clearOptions();
			directionEdit.addOption(RESOURCE["radio"], "4");
			if (!isOnlySupportLIU)
			{
				directionEdit.addOption(RESOURCE["XC"], "5");
			}
			directionEdit.addOption(RESOURCE["LIU"], "6");
		}
		else
		{
			directionEdit.clearOptions();
			directionEdit.addOption(RESOURCE["UNI"], "0");
			directionEdit.addOption(RESOURCE["NNI"], "1");
		}
	}
	
	if (colid == "direction" && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		var tmpPortMode = st.getCellStoreValue(rowIndex, "portmode", "portmode");
		var directionValue = st.getCellStoreValue(rowIndex, "direction", "direction");
		changeCTTable(tmpPortMode, directionValue, rowIndex);
	}
	
	if (colid == "reportcycle" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var cycleEdit = st.getCellEdit(rowIndex, "reportcycle").element;
		cycleEdit.onchange = function()
		{
			changeTesttimeRange(this.value, rowIndex, true);
		}
	}
	
	if (colid == "testtime" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var reportcyclevar = st.getCellStoreValue(rowIndex, "reportcycle", "reportcycle");
		changeTesttimeRange(reportcyclevar, rowIndex);
	}
}

function changeCTTable(portMode, dir, rowIndex)
{
	if(!isSupportE1PRBS)
	{
		return;
	}

	
	if (isE1PRBSTest(portMode, dir))
	{
		testResultCT.getAttrRow("bitNumCT").style.display = "none";
		testResultCT.getAttrRow("errRateCT").style.display = "none";
		if(isSupportPRBSReportNewAttr)
		{
			testResultCT.getAttrRow("bgErrBitCT").style.display = "none";
			testResultCT.getAttrRow("errBitSecondCT").style.display = "none";
			testResultCT.getAttrRow("severityErrBitSecondCT").style.display = "none";
			testResultCT.getAttrRow("unUsableSecondCT").style.display = "none";
		}
		testResultCT.getAttrRow("e1bitNumCT").style.display = "";
		testResultCT.getAttrRow("e1BitNumRateCT").style.display = "";
		testResultCT.getAttrRow("e1bgErrBitCT").style.display = "";
		testResultCT.getAttrRow("e1errBitSecondCT").style.display = "";
		testResultCT.getAttrRow("e1severityErrBitSecondCT").style.display = "";
		testResultCT.getAttrRow("e1unUsableSecondCT").style.display = "";
		testResultCT_print_E1_PRBS = true;
		
		if (HAVE_NO_E1)
		{
			st.setCellEdit(rowIndex, "pathid", false);
			st.getCellShow(rowIndex, "pathid").setValue("/");
		}
		else
		{
			st.setCellEdit(rowIndex, "pathid", true);
			
			var pathid = st.getCellStoreValue(rowIndex, "pathid", "pathid");
			if(typeof(pathid) == "undefined")
			{
				pathid = 1;
			}
			st.setCellValue(st.getCell(rowIndex, "pathid"), "pathid", pathid);
			st.getCellShow(rowIndex, "pathid").setValue("E1-" + pathid);
		}
	}
	else
	{
		testResultCT.getAttrRow("bitNumCT").style.display = "";
		testResultCT.getAttrRow("errRateCT").style.display = "";
		if(isSupportPRBSReportNewAttr)
		{
			testResultCT.getAttrRow("bgErrBitCT").style.display = "";
			testResultCT.getAttrRow("errBitSecondCT").style.display = "";
			testResultCT.getAttrRow("severityErrBitSecondCT").style.display = "";
			testResultCT.getAttrRow("unUsableSecondCT").style.display = "";
		}
		testResultCT.getAttrRow("e1bitNumCT").style.display = "none";
		testResultCT.getAttrRow("e1BitNumRateCT").style.display = "none";
		testResultCT.getAttrRow("e1bgErrBitCT").style.display = "none";
		testResultCT.getAttrRow("e1errBitSecondCT").style.display = "none";
		testResultCT.getAttrRow("e1severityErrBitSecondCT").style.display = "none";
		testResultCT.getAttrRow("e1unUsableSecondCT").style.display = "none";
		testResultCT_print_E1_PRBS = false;
		st.setCellEdit(rowIndex, "pathid", false);
		st.getCellShow(rowIndex, "pathid").setValue("-");
	}
}

function createTestResultCT()
{
	testResultCT = new CTable();
    testResultCT.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("span");
    testResultCT.addAttrRow("neNameCT", RESOURCE["neNameCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("slotidCT", RESOURCE["slotidCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("boardTypeCT", RESOURCE["boardTypeCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("portidCT", RESOURCE["portidCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("startTimeCT", RESOURCE["startTimeCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("testCycleCT", RESOURCE["testCycleCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("testTimeCT", RESOURCE["testTimeCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("endTimeCT", RESOURCE["endTimeCT"], atom);
	
    atom = new Atom("span");
    testResultCT.addAttrRow("bitNumCT", RESOURCE["bitNumCT"], atom);
    
    atom = new Atom("span");
    testResultCT.addAttrRow("errRateCT", RESOURCE["errRateCT"], atom);
	
	if(isSupportPRBSReportNewAttr)
	{
	    atom = new Atom("span");
	    testResultCT.addAttrRow("errBitSecondCT", RESOURCE["errBitSecond"], atom);
		
		atom = new Atom("span");
	    testResultCT.addAttrRow("severityErrBitSecondCT", RESOURCE["severityErrBitSecond"], atom);
	    
	    atom = new Atom("span");
	    testResultCT.addAttrRow("unUsableSecondCT", RESOURCE["unUsableSecond"], atom);
		
		atom = new Atom("span");
	    testResultCT.addAttrRow("bgErrBitCT", RESOURCE["bgErrBit"], atom);
	}
    
	if (isSupportE1PRBS)
	{
	    atom = new Atom("span");
	    testResultCT.addAttrRow("e1bitNumCT", RESOURCE["e1_bitNum"], atom);

	    atom = new Atom("span");
	    testResultCT.addAttrRow("e1BitNumRateCT", RESOURCE["e1_bitNumRate"], atom);
	    
	    atom = new Atom("span");
	    testResultCT.addAttrRow("e1errBitSecondCT", RESOURCE["e1_errBitSecond"], atom);
		
		atom = new Atom("span");
	    testResultCT.addAttrRow("e1severityErrBitSecondCT", RESOURCE["e1_severityErrBitSecond"], atom);
	    
	    atom = new Atom("span");
	    testResultCT.addAttrRow("e1unUsableSecondCT", RESOURCE["e1_unUsableSecond"], atom);
		
		atom = new Atom("span");
	    testResultCT.addAttrRow("e1bgErrBitCT", RESOURCE["e1_bgErrBit"], atom);
	}
	
    $("testResultTbl").appendChild(testResultCT.getTable());
}

function clearCTData()
{
	testResultCT.setAttrValue("neNameCT", "");
	testResultCT.setAttrValue("slotidCT", "");
	testResultCT.setAttrValue("boardTypeCT", "");
	testResultCT.setAttrValue("portidCT", "");
	testResultCT.setAttrValue("startTimeCT", "");
	testResultCT.setAttrValue("testCycleCT", "");
	testResultCT.setAttrValue("testTimeCT", "");
	testResultCT.setAttrValue("endTimeCT", "");
	testResultCT.setAttrValue("bitNumCT", "");
	testResultCT.setAttrValue("errRateCT", "");
	if(isSupportPRBSReportNewAttr)
	{
		testResultCT.setAttrValue("bgErrBitCT", "");
		testResultCT.setAttrValue("errBitSecondCT", "");
		testResultCT.setAttrValue("severityErrBitSecondCT", "");
		testResultCT.setAttrValue("unUsableSecondCT", "");
	}
	if (isSupportE1PRBS)
	{
		testResultCT.setAttrValue("e1bitNumCT", "");
		testResultCT.setAttrValue("e1BitNumRateCT", "");
		testResultCT.setAttrValue("e1bgErrBitCT", "");
		testResultCT.setAttrValue("e1errBitSecondCT", "");
		testResultCT.setAttrValue("e1severityErrBitSecondCT", "");
		testResultCT.setAttrValue("e1unUsableSecondCT", "");
	}
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["testResult"], $("tab1div"));
    tab.addEmbedTab("tab2div", RESOURCE["testReport"], $("tab2div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedTab").appendChild(tab.getEmbedTabs());
}

function initButton()
{
	
	$('startTestBtn').value = RESOURCE["starttest"];
    $("stopTestBtn").value = RESOURCE["stoptest"];
    
    $("queryResultBtn").value = RESOURCE["query"];
    $("printResultBtn").value = RESOURCE["print"];
    $("saveasResultBtn").value = RESOURCE["saveas"];
    $("printResultBtn").style.display = "none";
    $("queryReportBtn").value = RESOURCE["query"];
    $("printReportBtn").value = RESOURCE["print"];
    $("saveasReportBtn").value = RESOURCE["saveas"];
    
    $('displayFormatT').innerHTML = RESOURCE['displayFormatT'];
    $('displayFormat1').innerHTML = RESOURCE['displayFormat1'];
    $('displayFormat2').innerHTML = RESOURCE['displayFormat2'];
    $("invalid").innerHTML = RESOURCE["invalid"];
    $("normal").innerHTML = RESOURCE["normal"];
    $("biterr").innerHTML = RESOURCE["biterr"];
    $("textaddmode").innerHTML = RESOURCE["textaddmode"];
}

function disablebuttton()
{
    $('startTestBtn').disabled = true;
	$("stopTestBtn").disabled = true;
	
	$("queryResultBtn").disabled = true;
	$("printResultBtn").disabled = true;
	$("saveasResultBtn").disabled = true;
		
	$("queryReportBtn").disabled = true;
	$("printReportBtn").disabled = true;
	$("saveasReportBtn").disabled = true;
}

function rowSelectHandler()
{
	changebutton();
	var seletnum = st.getSelectedRowCount();
	if (seletnum > 0) 
	{
		querySelectedPortResult();
		queryTestReport();
	}
	else
	{
		clearCTData();
		testReportST.clearTableData();
		var urlreq ="../../../../specialAppServlet?sfid="+TECMDCODE_REPORTBITTESTRESULT+"&neid="+neid+"&slotid="+slotid
                +"&portid=-1&timeStamp="+new Date().getTime();

	    $("imagecontainer").src = urlreq;
	}
}

function queryTable()
{
	LoadingProcess.showWaitStatus("../../../../images/");
	
    var xmlstr = createFirstQueryTableXML();
    var urlreq ="../../../../neExlorerServlet?sfid="+2012021319;
    loadXMLdoc(urlreq, "POST",true,quertPortBack,null,"inputdata="+xmlstr);
}

function quertPortBack(doc)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	if(0 != data.getSErrorCode())
    {      
      return ;
    }
    
    st.clearTableData();
    createTableBody(st, window.tableconf[1], data, RESOURCE);
	
    var flag = true;
	for (var i = 0; i < st.getDataRowLength(); i++)
    {
    	var portMode = st.getCellStoreValue(i, "portmode", "portmode");
    	if (i == 0)
    	{
    	    var shelfType = st.getCellStoreValue(i, "shelfType", "shelfType");
    	    isOnlySupportLIU = getOnlySupportLIU(shelfType);
    	}
    	/**
    	 * PDH             
    	 */
    	if (PORTMODE_PDH == portMode || PORTMODE_IF == portMode)
    	{
    		var tempCell = st.getCell(i,"frameset");
			var tempCellShow = st.getCellShow(i,"frameset","frameset");
			setCellDisable(tempCell,tempCellShow)
    	}
    	
    	/**
    	 *            
    	 */
    	if (PORTMODE_IF == portMode)
    	{
			if (isSupportE1PRBS)
			{
				initE1PathColid(i);
				var dir = st.getCellStoreValue(i, "direction", "direction");
				if (dir == "-")
				{
					var tempCellShow = st.getCellShow(i,"direction","direction");
					tempCellShow.setValue(RESOURCE["radio"]);
					changeCTTable(portMode, IF_RADIO_OPTION, i);
				}
				else
				{
					changeCTTable(portMode, IF_NOT_RADIO_OPTION, i);
				}
				
			}
			else
			{
	    		var tempCell = st.getCell(i,"direction");
				var tempCellShow = st.getCellShow(i,"direction","direction");
				setCellDisableForRadio(tempCell,tempCellShow)
			}
			
    	}
    	
    	var testState = st.getCellStoreValue(i, "teststate", "teststate");
    	
    	var tmpReportcycle = st.getCellStoreValue(i, "reportcycle", "reportcycle");
    	var cycleEdit = st.getCellEdit(i, "reportcycle");
    	
    	changeTesttimeRange(tmpReportcycle, i);
    	/**
    	 *                                         
    	 */
    	if (testState == "1")
    	{
    		showWaitStatus("prbs",0,0,"100%",$("autoAcross").offsetHeight);
    		if (intervalID == -1 && flag)
    		{
    			flag = false;
    			st.setRowSelect(i);
    			currentPort = st.getCellStoreValue(i, "portid", "portid");
    			rowSelectHandler();
    			
    			var refreshtime = 2100;
    			if (tmpReportcycle != "1")
    			{
    				refreshtime = 61000;
    			}
    			
    			intervalID = setInterval(refreshTable,refreshtime);
    		}
    	}
    }
}

function initE1PathColid(rowIndex)
{
	var e1Count = st.getCellStoreValue(rowIndex, "hybridnum", "hybridnum");
	var pathidEdit = st.getCellEdit(rowIndex, "pathid");
	if(e1Count == null || e1Count == undefined || e1Count == 0)
	{
		HAVE_NO_E1 = true;
		return;
	}
	for (var i = 1; i <= e1Count; i++)
	{
		pathidEdit.addOption("E1-" + i, i);
	}
}

function changeTesttimeRange(reportcycle, rowIndex, isedit)
{
	var testtimeEdit = st.getCellEdit(rowIndex, "testtime").element;
	if (reportcycle == "2")
	{
		textCheck(testtimeEdit, 1, 144);
	}
	else if (reportcycle == "3")
	{
		textCheck(testtimeEdit, 1, 24);
	}
	else
	{
		textCheck(testtimeEdit, 1, 255);
	}
	
	if (isedit)
	{
		st.setAtomValue(st.getCell(rowIndex,"testtime").element.showElement, "1");
		st.setCellValue(st.getCell(rowIndex,"testtime"),"testtime", "1");
	}
}

function createFirstQueryTableXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "shelfid");
    param.setAttribute("value", 255);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","portid");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","firstQuery");
    param.setAttribute("value","true");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();	
}

/**
 *     
 */
function startTest()
{	
	if(testResultCT_print_E1_PRBS && HAVE_NO_E1)
	{
		alert(RESOURCE["HAVE_NO_E1"]);
		return;
	}
	
	var selectedIndex = st.getSelectedRows()[0];
	var tmpTestTime = parseInt(st.getCellStoreValue(selectedIndex, "testtime", "testtime"), 10);
	if (tmpTestTime < 1 || tmpTestTime > 255)
	{
		alert(RESOURCE["testtimealert"]);
		return;
	}
	
	var flag = confirm(RESOURCE["PRBS_ALARM"]);
	if(!flag)
	{
	  	return ;
	}
	
	alert(RESOURCE["redalert"]);
	
	disablebuttton();
	var xmlstr = createActionXML(1);
    var urlreq ="../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_CES_BITTEST + "&nmUser=" + nepara["nmUser"];
    loadXMLdoc(urlreq, "POST",true,refreshWorkBoard,1,"inputdata="+xmlstr);
}

/**
 *     
 */
function stopTest()
{
	if(testResultCT_print_E1_PRBS && HAVE_NO_E1)
	{
		alert(RESOURCE["HAVE_NO_E1"]);
		return;
	}
	
    disablebuttton();
    var xmlstr = createActionXML(0);
    var urlreq ="../../../../neExlorerServlet?sfid=" + TECMDCODE_STOP_CES_BITTEST + "&nmUser=" + nepara["nmUser"];
    loadXMLdoc(urlreq, "POST",true,refreshWorkBoard,null,"inputdata="+xmlstr);
}

/**
 *             
 */
function refreshWorkBoard(doc,param)
{   
	var data = EncapsulateData(doc);
    if(0 != data.getSErrorCode()) 
    {
       	if (data.getSErrorCode() != -1)
      	{
        	showErrorDialog(data);
      	}
        
        changebutton();
        
		currentPort = -1;
		
        return ;
    }
    
    /**
     *                 
     */
    if ( param == 1)
    {
        refreshPic();
    	isStopFlag = false;
    	clearCTData();
        $("stopTestBtn").disabled = !btnRightArr.stopTestBtn.right;
        showWaitStatus("prbs",0,0,"100%",$("autoAcross").offsetHeight);
        refreshTableState(st, window.tableconf[1], data);
		setProgress(0);
        /**
         *              0                    
         */
        window.setTimeout(startRefreshTable, 2000);

    }
    /**
     *                
     */
    else
    {
    	isStopFlag = true;
    	/**
    	 *                          
    	 *                  
    	 */
    	window.setTimeout(stopRefreshTable, 2000);
    }
}

/**
 *                    
 */
function startRefreshTable()
{
	var selectedrow = st.getSelectedRows()[0]
	var tmpReportcycle = st.getCellStoreValue(selectedrow, "reportcycle", "reportcycle");
	var refreshtime = 2000;
	if (tmpReportcycle != "1")
	{
		refreshtime = 61000;
	}
	if (intervalID != -1) 
	{
		clearInterval(intervalID);
		intervalID = -1;
	}
	intervalID = setInterval(refreshTable, refreshtime);
}

/**
 *                         ,        
 */
function stopRefreshTable()
{
	if (intervalID != -1)
	{
		clearInterval(intervalID);
		intervalID = -1
	}
	setProgress(100);
	removeWaitStatus("prbs");
	changebutton();
}

/**
 *                    100%
 */
function setProgress(progressvar)
{
	var selectedRow = st.getSelectedRows()[0];
	
	var progressShow = progressConvert(progressvar);
	st.setAtomValue(st.getCell(selectedRow,"progress").element.showElement, progressShow);
	st.setCellValue(st.getCell(selectedRow,"progress"),"progress", progressvar);
}

/**
 *             
 */
function queryTestReport()
{
	var selrows = st.getSelectedRows();
	if (selrows.length < 1)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var xmlstr = createQueryReportXML(selrows);
    var urlreq ="../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_CES_BITTESTREPORT;
    loadXMLdoc(urlreq, "POST",true,queryReportCallback,null,"inputdata="+xmlstr);
}

function queryReportCallback(doc)
{
	var data = EncapsulateData(doc);
	if (0 != data.getSErrorCode())
	{
		var errArr = [];
	    errArr[0] = "nename";
	    errArr[1] = "boardname";
	    openErrPage("../../../../page/", data.getError(), errArr); 
	}
	
	if(2 == data.getSErrorCode())
    {
      	return ;
    }
    
    testReportST.clearTableData();
    createTableBody(testReportST, window.tableconf[0], data, RESOURCE);
    
    /**
     *                   ,              
     */
    for (var i = 0, len = testReportST.getDataRowLength(); i < len; i++)
    {
    	var reportArr = testReportST.getCellStoreValue(i, "reportArr", "reportArr");
    	var rowEle = testReportST.getRow(i).element;
    	rowEle.onclick = null;
		rowEle.onmousedown = null;
    	if (reportArr == "testresultnores")
    	{
			rowEle.className = "selectedrow";
    	}
    }
}

function createQueryReportXML(selrows)
{	
	var portmodevar = st.getCellStoreValue(selrows[0], "portmode", "portmode");
	var portidvar = st.getCellStoreValue(selrows[0], "portid", "portid");
	
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", portidvar);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "servicelevel");
    param.setAttribute("value", "3");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portmode");
    param.setAttribute("value", portmodevar);
    row.appendChild(param);
	
	if(isSupportE1PRBS)
	{	
	    var direction = st.getCellStoreValue(selrows[0], "direction", "direction");    
        if (direction == "5" || direction == "6")
		{
	       param = new tagElement("param");
	       param.setAttribute("name", "isE1PRBSTest");
	       param.setAttribute("value", E1_PRBS_TEST_VALUE);
	       row.appendChild(param);		   
		}
	    		
	    param = new tagElement("param");
	    param.setAttribute("name", "pathid");
	    param.setAttribute("value", 0);
	    row.appendChild(param);
	}
	
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();	
}

/**
 *            
 */
function querySelectedPortResult()
{
	var selrows = st.getSelectedRows();
	if (selrows.length < 1)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	
	if(testResultCT_print_E1_PRBS && HAVE_NO_E1)
	{
		alert(RESOURCE["HAVE_NO_E1"]);
		return;
	}
	
	var xmlstr = createQueryPortResultXML(selrows);
	var urlreq ="../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_CES_SELECTED_PORTRESULT;
    loadXMLdoc(urlreq, "POST",true,refreshTableData,null,"inputdata="+xmlstr);
}

function createQueryPortResultXML(selrows)
{
	var portidvar = st.getCellStoreValue(selrows[0], "portid", "portid");
	var portmodevar = st.getCellStoreValue(selrows[0], "portmode", "portmode");
	
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", portidvar);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "servicelevel");
    param.setAttribute("value", "3");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portmode");
    param.setAttribute("value", portmodevar);
    row.appendChild(param);
	
    var isE1PRBSTestVar = testResultCT_print_E1_PRBS? "1" : "0";
    param = new tagElement("param");
    param.setAttribute("name", "isE1PRBSTest");
    param.setAttribute("value", isE1PRBSTestVar);
    row.appendChild(param);
	
    if (testResultCT_print_E1_PRBS)
    {
      var pathidVar = st.getCellStoreValue(selrows[0], "pathid", "pathid");
      param = new tagElement("param");
      param.setAttribute("name", "pathid");
      param.setAttribute("value", pathidVar);
      row.appendChild(param);
    }
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();	
}

function isE1PRBSTest(portmode, dir)
{
	if(!isSupportE1PRBS)
	{
		return false;
	}
	
	if (portmode == PORTMODE_IF && dir != IF_RADIO_OPTION)
	{
		return true;
	}
	
	return false;
}


/**
 *         
 */
function refreshTable()
{
	if (currentPort == -1)
	{
		return;
	}
	
	var xmlstr = createRefreshTableXML();
    var urlreq ="../../../../neExlorerServlet?sfid=2012022115";
    loadXMLdoc(urlreq, "POST",true,refreshTableData,true,"inputdata="+xmlstr);
}

/**
 *             
 */
function refreshTableData(doc,fresh)
{
	clearCTData();
	var data = EncapsulateData(doc);
	if(0 != data.getSErrorCode()) 
    {
    	showErrorDialog(data);
        return ;
    }
    
    /**
     *                
     */
    if (data.rows.length == 0)
    {
    	refreshPic();
    	return;
    }
    
	var refreshPortid = data.rows[0]["portid"].value;
	var stIndex = -1;
	/**
	 *          
	 */
	for (var i = 0; i < st.getDataRowLength(); i++)
	{
		var tmpPortid = st.getCellStoreValue(i, "portid", "portid");
		if (tmpPortid == refreshPortid)
		{
			stIndex = i;
			break;
		}
	}
	
	var refreshProgress = data.rows[0]["progress"].value;
	var tmpProgress = parseInt(refreshProgress);
	/**
	 *      100%         
	 */
	if (tmpProgress >= 100)
	{
		isStopFlag = true;
		stopRefreshTable();
	}
	
	/**
	 *                  
	 */
	if (!isStopFlag)
	{
		var progressShow = progressConvert(refreshProgress);
		st.setAtomValue(st.getCell(stIndex,"progress").element.showElement, progressShow);
		st.setCellValue(st.getCell(stIndex,"progress"),"progress", refreshProgress);
	}
	
	var refreshStartTime = data.rows[0]["starttime"].value;
	st.setAtomValue(st.getCell(stIndex,"starttime").element.showElement,refreshStartTime);
	st.setCellValue(st.getCell(stIndex,"starttime"),"starttime", refreshStartTime);
	
	/**
	 *                  
	 */
	if (isStopFlag && (fresh || !st.getCellModify(stIndex,"testtime")))
	{
		var refreshTestTime = data.rows[0]["testtime"].value;
		st.setAtomValue(st.getCell(stIndex,"testtime").element.showElement,refreshTestTime);
		st.setCellValue(st.getCell(stIndex,"testtime"),"testtime", refreshTestTime);
	}
	
	testResultCT.setAttrValue("neNameCT", data.rows[0]["nename"].value);
	testResultCT.setAttrValue("slotidCT", slotid);
	testResultCT.setAttrValue("boardTypeCT", nepara["boardname"]);
	testResultCT.setAttrValue("portidCT", refreshPortid);
	testResultCT.setAttrValue("startTimeCT", refreshStartTime);
	var testPeriod = data.rows[0]["reportcycle"].value;
	var testPeriodShow = "";
	if( testPeriod == "1" )
	{
		testPeriodShow = RESOURCE["shorttest"];
	}
	else if( testPeriod == "2" )
	{
		testPeriodShow = RESOURCE["normaltest"];
	}
	else if( testPeriod == "3" )
	{
		testPeriodShow = RESOURCE["longtest"];
	}
	else
	{
		testPeriodShow = RESOURCE["shorttest"];
	}

	testResultCT.setAttrValue("testCycleCT", testPeriodShow);
	testResultCT.setAttrValue("testTimeCT", data.rows[0]["actualtesttime"].value);

	var curtime = data.rows[0]["currenttime"].value;
	if (curtime.indexOf("1970-01-01") == -1)//                      
	{
		testResultCT.setAttrValue("endTimeCT", curtime);
	}

	if(data.rows[0]["isE1PRBSTest"] != null && data.rows[0]["isE1PRBSTest"].value == E1_PRBS_TEST_VALUE)
	{
		testResultCT.setAttrValue("e1bitNumCT", bittestValueConvert(data.rows[0]["e1errBitNum"].value));
		testResultCT.setAttrValue("e1BitNumRateCT", bittestValueConvert(data.rows[0]["e1bitNumRate"].value));
		testResultCT.setAttrValue("e1bgErrBitCT", bittestValueConvert(data.rows[0]["e1bgErrBit"].value));
		testResultCT.setAttrValue("e1errBitSecondCT", bittestValueConvert(data.rows[0]["e1errBitSecond"].value));
		testResultCT.setAttrValue("e1severityErrBitSecondCT", bittestValueConvert(data.rows[0]["e1severityErrBitSecond"].value));
		testResultCT.setAttrValue("e1unUsableSecondCT", bittestValueConvert(data.rows[0]["e1unUsableSecond"].value));
	}
	else
	{
		testResultCT.setAttrValue("bitNumCT", bittestValueConvert(data.rows[0]["errBitNum"].value));
		testResultCT.setAttrValue("errRateCT", bittestValueConvert(data.rows[0]["errBitRate"].value));
		
		if(isSupportPRBSReportNewAttr)
		{
			testResultCT.setAttrValue("bgErrBitCT", bittestValueConvert(data.rows[0]["bgErrBit"].value));
			testResultCT.setAttrValue("errBitSecondCT", bittestValueConvert(data.rows[0]["errBitSecond"].value));
			testResultCT.setAttrValue("severityErrBitSecondCT", bittestValueConvert(data.rows[0]["severityErrBitSecond"].value));
			testResultCT.setAttrValue("unUsableSecondCT", bittestValueConvert(data.rows[0]["unUsableSecond"].value));
		}
	}
	
	
	
	/**
	 *     100%             
	 */
	if (tmpProgress >= 100 || isStopFlag)
	{
		st.setCellValue(st.getCell(stIndex,"teststate"),"teststate", 0);
		changebutton();
	}
	refreshPic();
}

function createRefreshTableXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "shelfid");
    param.setAttribute("value", 255);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", currentPort);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();	
}

function createActionXML(testaction)
{
	var sel = st.getSelectedRows();
	var portMode = st.getCellStoreValue(sel[0], "portmode", "portmode");
	
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "shelfid");
    param.setAttribute("value", 255);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var portid = st.getCellStoreValue(sel[0], "portid", "portid");
    param.setAttribute("name", "portid");
    param.setAttribute("value", portid);
    row.appendChild(param);
    
	currentPort = portid;
    /**
     *   CES   PDH      
     */
    if (!(portMode == PORTMODE_IF))
    {
	    param = new tagElement("param");
	    var direction = st.getCellStoreValue(sel[0], "direction", "direction");
	    /**
	     *      PDH       1--   2--  
	     *    3  1              
	     */
	    if (direction == "3")
	    {
	    	direction = "1";
	    }
	    param.setAttribute("name", "direction");
	    param.setAttribute("value", direction);
	    row.appendChild(param);
    }
	else
	{
		if(isSupportE1PRBS)
		{
	    	var pathid = st.getCellStoreValue(sel[0], "pathid", "pathid");
	    	var direction = st.getCellStoreValue(sel[0], "direction", "direction");
		    /**
		     *    E1 PRBS        1--XC 2--LIU
		     *    5  1,6   2              ,     pathid E1 PRBS           
		     *    4    direction      
		     */
		    if (direction == "5")
		    {
		    	direction = "1";
		    	param = new tagElement("param");
		    	param.setAttribute("name", "direction");
		    	param.setAttribute("value", direction);
		    	row.appendChild(param);
				
		        param = new tagElement("param");
		    	param.setAttribute("name", "pathid");
		    	param.setAttribute("value", pathid);
		    	row.appendChild(param);
				
		    	param = new tagElement("param");
		    	param.setAttribute("name", "isE1PRBSTest");
		    	param.setAttribute("value", E1_PRBS_TEST_VALUE);
		    	row.appendChild(param);
		    }
		    else if (direction == "6")
		    {
		    	direction = "2";
		    	param = new tagElement("param");
		    	param.setAttribute("name", "direction");
		    	param.setAttribute("value", direction);
		    	row.appendChild(param);
				
		    	param = new tagElement("param");
		    	param.setAttribute("name", "pathid");
		    	param.setAttribute("value", pathid);
		    	row.appendChild(param);
				
		    	param = new tagElement("param");
		    	param.setAttribute("name", "isE1PRBSTest");
		    	param.setAttribute("value", E1_PRBS_TEST_VALUE);
		    	row.appendChild(param);
		    }
		}
	}
    
    /**
     *   CES       
     */
    if (portMode == PORTMODE_CES)
    {
	    var frameset = st.getCellStoreValue(sel[0], "frameset", "frameset");
	    param = new tagElement("param");
	    param.setAttribute("name", "frameset");
	    param.setAttribute("value", frameset);
	    row.appendChild(param);
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "testaction");
    param.setAttribute("value", testaction);
    row.appendChild(param);
    
    var reportcycle = st.getCellStoreValue(sel[0], "reportcycle", "reportcycle");
    param = new tagElement("param");
    param.setAttribute("name", "reportcycle");
    param.setAttribute("value", reportcycle);
    row.appendChild(param);
    
    var testtime = st.getCellStoreValue(sel[0], "testtime", "testtime");
    param = new tagElement("param");
    param.setAttribute("name", "testtime");
    param.setAttribute("value", testtime);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portmode");
    param.setAttribute("value", portMode);
    row.appendChild(param);
    
    param = new tagElement("param");
    var checkbox = $("checkid");
    var isaccu = 0  ;
    if (checkbox.checked)
    {
    	isaccu = 1;
    }
    param.setAttribute("name","isaccu");
    param.setAttribute("value",isaccu);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();	
}

/**
 *       
 */
function changebutton()
{
	var seletnum = st.getSelectedRowCount();
	if (seletnum <= 0 )
	{
		$("startTestBtn").disabled = true;
		$("stopTestBtn").disabled = true;
		
		$("queryResultBtn").disabled = true;
		$("printResultBtn").disabled = true;
		$("saveasResultBtn").disabled = true;
		
		$("queryReportBtn").disabled = true;
		$("printReportBtn").disabled = true;
		$("saveasReportBtn").disabled = true;
		
		return ;
	}
	$("queryReportBtn").disabled = !btnRightArr.queryReportBtn.right;
	$("printReportBtn").disabled = !btnRightArr.printReportBtn.right;
	$("saveasReportBtn").disabled = !btnRightArr.saveasReportBtn.right;
	var sel = st.getSelectedRows();
		
	var state1 = st.getCellCurrentValue(sel[0],"teststate","teststate");

	if (state1 != 1)
	{
		$('startTestBtn').disabled = !btnRightArr.startTestBtn.right;
		$("stopTestBtn").disabled = true;
		
		$("queryResultBtn").disabled = !btnRightArr.queryResultBtn.right;
		$("printResultBtn").disabled = !btnRightArr.printResultBtn.right;
		$("saveasResultBtn").disabled = !btnRightArr.saveasResultBtn.right;
	}
	else
	{
		$('startTestBtn').disabled = true;
		$("stopTestBtn").disabled = !btnRightArr.stopTestBtn.right;
		
		$("queryResultBtn").disabled = true;
		$("printResultBtn").disabled = true;
		$("saveasResultBtn").disabled = true;
		
	}
	var isaccu = st.getCellCurrentValue(sel[0],"isaccu","isaccu");
	var checkbox = $("checkid");
    
	if (isaccu == 1)
	{
    		checkbox.checked = true;
	}
	else
	{
    		checkbox.checked = false;
	}	
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "fullportname";
    openErrPage("../../../../page/", data.getError(), errArr); 
}

/**
 *             
 */
function setCellDisable(cell,cellShow)
{
	st.setCellIsEdit(cell,"0");
	cell.element.style.backgroundColor = "";
	cell.element.ondblclick = null;
	cell.element.style.cursor = "";
}

/**
 *             
 */
function setCellDisableForRadio(cell,cellShow)
{
	st.setCellIsEdit(cell,"0");
	cell.element.style.backgroundColor = "";
	cell.element.ondblclick = null;
	cell.element.style.cursor = "";
	cellShow.setValue(RESOURCE["radio"]);
}

/**
 *     ,      
 */
function showWaitStatus(id,sleft,stop,sWidth,sHeight)
{
	var sid = "shield_" + id;
	var shield = $(sid);
	if(!shield)
	{
		shield = document.createElement("DIV");
		shield.id = sid;
		document.body.appendChild(shield);
	}
	shield.style.position = "absolute";
	var bCorverAll = false;
	if(typeof(sleft) == "undefined")
	{
		sleft = "0";
		bCorverAll = true
	}
	if(typeof(stop) == "undefined")
	{
		stop = "0";
	}
	if(typeof(sWidth) == "undefined")
	{
		sWidth = "100%";
	}
	if(typeof(sHeight) == "undefined")
	{
		sHeight = document.body.scrollHeight + "px";
	}
	shield.style.left = sleft;
	shield.style.top = stop;
	shield.style.width = sWidth;
	shield.style.height = sHeight;
	shield.style.background = "#FFFFFF";
	shield.style.textAlign = "center";
	shield.style.zIndex = "10000";
	if(isIE)
	{
		shield.style.filter = "alpha(opacity=50)";
	}
	else
	{
		shield.style.opacity = "0.50";
	}

	if(isIE6 && bCorverAll)
	{
		var sels = document.getElementsByTagName("select");
		for(var i = 0,len = sels.length;i < len;i++)
		{
			if(sels[i] && sels[i].style.display == "")
			{
				sels[i].style.display = "none";
				sels[i].setAttribute("waitflag","true");
			}
		}
	}
}


/**
 *     ,      
 */
function removeWaitStatus(id)   
{
	var shield = $("shield_" + id);
	if(shield)
	{
		shield.style.filter = "";   
		shield.id = "";   
		shield.style.position = "";   
		shield.style.left = "";   
		shield.style.top = "";   
		shield.style.width = "";   
		shield.style.height ="";   
		shield.style.background = "";   
		shield.style.textAlign = "";   
		shield.style.zIndex = "";   
		shield.style.filter = "";
		if(isIE6)
		{
			var sels = document.getElementsByTagName("select");
			for(var i = 0,len = sels.length;i < len;i++)
			{
				if(sels[i] && sels[i].style.display == "none" && sels[i].getAttribute("waitflag") == "true")
				{
					sels[i].style.display = "";
					sels[i].setAttribute("waitflag","");
				}
			}
		}
	}
}

/**
 *           
 */
function printResult()
{
	var ptag,obj;
	var datainterface = new DataInterface();
	var neNameCT = testResultCT.getAttrValue("neNameCT");
	var slotidCT = testResultCT.getAttrValue("slotidCT");
	var boardTypeCT = testResultCT.getAttrValue("boardTypeCT");
	var portidCT = testResultCT.getAttrValue("portidCT");
	var testCycleCT = testResultCT.getAttrValue("testCycleCT");
	var testTimeCT = testResultCT.getAttrValue("testTimeCT");
	var startTimeCT = testResultCT.getAttrValue("startTimeCT");
	var endTimeCT = testResultCT.getAttrValue("endTimeCT");
	var bitNumCT = testResultCT.getAttrValue("bitNumCT");
	var errRateCT = testResultCT.getAttrValue("errRateCT");
	
	if(neNameCT == "" && slotidCT == "" && boardTypeCT == "" && portidCT == "" 
		&& startTimeCT == "" && endTimeCT == "" && bitNumCT == "" 
		&& errRateCT == "")//&& testCycleCT == ""
    {
        alert(RESOURCE["nodata"]);
        return;
    }
	
	addPrintTable(datainterface, neNameCT, RESOURCE["neNameCT"]);
	addPrintTable(datainterface, slotidCT, RESOURCE["slotidCT"]);
	addPrintTable(datainterface, boardTypeCT, RESOURCE["boardTypeCT"]);
	addPrintTable(datainterface, portidCT, RESOURCE["portidCT"]);
	addPrintTable(datainterface, startTimeCT, RESOURCE["startTimeCT"]);
	addPrintTable(datainterface, testCycleCT, RESOURCE["testCycleCT"]);
	addPrintTable(datainterface, testTimeCT, RESOURCE["testTimeCT"]);
	addPrintTable(datainterface, endTimeCT, RESOURCE["endTimeCT"]);
	
	if (testResultCT_print_E1_PRBS)
	{
		addPrintTable(datainterface, testResultCT.getAttrValue("e1bitNumCT"), RESOURCE["e1_bitNum"]);
		addPrintTable(datainterface, testResultCT.getAttrValue("e1BitNumRateCT"), RESOURCE["e1_bitNumRate"]);
		addPrintTable(datainterface, testResultCT.getAttrValue("e1errBitSecondCT"), RESOURCE["e1_errBitSecond"]);
		addPrintTable(datainterface, testResultCT.getAttrValue("e1severityErrBitSecondCT"), RESOURCE["e1_severityErrBitSecond"]);
		addPrintTable(datainterface, testResultCT.getAttrValue("e1unUsableSecondCT"), RESOURCE["e1_unUsableSecond"]);
		addPrintTable(datainterface, testResultCT.getAttrValue("e1bgErrBitCT"), RESOURCE["e1_bgErrBit"]);
	}
	else
	{
		addPrintTable(datainterface, bitNumCT, RESOURCE["bitNumCT"]);
		addPrintTable(datainterface, errRateCT, RESOURCE["errRateCT"]);
		if (isSupportPRBSReportNewAttr)
		{
			addPrintTable(datainterface, testResultCT.getAttrValue("errBitSecondCT"), RESOURCE["errBitSecond"]);
			addPrintTable(datainterface, testResultCT.getAttrValue("severityErrBitSecondCT"), RESOURCE["severityErrBitSecond"]);
			addPrintTable(datainterface, testResultCT.getAttrValue("unUsableSecondCT"), RESOURCE["unUsableSecond"]);
			addPrintTable(datainterface, testResultCT.getAttrValue("bgErrBitCT"), RESOURCE["bgErrBit"]);
		}
	}
	
	printResultST = new SortTable();
    createTableHead(printResultST, window.tableconf[0]);
    printResultST.clearTableData();
    createTableBody(printResultST, window.tableconf[0], datainterface, RESOURCE);
    
    openPrintPage("../../../../page/", RESOURCE["titleres"],"printResultST");
}

function addPrintTable(datainterface, value, name)
{
	obj = new Object();
	ptag = new ParamTag();
	ptag.value = name;
	obj["reportArr"] = ptag;
	ptag = new ParamTag();
	ptag.value = value;
	obj["reportVar"] = ptag;
	datainterface.rows.append(obj);
}
/**
 *       
 */
function printas()
{
    if(0 == testReportST.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    openPrintPage("../../../../page/", RESOURCE["titleres"],"testReportST");
}

function popupMenuHandler(evt)
{	
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent
			|| elem.editElement == null)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	var isColNotShowMenu = ((null != this.popupMenuExcludeCells) && (this.popupMenuExcludeCells.contains(colid)));

	if (rows.contains(rowid))
	{
		if (colid == "testtime")
    	{
			if (rows.length > 1)
			{
				return;
			}
			
			var reportcyclevar = st.getCellStoreValue(rowid, "reportcycle", "reportcycle");
			changeTesttimeRange(reportcyclevar, rowid);
    	}
    	
    	if (colid == "direction")
    	{
    		var tmpPortMode = st.getCellStoreValue(rowid, "portmode", "portmode");
			var directionEdit = st.getCellEdit(rowid, colid);
			if (tmpPortMode == PORTMODE_PDH)
			{
				directionEdit.clearOptions();
				directionEdit.addOption(RESOURCE["cross"], "3");
				directionEdit.addOption(RESOURCE["tributary"], "2");
			}
			else
			{
				directionEdit.clearOptions();
				directionEdit.addOption("UNI", "0");
				directionEdit.addOption("NNI", "1");
			}
    	}
    		
		if (null != elem.editElement && 
			 	elem.isEdit == 1 && !isColNotShowMenu)
		{
			createTablePopupMenu(elem, evt);
			return;
		}

		for ( var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i], colid);
			if (null != tmpElem.editElement && tmpElem.isEdit == 1 && !isColNotShowMenu)
			{
				createTablePopupMenu(tmpElem, evt);
				return;
			}
		}
	}
}

/**
 *        
 */
function saveas()
{
    if(testReportST.getDataRowLength()<=0)
	  {
	  	alert(RESOURCE["nodata"]);
	  	return;
	  }
	  openSaveAsPage("../../../../page/", RESOURCE["titleres"], "testReportST");
}


function changeDisplay(/*int*/mode)
{
	displayMode = mode; //            
	if(mode == DISPLAY_GRAP)
	{
		setDisplay("testResultTbl", "none");
		setDisplay("testResultImg", "");	
		$("printResultBtn").style.display = "none";
		
	}
	else
	{
		
		setDisplay("testResultTbl", "");
		setDisplay("testResultImg", "none");
		 $("printResultBtn").style.display = "";
	}
}
function setDisplay(/*string*/id, /*string*/displayType)
{
	$(id).style.display = displayType;
}
function refreshPic()
{
	var selectnum = st.getSelectedRowCount();
	if (selectnum <= 0 )
	{
		return ;
	}
	
	var sel = st.getSelectedRows();
	var portid = st.getCellCurrentValue(sel[0],"portid","portid");
	var nepara = getNeProperty(self);
	var neid = nepara["neid"];
	var slotid = nepara["slotid"];
	
	var urlreq ="../../../../specialAppServlet?sfid="+TECMDCODE_REPORTBITTESTRESULT+"&neid="+neid+"&slotid="+slotid
	+"&portid="+portid+"&timeStamp="+new Date().getTime();
    
	if(testResultCT_print_E1_PRBS)
	{
		var pathid = st.getCellCurrentValue(sel[0],"pathid","pathid");
		urlreq = urlreq + "&vc4=" + pathid;
	}
	
    var contain1 = $("imagecontainer");
        
    contain1.src = urlreq;	
   
}
function checkboxClick()
{
	var selectnum = st.getSelectedRowCount();
	if (selectnum <= 0 )
	{
		return ;
	}
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var nepara = getNeProperty(self);
    var neidvalue = nepara["neid"];
    param.setAttribute("name","neid");
    param.setAttribute("value",neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    var slotid = nepara["slotid"];
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var sel = st.getSelectedRows();
    var portid =  st.getCellCurrentValue(sel[0],"portid","portid");
    param.setAttribute("name","portid");
    param.setAttribute("value",portid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var isaccu ;
    var checkbox = $("checkid");
    if (checkbox.checked)
    {
    	isaccu = 1;
    }
    else
    {
    	isaccu = 0;
    }
    param.setAttribute("name","isaccu");
    param.setAttribute("value",isaccu);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);

    var xmlstr = di.toString();                      
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SONET_TACC_GET_ALLTAPTACC+"&timeStamp="+new Date().getTime();
   
    loadXMLdoc(urlreq, "POST",true,updataPic,isaccu,"inputdata="+xmlstr);	
}

function autoRefreshPic(freshpara)
{   
	var selectnum = st.getSelectedRowCount();
    if (selectnum <= 0 )
	{
		return ;
    }
    if (freshpara)
    {
    	refreshPic();
    	return ;
    }
    
    var sel = st.getSelectedRows();
    var teststate =  st.getCellCurrentValue(sel[0],"teststate","teststate");
    var totalErrNum =  st.getCellCurrentValue(sel[0],"totalErrNum","totalErrNum");
    if( totalErrNum > 0 && teststate == 1)   
    {
       refreshPic();
    }
}
function updataPic(doc,param)
{

    var data = EncapsulateData(doc);
    
    if(0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return ;
    }
    var sel = st.getSelectedRows();
    st.setCellValue(st.getCell(sel[0],"isaccu"),"isaccu",param);
    autoRefreshPic(true);
}

function saveasResult()
{
	if(!checkQueryStatus())
	{
		return;
	}
	if($("grapMode").checked)
	{
		exportGraph();
	}
	else
	{
		exportResult();
	}
}

function exportResult()
{
	var txtContent = RESOURCE["titleres"] + String.fromCharCode(13, 10);
	txtContent += RESOURCE["attribute"] + getSpace(18 - getLength(RESOURCE["attribute"])) + RESOURCE["value"] + String.fromCharCode(13, 10);
	txtContent += RESOURCE["neNameCT"] + getSpace(18 - getLength(RESOURCE["neNameCT"])) + testResultCT.getAttrValue("neNameCT") + String.fromCharCode(13, 10);
	txtContent += RESOURCE["slotidCT"] + getSpace(18 - getLength(RESOURCE["slotidCT"])) + testResultCT.getAttrValue("slotidCT") +String.fromCharCode(13, 10);
	txtContent += RESOURCE["boardTypeCT"] + getSpace(18 - getLength(RESOURCE["boardTypeCT"])) + testResultCT.getAttrValue("boardTypeCT") +String.fromCharCode(13, 10);
	txtContent += RESOURCE["portidCT"] + getSpace(18 - getLength(RESOURCE["portidCT"])) + testResultCT.getAttrValue("portidCT") +String.fromCharCode(13, 10);
	txtContent += RESOURCE["startTimeCT"] + getSpace(18 - getLength(RESOURCE["startTimeCT"])) + testResultCT.getAttrValue("startTimeCT") +String.fromCharCode(13, 10);
	txtContent += RESOURCE["testCycleCT"] + getSpace(18 - getLength(RESOURCE["testCycleCT"])) + testResultCT.getAttrValue("testCycleCT") +String.fromCharCode(13, 10);
	txtContent += RESOURCE["testTimeCT"] + getSpace(18 - getLength(RESOURCE["testTimeCT"])) + testResultCT.getAttrValue("testTimeCT") +String.fromCharCode(13, 10);
	txtContent += RESOURCE["endTimeCT"] + getSpace(18 - getLength(RESOURCE["endTimeCT"])) + testResultCT.getAttrValue("endTimeCT") +String.fromCharCode(13, 10);
	if (testResultCT_print_E1_PRBS) 
	{
		txtContent += RESOURCE["e1_bitNum"] + getSpace(18 - getLength(RESOURCE["e1_bitNum"])) + testResultCT.getAttrValue("e1bitNumCT") + String.fromCharCode(13, 10);
		txtContent += RESOURCE["e1_bitNumRate"] + getSpace(18 - getLength(RESOURCE["e1_bitNumRate"])) + testResultCT.getAttrValue("e1BitNumRateCT") + String.fromCharCode(13, 10);
		txtContent += RESOURCE["e1_errBitSecond"] + getSpace(18 - getLength(RESOURCE["e1_errBitSecond"])) + testResultCT.getAttrValue("e1errBitSecondCT") + String.fromCharCode(13, 10);
		txtContent += RESOURCE["e1_severityErrBitSecond"] + getSpace(18 - getLength(RESOURCE["e1_severityErrBitSecond"])) + testResultCT.getAttrValue("e1severityErrBitSecondCT") + String.fromCharCode(13, 10);
		txtContent += RESOURCE["e1_unUsableSecond"] + getSpace(18 - getLength(RESOURCE["e1_unUsableSecond"])) + testResultCT.getAttrValue("e1unUsableSecondCT") + String.fromCharCode(13, 10);
		txtContent += RESOURCE["e1_bgErrBit"] + getSpace(18 - getLength(RESOURCE["e1_bgErrBit"])) + testResultCT.getAttrValue("e1bgErrBitCT") + String.fromCharCode(13, 10);
	}
	else 
	{
		txtContent += RESOURCE["bitNumCT"] + getSpace(18 - getLength(RESOURCE["bitNumCT"])) + testResultCT.getAttrValue("bitNumCT") + String.fromCharCode(13, 10);
		txtContent += RESOURCE["errRateCT"] + getSpace(18 - getLength(RESOURCE["errRateCT"])) + testResultCT.getAttrValue("errRateCT") + String.fromCharCode(13, 10);
		if (isSupportPRBSReportNewAttr) 
		{
			txtContent += RESOURCE["errBitSecond"] + getSpace(18 - getLength(RESOURCE["errBitSecond"])) + testResultCT.getAttrValue("errBitSecondCT") + String.fromCharCode(13, 10);
			txtContent += RESOURCE["severityErrBitSecond"] + getSpace(18 - getLength(RESOURCE["severityErrBitSecond"])) + testResultCT.getAttrValue("severityErrBitSecondCT") + String.fromCharCode(13, 10);
			txtContent += RESOURCE["unUsableSecond"] + getSpace(18 - getLength(RESOURCE["unUsableSecond"])) + testResultCT.getAttrValue("unUsableSecondCT") + String.fromCharCode(13, 10);
			txtContent += RESOURCE["bgErrBit"] + getSpace(18 - getLength(RESOURCE["bgErrBit"])) + testResultCT.getAttrValue("bgErrBitCT") + String.fromCharCode(13, 10);
		}
	}
	openSaveAsPage("../../../../page/", RESOURCE["titleres"], txtContent,null,false);
}


function checkQueryStatus()
{
	var neNameCT = testResultCT.getAttrValue("neNameCT");
	var slotidCT = testResultCT.getAttrValue("slotidCT");
	var boardTypeCT = testResultCT.getAttrValue("boardTypeCT");
	var portidCT = testResultCT.getAttrValue("portidCT");
	var testCycleCT = testResultCT.getAttrValue("testCycleCT");
	var testTimeCT = testResultCT.getAttrValue("testTimeCT");
	var startTimeCT = testResultCT.getAttrValue("startTimeCT");
	var endTimeCT = testResultCT.getAttrValue("endTimeCT");
	var bitNumCT = testResultCT.getAttrValue("bitNumCT");
	var errRateCT = testResultCT.getAttrValue("errRateCT");
	
	if(neNameCT == "" && slotidCT == "" && boardTypeCT == "" && portidCT == "" 
		&& startTimeCT == "" && endTimeCT == "" && bitNumCT == "" 
		&& errRateCT == "")//&& testCycleCT == ""
    {
        alert(RESOURCE["nodata"]);
        return false;
    }
	return true;
}

function exportGraph()
{      		
	var neNameCT = testResultCT.getAttrValue("neNameCT");
	var slotidCT = testResultCT.getAttrValue("slotidCT");
	var boardTypeCT = testResultCT.getAttrValue("boardTypeCT");
	var portidCT = testResultCT.getAttrValue("portidCT");
	var testCycleCT = testResultCT.getAttrValue("testCycleCT");
	var testTimeCT = testResultCT.getAttrValue("testTimeCT");
	var startTimeCT = testResultCT.getAttrValue("startTimeCT");
	var endTimeCT = testResultCT.getAttrValue("endTimeCT");
	var bitNumCT = testResultCT.getAttrValue("bitNumCT");
	var errRateCT = testResultCT.getAttrValue("errRateCT");
	
	if(neNameCT == "" && slotidCT == "" && boardTypeCT == "" && portidCT == "" 
		&& startTimeCT == "" && endTimeCT == "" && bitNumCT == "" 
		&& errRateCT == "")//&& testCycleCT == ""
    {
        alert(RESOURCE["nodata"]);
        return;
    }
	var sel = st.getSelectedRows();
	var portid = st.getCellCurrentValue(sel[0],"portid","portid");
	var nepara = getNeProperty(self);
	var neid = nepara["neid"];
	var slotid = nepara["slotid"];
       
          
    var url="../../../../specialAppServlet?sfid="+ TECMDCODE_REPORTBITTESTRESULT +"&neid="+neid+"&slotid="+slotid
	+"&portid="+portid+"&timeStamp="+new Date().getTime();
    url = url + '&downFlg=y&';
	
  	if(testResultCT_print_E1_PRBS)
	{
		var pathid = st.getCellCurrentValue(sel[0],"pathid","pathid");
		url = url + "&vc4=" + pathid;
	}

    window.location.href=url;

}
    
    
