/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.vplsmgr.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.sdh.vplsmgr.db.TEVplsInfoDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEVPLSInfoMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TEVplsInfoScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEVPLSInfoMOPO vplsInfoMO = TEVplsInfoDbMgr.getVplsInfoMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == vplsInfoMO) {
            logger.info("vplsInfoMO is null! neID->" + neID);
            return 0;
        }
        this.writeSvlantpidScript(neID, item, vplsInfoMO);
        this.writeUninumScript(neID, item, vplsInfoMO);
        return 0;
    }

    private int writeSvlantpidScript(int neID, int item, TEVPLSInfoMOPO vplsInfoMO) {
        TEScriptCmd cmd = this.constractSvlantpidScriptCmd(vplsInfoMO, item);
        if (null == cmd) {
            return 0;
        }
        TEScriptOperationMgr.getInstance().writeComment(neID, item, "//TP ID");
        return TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
    }

    private int writeUninumScript(int neID, int item, TEVPLSInfoMOPO vplsInfoMO) {
        TEScriptCmd cmd = this.constractUninumScriptCmd(vplsInfoMO, item);
        if (null == cmd) {
            return 0;
        }
        TEScriptOperationMgr.getInstance().writeComment(neID, item, "//UNI Logic Interface Number");
        return TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
    }

    private TEScriptCmd constractSvlantpidScriptCmd(TEVPLSInfoMOPO vplsInfoMO, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(1376562);
        String svlantpidStr = vplsInfoMO.getTPID();
        if (null == svlantpidStr) {
            return null;
        }
        try {
            int svlantpid = Integer.parseInt(svlantpidStr, 16);
            cmd.addPara("svlantpid", svlantpid, true, false);
        }
        catch (Exception e) {
            logger.error("parse svlantpid  fail!", (Throwable)e);
        }
        return cmd;
    }

    private TEScriptCmd constractUninumScriptCmd(TEVPLSInfoMOPO vplsInfoMO, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        int vuninum = vplsInfoMO.getVuninum();
        cmd.addPara("uninum", vuninum, false, false);
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

