/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.vplsmgr.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEVPLSInfoMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TEVplsInfoDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEVplsInfoDbMgr() {
    }

    public static TEVPLSInfoMOPO getVplsInfoMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEVplsInfoDbMgr.getVplsInfoMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVplsInfoDbMgr.getVplsInfoMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEVPLSInfoMOPO moDevice = null;
        TEDaoOperationResult dbResult_rep2 = null;
        try {
            TENE ne_rep2 = TENEListMgr.getInstance().getNE(neID);
            if (null == ne_rep2) {
                TEVplsInfoDbMgr.logNullNEError(neID);
                TEVplsInfoDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.getVplsInfoMOFromDB");
                return moDevice;
            }
            dbResult_rep2 = ne_rep2.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEVPLSInfoMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEVPLSInfoMOPO.class);
        }
        catch (Exception e) {
            TEVplsInfoDbMgr.logExceptionOnGet(neID, e);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.getVplsInfoMOFromDB");
            return moDevice;
        }
        if (null == dbResult_rep2) {
            TEVplsInfoDbMgr.logNullErrorOnGet(neID);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.getVplsInfoMOFromDB");
            return moDevice;
        }
        int retCode = dbResult_rep2.getResult();
        if (0 == retCode) {
            List data = dbResult_rep2.getData();
            if (null != data && !data.isEmpty()) {
                moDevice = (TEVPLSInfoMOPO)data.get(0);
            }
        } else {
            TEVplsInfoDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.getVplsInfoMOFromDB");
        return moDevice;
    }

    public static void updateVplsInfoMOToDB(int neID, TEVPLSInfoMOPO tpidMO, TEErrInfoReturn errRet_rep2) {
        String FUNC_NAME_rep2 = "TEVplsInfoDbMgr.updateVplsInfoMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVplsInfoDbMgr.updateVplsInfoMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet_rep2) {
            errRet_rep2 = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult_rep2 = null;
        try {
            TENE ne_rep2 = TENEListMgr.getInstance().getNE(neID);
            dbResult_rep2 = ne_rep2.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TEVplsInfoDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEVplsInfoDbMgr.setOperFail(neID, errRet_rep2, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.updateVplsInfoMOToDB");
            return;
        }
        if (null == dbResult_rep2) {
            TEVplsInfoDbMgr.logNullErrorOnUpdate(neID);
            TEVplsInfoDbMgr.setOperFail(neID, errRet_rep2, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.updateVplsInfoMOToDB");
            return;
        }
        int retCode = dbResult_rep2.getResult();
        if (0 != retCode) {
            TEVplsInfoDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEVplsInfoDbMgr.setOperFail(neID, errRet_rep2, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.updateVplsInfoMOToDB");
    }

    public static void createVplsInfoMOToDB(int neID, TEVPLSInfoMOPO tpidMO, TEErrInfoReturn errRet) {
        String FUNC_NAME_rep2 = "TEVplsInfoDbMgr.createVplsInfoMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVplsInfoDbMgr.createVplsInfoMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult_rep2 = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult_rep2 = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TEVplsInfoDbMgr.logExceptionErrorOnCreate(neID, e);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.createVplsInfoMOToDB");
            return;
        }
        if (null == dbResult_rep2) {
            TEVplsInfoDbMgr.logNullErrorOnCreate(neID);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.createVplsInfoMOToDB");
            return;
        }
        int retCode = dbResult_rep2.getResult();
        if (0 != retCode) {
            TEVplsInfoDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.createVplsInfoMOToDB");
    }

    public static void delVplsInfoMOToDB(int neID, TEVPLSInfoMOPO vplsMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEVplsInfoDbMgr.delVplsInfoMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVplsInfoDbMgr.delVplsInfoMOToDB");
        if (null == vplsMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResultVpls = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResultVpls = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)vplsMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)vplsMO);
        }
        catch (Exception ex) {
            TEVplsInfoDbMgr.logExceptionErrorOnDel(neID, ex);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.delVplsInfoMOToDB");
            return;
        }
        if (null == dbResultVpls) {
            TEVplsInfoDbMgr.logNullErrorOnDel(neID);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.delVplsInfoMOToDB");
            return;
        }
        int retCode = dbResultVpls.getResult();
        if (0 != retCode) {
            TEVplsInfoDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEVplsInfoDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVplsInfoDbMgr.delVplsInfoMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCodeVpls) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEVplsInfoDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCodeVpls).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCodeVpls) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEVplsInfoDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCodeVpls);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCodeVpls) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEVplsInfoDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCodeVpls);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objNameVpls) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objNameVpls.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objNameVpls[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCodeVpls) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCodeVpls);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception ex) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)ex);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCodeVpls) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCodeVpls);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception ex) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)ex);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception ex) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)ex);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCodeVpls) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCodeVpls);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception ex) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)ex);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCodeVpls) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCodeVpls);
        logger.error(tipStr);
    }
}

