/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.vplsmgr.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.nemgr.sdh.vplsmgr.db.TEVplsInfoDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEVPLSInfoMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.List;
import org.slf4j.Logger;

public class TEVPLSSetBeanPlugin
extends TEBeanPlugin {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        String operName = null;
        for (Operation oper : operationList) {
            TEErrInfoReturn tempErrRet;
            operName = oper.getName();
            if ("NSCMD_SERVICE_SET_VPLSUNI_NUM".equals(operName)) {
                tempErrRet = new TEErrInfoReturn();
                this.handleNSCMD_SERVICE_SET_VPLSUNI_NUM(neid, oper, tempErrRet);
                continue;
            }
            if (!"NSCMD_PTN_MPLS_PW_SET_SVLAN_NETPID".equals(operName)) continue;
            tempErrRet = new TEErrInfoReturn();
            this.handleNSCMD_PTN_MPLS_PW_SET_SVLAN_NETPID(neid, oper, tempErrRet);
        }
        return errRet;
    }

    private void handleNSCMD_SERVICE_SET_VPLSUNI_NUM(int neID, Operation oper, TEErrInfoReturn errRet) {
        int vuninum = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"vuninum", (int)-1);
        if (-1 == vuninum) {
            logger.info("vuninum is invalid! will not save to db!");
            return;
        }
        TEVPLSInfoMOPO vplsInfoMO = TEVplsInfoDbMgr.getVplsInfoMOFromDB(neID, errRet);
        if (0 == errRet.getResult()) {
            if (null == vplsInfoMO) {
                logger.info("vplsInfoMO is null! will create!");
                vplsInfoMO = new TEVPLSInfoMOPO();
                vplsInfoMO.setVuninum(vuninum);
                TEVplsInfoDbMgr.createVplsInfoMOToDB(neID, vplsInfoMO, errRet);
            } else {
                vplsInfoMO.setVuninum(vuninum);
                TEVplsInfoDbMgr.updateVplsInfoMOToDB(neID, vplsInfoMO, errRet);
            }
        }
        TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
    }

    private void handleNSCMD_PTN_MPLS_PW_SET_SVLAN_NETPID(int neID, Operation oper, TEErrInfoReturn errRet) {
        String tpID = TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"tpid", (String)"");
        if (null == tpID || tpID.isEmpty()) {
            return;
        }
        TEVPLSInfoMOPO tpidMO = TEVplsInfoDbMgr.getVplsInfoMOFromDB(neID, errRet);
        if (0 == errRet.getResult()) {
            if (null == tpidMO) {
                TELogFactory.getNormalLogger().info("tpidMO is null! will create!");
                tpidMO = new TEVPLSInfoMOPO();
                tpidMO.setTPID(tpID);
                TEVplsInfoDbMgr.createVplsInfoMOToDB(neID, tpidMO, errRet);
            } else {
                tpidMO.setTPID(tpID);
                TEVplsInfoDbMgr.updateVplsInfoMOToDB(neID, tpidMO, errRet);
            }
        }
        TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
    }
}

