/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.vplsmgr.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.nemgr.sdh.vplsmgr.db.TEVplsInfoDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEVPLSInfoMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.List;
import org.slf4j.Logger;

public class TEVPLSQueryBeanPlugin
extends TEBeanPlugin {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        String operName = null;
        for (Operation oper : operationList) {
            TEErrInfoReturn tempErrRet;
            operName = oper.getName();
            if ("NSCMD_SERVICE_GET_VPLSUNI_NUM".equals(operName)) {
                tempErrRet = new TEErrInfoReturn();
                this.handleNSCMD_SERVICE_GET_VPLSUNI_NUM(neid, oper, tempErrRet);
                if (0 == tempErrRet.getResult()) continue;
                errRet.setResult(2);
                errRet.addErrInfo(tempErrRet.getErrList());
                continue;
            }
            if (!"NSCMD_PTN_MPLS_PW_GET_SVLAN_NETPID".equals(operName)) continue;
            tempErrRet = new TEErrInfoReturn();
            this.handleNSCMD_PTN_MPLS_PW_GET_SVLAN_NETPID(neid, oper, tempErrRet);
            if (0 == tempErrRet.getResult()) continue;
            errRet.setResult(2);
            errRet.addErrInfo(tempErrRet.getErrList());
        }
        return errRet;
    }

    private void handleNSCMD_SERVICE_GET_VPLSUNI_NUM(int neID, Operation oper, TEErrInfoReturn errRet) {
        int vuninum = TEBeanPluginUtil.getOutputPartValueInt((Operation)oper, (String)"vuninum", (int)-1);
        if (-1 == vuninum) {
            logger.info("vuninum is invalid! will not set to db!");
            return;
        }
        TEVPLSInfoMOPO vplsInfoMO = TEVplsInfoDbMgr.getVplsInfoMOFromDB(neID, errRet);
        if (0 == errRet.getResult()) {
            if (null == vplsInfoMO) {
                logger.info("vplsInfoMO is null! will create!");
                vplsInfoMO = new TEVPLSInfoMOPO();
                vplsInfoMO.setVuninum(vuninum);
                TEVplsInfoDbMgr.createVplsInfoMOToDB(neID, vplsInfoMO, errRet);
            } else {
                vplsInfoMO.setVuninum(vuninum);
                TEVplsInfoDbMgr.updateVplsInfoMOToDB(neID, vplsInfoMO, errRet);
            }
        }
        TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
    }

    private void handleNSCMD_PTN_MPLS_PW_GET_SVLAN_NETPID(int neID, Operation oper, TEErrInfoReturn errRet) {
        String tpID = TEBeanPluginUtil.getOutputPartValueStr((Operation)oper, (String)"tpid", (String)"");
        if (null == tpID || tpID.isEmpty()) {
            return;
        }
        TEVPLSInfoMOPO vplsInfoMO = TEVplsInfoDbMgr.getVplsInfoMOFromDB(neID, errRet);
        if (0 == errRet.getResult()) {
            if (null == vplsInfoMO) {
                logger.info("tpidMO is null! will create!");
                vplsInfoMO = new TEVPLSInfoMOPO();
                vplsInfoMO.setTPID(tpID);
                TEVplsInfoDbMgr.createVplsInfoMOToDB(neID, vplsInfoMO, errRet);
            } else {
                vplsInfoMO.setTPID(tpID);
                TEVplsInfoDbMgr.updateVplsInfoMOToDB(neID, vplsInfoMO, errRet);
            }
        }
        TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
    }
}

