/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TESNCSwitchCMDBean
extends TENEExplorerBean {
    private String[] pgNoArray = null;
    private String[] srcBoardNameArray = null;
    private String[] snkBoardNameArray = null;
    private String[] swtTypeArray = null;
    private String[] swtDirectionArray = null;
    private int convertSize = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.inputData = inputData;
            this.neid = neid;
            this.subfunc = subFunc;
            this.outputData = new Datainterface();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.pgNoArray = new String[rParams.length];
            this.swtTypeArray = new String[rParams.length];
            this.swtDirectionArray = new String[rParams.length];
            this.srcBoardNameArray = new String[rParams.length];
            this.snkBoardNameArray = new String[rParams.length];
            int len = rParams.length;
            for (int i = 0; i < len; ++i) {
                this.pgNoArray[i] = rParams[i].getParam("pgno").getValue();
                this.swtTypeArray[i] = rParams[i].getParam("switchType").getValue();
                this.swtDirectionArray[i] = rParams[i].getParam("switchDirect").getValue();
                this.srcBoardNameArray[i] = rParams[i].getParam("srcBoardName").getValue();
                this.snkBoardNameArray[i] = rParams[i].getParam("snkBoardName").getValue();
                ++this.convertSize;
            }
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCode1 = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode1 == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList1 = new ArrayList<TELogInfo>();
            TELogInfo loginfo1 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode1 == 0) {
                loginfo1 = new TELogInfo();
                loginfo1.setResult(0);
                loginfo1.setErrCode(0);
                loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode1));
                loginfoList1.add(loginfo1);
            } else if (errorCode1 == 2 || errorCode1 == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        loginfo1 = new TELogInfo();
                        loginfo1.setResult(2);
                        loginfo1.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                        loginfo1.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                        loginfoList1.add(loginfo1);
                    }
                }
            } else {
                loginfo1 = new TELogInfo();
                loginfo1.setResult(2);
                loginfo1.setErrCode(errorCode1);
                loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode1));
                loginfoList1.add(loginfo1);
            }
            if (this.convertSize > 0 && errorCode1 == 0) {
                for (int ik = 0; ik < this.convertSize; ++ik) {
                    int size = loginfoList1.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        loginfo1 = (TELogInfo)loginfoList1.get(i2);
                        loginfo1.setCmdID(subfunc.getCode());
                        loginfo1.setLocation(ipAddress);
                        loginfo1.setUserID(userID);
                        loginfo1.setUserName(TESysManagerBean.getInstance().getSysUser());
                        loginfo1.setOperateName(subfunc.getSubFuncDes(neid));
                        loginfo1.setOperateObject(operObj);
                        loginfo1.setOperateDesc(this.operationDescribtion(ik));
                        TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList1.get(i2)));
                    }
                }
            } else {
                int size = loginfoList1.size();
                for (i = 0; i < size; ++i) {
                    loginfo1 = (TELogInfo)loginfoList1.get(i);
                    loginfo1.setCmdID(subfunc.getCode());
                    loginfo1.setLocation(ipAddress);
                    loginfo1.setUserID(userID);
                    loginfo1.setUserName(TESysManagerBean.getInstance().getSysUser());
                    loginfo1.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfo1.setOperateObject(operObj);
                    loginfo1.setOperateDesc("");
                    TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList1.get(i)));
                }
            }
        }
        catch (NumberFormatException e1) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e1);
            return;
        }
        catch (IndexOutOfBoundsException e2) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e2);
            return;
        }
    }

    private String operationDescribtion(int index) {
        StringBuffer operDesc_rep1 = new StringBuffer();
        StringBuffer filePath_rep1 = new StringBuffer();
        filePath_rep1.append("sdh").append(File.separator).append("res").append(File.separator).append("sdhconfig_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath_rep1);
        operDesc_rep1.append(res.getString("pgNo")).append(":").append(this.pgNoArray[index]);
        operDesc_rep1.append(",");
        operDesc_rep1.append(res.getString("srcBoardName")).append(":").append(this.srcBoardNameArray[index]);
        operDesc_rep1.append(",");
        operDesc_rep1.append(res.getString("snkBoardName")).append(":").append(this.snkBoardNameArray[index]);
        operDesc_rep1.append(",");
        operDesc_rep1.append(res.getString("swtDirection")).append(":");
        operDesc_rep1.append(res.getString("swtDirection" + this.swtDirectionArray[index]));
        operDesc_rep1.append(",");
        operDesc_rep1.append(res.getString("swtType")).append(":");
        operDesc_rep1.append(res.getString("swtType" + this.swtTypeArray[index]));
        operDesc_rep1.append(" ");
        return operDesc_rep1.toString();
    }
}

