/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHBoardResource;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHLevelResource;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHUseableReource;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEGetAvaliableSDHXCBoard
extends TENEExplorerBean {
    private int neid;
    private Datainterface output;
    private ArrayList usableResourceList = new ArrayList();
    private ArrayList sdhLevelList = null;
    private Logger log = TELogFactory.getNormalLogger();
    private static final int XCLEVEL_VC4 = 1;
    private static final int XCLEVEL_VC3 = 7;
    private static final int XCLEVEL_VC4_4C = 2;
    private static final int XCLEVEL_VC4_8C = 3;
    private static final int XCLEVEL_VC4_16C = 4;
    private static final int XCLEVEL_VC4_64C = 5;
    private static final int XCLEVEL_VC12 = 6;
    private static final String SERVICE_TYPE_STM1 = "769";
    private static final int IF1MAX0 = 0;
    private static final int IF1MAX1 = 1;
    private static final int IF1MAX2 = 3;
    private static final int IF1MAX6 = 63;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        this.operationList = new ArrayList();
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        Param[] paramArr = rParams.getParam();
        if (paramArr.length <= 0) {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.output;
        }
        try {
            this.sdhLevelList = new ArrayList();
            HashMap<Integer, ArrayList> usedSlotID = new HashMap<Integer, ArrayList>();
            Vector boardList = TENEListMgr.getInstance().getNE(neid).getBoardList();
            int len = paramArr.length;
            for (int i = 0; i < len; ++i) {
                String sdhname = paramArr[i].getName();
                int sdhvalue = Integer.parseInt(paramArr[i].getValue());
                if (!sdhname.equalsIgnoreCase("sdhlevel")) continue;
                ArrayList<TESDHBoardResource> usableBoardList = new ArrayList<TESDHBoardResource>();
                int size = boardList.size();
                block20: for (int j = 0; j < size; ++j) {
                    TEBoard board = (TEBoard)boardList.get(j);
                    int bdType = board.getBoardType();
                    int slotID = board.getSlotID();
                    String bdName = board.getBoardName();
                    boolean isBDSupport = TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_VALIDATESDHXCBD");
                    if (bdType == 1577 || bdType == 1576 || isBDSupport) {
                        ArrayList portRecordList = TEConfigurationDataMgr.getInstance().getDynPropertyList(neid, bdType);
                        String portString = "";
                        String vc4String = "";
                        ArrayList<Integer> tmpPors = new ArrayList<Integer>();
                        int ksize = portRecordList.size();
                        for (int k = 0; k < ksize; ++k) {
                            TEPortProperty portRecord = (TEPortProperty)portRecordList.get(k);
                            ArrayList<Integer> portList = portRecord.getPortNoList();
                            if (portList == null) {
                                portList = new ArrayList<Integer>();
                                portList.add(portRecord.getPortNo());
                            }
                            Collections.sort(portList);
                            int lLen = portList.size();
                            for (int l = 0; l < lLen; ++l) {
                                Integer iportVc0 = (Integer)portList.get(l);
                                String iportVc1 = "";
                                iportVc1 = TEGenCfgDataMgr.getGenCfgMode((int)bdType).getMaxFbid1_listSize() + "";
                                if (tmpPors.contains(iportVc0)) continue;
                                tmpPors.add(iportVc0);
                                if (portString.equals("")) {
                                    portString = String.valueOf(iportVc0);
                                    vc4String = iportVc1;
                                    continue;
                                }
                                portString = portString + "," + iportVc0;
                                vc4String = vc4String + "," + iportVc1;
                            }
                        }
                        if (portString.equalsIgnoreCase("")) continue;
                        switch (sdhvalue) {
                            case 1: 
                            case 2: {
                                boolean isCPNotSupport = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC4");
                                if (isCPNotSupport) break;
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 1, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                boolean isCPNotSupport = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC4");
                                if (bdType == 1577 || isCPNotSupport) break;
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 63, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            case 7: {
                                boolean isCPNotSupport = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC3");
                                if (bdType == 1548 || isCPNotSupport) break;
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 3, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            case 6: {
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 63, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            default: {
                                TELogFactory.getNormalLogger().info("TEGetAvaliableSDHXCBoard.performBussinessProcess() sdhvalue:" + sdhvalue + " not in case!");
                            }
                        }
                    }
                    boolean isCPNotSupport = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPSDHLINEBD");
                    if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, slotID) && bdType != 1576 && bdType != 1577 && !isCPNotSupport) {
                        if (TEVirtualPortUtil.isMSOTNBoard((int)bdType)) {
                            this.addMSOTNBordSDHRes(sdhvalue, slotID, usableBoardList);
                            continue;
                        }
                        boolean isSdhPort = true;
                        List<String> portList = (ArrayList)usedSlotID.get(slotID);
                        if (null == portList) {
                            portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotID, (int)bdType, (boolean)isSdhPort);
                            boolean isSdhPortBD = TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NEEDGETSDHPORT");
                            if (bdType == 1622 || isSdhPortBD) {
                                if (SERVICE_TYPE_STM1.equals(this.getTSPServiceType(neid, slotID))) {
                                    portList.remove("201-4");
                                    portList.remove("202-4");
                                    portList.add("201-1");
                                    portList.add("202-1");
                                }
                                if (sdhvalue == 6) {
                                    for (int l = 5; l < 26; ++l) {
                                        portList.add(l + "-0");
                                    }
                                }
                            }
                            usedSlotID.put(slotID, (ArrayList)portList);
                        }
                        boolean isSort = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTNEEDSORT");
                        if (bdType != 1622 && !isSort) {
                            Collections.sort(portList);
                        }
                        String portString = "";
                        String vc4String = "";
                        boolean issublist = TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_PORTTOVC4");
                        if (bdType == 1557 || issublist) {
                            portList = portList.subList(0, 1);
                        }
                        int ksize = portList.size();
                        for (int k = 0; k < ksize; ++k) {
                            String iportVcStr = (String)portList.get(k);
                            String[] iportVc = iportVcStr.split("-");
                            if (portString.equals("")) {
                                portString = iportVc[0];
                                vc4String = iportVc[1];
                                continue;
                            }
                            portString = portString + "," + iportVc[0];
                            vc4String = vc4String + "," + iportVc[1];
                        }
                        if (portString.equalsIgnoreCase("")) continue;
                        switch (sdhvalue) {
                            case 1: {
                                boolean isSPVC4 = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC4");
                                if (isSPVC4) continue block20;
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 1, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                boolean isSPVC416C = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC4_16C");
                                if (bdType == 1557 || isSPVC416C) continue block20;
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 1, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            case 5: {
                                boolean isSPVC464C = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC4_64C");
                                if (1579 == bdType || bdType == 1557 || bdType == 2049 || isSPVC464C) continue block20;
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 1, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            case 7: {
                                boolean isbdNotSupport = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC3");
                                if (bdType == 1548 || isbdNotSupport) continue block20;
                                TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 3, bdName, sdhvalue);
                                usableBoardList.add(bdResource);
                                break;
                            }
                            case 6: {
                                boolean isNotSPVC12 = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC12");
                                if (bdType != 1557 && !isNotSPVC12) {
                                    TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 63, bdName, sdhvalue);
                                    usableBoardList.add(bdResource);
                                    break;
                                }
                            }
                            default: {
                                TELogFactory.getNormalLogger().info("TEGetAvaliableSDHXCBoard.performBussinessProcess() sdhvalue:" + sdhvalue + " not in case!");
                                break;
                            }
                        }
                        continue;
                    }
                    if (!TEConfigurationDataMgr.getInstance().isBranchBoard(this.neid, slotID)) continue;
                    int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
                    int iLevel = TEConfigurationDataMgr.getInstance().getPortIterfaceLevel(neid, boardtype, 1);
                    int portNum = TEConfigurationDataMgr.getInstance().getBoardPortNum(this.neid, bdType);
                    String portString = "";
                    for (int k = 0; k < portNum; ++k) {
                        portString = portString.equals("") ? String.valueOf(k + 1) : portString + "," + (k + 1);
                    }
                    switch (sdhvalue) {
                        case 6: {
                            boolean isNotSPVC12 = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_NOTSPXCVC12");
                            if (isNotSPVC12) continue block20;
                            TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, 0, portNum, bdName, sdhvalue);
                            usableBoardList.add(bdResource);
                            continue block20;
                        }
                        case 7: {
                            if (iLevel != 4099) continue block20;
                            TESDHBoardResource bdResource = new TESDHBoardResource(slotID, bdType, portString, 0, portNum, bdName, sdhvalue);
                            bdResource.setBranchBoard(true);
                            usableBoardList.add(bdResource);
                            continue block20;
                        }
                        default: {
                            continue block20;
                        }
                    }
                }
                TESDHLevelResource sdhResource = new TESDHLevelResource(sdhvalue, sdhname, usableBoardList);
                this.sdhLevelList.add(sdhResource);
            }
            this.output = this.constructsdhBoardList(this.sdhLevelList);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        catch (Exception e) {
            this.log.error("Get Avaliable SDH XC Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    public Datainterface constructsdhBoardList(ArrayList BoardList) {
        Datainterface data_rtn = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = BoardList.size();
        for (int i = 0; i < size; ++i) {
            TESDHLevelResource sdhLevel = (TESDHLevelResource)BoardList.get(i);
            ArrayList boardList = sdhLevel.getusableList();
            Collections.sort(boardList);
            int bdsize = boardList.size();
            for (int j = 0; j < bdsize; ++j) {
                TESDHBoardResource board = (TESDHBoardResource)boardList.get(j);
                RowParams rParams = new RowParams();
                Param param_rtn7 = null;
                param_rtn7 = new Param("sdhName", sdhLevel.getsdhName());
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("sdhLevel", String.valueOf(sdhLevel.getsdhLevel()));
                rParams.addParam(param_rtn7);
                int slotid = board.getSlotID();
                param_rtn7 = new Param("slotID", String.valueOf(slotid));
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotid)));
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid));
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)));
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("bdType", String.valueOf(board.getBoardType()));
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("bdName", board.getBoardName());
                rParams.addParam(param_rtn7);
                param_rtn7 = "".equals(board.getVC4String()) ? new Param("bdVC4", Integer.valueOf(board.getVC4num()).toString()) : new Param("bdVC4", board.getVC4String());
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("bdPort", board.getPortString());
                rParams.addParam(param_rtn7);
                param_rtn7 = new Param("bdPath", Integer.valueOf(board.getPathNumber()).toString());
                rParams.addParam(param_rtn7);
                bParams.addRowParams(rParams);
            }
        }
        data_rtn.setBussinessParams(bParams);
        data_rtn.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return data_rtn;
    }

    public Datainterface constructRtnData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TESDHUseableReource res = (TESDHUseableReource)this.usableResourceList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("sdhLevel", Integer.valueOf(res.getSDHLevel()).toString());
            rParams.addParam(param);
            int slotid = res.getSlotID();
            param = new Param("slotID", String.valueOf(slotid));
            rParams.addParam(param);
            param = new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotid)));
            rParams.addParam(param);
            param = new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid));
            rParams.addParam(param);
            param = new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)));
            rParams.addParam(param);
            param = new Param("bdType", Integer.valueOf(res.getBoardType()).toString());
            rParams.addParam(param);
            param = new Param("bdName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("port", (String)res.getPorts().get(0));
            int size1 = res.getPorts().size();
            for (int j = 1; j < size1; ++j) {
                Option option = new Option((String)res.getPorts().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        data.setBussinessParams(bParams);
        return data;
    }

    private String getTSPServiceType(int neid, int slotId) {
        Output operationOutput;
        String serviceType = "0";
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ENCAPSULATION_EX");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Input input = oper.getInput();
        Part part = input.getPart("slotID");
        part.setValue(String.valueOf(slotId));
        input.getPart("slotid").setValue(String.valueOf(slotId));
        input.getPart("port").setValue(String.valueOf(251));
        input.getPart("path").setValue("1");
        operationList.add(oper);
        int resualt = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)this.TIME_OUT).retCode;
        if (resualt == 0 && (operationOutput = ((Operation)operationList.get(0)).getOutput()[0]).getFault()[0].getCode().equals(String.valueOf(0)) && (serviceType = oper.getOutput(0).getPartValue("W32PORT_ATTR_ST_SERVICETYPE_2")).equals("")) {
            serviceType = "0";
        }
        return serviceType;
    }

    public boolean isNeedOperationlog(String ipAddress) {
        return false;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void addMSOTNBordSDHRes(int sdhLevel, int slotid, List<TESDHBoardResource> resList) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        List portList = TEVirtualPortUtil.getExistVPortsByDomain((int)this.neid, (int)slotid, (int)1);
        StringBuilder portStr = new StringBuilder();
        StringBuilder vc4Str = new StringBuilder();
        for (Integer port : portList) {
            if (portStr.length() <= 0) {
                portStr.append(port);
            } else {
                portStr.append(",").append(port);
            }
            if (vc4Str.length() <= 0) {
                vc4Str.append(TEVirtualPortUtil.getVC4NumByVSDHPortLevel((int)this.neid, (int)slotid, (int)port));
                continue;
            }
            vc4Str.append(",").append(TEVirtualPortUtil.getVC4NumByVSDHPortLevel((int)this.neid, (int)slotid, (int)port));
        }
        int countSdhLevleNumByVc4 = 0;
        switch (sdhLevel) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                countSdhLevleNumByVc4 = 1;
                break;
            }
            case 7: {
                countSdhLevleNumByVc4 = 3;
                break;
            }
            case 6: {
                countSdhLevleNumByVc4 = 63;
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEGetAvaliableSDHXCBoard.performBussinessProcess() sdhvalue:" + sdhLevel + " not in case!");
            }
        }
        TESDHBoardResource bdResource = new TESDHBoardResource(slotid, board.getBoardType(), portStr.toString(), vc4Str.toString(), countSdhLevleNumByVc4, board.getBoardName(), sdhLevel);
        TELogFactory.getNormalLogger().info("addMSOTNBordSDHRes() neid:" + this.neid + "slotid:" + slotid + " portStr:" + portStr.toString());
        resList.add(bdResource);
    }
}

