/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig.po;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESDHTs;
import com.huawei.nglct.nelist.model.TESDHXCTTp;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHIF1ABBoard;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHPayloadComparator;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHQueryDataCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

public class TESDHSingleXC
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4074415085157305667L;
    private int id;
    public int logicNeId;
    public int sdhxcid;
    public int pgno;
    public int activateState;
    public int bindGroupNo;
    public int checkPointAndPriority;
    public int groupNo;
    public int groupType;
    public int holdoffTime;
    public int initCriteria;
    public int level;
    public int payloadNeedReplicate;
    public int revertMode;
    public int sncmpCheckPoint;
    public int sncmpPriority;
    public int sncmpProtUnitId;
    public int snkLogicSysId;
    public int snkPortId;
    public int snkSlotId;
    public int snkTtpType;
    public int snkTug;
    public int snkVc4;
    public int snkNO = 0;
    public int snkTug3 = 0;
    public int snkTug2 = 0;
    public int snkTu12 = 0;
    public int srcLogicSysId;
    public int srcPortId;
    public int srcSlotId = 0;
    public int srcTtpType;
    public int srcTug;
    public int srcVc4;
    public int srcNO = 0;
    public int srcTug3 = 0;
    public int srcTug2 = 0;
    public int srcTu12 = 0;
    public int snkBoardType = 0;
    public int wtrtime;
    public int xcflag;
    public int srcBoardType = 0;
    public int switchState = -1;
    public int sncpType = 1;
    private transient Comparator payloadcomparator = new TESDHPayloadComparator();
    private static final int VC4 = 1;
    private static final int VC12 = 6;
    private static final int VC3 = 7;
    public String snkBoardCellView = null;
    public String srcBoardCellView = null;
    private String circuitName;

    public TESDHSingleXC() {
    }

    public TESDHSingleXC(int _neID) {
        this.logicNeId = _neID;
    }

    public TESDHSingleXC(int logicNeId, int sdhxcid, int pgno, int activateState, int bindGroupNo, int checkPointAndPriority, int groupNo, int groupType, int holdoffTime, int initCriteria, int level, int payloadNeedReplicate, int revertMode, int sncmpCheckPoint, int sncmpPriority, int sncmpProtUnitId, int snkLogicSysId, int snkPortId, int snkSlotId, int snkTtpType, int snkTug, int snkVc4, int srcLogicSysId, int srcPortId, int srcSlotId, int srcTtpType, int srcTug, int srcVc4, int wtrtime, int xcflag) {
        this.logicNeId = logicNeId;
        this.sdhxcid = sdhxcid;
        this.pgno = pgno;
        this.activateState = activateState;
        this.bindGroupNo = bindGroupNo;
        this.checkPointAndPriority = checkPointAndPriority;
        this.groupNo = groupNo;
        this.groupType = groupType;
        this.holdoffTime = holdoffTime;
        this.initCriteria = initCriteria;
        this.level = level;
        this.payloadNeedReplicate = payloadNeedReplicate;
        this.revertMode = revertMode;
        this.sncmpCheckPoint = sncmpCheckPoint;
        this.sncmpPriority = sncmpPriority;
        this.sncmpProtUnitId = sncmpProtUnitId;
        this.snkLogicSysId = snkLogicSysId;
        this.snkPortId = snkPortId;
        this.snkSlotId = snkSlotId;
        this.snkTtpType = snkTtpType;
        this.snkTug = snkTug;
        this.snkVc4 = snkVc4;
        this.srcLogicSysId = srcLogicSysId;
        this.srcPortId = srcPortId;
        this.srcSlotId = srcSlotId;
        this.srcTtpType = srcTtpType;
        this.srcTug = srcTug;
        this.srcVc4 = srcVc4;
        this.wtrtime = wtrtime;
        this.xcflag = xcflag;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getLogicNeId() {
        return this.logicNeId;
    }

    public void setLogicNeId(int logicNeId) {
        this.logicNeId = logicNeId;
    }

    public int getSdhxcid() {
        return this.sdhxcid;
    }

    public void setSdhxcid(int sdhxcid) {
        this.sdhxcid = sdhxcid;
    }

    public int getPgno() {
        return this.pgno;
    }

    public void setPgno(int pgno) {
        this.pgno = pgno;
    }

    public int getActivateState() {
        return this.activateState;
    }

    public void setActivateState(int activateState) {
        this.activateState = activateState;
    }

    public int getBindGroupNo() {
        return this.bindGroupNo;
    }

    public void setBindGroupNo(int bindGroupNo) {
        this.bindGroupNo = bindGroupNo;
    }

    public int getCheckPointAndPriority() {
        return this.checkPointAndPriority;
    }

    public void setCheckPointAndPriority(int checkPointAndPriority) {
        this.checkPointAndPriority = checkPointAndPriority;
    }

    public int getGroupNo() {
        return this.groupNo;
    }

    public void setGroupNo(int groupNo) {
        this.groupNo = groupNo;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public int getHoldoffTime() {
        return this.holdoffTime;
    }

    public void setHoldoffTime(int holdoffTime) {
        this.holdoffTime = holdoffTime;
    }

    public int getInitCriteria() {
        return this.initCriteria;
    }

    public void setInitCriteria(int initCriteria) {
        this.initCriteria = initCriteria;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getPayloadNeedReplicate() {
        return this.payloadNeedReplicate;
    }

    public void setPayloadNeedReplicate(int payloadNeedReplicate) {
        this.payloadNeedReplicate = payloadNeedReplicate;
    }

    public int getSncmpCheckPoint() {
        return this.sncmpCheckPoint;
    }

    public void setSncmpCheckPoint(int sncmpCheckPoint) {
        this.sncmpCheckPoint = sncmpCheckPoint;
    }

    public int getSncmpPriority() {
        return this.sncmpPriority;
    }

    public void setSncmpPriority(int sncmpPriority) {
        this.sncmpPriority = sncmpPriority;
    }

    public int getSncmpProtUnitId() {
        return this.sncmpProtUnitId;
    }

    public void setSncmpProtUnitId(int sncmpProtUnitId) {
        this.sncmpProtUnitId = sncmpProtUnitId;
    }

    public int getSnkLogicSysId() {
        return this.snkLogicSysId;
    }

    public void setSnkLogicSysId(int snkLogicSysId) {
        this.snkLogicSysId = snkLogicSysId;
    }

    public int getSnkPortId() {
        return this.snkPortId;
    }

    public void setSnkPortId(int snkPortId) {
        this.snkPortId = snkPortId;
    }

    public int getSnkSlotId() {
        return this.snkSlotId;
    }

    public void setSnkSlotId(int snkSlotId) {
        this.snkSlotId = snkSlotId;
    }

    public int getSnkTtpType() {
        return this.snkTtpType;
    }

    public void setSnkTtpType(int snkTtpType) {
        this.snkTtpType = snkTtpType;
    }

    public int getSnkTug() {
        return this.snkTug;
    }

    public void setSnkTug(int snkTug) {
        this.snkTug = snkTug;
    }

    public int getSnkVc4() {
        return this.snkVc4;
    }

    public void setSnkVc4(int snkVc4) {
        this.snkVc4 = snkVc4;
    }

    public int getSrcLogicSysId() {
        return this.srcLogicSysId;
    }

    public void setSrcLogicSysId(int srcLogicSysId) {
        this.srcLogicSysId = srcLogicSysId;
    }

    public int getSrcPortId() {
        return this.srcPortId;
    }

    public void setSrcPortId(int srcPortId) {
        this.srcPortId = srcPortId;
    }

    public int getSrcSlotId() {
        return this.srcSlotId;
    }

    public void setSrcSlotId(int srcSlotId) {
        this.srcSlotId = srcSlotId;
    }

    public int getSrcTtpType() {
        return this.srcTtpType;
    }

    public void setSrcTtpType(int srcTtpType) {
        this.srcTtpType = srcTtpType;
    }

    public int getSrcTug() {
        return this.srcTug;
    }

    public void setSrcTug(int srcTug) {
        this.srcTug = srcTug;
    }

    public int getSrcVc4() {
        return this.srcVc4;
    }

    public void setSrcVc4(int srcVc4) {
        this.srcVc4 = srcVc4;
    }

    public int getWtrtime() {
        return this.wtrtime;
    }

    public void setWtrtime(int wtrtime) {
        this.wtrtime = wtrtime;
    }

    public int getXcflag() {
        return this.xcflag;
    }

    public void setXcflag(int xcflag) {
        this.xcflag = xcflag;
    }

    public int getSrcBoardType() {
        return this.srcBoardType;
    }

    public void setSrcBoardType(int srcBoardType) {
        this.srcBoardType = srcBoardType;
    }

    public String getBoardViewName(int neid, int slotid, int port) {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port);
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(neid, slotid)) {
            return slotid + "-" + boardname;
        }
        return slotid + "-" + boardname + "-" + portname;
    }

    public boolean equals(Object obj) {
        return this.payloadcomparator.compare(this, obj) == 0;
    }

    public int hashCode() {
        int result = 37;
        result += this.sdhxcid;
        result += this.srcSlotId;
        result += this.srcBoardType;
        result += this.srcPortId;
        result += this.srcVc4;
        result += this.srcNO;
        result += this.srcTug3;
        result += this.srcTug2;
        result += this.srcTu12;
        result += this.srcTtpType;
        result += this.snkSlotId;
        result += this.snkBoardType;
        result += this.snkPortId;
        result += this.snkVc4;
        result += this.snkNO;
        result += this.snkTug3;
        result += this.snkTug2;
        result += this.snkTu12;
        result += this.snkTtpType;
        result += this.level;
        result += this.pgno;
        result += this.xcflag;
        return result += this.logicNeId;
    }

    public Object clone() {
        try {
            TESDHSingleXC result = (TESDHSingleXC)super.clone();
            result.holdoffTime = this.holdoffTime;
            result.initCriteria = this.initCriteria;
            result.pgno = this.pgno;
            result.revertMode = this.revertMode;
            result.sdhxcid = this.sdhxcid;
            result.snkNO = this.snkNO;
            result.snkSlotId = this.snkSlotId;
            result.snkBoardType = this.snkBoardType;
            result.snkTtpType = this.snkTtpType;
            result.snkPortId = this.snkPortId;
            result.snkVc4 = this.snkVc4;
            result.snkTug3 = this.snkTug3;
            result.snkTug2 = this.snkTug2;
            result.snkTu12 = this.snkTu12;
            result.snkTug = this.snkTug;
            result.srcNO = this.srcNO;
            result.srcSlotId = this.srcSlotId;
            result.srcBoardType = this.srcBoardType;
            result.srcTtpType = this.srcTtpType;
            result.srcPortId = this.srcPortId;
            result.srcVc4 = this.srcVc4;
            result.srcTug3 = this.srcTug3;
            result.srcTug2 = this.srcTug2;
            result.srcTu12 = this.srcTu12;
            result.srcTug = this.srcTug;
            result.wtrtime = this.wtrtime;
            result.xcflag = this.xcflag;
            result.level = this.level;
            result.activateState = this.activateState;
            return result;
        }
        catch (CloneNotSupportedException ex) {
            TELogFactory.getNormalLogger().error("TESDHSingleXC.clone() fail!", (Throwable)ex);
            throw new InternalError();
        }
    }

    public String getSrcVC12Name() {
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.logicNeId, this.srcSlotId)) {
            return String.valueOf(this.srcPortId);
        }
        TESDHQueryDataCache xcCacheInstance = TESDHQueryDataCache.getInstance();
        ArrayList ifboardList = xcCacheInstance.getIF1ABList(this.logicNeId);
        boolean IF1InPDHMode = false;
        if (ifboardList != null) {
            int isize = ifboardList.size();
            for (int i = 0; i < isize; ++i) {
                TESDHIF1ABBoard ifboard = (TESDHIF1ABBoard)ifboardList.get(i);
                if (!ifboard.isPDHMode(this.srcSlotId)) continue;
                IF1InPDHMode = true;
                break;
            }
        }
        if (IF1InPDHMode) {
            return String.valueOf(this.srcTug);
        }
        if (this.level == 1) {
            return "VC4:" + this.srcVc4;
        }
        if (this.level == 7) {
            return "VC4:" + this.srcVc4 + ":" + this.srcTug;
        }
        return "VC4:" + this.srcVc4 + ":" + this.srcTug;
    }

    public String getSnkVC12Name() {
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.logicNeId, this.snkSlotId)) {
            return String.valueOf(this.snkPortId);
        }
        TESDHQueryDataCache xcCacheInstance = TESDHQueryDataCache.getInstance();
        ArrayList ifboardList = xcCacheInstance.getIF1ABList(this.logicNeId);
        boolean IF1InPDHMode = false;
        if (ifboardList != null) {
            int isize = ifboardList.size();
            for (int i = 0; i < isize; ++i) {
                TESDHIF1ABBoard ifboard = (TESDHIF1ABBoard)ifboardList.get(i);
                if (!ifboard.isPDHMode(this.snkSlotId)) continue;
                IF1InPDHMode = true;
                break;
            }
        }
        if (IF1InPDHMode) {
            return String.valueOf(this.snkTug);
        }
        if (this.level == 1) {
            return "VC4:" + this.snkVc4;
        }
        if (this.level == 7) {
            return "VC4:" + this.snkVc4 + ":" + this.snkTug;
        }
        return "VC4:" + this.snkVc4 + ":" + this.snkTug;
    }

    public static boolean isCanAdjoin(TESDHSingleXC xc1, TESDHSingleXC xc2) {
        return TESDHSingleXC.isCanAdjoinSingleDirection(xc1, xc2) || TESDHSingleXC.isCanAdjoinSingleDirection(xc2, xc1);
    }

    private static boolean isCanAdjoinSingleDirection(TESDHSingleXC xc1, TESDHSingleXC xc2) {
        if (xc1.level != xc2.level) {
            return false;
        }
        switch (xc1.level) {
            case 1: {
                boolean result = false;
                boolean result1 = false;
                if (xc1.srcSlotId == xc2.srcSlotId && xc1.snkSlotId == xc2.snkSlotId) {
                    if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.logicNeId, xc1.srcSlotId)) {
                        if (xc1.srcPortId == xc2.srcPortId - 1) {
                            result = true;
                        }
                    } else if (xc1.srcPortId == xc2.srcPortId && xc1.srcVc4 == xc2.srcVc4 - 1) {
                        result = true;
                    }
                    if (result) {
                        if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.logicNeId, xc1.snkSlotId)) {
                            if (xc1.snkPortId == xc2.snkPortId - 1) {
                                result1 = true;
                            }
                        } else if (xc1.snkPortId == xc2.snkPortId && xc1.snkVc4 == xc2.snkVc4 - 1) {
                            result1 = true;
                        }
                    }
                }
                return result && result1;
            }
            case 6: {
                return TESDHSingleXC.getResult(xc1, xc2);
            }
            case 7: {
                return TESDHSingleXC.getResult(xc1, xc2);
            }
        }
        TELogFactory.getNormalLogger().info("TESDHSingleXC.isCanAdjoinSingleDirection() xc1.level:" + xc1.level + " not in case!");
        return false;
    }

    private static boolean getResult(TESDHSingleXC xc1, TESDHSingleXC xc2) {
        boolean result = false;
        boolean result1 = false;
        if (xc1.srcSlotId == xc2.srcSlotId && xc1.snkSlotId == xc2.snkSlotId) {
            if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.logicNeId, xc1.srcSlotId)) {
                if (xc1.srcPortId == xc2.srcPortId - 1) {
                    result = true;
                }
            } else if (xc1.srcPortId == xc2.srcPortId && xc1.srcVc4 == xc2.srcVc4 && xc1.srcTug == xc2.srcTug - 1) {
                result = true;
            }
            if (result) {
                if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.logicNeId, xc1.snkSlotId)) {
                    if (xc1.snkPortId == xc2.snkPortId - 1) {
                        result1 = true;
                    }
                } else if (xc1.snkPortId == xc2.snkPortId && xc1.snkVc4 == xc2.snkVc4 && xc1.snkTug == xc2.snkTug - 1) {
                    result1 = true;
                }
            }
        }
        return result && result1;
    }

    boolean isSameSrc(TESDHSingleXC data) {
        return this.srcSlotId == data.srcSlotId && this.srcBoardType == data.srcBoardType && this.srcPortId == data.srcPortId;
    }

    public int getRevertMode() {
        return this.revertMode;
    }

    public int getPayloadType() {
        if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.logicNeId, this.srcSlotId)) {
            if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.logicNeId, this.snkSlotId)) {
                if (this.srcSlotId == this.snkSlotId && this.srcPortId == this.snkPortId && this.srcVc4 == this.snkVc4) {
                    return 5;
                }
                return 3;
            }
            return 0;
        }
        if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.logicNeId, this.snkSlotId)) {
            return 1;
        }
        return 6;
    }

    public void setSrcBoardCellView(String srcBoardCellView) {
        this.srcBoardCellView = srcBoardCellView;
    }

    public String getSrcBoardCellView() {
        return this.srcBoardCellView;
    }

    public void setSnkBoardCellView(String snkBoardCellView) {
        this.snkBoardCellView = snkBoardCellView;
    }

    public String getSnkBoardCellView() {
        return this.srcBoardCellView;
    }

    public int getIRevertMode() {
        return this.revertMode;
    }

    public void setRevertMode(int iRevertMode) {
        this.revertMode = iRevertMode;
        this.initCriteria = 0;
        this.holdoffTime = 0;
    }

    public int getSnkNO() {
        return this.snkNO;
    }

    public void setSnkNO(int snkNO) {
        this.snkNO = snkNO;
    }

    public int getSnkTu12() {
        return this.snkTu12;
    }

    public void setSnkTu12(int snkTu12) {
        this.snkTu12 = snkTu12;
    }

    public int getSnkTug2() {
        return this.snkTug2;
    }

    public void setSnkTug2(int snkTug2) {
        this.snkTug2 = snkTug2;
    }

    public int getSnkTug3() {
        return this.snkTug3;
    }

    public void setSnkTug3(int snkTug3) {
        this.snkTug3 = snkTug3;
    }

    public int getSrcNO() {
        return this.srcNO;
    }

    public void setSrcNO(int srcNO) {
        this.srcNO = srcNO;
    }

    public int getSrcTu12() {
        return this.srcTu12;
    }

    public void setSrcTu12(int srcTu12) {
        this.srcTu12 = srcTu12;
    }

    public int getSrcTug2() {
        return this.srcTug2;
    }

    public void setSrcTug2(int srcTug2) {
        this.srcTug2 = srcTug2;
    }

    public int getSrcTug3() {
        return this.srcTug3;
    }

    public void setSrcTug3(int srcTug3) {
        this.srcTug3 = srcTug3;
    }

    public String getCircuitName() {
        return this.circuitName;
    }

    public void setCircuitName(String circuitName) {
        this.circuitName = circuitName;
    }

    public int getSncpType() {
        return this.sncpType;
    }

    public void setSncpType(int sncpType) {
        this.sncpType = sncpType;
    }

    public TESDHXCTTp getSrcTTp() {
        TESDHXCTTp xcTTp = new TESDHXCTTp(this.srcLogicSysId, this.srcSlotId, this.srcPortId, this.getSrcTs(), this.srcTtpType, this.level);
        return xcTTp;
    }

    public TESDHXCTTp getSnkTTp() {
        TESDHXCTTp xcTTp = new TESDHXCTTp(this.snkLogicSysId, this.snkSlotId, this.snkPortId, this.getSnkTs(), this.snkTtpType, this.level);
        return xcTTp;
    }

    public TESDHTs getSrcTs() {
        return new TESDHTs(this.srcVc4, this.srcTug);
    }

    public TESDHTs getSnkTs() {
        return new TESDHTs(this.snkVc4, this.snkTug);
    }

    public boolean getXCFlagBits(int flagBits) {
        return (this.xcflag & 1 << flagBits) != 0;
    }

    public void setXCFlagBits(int flagBits, boolean bValue) {
        this.xcflag = bValue ? (this.xcflag |= 1 << flagBits) : (this.xcflag &= ~(1 << flagBits));
    }

    public int validate() {
        int errCode = 0;
        errCode = this.getSrcTTp().validate();
        if (errCode == 0) {
            errCode = this.getSnkTTp().validate();
        }
        return errCode;
    }
}

